/*
 * Viewer - the class for the display part fo the documentation viewer.
 *          You create a collection of ViewObjects with a Parser object,
 *          and then pass that collection to a Viewer constructor, and
 *          run the viewer.
 */

#ifndef viewer_Viewer_h
#define viewer_Viewer_h

#include "ViewObject.h"
#include "../util/Collection.h"

class Viewer
{
private:
 Collection<ViewObject>* objects;
 
 int first, last;
 int x, y, w, h, top;
 int totalHeight;
 
 char* background;
 
public:
 Viewer(Collection<ViewObject>* _objects, char* _bk, int _x, int _y, int _w, int _h);
 
 bool init();
 void draw();
 bool run();
 bool scrollDown(int dist);
 bool scrollUp(int dist);
};

#endif
