///////////////////////////////////////////////////////////////////////////////
// $Id: MainDeck.cxx,v 1.3 2000/01/10 23:28:43 bwmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// MainDeck.hxx - Main oonsoo deck of cards (Dealer's deck)
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 13,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: MainDeck.cxx,v $
// Revision 1.3  2000/01/10 23:28:43  bwmott
// Modified pixmap operations to take the display depth into account and
// changed the order of the cards
//
// Revision 1.2  1996/01/06 05:11:46  bwmott
// Changed all NULLs to 0
//
// Revision 1.1  1995/01/08 06:44:41  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "UIApplication.hxx"
#include "Sprite.hxx"
#include "SpriteCollection.hxx"
#include "Card.hxx"
#include "MainDeck.hxx"
#include "Command.hxx"

// Structure to describe standard cards
typedef struct {
  int suite;
  int priority;
  char* name;
} StandardCard;

// Standard deck of oonsoo cards 
static StandardCard standardDeckOfCards[] = {
  { 12,  2,  "BlueStarOne" },
  { 12,  2,  "BlueStarTwo" },
  { 12,  3,  "BlueStarThree" },
  { 12,  4,  "BlueStarFour" },
  { 11,  1,  "HairOne" },
  { 11,  2,  "HairTwo" },
  { 11,  3,  "HairThree" },
  { 11,  4,  "HairFour" },
  { 10,  2,  "LeavesOne" },
  { 10,  2,  "LeavesTwo" },
  { 10,  3,  "LeavesThree" },
  { 10,  4,  "LeavesFour" },
  {  9,  2,  "MumOne" },
  {  9,  2,  "MumTwo" },
  {  9,  3,  "MumThree" },
  {  9,  4,  "MumFour" },
  {  8,  2,  "MoonOne" },
  {  8,  2,  "MoonTwo" },
  {  8,  3,  "MoonThree" },
  {  8,  4,  "MoonFour" },
  {  7,  2,  "RedBushOne" },
  {  7,  2,  "RedBushTwo" },
  {  7,  3,  "RedBushThree" },
  {  7,  4,  "RedBushFour" },
  {  6,  2,  "RoseOne" },
  {  6,  2,  "RoseTwo" },
  {  6,  3,  "RoseThree" },
  {  6,  4,  "RoseFour" },
  {  5,  2,  "LilyOne" },
  {  5,  2,  "LilyTwo" },
  {  5,  3,  "LilyThree" },
  {  5,  4,  "LilyFour" },
  {  4,  2,  "BushOne" },     
  {  4,  2,  "BushTwo" },
  {  4,  3,  "BushThree" },  
  {  4,  4,  "BushFour" },
  {  3,  2,  "AzaleaOne" },
  {  3,  2,  "AzaleaTwo" },
  {  3,  3,  "AzaleaThree" },
  {  3,  4,  "AzaleaFour" },
  {  2,  2,  "DaisyOne" },
  {  2,  2,  "DaisyTwo" },
  {  2,  3,  "DaisyThree" },
  {  2,  4,  "DaisyFour" },
  {  1,  2,  "HillOne" },
  {  1,  2,  "HillTwo" },
  {  1,  3,  "HillThree" },
  {  1,  4,  "HillFour" }
};

///////////////////////////////////////////////////////////////////////////////
// Construct a complete deck of oonsoo cards
///////////////////////////////////////////////////////////////////////////////
MainDeck::MainDeck(ContainerWidget* parent, const char *const widgetName,
    int x, int y, int width, int maxHeight, 
    SpriteCollection* sprites, Command* command)
    : Deck(parent, widgetName, x, y, width, maxHeight, sprites),
      myCommand(command)
{
  // Create each of the cards
  for(int t=0; t < (sizeof(standardDeckOfCards)/sizeof(StandardCard)); ++t)
  {
    Sprite* face = sprites->getByName(standardDeckOfCards[t].name);

    Card* card = new Card(face, standardDeckOfCards[t].suite,
        standardDeckOfCards[t].priority, FaceDown);

    myListOfCards.append(card);
  }

  // Update my view
  updateView();
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
MainDeck::~MainDeck()
{ 
  delete myCommand;
}

///////////////////////////////////////////////////////////////////////////////
// Update graphical view of myself
///////////////////////////////////////////////////////////////////////////////
void MainDeck::updateView()
{
  Pixmap pixmap;

  Sprite* back = mySprites->getByName("StandardBack");
  Sprite* emptyDeck = mySprites->getByName("EmptyDeck");

  int numberOfCards = myListOfCards.size();
  int cardWidth = back->width();
  int cardHeight = back->height();
  int drawingAreaHeight;
  int drawingAreaWidth;


  // See if I have any cards
  if(numberOfCards > 0)
  {
    int cardOffset;

    cardOffset = (myMaximumHeight - cardHeight) / 
        ((sizeof(standardDeckOfCards) / sizeof(StandardCard)) - 1); 
    drawingAreaHeight = cardHeight + (numberOfCards-1) * cardOffset;
    drawingAreaWidth = cardWidth;

    // Build pixmap to hold my view
    pixmap = XCreatePixmap(application->display(), myWindow,
        drawingAreaWidth, drawingAreaHeight, application->depth());

    int pixmapOffset = 0;
    for(Card* card = myListOfCards.first(); card != (Card*)0 ;
        card = myListOfCards.next())
    {
      Sprite* sprite;

      if(card != myListOfCards.tail())
        XPutImage(application->display(), pixmap, application->gc(),
            back->image(), 0, 0, 0, pixmapOffset, 
            back->width(), cardOffset);
      else
        XPutImage(application->display(), pixmap, application->gc(),
            back->image(), 0, 0, 0, pixmapOffset, 
            back->width(), back->height());

      pixmapOffset += cardOffset;
    }
  }
  else
  {
    Sprite* sprite = emptyDeck;
    drawingAreaWidth = sprite->width();
    drawingAreaHeight = sprite->height();

    // Build pixmap to hold my view
    pixmap = XCreatePixmap(application->display(), myWindow, 
        drawingAreaWidth, drawingAreaHeight, application->depth());
    
    XPutImage(application->display(), pixmap, application->gc(), 
        sprite->image(), 0, 0, 0, 0, sprite->width(), sprite->height());
  }

  // Install the pixmap on my drawing area
  XSetWindowBackgroundPixmap(application->display(), myWindow, pixmap);

  // Make sure the window refreshes
  XClearWindow(application->display(), myWindow);

  // Resize the window to fit the pixmap
  resize(drawingAreaWidth, drawingAreaHeight);

  // Free the pixmap
  XFreePixmap(application->display(), pixmap);
}

///////////////////////////////////////////////////////////////////////////////
// Called whenever an event arrives for me (I need to override the default)
///////////////////////////////////////////////////////////////////////////////
void MainDeck::handleEvent(XEvent* event)
{
  if ((event->type == ButtonPress) && (event->xbutton.button == Button1))
  {
    myCommand->execute(0);
  }
}

