#! /bin/sh
#
# Render all player sprites
#
#
# Program XBLAST V2.6 or higher
# (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2; or (at your option)
# any later version
#
# This program is distributed in the hope that it will be entertaining,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.
# 675 Mass Ave, Cambridge, MA 02139, USA.
#
#

#
# check commandline
#
USE_DIR=0
USE_ANI=0
#
SPEC=0
BIGO=0
NORM=0
SKEL=0
NDIR=""
for i in $*; do
    case $i in
    # animation sub sets
    -sp* ) SPEC=1; USE_ANI=1;;
    -b*  ) BIGO=1; USE_ANI=1;;
    -n*  ) NORM=1; USE_ANI=1;;
    -sk* ) SKEL=1; USE_ANI=1;;
    # shapes
    -N*  ) USE_DIR=1; NDIR=$NDIR" "./normal ;;
    -G*  ) USE_DIR=1; NDIR=$NDIR" "./girl   ;;
    -F*  ) USE_DIR=1; NDIR=$NDIR" "./fat    ;;
    -T*  ) USE_DIR=1; NDIR=$NDIR" "./tall   ;;
    -S*  ) USE_DIR=1; NDIR=$NDIR" "./skull  ;;
    esac
done

#
# set animations subsets
#
if test $USE_ANI -eq 0; then
    SPEC=1
    BIGO=1
    NORM=1
    SKEL=1
fi

#
# set source dirs
#
if test $USE_DIR -eq 1; then
    # use only selected ones
    DIRS=$NDIR
else
    # use alls source dirs
    DIRS="./normal ./girl ./fat ./tall ./skull"
fi

#
# loop over all source dirs
#
for SRC in $DIRS; do
    #
    # go to sprite subdir
    # 
    pushd $SRC
    #
    # big winner sprites
    #
    if test $BIGO -eq 1; then
	povray BigWinner.ini
    fi
    #
    # special sprites
    #
    if test $SPEC -eq 1; then 
	povray AllPlayerSpecial.ini HiQ.ini
    fi
    # 
    # "normal" sprites
    #
    if test $NORM -eq 1; then
	povray AllPlayerAnimation.ini HiQ.ini
    fi
    #
    # back to top dir
    #
    popd
    #
done

#
# now the skeletons
#
if test $SKEL -eq 1; then
    #
    # go to sprite subdir
    # 
    pushd ./skeleton
    #
    # render it
    #
    povray Skeleton.ini HiQ.ini
    #
    # back to top dir
    #
    popd
    #
fi

#
# end file render.sh
#



