/*  SCAVENGER by David Ashley  dash@netcom.com dash5@geocities.com */
/*
 * scavserver.c - VoxWare(tm) Compatible Sound - Apr. 1995
 *                 PC Speaker  Compatible Sound 
 *                 This server is Linux Specific.
 *
 * Copyright 1994-1995 Sujal M. Patel (smpatel@wam.umd.edu)
 * Conditions in "copyright.h"
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#if defined(__FreeBSD__)  || defined(__NetBSD__) || defined(__OpenBSD__)
#include <machine/soundcard.h>
#else
#include <linux/soundcard.h>
#endif
/*#include "linux_pcsp.h"	*/	/* /usr/include/linux/pcsp.h      */
#include <sys/time.h>
#include <signal.h>
#include <string.h>

char *dirlist;

char           *FILENAME[] =
{
  "fall.raw",
  "dig.raw",
  "pop.raw",
  "victory.raw",
  "death.raw"

};

#define NUM_SOUNDS	(sizeof(FILENAME)/sizeof(char*))

signed char    *sound_buffer[NUM_SOUNDS];
int             sound_size[NUM_SOUNDS];
int             fragsize;


/* Terminate: Signal Handler */
void
quit ()
{
  exit (0);
}



void
init (int argc, char **argv)
{
  int             i;
/*  char            s[1024];*/

  if (argc != 3)
    {
      printf ("This program is only executed by Scavenger\n");
      exit (1);
    }

	dirlist=argv[1];

  for (i = 0; i < NUM_SOUNDS; i++)
    {
/*
      s[0] = 0;
      strcat (s, argv[1]);
      if (s[(int) strlen (s) - 1] == '/')
	FILENAME[i]++;
      strcat (s, FILENAME[i]);
      FILENAME[i] = malloc ((int) strlen (s) + 1);
      strcpy (FILENAME[i], s);
*/
      sound_buffer[i] = NULL;
      sound_size[i] = 0;
    }

  signal (SIGTERM, quit);	/* Setup Terminate Signal Handler */
}


/*
   Setup DSP: Opens /dev/dsp or /dev/pcdsp
   Sets fragment size on VoxWare
   Sets speed to 8000hz
   Should set mono mode
   Error checking                
 */
int
setup_dsp (char *dspdev, int *is_pcsp)
{
  int             dsp, frag, value;
  int             mixer;

  dsp = open (dspdev, O_RDWR);
  if (dsp < 1)
    {
      fprintf (stderr, "scavserver: Couldn't open DSP %s, you must play without sound.\n", dspdev);
      return -1;
    }

  *is_pcsp = 0;
  fragsize = 0;

  frag = 0x00020009;		/* try 512 bytes, for 1/16 second frag size */
  ioctl (dsp, SNDCTL_DSP_SETFRAGMENT, &frag);
  value = 10000 /*8010*/;
  if (ioctl (dsp, SNDCTL_DSP_SPEED, &value))
    {
      fprintf (stderr, "scavserver: Couldn't set DSP rate!\n");
    };
  value = 0;
  ioctl (dsp, SNDCTL_DSP_STEREO, &value);
  ioctl (dsp, SNDCTL_DSP_GETBLKSIZE, &fragsize);
/*  fprintf(stderr,"scavserver: fragment set to %d\n",fragsize); */

  if (!fragsize)
    {
      /* Don't Assume just because you can't set the fragment, use proper IOCTL */
      fprintf (stderr, "scavserver: Couldn't set Fragment Size.\nAssuming PC Speaker!\n");
      fragsize = 128;
      *is_pcsp = 1;
    }
  else
    {
      mixer = open ("/dev/mixer", O_RDWR | O_NONBLOCK);
      if (mixer == -1)
	{
	  fprintf (stderr, "scavserver: Couldn't open mixer %s\n", "/dev/mixer");
	  return (-1);
	};
#if 0
      value = 0x6464;
      ioctl (mixer, SOUND_MIXER_WRITE_PCM, &value);
      ioctl (mixer, SOUND_MIXER_WRITE_VOLUME, &value);	/*what does this do? */
#endif
      close (mixer);

    }

  return dsp;
}

int
read_sound (int k)
{
  int             i, fd, size;
  
char namearea[256],*p1,*p2,ch;

	p1=dirlist;
	for(;;)
	{
		p2=namearea;
		while(*p1 && (ch=*p1++)!=',')
			*p2++=ch;
		if(p2>namearea && p2[-1]!='/') *p2++='/';
		strcpy(p2,FILENAME[k]);
		fd=open (namearea, O_RDONLY);
		if(fd>=0) break;
		if(!*p1)
		{
			fprintf (stderr, "scavserver: The sound %s number %i could not be opened\n", FILENAME[k], k);
			sound_size[k] = -1;
			return (0);
		}
	}
	

/*
  fd = open (FILENAME[k], O_RDONLY);
  if (fd <= 0)
    {
      fprintf (stderr, "scavserver: The sound %s number %i could not be opened\n", FILENAME[k], k);
      sound_size[k] = -1;
      return (0);
    };
*/
  size = lseek (fd, 0, SEEK_END);
  sound_size[k] = (size / fragsize) + 1;	/*size in fragments */
  sound_buffer[k] = malloc ((sound_size[k] + 1) * fragsize);
  if (sound_buffer[k] == NULL)
    {
      fprintf (stderr, "scavserver: couldn't malloc memory for sound\n");
      sound_size[k] = -1;
      close (fd);
      return (0);
    };
  lseek (fd, 0, SEEK_SET);
  read (fd, sound_buffer[k], size);
  close (fd);
  for (i = 0; i < size; i++)
    sound_buffer[k][i] ^= 0x80;
  memset (sound_buffer[k] + size, 0, sound_size[k] * fragsize - size);

  /*fprintf(stderr,"sound has been loaded, %d bytes\n",size); *//*DEBUG */
  return (1);
}


void
do_everything (int dsp, int is_pcsp)
{
  int             k;
  int             i, j;
  int             playing[16];	/* Sound numbers that we are playing                     */
  int             position[16];	/* Current position in each sound file */
  int             playnum = 0;	/* Number of sounds currently being played               */
  unsigned char   final[512];	/* Final Mixing Buffer                                   */
  int             premix[512],*ip;
  char           *sample;
  unsigned char clip[8192],*fp;

  char commands[64],*comtake;
  int comlen;


	for(i=0;i<8192;i++)
	{
		j=i-4096;
		clip[i]=j > 255 ? 255 : (j < -256 ? 0 : (j >> 1) + 128);
	}

	for (;;)
	{
      /* Try to open a new sound if we get an integer on the 'in' pipe */
		i = read (STDIN_FILENO, commands, sizeof (commands));
		if (i == 0)
		{			/* EOF on pipe means parent has closed its end */
	  /*fprintf(stderr,"scavserver: shutting down\n"); */
			kill (getpid (), SIGTERM);
		}
		if (i != -1)
		{
	  /* Negative means silence */

			comlen=i;
			comtake=commands;
			while(comlen--)
			{
				k=(int) *comtake++;
				if (k < 0)
				{
					playnum=0;
				}
				else
				{
					if(k<NUM_SOUNDS) /* DA */
					{
						if (sound_size[k] == 0)
							read_sound (k);
					     if (sound_size[k] > 0 && playnum < 16)
						{
							position[playnum] = 0;
							playing[playnum++] = k;
						}
					} else if(k>=64 && k<64+NUM_SOUNDS)
					{
						k-=64;
						for(i=0;i<playnum;i++)
							if(playing[i]==k)
								position[i]=sound_size[k];
					}
				}
			}
		}

		/* terminate a sound if necessary */
		for (i = 0; i < playnum; i++)
		{
			if ((position[i] >= sound_size[playing[i]]) )
			{
				memmove (playing + i, playing + i + 1, (playnum - i) * sizeof (int));
				memmove (position + i, position + i + 1, (playnum - i) * sizeof (int));
				playnum--;
				i--;
			}
		}

		if (playnum)
		{
			/* Mix each sound into the final buffer */
			memset (premix, 0, sizeof (premix));
			for (i = 0; i < playnum; i++)
			{
				sample = sound_buffer[playing[i]] + position[i] * fragsize;
				j=fragsize;
				ip=premix;
				while(j--) *ip++ += *sample++;
	    			position[i]++;
			}
	
			i=fragsize;
			ip=premix;
			fp=final;
			while(i--) *fp++ = clip[*ip++ + 4096];
		} else
		{
		  /* 
		     We have no sounds to play
		     Just fill the buffer with silence and maybe play it 
		   */
			memset (final, 128, sizeof (final));
		}
		if(dsp>=0) write (dsp, final, fragsize);
	}
}



void
main (argc, argv)
     int             argc;
     char          **argv;
{
  int             dsp, is_pcsp;

  fcntl (STDIN_FILENO, F_SETFL, O_NONBLOCK);
  init (argc, argv);
  dsp = setup_dsp (argv[2], &is_pcsp);

  do_everything (dsp, is_pcsp);
}
