/*
	Standard object values.

 */

#include "swserv.h"



int NetHandleObjectValues(int condescriptor, char *arg)
{
        static long object_num, con_object_num;

	static int loc_type;        
        static long locked_on;
        static long intercepting_object;

        static int thrust_rev_state;
        static double thrust_dir;
        static double thrust;
        static double throttle;

        static int lighting;	/* Real type is xswo_lighting_t. */
        static double hp;
        static double power;
        static double antimatter;
        static int shield_state;
  
        static int selected_weapon;
        static int cloak_state;
        static double cloak_strength;
        static double visibility;
        
        static int damage_control;
        
        static xsw_object_struct *obj_ptr;
        
 
        con_object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(con_object_num))
            return(-1);
        else
            obj_ptr = xsw_object[con_object_num];
        
        
        /*
         *	SWEXTCMD_STDOBJVALS format:
         *
         *      object_num,
         *      loc_type, locked_on, intercepting_object,
         *      thrust_rev_state, thrust_dir, thrust, throttle,
         *      lighting, hp, power,
         *      antimatter, shield_state, selected_weapon, cloak_state,
         *      cloak_strength, visibility, damage_control
         */
        sscanf(arg,
"%ld\
 %i %ld %ld\
 %i %lf %lf %lf\
 %i %lf %lf\
 %lf %i %i %i\
 %lf %lf %i",

                &object_num,

                &loc_type,
                &locked_on, 
                &intercepting_object,

                &thrust_rev_state,
                &thrust_dir,
                &thrust,
                &throttle,

                &lighting,
                &hp,
                &power,

                &antimatter,
                &shield_state,
                &selected_weapon,
                &cloak_state,

                &cloak_strength,
                &visibility,
                &damage_control
        ); 


        /* Connection must own object. */
        if(object_num != con_object_num)
            return(-3);


        /* Set throttle. */
        if(throttle < 0.0) 
            throttle = 0.0;
        else if(throttle > 1.0)
            throttle = 1.0;

        obj_ptr->throttle = throttle;


        /* *** Everything else is tossed away. *** */


        return(0);
}


int NetSendObjectValues(int condescriptor, long object_num)
{
        static char sndbuf[CS_DATA_MAX_LEN];
        static xsw_object_struct *obj_ptr;


        if(DBIsObjectGarbage(object_num))
            return(-1);
        else
            obj_ptr = xsw_object[object_num];


        /*
         *      SWEXTCMD_STDOBJVALS format:
         *
         *      object_num,
         *      loc_type, locked_on, intercepting_object,
         *      thrust_rev_state, thrust_dir, thrust, throttle,
         *      lighting, hp, power,
         *      antimatter, shield_state, selected_weapon, cloak_state,
         *      cloak_strength, visibility, damage_control
         */
        sprintf(sndbuf,
"%i %i %ld\
 %i %ld %ld\
 %i %.4lf %.4lf %.4lf\
 %i %.4lf %.4lf\
 %.4lf %i %i\
 %i %.4lf %.4lf %i\n",

                CS_CODE_EXT,
                SWEXTCMD_STDOBJVALS,

                object_num,
        
                obj_ptr->loc_type,
                obj_ptr->locked_on,
                obj_ptr->intercepting_object,

                0,		/* thrust_rev_state, no longer used. */
                obj_ptr->thrust_dir,
                obj_ptr->thrust,
                obj_ptr->throttle,

                obj_ptr->lighting,
                obj_ptr->hp,
                obj_ptr->power,

                obj_ptr->antimatter,
                obj_ptr->shield_state,
                obj_ptr->selected_weapon,

                obj_ptr->cloak_state,
                obj_ptr->cloak_strength,
                obj_ptr->visibility,
                obj_ptr->damage_control
        );
        NetDoSend(condescriptor, sndbuf);


        return(0);
}
