/*
                          Unit Conversions

	Functions: 

	double ConvertRUToAU(double x)
	double ConvertRUToSU(double x)

	double ConvertVelocityRUPCToRUPS(double x)
	double ConvertVelocityRUPCToAUPS(double x)

	---

	See ../include/reality.h for official conversion table.

 */

#include <stdio.h>
#include <math.h>

#include "../include/reality.h"



/*
 *	Convert XSW real units to Astronomical units.
 */
double ConvertRUToAU(double x)
{
        return(x * sw_units.ru_to_au);
}

/*
 *	Convert XSW real units to screen units.
 */
double ConvertRUToSU(double x)
{
	return(x * 1000);
}


/*
 *	Convert velocity in XSW real units per cycle (quantom)
 *	XSW real units per second.
 */
double ConvertVelocityRUPCToRUPS(double x)
{
        return(
            x * (1000 / (double)CYCLE_LAPSE_MS)
        );
}

/*
 *      Convert velocity in XSW real units per cycle (quantom)
 *      to Astronomical units per second.
 */
double ConvertVelocityRUPCToAUPS(double x)
{
        return(
            (x * sw_units.ru_to_au) *    /* Convert real units to meters. */
            (1000 / (double)CYCLE_LAPSE_MS)
        );
}
