// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

//JAS import vrml.external.*;
//JAS import vrml.external.field.*;
//JAS import vrml.external.exception.*;
import java.util.Hashtable;

public class EAIObject extends VRMLObject implements EventOutObserver
{
    Node[]			nodes;
    EventIn[]			eventIns;
    EventOut[]			eventOuts;
    EventOut			clicked;
    Browser			browser;

    private EventInMFNode	textNodes;
    private EventOutMFNode	objectNodes;

    public EAIObject(int id, String URL, Browser browser,
   		     VRMLObjectObserver observer)
    {
	super(id, URL, observer);
	this.browser = browser;
	create();
	clicked = nodes[0].getEventOut("clicked");
	clicked.advise(this, clicked);
    }

    // creates the necessary VRML nodes for a placeholder for this object
    public void create()
    {
        try {
            nodes = browser.createVrmlFromString(
            "PROTO Avatar [ \n"
          + "  exposedField SFVec3f position 0 0 0 \n"      
          + "  exposedField SFRotation orientation 0 0 0 0 \n"
          + "  exposedField SFVec3f scale 1.0 1.0 1.0 \n"
          + "  exposedField MFString name \"\"\n"
          + "  exposedField MFNode objectNodes [] \n"
	  + "  exposedField MFNode textNodes [] \n"
	  + "  eventOut SFBool clicked \n"
          + "] { \n"
          + " Transform { \n"
          + "  translation IS position \n"
          + "  rotation IS orientation \n"
          + "  children [ \n"  //JAS 
// JAS 	  + "    Collision { \n"  //JAS 
// JAS 	  + "      collide FALSE \n"  //JAS 
// JAS	  + "      children [ \n"
//ADD CUBE HERE to see container JAS
//+ " Shape { appearance Appearance { material Material { } } geometry Sphere {radius 0.2 } }"

          + "        Transform { \n"
          + "          rotation 0 1 0 3.14159 \n"
          + "          children [ \n"
          + "            Transform { \n"
          + "              translation 0.0 0.7 0.0 \n"
          + "              scale 0.2 0.2 0.2 "
          + "              children Billboard { \n " 
	  + "                children IS textNodes \n "
	  + "              } \n"
          + "            } \n"
          + "            Transform { \n"
          + "              scale IS scale \n"
          + "              children IS objectNodes \n"
          + "            } \n"
          + "            TouchSensor { \n"
	  + "              isActive IS clicked \n"
          + "            } \n"
          + "          ] \n"
          + "        } \n"
	  + "      ] \n"
 // JAS	  + "    } \n" //JAS
// JAS          + "  ] \n"  //JAS 
          + " } \n"   
          + "} \n"
          + "Avatar {}");

	    eventIns = new EventIn[VIP.NUM_FIELDS];
	    eventOuts = new EventOut[VIP.NUM_FIELDS];

	    // get the EventIn's and EventOut's

	    for (int i = 0; i < VIP.NUM_FIELDS; i++) {
		eventIns[i] = nodes[0].getEventIn(fieldNames[i]);
		eventOuts[i] = nodes[0].getEventOut(fieldNames[i]);
	    }

	    textNodes = (EventInMFNode) nodes[0].getEventIn("textNodes");
	    objectNodes = (EventOutMFNode) nodes[0].getEventOut("objectNodes");

	} catch (Exception e) {
	    // it'll never happen.. (famous last words)
            System.err.println(e);
	}
    }

    protected void doSetField(short field, VField value)
    {
	EventIn e = eventIns[field];
	if (e != null) {
	    switch (value.getType()) {
	      case VField.SFVEC3F:
		((EventInSFVec3f) e).setValue(((VSFVec3f) value).getValue());
		break;
	      case VField.SFROTATION:
		((EventInSFRotation) e).setValue(((VSFRotation) value).getValue());
		break;
	      case VField.MFSTRING:
		((EventInMFString) e).setValue(((VMFString) value).getValue());
		break;
	      case VField.SFSTRING:
		((EventInSFString) e).setValue(((VSFString) value).getValue());
		break;
	      case VField.SFBOOL:
		((EventInSFBool) e).setValue(((VSFBool) value).getValue());
		break;
	    }
	}
    }

    public static VField toVField(EventOut e) {
	switch (e.getType()) {
	  case FieldTypes.SFVEC3F:
	    return new VSFVec3f(((EventOutSFVec3f) e).getValue());
	  case FieldTypes.SFROTATION:
	    return new VSFRotation(((EventOutSFRotation) e).getValue());
	  case FieldTypes.MFSTRING:
	    return new VMFString(((EventOutMFString) e).getValue());
	  case FieldTypes.SFSTRING:
	    return new VSFString(((EventOutSFString) e).getValue());
	  default:
	    throw new UnsupportedFieldTypeException();
	}
    }

    public void load()
    {
        String          strs[] = { URL };

        if (URL.length() > 0) {
	    objectNodes.advise(this, objectNodes);
            browser.createVrmlFromURL(strs, nodes[0], "objectNodes");
        }
    }

    public void setName(String name) {
	super.setName(name);
   
	// FIXME:  the following is a gross hack to work around
	// a NS4.0 crash on Win95.
	// instead of just setting the string EventIn in the Text node,
	// we have to create a whole new Text node.

	textNodes.setValue(browser.createVrmlFromString(
            "Shape { \n"
          + "  geometry Text { \n"
          + "    string \"" + name + "\" \n"
          + "    fontStyle FontStyle { \n"
          + "      justify  \"MIDDLE\" \n"
          + "      family   \"SANS\" \n"
          + "    } \n"
          + "  } \n"
          + "} \n"));
    }   

    public void callback(EventOut value, double timeStamp, Object data)
    {
System.out.println ("callback in EAIObject " + value.RLreturn);

	if (data == clicked) {
//JAS
System.out.println ("Clicked callback! - raw data is " + value.RLreturn);
	    if (((EventOutSFBool) value).getValue()) {
		observer.onClicked(this);
	    }
	} else if (data == objectNodes && !loaded) {
	    onLoaded();
	}
    }

    private void onLoaded()
    {
 	Node node = objectNodes.get1Value(0);
 	while (node.getType().equals("Group")) {
 		node = ((EventOutMFNode) node.getEventOut("children")).get1Value(0);
 	}

 	EventOutMFString gestureList;

	loaded = true;

 	try {
 	    gestureList = (EventOutMFString) node.getEventOut("gestures");
 	} catch (InvalidEventOutException e) {
 	    System.out.println(name + ":  no gestures found");
 	    gestureList = null;
 	}

 	if (gestureList != null) {
 	    gestures = gestureList.getValue();
 	    int		numFields = VIP.NUM_FIELDS + gestureList.getSize();
 	    EventIn[] newEventIns = new EventIn[numFields];
 	    VField[] newFields = new VField[numFields];
 	    for (int i = 0; i < VIP.NUM_FIELDS; i++) {
 		newEventIns[i] = eventIns[i];
 		newFields[i] = fields[i];
 	    }
 
 	    for (int i = 0; i < gestureList.getSize(); i++) {
 		newFields[VIP.NUM_FIELDS + i] = new VSFBool(false);
 		try {
 		    newEventIns[VIP.NUM_FIELDS + i] = node.getEventIn(gestures[i]);
 		} catch (InvalidEventInException e) {
 		    System.out.println(name + ":  invalid gesture \"" + gestures[i] + "\"");
 		}
 	    }
 	    fields = newFields;
 	    eventIns = newEventIns;
 	}
	observer.onLoaded(this);
  }
}
