// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import vrml.*;
import vrml.node.*;
import vrml.field.*;
import java.util.Hashtable;

public class JSAIObject extends VRMLObject
{
    BaseNode[]		nodes;
    Field		eventIns[];
    Node		objectTransform;
    Browser		browser;

    public JSAIObject(int id, String URL, Browser browser,
		      VRMLObjectObserver observer)
    {
	super(id, URL, observer);
	this.browser = browser;
	create();
    }

    public void create() {
	// since LR doesn't support PROTO's in createVRMLFromString(),
	// we'll have to do this "by hand" (ugh)

	try {
	    nodes = browser.createVrmlFromString(
	    "Transform { "
	  + "  children [ "
	  + "    Transform { "
	  + "      rotation 0 1 0 3.14159 "
	  + "      children [ "
	  + "        Transform { "
	  + "          translation 0.0 0.7 0.0 "
	  + "          scale 0.05 0.05 0.05"
	  + "          children [ "
	  + "            Billboard { "
	  + "              children [ "
	  + "                Shape { "
	  + "                  geometry Text { "
	  + "                    fontStyle FontStyle { "
	  + "                      justify  \"MIDDLE\" "
	  + "                      family   \"SANS\" "
	  + "                    } "
	  + "                  } " 
	  + "                } "
	  + "              ] "
	  + "            } "
	  + "          ] "
	  + "        } "
	  + "        Transform { "
	  + "        } "
	  + "        TouchSensor { "
	  + "        } "
	  + "      ] "
	  + "    } "
	  + "  ] "
	  + "} ");

	    Node main = (Node) this.nodes[0];
	    eventIns = new Field[4];
	    eventIns[VIP.POSITION] = main.getExposedField("translation");
	    eventIns[VIP.ORIENTATION] = main.getExposedField("rotation");
    
	    // get its first child (transform -- 180deg rotation)
	    Node rot = (Node) ((MFNode) main.getExposedField("children")).get1Value(0);
	    // get its first child (translate for text)
	    Node textTransform = (Node) ((MFNode) rot.getExposedField("children")).get1Value(0);

	    // get its first child (Billboard)
	    Node billboard = (Node) ((MFNode) textTransform.getExposedField("children")).get1Value(0);

	    // get its first child (Shape)
	    Node shape = (Node) ((MFNode) billboard.getExposedField("children")).get1Value(0);

	    // get its geometry (text)
	    Node text = (Node) ((SFNode) shape.getExposedField("geometry")).getValue();

	    // get the string
	    eventIns[VIP.NAME] = text.getExposedField("string");
    
	    // get second child of main transform (transform for avatar nodes)
	    objectTransform = (Node) ((MFNode) rot.getExposedField("children")).get1Value(1);
    
	    eventIns[VIP.SCALE] = objectTransform.getExposedField("scale");

	} catch (Exception e) {
	    // the above should really be InvalidVRMLSyntaxException,
	    // but it won't compile against the CommunityPlace classes.

	    // it'll never happen.. (famous last words)
	    System.err.println("invalid syntax?");
	}
    }

    protected void doSetField(short field, VField value) {
	Field e = eventIns[field];
        if (e != null) {
	    switch (value.getType()) {
	      case VField.SFVEC3F:
		((SFVec3f) e).setValue(((VSFVec3f) value).getValue());
		break;
	      case VField.SFROTATION:
		((SFRotation) e).setValue(((VSFRotation) value).getValue());
		break;
	      case VField.MFSTRING:
		((MFString) e).setValue(((VMFString) value).getValue());
		break;
	      case VField.SFSTRING:
		((SFString) e).setValue(((VSFString) value).getValue());
		break;
	    }
	}
    }

    public static VField toVField(ConstField e) {
	if (e instanceof ConstSFVec3f) {
	    float[]	v = new float[3];
	    ((ConstSFVec3f) e).getValue(v);
	    return new VSFVec3f(v);
	} else if (e instanceof ConstSFRotation) {
	    float[]	v = new float[4];
	    ((ConstSFRotation) e).getValue(v);
	    return new VSFRotation(v);
	} else if (e instanceof ConstMFString) {
	    ConstMFString	es = (ConstMFString) e;
	    String[]	strings = new String[es.getSize()];
	    es.getValue(strings);
	    return new VMFString(strings);
	} else if (e instanceof ConstSFString) {
	    return new VSFString(((ConstSFString) e).getValue());
	} else {
	    throw new UnsupportedFieldTypeException();
	}
    }

    public void load() {
        String          strs[] = { URL };
	
        try {
            browser.createVrmlFromURL(strs, objectTransform, "set_children");
        } catch (Exception e) {
        }
    }
}
