// copyright (c) 1997-1998 stephen f. white, jeff sonstein
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.awt.*;
import java.util.StringTokenizer;

public class TalkerPanel extends BorderPanel implements UserListObserver
{
    // login window widgets
    static final int	fieldWidth = 10;
    TextField		usernameText = new TextField(fieldWidth);
    TextField		passwordText = new TextField(fieldWidth);
    TextField		avatarURLText = new TextField(fieldWidth);
    Choice		avatar = new Choice();
    JanneButton		loginButton = new JanneButton("Connect");
    Label		avatarLabel = new Label("Avatar URL:", Label.RIGHT);
    CardLayout		layout = new CardLayout();
    BorderPanel		loginText = new BorderPanel();

    // main window widgets
    TextArea		outputText = new TextArea();
    TextField		inputText = new TextField();
    Scrollbar           scaleBar = new Scrollbar(Scrollbar.VERTICAL, 0, 100,
                                                 0, 1000);
    
    Panel		inputPanel = new Panel();
    Panel		buttonPanel = new Panel();
    JanneButton		whisperButton = new JanneButton("Whisper");
    JanneButton		oobeButton = new JanneButton("OOBE");
//    JanneButton		buildButton = new JanneButton("Build");
    JanneButton		quitButton = new JanneButton("Quit");

    UserList		userList = new UserList(this);
    JanneButton[]	gestureButtons;

//    Builder		builder;

    int			selectedUser = -1;

    boolean		connected;

    String[]		avatarNames;
    String[]		avatarURLs;
    String		hostname;
    int			port;
    String		username;
    String		password;
    String		avatarURL;
    boolean		custom = false;

    int			userVid;

    Dispatcher		dispatcher;

    public TalkerPanel(Dispatcher dispatcher,
		       String hostname, int port,
		       String[] avatarNames, String[] avatarURLs) {

	this.dispatcher = dispatcher;
//	builder = new Builder(dispatcher);
	this.hostname = hostname;
	this.port = port;
	this.avatarNames = avatarNames;
	this.avatarURLs = avatarURLs;

	setLayout(layout);
        setStyle(BorderPanel.RAISED);

	add("login", buildLoginWindow());
//	add("build", builder);
	add("main", buildMainWindow());

	for (int i = 0; i < avatarNames.length; i++) {
	    avatar.addItem(avatarNames[i]);
	}

	showCustomStuff(custom);
	layout.show(this, "login");
    }

    Panel buildMainWindow()
    {
	Panel			mainPanel = new Panel();
	Panel			userPanel = new Panel();

	Panel			mainWindow = new Panel();

	mainWindow.setLayout(new BorderLayout());
	mainPanel.setLayout(new BorderLayout());
	inputPanel.setLayout(new BorderLayout());
	userPanel.setLayout(new BorderLayout());
	buttonPanel.setLayout(new GridLayout(1, 3));

	whisperButton.disable();

	buttonPanel.add(whisperButton);
	buttonPanel.add(oobeButton);
//	buttonPanel.add(buildButton);
	buttonPanel.add(quitButton);

	outputText.setEditable(false);

	inputPanel.add("Center", inputText);
	inputPanel.add("East", buttonPanel);

        mainPanel.add("Center", outputText);
	mainPanel.add("South", inputPanel);
        mainPanel.add("West", scaleBar);

	userPanel.add("Center", userList);
	userPanel.add("North", new Label("Users"));

	mainWindow.add("Center", mainPanel);
        mainWindow.add("East", userPanel);

	return mainWindow;
    }
    
    Panel buildLoginWindow() {
	Panel	mainLoginPanel = new Panel();
	Panel	loginButtonPanel = new Panel();
	Panel	loginPanel = new Panel();
	Panel	eastPanel = new Panel();

	loginPanel.setLayout(new GridLayout(1, 2));
	eastPanel.setLayout(new BorderLayout());
	mainLoginPanel.setLayout(new GridLayout(5, 2));

	usernameText.setText(username);
	passwordText.setText(password);
	passwordText.setEchoCharacter('*');

	mainLoginPanel.add(new Label("Name:", Label.RIGHT));
	mainLoginPanel.add(usernameText);
//	mainLoginPanel.add(new Label("Password:", Label.RIGHT));
//	mainLoginPanel.add(passwordText);
	mainLoginPanel.add(new Label("Avatar:", Label.RIGHT));
	mainLoginPanel.add(avatar);
	mainLoginPanel.add(avatarLabel);
	mainLoginPanel.add(avatarURLText);

	eastPanel.add("North", mainLoginPanel);
	eastPanel.add("South", loginButtonPanel);

	loginButtonPanel.add(loginButton);

	loginText.setLayout(new GridLayout(0, 1));
	loginText.setStyle(BorderPanel.IN);
	loginText.add(new Label("1) Type the name or handle you wish to use"));
	loginText.add(new Label("   in the name field."));
	loginText.add(new Label("2) Select one of the avatars to embody yourself"));
	loginText.add(new Label("   If you choose custom, then you may type in"));
        loginText.add(new Label("   a URL to any valid VRML object."));
        loginText.add(new Label(" "));
        loginText.add(new Label("Note: there is currently no check on the validity"));
        loginText.add(new Label("      or size of an avatar."));

	loginPanel.add(loginText);
	loginPanel.add(eastPanel);

	return loginPanel;
    }

    public void setConnected(int vid) {
	connected = vid != -1;
	userVid = vid;
	enable();
	if (connected) {
	    outputText.setText("");
	    layout.show(this, "main");
	    inputText.requestFocus();
	} else {
	    layout.show(this, "login");
	}
    }

    private void showCustomStuff(boolean cond)
    {
	avatarLabel.enable(cond);
	avatarURLText.enable(cond);
    }

    public boolean handleEvent(Event evt)
    {
	if (evt.target == inputText && evt.id == Event.ACTION_EVENT) {
	    dispatcher.sendMessage(username + ":  "+ inputText.getText()
				   + "\n");
	    inputText.setText("");
	    return true;
	} else if (evt.target == whisperButton && evt.id == Event.ACTION_EVENT) {
	    dispatcher.sendPrivateMessage(userVid, "Whispered to " +
		userList.getSelectedItem() + ":  " + inputText.getText() +
		"\n");
	    dispatcher.sendPrivateMessage(selectedUser,
		username + " whispers: " + inputText.getText() + "\n");
	    inputText.setText("");
	    inputText.requestFocus();
	    return true;
//	} else if (evt.target == buildButton && evt.id == Event.ACTION_EVENT) {
//	    layout.show(this, "build");
//	    return true;
	} else if (evt.target == oobeButton && evt.id == Event.ACTION_EVENT) {
	    dispatcher.toggleOOBE();
	    return true;
	} else if (evt.target == quitButton && evt.id == Event.ACTION_EVENT) {
	    disable();
	    dispatcher.send(userVid, VIP.QUIT, null);
	    return true;
	} else if (evt.target == loginButton && evt.id == Event.ACTION_EVENT
		|| evt.target == passwordText && evt.id == Event.ACTION_EVENT
		|| evt.target == usernameText && evt.id == Event.ACTION_EVENT
		|| evt.target == avatarURLText && evt.id == Event.ACTION_EVENT) {
	    username = usernameText.getText().trim();
	    password = passwordText.getText();
	    if (custom) {
		avatarURL = avatarURLText.getText();
	    } else {
		avatarURL = avatarURLs[avatar.getSelectedIndex()];
	    }
	    if (username.length() == 0) {
		dispatcher.onError("You must specify the name you wish to use.");
		usernameText.requestFocus();
	    } else if (avatarURL.length() == 0) {
		dispatcher.onError("You must specify the URL for your custom avatar.");
		avatarURLText.requestFocus();
	    } else {
		dispatcher.onLogin(hostname, port, username, avatarURL);
	    }
	    return true;
	} else if (evt.target == avatar && evt.id == Event.ACTION_EVENT) {
	    custom = avatar.getSelectedItem().equals("Custom");
	    showCustomStuff(custom);
	    return true;
        } else if (evt.target == scaleBar &&
            (evt.id == Event.SCROLL_ABSOLUTE
          || evt.id == Event.SCROLL_LINE_UP
          || evt.id == Event.SCROLL_LINE_DOWN
          || evt.id == Event.SCROLL_PAGE_UP
          || evt.id == Event.SCROLL_PAGE_DOWN)) {
            dispatcher.scaleAvatar(((float) (1000 - scaleBar.getValue())) / 1000.0F);
            return true;
	} else if (connected
		   && evt.id == Event.GOT_FOCUS && evt.target == outputText) {
	    inputText.requestFocus();
	    return true;
	} else if (gestureButtons != null) {
	    for (short i = 0; i < gestureButtons.length; i++) {
		if (evt.target == gestureButtons[i]
			&& evt.id == Event.ACTION_EVENT) {
		    dispatcher.gesture(i);
		    return true;
		}
	    }
	}
	return false;
    }

    public void appendText(String str)
    {
	outputText.appendText(str);
    }

    public void onUserListSelect(int vid)
    {
	selectedUser = vid;
	if (vid != -1) whisperButton.enable();
//	builder.setSelection(vid);
    }

    public void onUserListDeselect()
    {
	selectedUser = -1;
	whisperButton.disable();
//	builder.setSelection(-1);
    }

    public void setSelection(int vid) {
	userList.selectUser(vid);
//	builder.setSelection(vid);
    }

    public void addGestures(String[] gestures) {
	buttonPanel.removeAll();
	if (gestures != null) {
	    gestureButtons = new JanneButton[gestures.length];
	    for (int i = 0; i < gestures.length; i++) {
		gestureButtons[i] = new JanneButton(gestures[i]);
		buttonPanel.add(gestureButtons[i]);
	    }
	}
	addButtons();
	inputPanel.validate();
    }

    public void addButtons() {
	buttonPanel.add(whisperButton);
	buttonPanel.add(oobeButton);
//	buttonPanel.add(buildButton);
	buttonPanel.add(quitButton);
    }
}
