/*
  gsumi version 0.5

  Copyright 1997 Owen Taylor <owt1@cornell.edu>

  gsumi is heavily based upon:

  xink version 0.02

  Copyright 1997 Raph Levien <raph@acm.org>

  This code is free for commercial and non-commercial use or
  redistribution, as long as the source code release, startup screen,
  or product packaging includes this copyright notice.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gsumi.h"

/* menu callbacks */

static void undo_callback(GtkWidget *w, gpointer data);
static void redo_callback(GtkWidget *w, gpointer data);
static void zoom_in_callback(GtkWidget *w, gpointer data);
static void zoom_out_callback(GtkWidget *w, gpointer data);
static void save_options_callback(GtkWidget *w, gpointer data);
static void clear_image_callback(GtkWidget *w, gpointer data);

static void menu_print_func (gpointer func_data, gchar *str);


GtkItemFactory *item_factory;
GtkAccelGroup  *accel_group;

/* local functions */

static GtkItemFactoryEntry menu_items[] =
{
  { "/File/New",            "<control>N",  do_new },
  { "/File/Open",           "<control>O",  do_open },
  { "/File/Save",           "<control>S",  do_save },
  { "/File/Save As...",      NULL,         do_save_as },
  { "/File/Input Dialog...", NULL,         do_input_dialog },
  { "/File/Toolbox...",      NULL,         do_tool_box },
  { "/File/Save Options",    NULL,         save_options_callback },
  { "/File/sep1",            NULL,         NULL, 0, "<Separator>" },
  { "/File/Quit",           "<control>Q",  do_exit }, 

  { "/Image/Undo",          "<control>Z",  undo_callback },
  { "/Image/Redo",          "<control>R",  redo_callback },
  { "/Image/Zoom In",       "equal",       zoom_in_callback },
  { "/Image/Zoom Out",      "minus",       zoom_out_callback },
  { "/Image/sep1",           NULL,         NULL, 0, "<Separator>" },
  { "/Image/Clear",         "<control>period",  clear_image_callback },
};

static int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

static void 
undo_callback(GtkWidget *w, gpointer data)
{
  undo();
}

static void
redo_callback(GtkWidget *w, gpointer data)
{
  redo();
}

static void
zoom_in_callback(GtkWidget *w, gpointer data)
{
  decrement_scale();
}
static void 
zoom_out_callback(GtkWidget *w, gpointer data)
{
  increment_scale();
}
static void 
save_options_callback(GtkWidget *w, gpointer data)
{
  save_gsumirc();
}

static void 
clear_image_callback(GtkWidget *w, gpointer data)
{
  rect rec;
  rec.x0 = 0;
  rec.x1 = bitmap->width;
  rec.y0 = 0;
  rec.y1 = bitmap->height;
  
  undo_begin();
  bitmap_update (&rec);
  undo_update(&rec);
  bitmap_clear();
}

/* Accelerator handling */

void 
menus_create (void)
{
  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, 
				       "<main>", 
				       accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
}

static void 
menu_print_func (gpointer func_data, gchar *str)
{
  /* Fix ItemFactory! Now! */

  gchar *path;
  gchar *accelerator;
  gchar *pos;

  /* Extract path */
  str = strchr (str, '"');
  g_return_if_fail (str != NULL);
  str++;
  
  pos = strchr (str, '"');
  g_return_if_fail (pos != NULL);

  path = g_new (gchar, pos - str + 1);
  strncpy (path, str, pos - str);
  path[pos - str] = '\0';

  str = pos+1;

  /* And accelerator specification */
  str = strchr (str, '"');
  g_return_if_fail (str != NULL);
  str++;
  
  pos = strchr (str, '"');
  g_return_if_fail (pos != NULL);

  accelerator = g_new (gchar, pos - str + 1);
  strncpy (accelerator, str, pos - str);
  accelerator[pos - str] = '\0';

  /* Store result */
  gsumirc_store_menu_path (path, accelerator);

  g_free (path);
  g_free (accelerator);
}

void 
menus_store (void)
{
  gtk_item_factory_dump_items (NULL, TRUE, menu_print_func, NULL);
}

void 
menus_add_path (char *path,
	        char *accelerator)
{
  GtkWidget *widget;

  g_return_if_fail (item_factory != NULL);
  
  widget = gtk_item_factory_get_widget (item_factory, path);

  if (widget != NULL)
    {
      guint key;
      GdkModifierType mods;

      gtk_accelerator_parse (accelerator, &key, &mods);

      if (key != 0)
	gtk_accel_group_add (accel_group,
			     key, mods, 
			     GTK_ACCEL_VISIBLE, 
			     GTK_OBJECT (widget), "activate");
    }
}

void 
menus_get_main_menubar (GtkWidget     **menu,
			GtkAccelGroup **group)
{
  *menu = gtk_item_factory_get_widget (item_factory, "<main>");
  *group = accel_group;
}
