// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PTDOpen.C

  Stephane Rehel

  October 26 1997
*/

#include <string.h>
#include <stdlib.h>

#include "kw/KWFileDialogManager.h"
#include "kw/KWDialog.h"

#include "photo/PhotoModule.h"
#include "photo/PhotoCommand.h"
#include "photo/PhotoCommands.h"

#include "PTDOpen.h"
#include "PTOpenDlg.h"

#include "image/MLImageFormat.h"

/////////////////////////////////////////////////////////////////////////////

PTDOpen::PTDOpen( PhotoModule* _photo ):
  MLGlobalDialog(_photo)
{
  photo= _photo;

  manager= new KWFileDialogManager;
}

/////////////////////////////////////////////////////////////////////////////

PTDOpen::~PTDOpen()
{
  photo= 0;

  delete manager; manager= 0;
}

/////////////////////////////////////////////////////////////////////////////

boolean PTDOpen::run()
{
  if( ! MLGlobalDialog::create(PTOpenDlg::data) )
    return false;

  manager->init( kwDialog,
                 PTOpenDlg::directories,
                 PTOpenDlg::files,
                 PTOpenDlg::location,
                 PTOpenDlg::selection,
                 PTOpenDlg::ok,
                 PTOpenDlg::cancel );

  static int currentFormatIndex= 1;

  int nFormats= MLImageFormat::getNFormats();

  static char* currentPath= 0;

  if( currentPath == 0 )
    currentPath= strdup("~");

  if( currentFormatIndex < 0 || currentFormatIndex > nFormats )
    currentFormatIndex= 1;

  kwDialog->appendListText( PTOpenDlg::formats, "Any" );

  int i;
  for( i= 0; i < nFormats; ++i )
    {
    MLImageFormat::FORMAT fmt= MLImageFormat::getFromIndex(i);
    MLString name= MLImageFormat::getName(fmt);
    kwDialog->appendListText( PTOpenDlg::formats, name );
    }

  kwDialog->setInteger( PTOpenDlg::formats, currentFormatIndex+1 );

  if( currentFormatIndex == 0 )
    manager->setPattern( MLString("*") );
   else
    {
    MLImageFormat::FORMAT fmt= MLImageFormat::getFromIndex(currentFormatIndex);
    manager->setPattern( MLString("*") + MLImageFormat::getExtension(fmt) );
    }

  manager->setPath(currentPath);

  manager->updateDirectories();

  kwDialog->focus(PTOpenDlg::selection);

  int outcome= kwDialog->run();
  int format_index= kwDialog->getInteger(PTOpenDlg::formats)-1;

  currentFormatIndex= format_index;
  free( (void*) currentPath );
  currentPath= strdup( kwDialog->getText(PTOpenDlg::location).get() );

  MLGlobalDialog::close();

  if( outcome == KWDialog::VALIDATE && manager != 0 )
    {
    MLString filename= manager->getFilename();

    PhotoCommand* cmd= new PhotoCommand;
    cmd->type= PhotoCommands::LOAD_IMAGE;
    cmd->string= filename;

    photo->post(cmd);

    return true;
    }

  return false;
}

/////////////////////////////////////////////////////////////////////////////

boolean PTDOpen::kwCallback( KWEvent& event )
{
  if( manager != 0 )
    if( manager->handleKWEvent(event) )
      return true;

  if( event.type == KWEvent::SELECT &&
      event.widget == PTOpenDlg::formats )
    {
    int i= kwDialog->getInteger(PTOpenDlg::formats)-1;
    int nFormats= MLImageFormat::getNFormats();
    if( (i >= 0 && i <= nFormats) && manager != 0 )
      {
      if( i == 0 )
        manager->setPattern( MLString("*") );
       else
        {
        MLImageFormat::FORMAT fmt= MLImageFormat::getFromIndex(i);
        manager->setPattern( MLString("*")+MLImageFormat::getExtension(fmt) );
        }

      manager->updateDirectories();

      kwDialog->focus(PTOpenDlg::selection);
      }

    return true;
    }

  return MLGlobalDialog::kwCallback(event);
}

/////////////////////////////////////////////////////////////////////////////

