/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     ginfo.c                                                        *
 *            GTK-notebook to display image information                      *
 * Author:    Andreas Tille                                                  *
 * Date:      20.10.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <unistd.h>
#include <sys/stat.h>
#include <sys/param.h>

#include "paul.h"
#include "callback.h"
#include "names.h"

static gint PageSwitchTag = 0;

static void PageSwitch(GtkWidget *widget, GtkNotebookPage *page, gint page_num)
/* Switch pages in info notebook
 * --- Parameter: ---
 * GtkWidget       *widget   : information notebook (connected to PAUL structure)
 * GtkNotebookPage *page     : current page (connected to PICTURE list)
 * gint             page_num : current page number
 */
{
  static int flag = 0;
  PAUL  *p;
  GList *pl;

  if ( flag ) {
    flag = 0;
    return;
  }
  
  g_return_if_fail ( GTK_IS_NOTEBOOK(widget) );
  g_return_if_fail ( (p  = (PAUL *)gtk_object_get_user_data(GTK_OBJECT(widget))) );
  g_return_if_fail ( IS_PAUL(p) );
  g_return_if_fail ( page && page->child );
  pl = (GList *)gtk_object_get_user_data(GTK_OBJECT(page->child));
  g_return_if_fail ( CheckPicList(pl) );

  gtk_clist_unselect_row(GTK_CLIST(p->filelist), ROW(p, p->activ), 0);
  p->activ = pl;
  flag = 1;
  SelectAndShowActiv(p);
}

static void CreatePages(GtkNotebook *notebook, PAUL *p)
{
  GtkWidget *child = NULL,
            *label,
            *label_box,
            *menu_box;
  GList     *pl;
  PICTURE   *bild;

  g_return_if_fail ( notebook );
  g_return_if_fail ( GTK_IS_NOTEBOOK(notebook) );
  g_return_if_fail ( IS_PAUL(p) );

  for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
    label_box = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(label_box);
    label     = gtk_label_new(bild->file);
    gtk_box_pack_start(GTK_BOX(label_box), label, FALSE, TRUE, 0);
    gtk_widget_show(label);
      
    menu_box = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(menu_box);
    label    = gtk_label_new(bild->file);
    gtk_box_pack_start(GTK_BOX(menu_box), label, FALSE, TRUE, 0);
    gtk_widget_show(label);

    child = gtk_frame_new(bild->file);
    gtk_notebook_append_page_menu(notebook, child, label_box, menu_box);
    InfoFrame(child, bild);
    gtk_object_set_user_data(GTK_OBJECT(child), pl);
  }
  
  gtk_notebook_set_tab_pos(notebook, GTK_POS_RIGHT);
  gtk_notebook_set_show_tabs(notebook, TRUE);
  gtk_notebook_set_scrollable(notebook, TRUE);
}


static void NotebookDestroy(GtkWidget *button, GtkWidget *window)
/* Destroy the info notebook
 * This is necessary to avoid displaying all images form active up to the last
 * by disconnecting the PageSwitch function
 * --- Parameter: ---
 * GtkWidget *button : can be ignored
 * GtkWidget *window : window to close (connected with notebook)
 */
{
   GtkWidget *notebook, *tmp;
   PAUL      *p;

   notebook = gtk_object_get_user_data(GTK_OBJECT(window));
   p        = gtk_object_get_user_data(GTK_OBJECT(notebook));
   if ( PageSwitchTag) gtk_signal_disconnect(GTK_OBJECT(notebook), PageSwitchTag);

   tmp = gtk_object_get_user_data(GTK_OBJECT(p->w));
   if ( tmp && (tmp != window) ) g_warning(_("Inconsistent data in info widget."));
   gtk_object_set_user_data(GTK_OBJECT(p->w), NULL);

   gtk_widget_destroy(window);
}

static void InfoCleanUp(GtkWidget *widget, PAUL *p)
/* Reset info flag
 */
{
   gtk_object_set_user_data(GTK_OBJECT(p->w), NULL);
   p->opt->f &= ~INFO;
}

void FileInfo(PAUL *p)
/* Create notebook with information about all pictures
 * --- Parameter: ---
 * PAUL      *p      : structure of all pictures
 * --- Return: ---
 * GtkWidget *(p->w) : the notebook window is set via gtk_object_set_user_data to
 *                     give other functions a chance to update the informations
 */
{
  static    GtkWidget *window = NULL;  /* notebook will be connected,       *
                                        * window will be connected to p->w  */
  GtkWidget           *box1, *box2, *button, *separator,
                      *notebook;       /* PAUL *p will be connected  */
  int                  x = -1, y = -1;

  g_return_if_fail ( IS_PAUL(p) );
  
  if ( window ) {
    gdk_window_get_position(window->window, &x, &y);
    NotebookDestroy(NULL, window);
  }
      
  if ( !p->piclist ) return;
  window   = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  if ( x > -1 && y > -1 ) gtk_widget_set_uposition(window, x, y);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);

  gtk_window_set_title(GTK_WINDOW(window), _("Image information"));
  gtk_container_set_border_width(GTK_CONTAINER(window), 0);

  box1     = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), box1);

  box2     = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(box1), box2);

  notebook = gtk_notebook_new();
  gtk_box_pack_start(GTK_BOX(box2), notebook, TRUE, TRUE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(notebook), 10);
  /*  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);  doesn't help to come from  *
   * last page via "next" to the first                                                       */
  gtk_object_set_user_data(GTK_OBJECT(notebook), p);

  gtk_widget_realize(notebook);
  CreatePages(GTK_NOTEBOOK(notebook), p);

#ifdef PHYSICAL_PAUL
  PhysicalInfoFrame(box2, &PG);
#endif

  separator = gtk_hseparator_new ();
  gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, TRUE, 10);
   
  box2      = gtk_hbox_new(FALSE, 10);
  gtk_container_set_border_width(GTK_CONTAINER(box2), 10);
  gtk_box_pack_start(GTK_BOX(box1), box2, FALSE, TRUE, 0);
   
  button    = gtk_button_new_with_label(_("close"));
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(button);
  gtk_object_set_user_data(GTK_OBJECT(window), notebook);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(InfoCleanUp), p);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(NotebookDestroy), GTK_OBJECT(window));
  gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(button);

  button = gtk_button_new_with_label(_("next"));
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_notebook_next_page),
                            GTK_OBJECT(notebook));
  gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

  button = gtk_button_new_with_label(_("previous"));
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_notebook_prev_page),
                            GTK_OBJECT (notebook));
  gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

  gtk_notebook_set_page(GTK_NOTEBOOK(notebook), GetListPosition(p->piclist, p->activ));
  PageSwitchTag = gtk_signal_connect(GTK_OBJECT(notebook), "switch_page", GTK_SIGNAL_FUNC(PageSwitch), p);
  /* set window as userdata of filelist window */
  gtk_object_set_user_data(GTK_OBJECT(p->w), window);
  p->opt->f |= INFO;

  gtk_widget_show_all(window);
}

