/***************************************************************************
                          racttag.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


#include <math.h>
#include <stdlib.h>

#include <qapplication.h>
#include <qbitmap.h>
#include <qcursor.h>

#include "rappwin.h"
#include "racttag.h"
#include "rbehaviordef.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rinputdialog.h"
#include "rlog.h"
#include "rsnap.h"
#include "rstatuspanel.h"

/*! \class RActTag
    \brief Event handling for tag functions

    \author Andrew Mustun
*/

/*! Constructor:
*/
RActTag::RActTag()
{
  
}



/*! Destructor:
*/
RActTag::~RActTag()
{
}



/*! Serves an event to the corresponding function
    \param _action The Action (e.g. ACT_LINES_NORMAL)
    \param _rEvent The event (e.g. REVENT_BEGIN, REVENT_END, REVENT_LBUTTONDOWN, ...)
*/
void
RActTag::serveEvent(int _action,
                    int _rEvent )
{
  if(_action>=ACT_TAG_FIRST &&
     _action<=ACT_TAG_LAST     ) {

    switch(_action) {

      case ACT_TAG_ELEMENT:
        tagElement(_rEvent);
        break;
        
      case ACT_TAG_CONTOUR:
        tagContour(_rEvent);
        break;
        
      case ACT_UNTAG_RANGE:
        tagRange(_rEvent, false);
        break;
        
      case ACT_TAG_RANGE:
        tagRange(_rEvent, true);
        break;

      case ACT_UNTAG_INTERS:
        tagInters(_rEvent, false);
        break;
        
      case ACT_TAG_INTERS:
        tagInters(_rEvent, true);
        break;
        
      case ACT_TAG_LAYER:
        tagLayer(_rEvent);
        break;
        
      default:
        break;
    }
  }
}



/*! Handles events for tagging single elements
*/
void
RActTag::tagElement(int _rEvent)
{
 
  switch(_rEvent) {

    case REVENT_BEGIN:
      currentDoc()->setCurrentState(1);
      currentDoc()->setBehavior(BVR_SNAP_NEXT_ELEMENT);
      statusPanel()->setActionStatus(RMES(343), RMES(270), RMES(335));
      break;

    case REVENT_MOUSEMOVE:
      if(currentDoc()->getCurrentState()==1) {
        currentDoc()->setBehavior(BVR_SNAP_NEXT_ELEMENT);
        if(snapper()) snapper()->getSnappedElement();
      }
      break;

    case REVENT_LBUTTONUP:
      if(currentDoc()->getCurrentState()==1) {
        // Tag element:
        //
        if(snapper() && 
           snapper()->getSnappedElement()) {

          if(snapper()->getSnappedElement()->getFlag(E_TAGGED)) {
            snapper()->getSnappedElement()->untag();
          }
          else {
            snapper()->getSnappedElement()->tag();
          }
          
          currentDoc()->drawElement(snapper()->getSnappedElement());
        }
      }
      break;

    case REVENT_RBUTTONUP:
      if(currentDoc()->getCurrentState()==1) {
        snapper()->stop();
        currentDoc()->setBehavior(BVR_NO);
        currentDoc()->resetCurrentState();
        currentDoc()->resetCurrentAction();
        statusPanel()->clear();
      }
      break;

    default:
      break;
  }
}



/*! Handles events for tagging contours
*/
void
RActTag::tagContour(int _rEvent)
{
 
  switch(_rEvent) {

    case REVENT_BEGIN:
      currentDoc()->setCurrentState(1);
      currentDoc()->setBehavior(BVR_SNAP_NEXT_ELEMENT);
      statusPanel()->setActionStatus(RMES(344), RMES(270), RMES(336));
      break;

    case REVENT_MOUSEMOVE:
      if(currentDoc()->getCurrentState()==1) {
        currentDoc()->setBehavior(BVR_SNAP_NEXT_ELEMENT);
        if(snapper()) snapper()->getSnappedElement();
      }
      break;

    case REVENT_LBUTTONUP:
      if(currentDoc()->getCurrentState()==1) {
        // Tag contour:
        //
        if(snapper() && 
           snapper()->getSnappedElement()) {

          if(snapper()->getSnappedElement()->getFlag(E_TAGGED)) {
            currentDoc()->tagContour(snapper()->getSnappedElement(), 
                                     false, true);
          }
          else {
            currentDoc()->tagContour(snapper()->getSnappedElement(), 
                                     true, true);
          }
          
          currentDoc()->drawElement(snapper()->getSnappedElement());
        }
      }
      break;

    case REVENT_RBUTTONUP:
      if(currentDoc()->getCurrentState()==1) {
        snapper()->stop();
        currentDoc()->setBehavior(BVR_NO);
        currentDoc()->resetCurrentState();
        currentDoc()->resetCurrentAction();
        statusPanel()->clear();
      }
      break;

    default:
      break;
  }
}




/*! Handles events for (un-)tagging ranges
    \param _tag true=tag / false=untag
*/
void
RActTag::tagRange(int _rEvent, bool _tag)
{
  static float x1=DEF_AREAMAX;  // Coordinates of first (last) point
  static float y1=DEF_AREAMAX;  //
 
  switch(_rEvent) {

    case REVENT_BEGIN:
      RAppWin::getRAppWin()->changeMenu(TOOLBAR_SNAP);
      currentDoc()->setCurrentState(1);
      currentDoc()->setCursor(*RAppWin::getRAppWin()->curCross);
      if(_tag) statusPanel()->setActionStatus(RMES(345), RMES(270), RMES(338));
      else     statusPanel()->setActionStatus(RMES(345), RMES(270), RMES(337));
      break;

    case REVENT_MOUSEMOVE:
      
      // Move before 1st point is set:
      //
      if(currentDoc()->getCurrentState()==1) {
        snapper()->snapPoint();
      }
      
      // Move for setting next point:
      //
      else if(currentDoc()->getCurrentState()==2) {
        float px, py;
        if(snapper()->snapPoint(&px, &py)) {
          if(currentDoc()->setPreviewElement(T_RECT, x1, y1, px, py)) {
            currentDoc()->drawPreviewElement();
          }
        }
      }
      break;

    case REVENT_LBUTTONUP:

      // Set 1st point:
      //
      if(currentDoc()->getCurrentState()==1) {
        if(snapper()->snapPoint(&x1, &y1, true)) {
          currentDoc()->setCurrentState(2);
          statusPanel()->setLeftButtonStatus(RMES(346));
        }
      }

      // Set 2nd point:
      //
      else if(currentDoc()->getCurrentState()==2) {
        float px, py;
        if(snapper()->snapPoint(&px, &py, true)) {
          snapper()->stop();
          
          currentDoc()->tagRange(x1, y1, px, py, _tag, true);
          
          x1=DEF_AREAMAX;
          y1=DEF_AREAMAX;
          currentDoc()->setCurrentState(1);
          statusPanel()->setLeftButtonStatus(RMES(345));
        }
        snapper()->snapPoint();
      }
      
      break;

    case REVENT_RBUTTONUP:
     
      // Break before 1st point is set:
      //
      if(currentDoc()->getCurrentState()==1) {
        snapper()->stop();
        currentDoc()->setBehavior(BVR_NO);
        currentDoc()->resetCurrentState();
        currentDoc()->resetCurrentAction();
        currentDoc()->setCursor(arrowCursor);
        statusPanel()->clear();
      }
      
      // Go back to setting of first point:
      //
      else if(currentDoc()->getCurrentState()==2) {
        snapper()->stop();
        currentDoc()->setCurrentState(1);
        snapper()->snapPoint();
        statusPanel()->setLeftButtonStatus(RMES(345));
      }
      break;

    default:
      break;
  }
}




/*! Handles events for (un-)tagging elements intersected by a line
    \param _tag true=tag / false=untag
*/
void
RActTag::tagInters(int _rEvent, bool _tag)
{
  static float x1=DEF_AREAMAX;  // Coordinates of first (last) point
  static float y1=DEF_AREAMAX;  //
 
  switch(_rEvent) {

    case REVENT_BEGIN:
      RAppWin::getRAppWin()->changeMenu(TOOLBAR_SNAP);
      currentDoc()->setCurrentState(1);
      currentDoc()->setCursor(*RAppWin::getRAppWin()->curCross);
      if(_tag) statusPanel()->setActionStatus(RMES(347), RMES(270), RMES(340));
      else     statusPanel()->setActionStatus(RMES(347), RMES(270), RMES(339));
      break;

    case REVENT_MOUSEMOVE:
      
      // Move before 1st point is set:
      //
      if(currentDoc()->getCurrentState()==1) {
        snapper()->snapPoint();
      }
      
      // Move for setting next point:
      //
      else if(currentDoc()->getCurrentState()==2) {
        float px, py;
        if(snapper()->snapPoint(&px, &py)) {
          if(currentDoc()->setPreviewElement(T_LINE, x1, y1, px, py)) {
            currentDoc()->drawPreviewElement();
          }
        }
      }
      break;

    case REVENT_LBUTTONUP:

      // Set 1st point:
      //
      if(currentDoc()->getCurrentState()==1) {
        if(snapper()->snapPoint(&x1, &y1, true)) {
          currentDoc()->setCurrentState(2);
          statusPanel()->setLeftButtonStatus(RMES(348));
        }
      }

      // Set 2nd point:
      //
      else if(currentDoc()->getCurrentState()==2) {
        float px, py;
        if(snapper()->snapPoint(&px, &py, true)) {
          snapper()->stop();
          
          currentDoc()->tagInters(x1, y1, px, py, _tag, true);
          
          x1=DEF_AREAMAX;
          y1=DEF_AREAMAX;
          currentDoc()->setCurrentState(1);
          statusPanel()->setLeftButtonStatus(RMES(347));
        }
        snapper()->snapPoint();
      }
      
      break;

    case REVENT_RBUTTONUP:
     
      // Break before 1st point is set:
      //
      if(currentDoc()->getCurrentState()==1) {
        snapper()->stop();
        currentDoc()->setBehavior(BVR_NO);
        currentDoc()->resetCurrentState();
        currentDoc()->resetCurrentAction();
        currentDoc()->setCursor(arrowCursor);
        statusPanel()->clear();
      }
      
      // Go back to setting of first point:
      //
      else if(currentDoc()->getCurrentState()==2) {
        snapper()->stop();
        currentDoc()->setCurrentState(1);
        snapper()->snapPoint();
        statusPanel()->setLeftButtonStatus(RMES(347));
      }
      break;

    default:
      break;
  }
}



/*! Handles events for tagging layers
*/
void
RActTag::tagLayer(int _rEvent)
{
  switch(_rEvent) {

    case REVENT_BEGIN:
      currentDoc()->setCurrentState(1);
      currentDoc()->setBehavior(BVR_SNAP_NEXT_ELEMENT);
      statusPanel()->setActionStatus(RMES(349), RMES(270), RMES(342));
      break;

    case REVENT_MOUSEMOVE:
      if(currentDoc()->getCurrentState()==1) {
        currentDoc()->setBehavior(BVR_SNAP_NEXT_ELEMENT);
        if(snapper()) snapper()->getSnappedElement();
      }
      break;

    case REVENT_LBUTTONUP:
      if(currentDoc()->getCurrentState()==1) {
        // Tag layer:
        //
        if(snapper() && 
           snapper()->getSnappedElement()) {

          if(snapper()->getSnappedElement()->getFlag(E_TAGGED)) {
            currentDoc()->tagLayer(snapper()->getSnappedElement()->getLayer(), 
                                   false, true);
          }
          else {
            currentDoc()->tagLayer(snapper()->getSnappedElement()->getLayer(), 
                                   true, true);
          }
          
          currentDoc()->drawElement(snapper()->getSnappedElement());
        }
      }
      break;

    case REVENT_RBUTTONUP:
      if(currentDoc()->getCurrentState()==1) {
        snapper()->stop();
        currentDoc()->setBehavior(BVR_NO);
        currentDoc()->resetCurrentState();
        currentDoc()->resetCurrentAction();
        statusPanel()->clear();
      }
      break;

    default:
      break;
  }
}


// EOF

