/***************************************************************************
                          rfilecxf.cpp  -  description
                             -------------------
    begin                : Sun Nov 7 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : mustun@ribbonsoft.com
 ***************************************************************************/

#include "rfilecxf.h"

#include <stdlib.h>

#include <qstring.h>
#include <qtextstream.h>
#include <qdatetime.h>
#include <qfileinfo.h>

#include "rappwin.h"
#include "rfilebase.h"
#include "rfonts.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rlog.h"
#include "rmath.h"
#include "rprgdef.h"
#include "rstatuspanel.h"
#include "rstring.h"

// Constructor:
//
RFileCxf::RFileCxf(const char* _name, RGraphic* _graphic)
  :RFileBase(_name)
{
  graphic=_graphic;
}



// Destructor:
//
RFileCxf::~RFileCxf()
{

}



// load a cxf file (read in buffer / read from buffer):
//
bool
RFileCxf::load()
{
  if(readFileInBuffer()) {
    seperateBuf();
    return readFromBuffer();
  }
  else {
    return false;
  }
}



// read a cxf file from buffer:
//
bool
RFileCxf::readFromBuffer()
{
  // Create border elements:
  //
  int layer = graphic->addLayer( "Border" );

  graphic->setColor(7);

  graphic->addLine( 0.0, -1.0, 2814.0, -1.0, layer, false );
  graphic->addLine( 0.0, 10.0, 2814.0, 10.0, layer, false );

  unsigned char numStr[4];

  int c;
  int normalFont = RFonts::getRFonts()->getFontNumber("normal");
  for( c=0; c<256; ++c ) {
    graphic->setColor(7);

    graphic->addLine( c*11.0, -11.0, c*11.0, 19.0, layer, false );
    graphic->addLine( c*11.0+9.0, -11.0, c*11.0+9.0, 19.0, layer, false );

    graphic->setColor(0);

    // ASCII number:
    sprintf( (char*)numStr, "%03d", c );
    graphic->addText( c*11.0+4.5, -6.0,
                      normalFont,
                      numStr, E_STRAIGHT|E_CENTER,
                      2.0, 0.0, 0.0, 0.4, 0.0, 0.0, layer, false );

    // ASCII char:
    if(c>31 && RFonts::getRFonts()->getLetterElementNumber(normalFont, c)>0) {
      numStr[0]=c;
      numStr[1]='\0';
      graphic->addText( c*11.0+4.5, -11.0,
                        normalFont,
                        numStr, E_STRAIGHT|E_CENTER,
                        4.0, 0.0, 0.0, 0.4, 0.0, 0.0, layer, false );
    }
  }

  // Add the characters:
  //
  layer = graphic->addLayer( "Letters" );
  graphic->setColor(0);
  int fontNumber = RFonts::getRFonts()->getFontNumber( QFileInfo(name()).baseName().latin1() );

  for( c=32; c<256; ++c ) {
    // Add the letter from this font:
    //
    if(RFonts::getRFonts()->getLetterElementNumber(fontNumber, c)>0) {
      numStr[0]=c;
      numStr[1]='\0';
      int el = graphic->addText( c*11.0, 0.0,
                                 fontNumber,
                                 numStr,
                                 E_STRAIGHT|E_LEFT,
                                 9.0, 0.0, 0.0, 0.4, 0.4, 14.0, layer, false );

      // Tag all letters for splitting to elements later:
      if(el!=-1 && graphic->elementCurrent()) {
        graphic->elementAt(el)->setFlag( E_TAGGED );
        graphic->elementCurrent()->setFlag( E_TAGGED );
      }
    }
  }

  graphic->editTextElements( true );

  return true;
}



// save a cxf file:
//
bool
RFileCxf::save()
{
  bool      ret;          // returned value
  RElement *el;           // pointer which walks through elements
  int       lc;           // Letter counter 0-255
  int       elNum;        // Number of elements of current letter
  float     letterOffset; // Letter offset

  //statusPanel()->iniProgress(graphic->count(), RMES(293));

  RLOG("\nRFileCxf::Save()");

  fPointer = fopen(name(), "wt");
  if(fPointer!=NULL) {

    // Write CXF-header:

    // HEADER:
    //
    fprintf(fPointer, "# Format:      CAM Expert Font\n"
                      "# Creator:     %s\n"
                      "# Version:     %s\n"
                      "# Name:        %s\n"
                      "# Dimensions:  0.1 0.6 1.4\n",
                      DEF_APPNAME, DEF_VERSION, QFileInfo(name()).baseName().latin1());

    // LETTERS:
    //
    for(lc=32; lc<=255; lc++) {

      elNum = 0;
      letterOffset = 11.0*lc;

      // Untag all elements:
      //
      graphic->tagNothing(true);

      // Tag current letter:
      //
      graphic->tagRange(letterOffset-1.0, -6.0, letterOffset+10.0, 17.0, true, true);

      // Count tagged ELEMENTS:
      //
      for(el=graphic->elementFirst(); el!=0; el=graphic->elementNext()) {
        if(el->getFlag(E_ACTIVE) && !el->getFlag(E_UNDO) && el->getFlag(E_TAGGED) &&
           (el->getElementTyp()==T_LINE || el->getElementTyp()==T_ARC || el->getElementTyp()==T_CIRCLE)) {
          ++elNum;
          if(el->getElementTyp()==T_CIRCLE) ++elNum;
        }
      }

      if(elNum>0) {

        // Save letter header:
        //
        fprintf(fPointer, "\n[%c] %d\n", lc, elNum);

        // Save tagged ELEMENTS:
        //
        for(el=graphic->elementFirst(); el!=0; el=graphic->elementNext()) {
          if(el->getFlag(E_ACTIVE) && !el->getFlag(E_UNDO) && el->getFlag(E_TAGGED)) {

            statusPanel()->setProgress(graphic->elementAt(), 200);

            switch(el->getElementTyp()) {

              // Line:
              //
              case T_LINE:
                fprintf(fPointer,
                        "L %s,%s,%s,%s\n",
                        strFloatToString(el->getX1()-letterOffset).latin1(),
                        strFloatToString(el->getY1()).latin1(),
                        strFloatToString(el->getX2()-letterOffset).latin1(),
                        strFloatToString(el->getY2()).latin1() );
                break;

              // Arc:
              //
              case T_ARC:
                if(!el->getFlag(E_REVERSED)) {
                  fprintf(fPointer, "A");
                }
                else {
                  fprintf(fPointer, "AR");
                }

                fprintf(fPointer,
                        " %s,%s,%s,%s,%s\n",
                        strFloatToString(el->getCx()-letterOffset).latin1(),
                        strFloatToString(el->getCy()).latin1(),
                        strFloatToString(el->getCr()).latin1(),
                        strFloatToString(el->getA1()).latin1(),
                        strFloatToString(el->getA2()).latin1() );
                break;

              // Circle:
              //
              case T_CIRCLE:
                fprintf(fPointer,
                        "A %s,%s,%s,0,180\n",
                        strFloatToString(el->getCx()-letterOffset).latin1(),
                        strFloatToString(el->getCy()).latin1(),
                        strFloatToString(el->getCr()).latin1() );
                fprintf(fPointer,
                        "A %s,%s,%s,180,360\n",
                        strFloatToString(el->getCx()-letterOffset).latin1(),
                        strFloatToString(el->getCy()).latin1(),
                        strFloatToString(el->getCr()).latin1() );
                break;

              default:
                break;
            }
          }
        }
      }
    }


    // End:
    //
    fprintf(fPointer, "\n#EOF\n");

    fclose(fPointer);

    statusPanel()->delProgress();

    // Reread fonts:
    //
    RFonts::getRFonts()->init();

    ret=true;
  }
  else {
    ret=false;
  }

  return ret;

}




















