/***************************************************************************
                          rintro.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rintro.cpp 1998/10/04 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qpainter.h>
#include <qpixmap.h>


#include "rintro.h"
#include "rlabel.h"
#include "rprgdef.h"
#include "rconfig.h"

#ifdef DEF_CAM_EXPERT
#include "xpm/camexpertintro.xpm"
#endif

#ifdef DEF_QCAD
#include "xpm/qcadintro.xpm"
#endif

// Constructor:
//
RIntro::RIntro(const char* _version, 
               QWidget* _parent, 
               const char* _name)
  :QWidget(_parent, _name, WStyle_NoBorder)
{
  setFixedSize(298, 200);  // 256 158
  /*
  move((QApplication::desktop()->width()-width())/2,
       (QApplication::desktop()->height()-height())/2);
  */
  
  if(parentWidget()) {
    move((parentWidget()->width()-width())/2,
         (parentWidget()->height()-height())/2);
  }

  sVersion = "Version ";
  sVersion +=_version;

  pIntro = new QPixmap(DEF_INTRO);
}



// Destructor:
//
RIntro::~RIntro()
{

}



// Paint:
//
void 
RIntro::paintEvent(QPaintEvent* _ev)
{
  QWidget::paintEvent(_ev);

  QPainter paint;        // painter
  
  paint.begin(this);
  paint.drawPixmap(0, 0, *pIntro);
  
#ifndef DEF_QCAD
  
  paint.setFont(QFont("helvetica", RCONFIG->getSettingInt("Application:FontSize0")));
  paint.setPen(black);
  /*paint.drawText(19, 69, 200, 50,
                 AlignLeft|AlignTop,
                 "http://www.ribbonsoft.com\n"
                 "info@ribbonsoft.com");*/
                 
  paint.setFont(QFont("helvetica", 9));
  /*paint.setPen(white);*/
  paint.drawText(DEF_INTRO_VERX, DEF_INTRO_VERY, 100, 26,
                 AlignLeft|AlignTop,
                 sVersion.data());
#endif
  paint.end();

}




// EOF

