/***************************************************************************
                          rmath.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rmath.cpp 1998/08/27 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <math.h>

#include "rmath.h"

#include "relement.h"


// Compare two float values:
//
// return: true: values are equal
//         false: values are not equal
//
bool 
mtCompFloat(float _v1, float _v2, float _tol)
{
  float delta = _v2-_v1;
  
  if(delta>-_tol && delta<_tol) return true;
  else                          return false;
}



// Correct an angle (bring it to range of 0-360)
//   this function returns the new angle
//   is doesn't change the parameter
//
float
mtCorrAngle(float _ang)
{
  float ret=_ang;
  
  while(ret<   0.0) ret+=360.0;
  while(ret>=360.0) ret-=360.0;
  return ret;
}



// Correct an angle (bring it to range of 0-360)
//   this function changes the parameter
//
void
mtCorrAngle(float* _ang)
{
  while(*_ang<   0.0) *_ang+=360.0;
  while(*_ang>=360.0) *_ang-=360.0;
}


// Test if angle _ang is beteen _startAngle and _endAngle:
//   (in pos. direction)
//
bool
mtAngleIsBetween(float _ang, float _startAngle, float _endAngle)
{
  bool ret=false;

  if(_startAngle>_endAngle) {
    if(_ang>=_startAngle || _ang<=_endAngle) ret=true;
  }
  else {
    if(_ang>=_startAngle && _ang<=_endAngle) ret=true;
  }

  return(ret);
}



// Get Angle from point _cx, _cy
//   to point _px, _py
//
float 
mtGetAngle(float _x1, float _y1, float _x2, float _y2)
{
  float xdist, ydist, angle;

  xdist=_x2-_x1;
  ydist=_y2-_y1;

  if(mtCompFloat(xdist, 0.0)) {
    if(_y2<_y1) angle=270.0;
    else angle=90.0;
    return angle;
  }

  if(mtCompFloat(ydist, 0.0)) {
    if(_x2<_x1) angle=180.0;
    else angle=0.0;
    return angle;
  }

  angle = atan(ydist/xdist)*ARAD;

  if(angle<0.0) angle*=-1.0;

  if(_x2>_x1 && _y2>_y1) angle =   0.0 + angle;   // 1. Quadrant
  if(_x2<_x1 && _y2>_y1) angle = 180.0 - angle;   // 2. Quadrant
  if(_x2<_x1 && _y2<_y1) angle = 180.0 + angle;   // 3. Quadrant
  if(_x2>_x1 && _y2<_y1) angle = 360.0 - angle;   // 4. Quadrant

  return angle;
}



// Get Angle difference between _a1 and _a2
//
//   (Which angle must I add to _a1 to get _a2)
//
float 
mtGetAngleDiff(float _a1, float _a2) 
{
 float ret;

 if(_a1>=_a2) _a2+=360.0;
 ret = _a2-_a1;

 if(ret>=360.0) ret=0.0;

 return ret;
}



// Get Distance from point _cx, _cy
//   to point _px, _py
//
float 
mtGetDistance(float _x1, float _y1, float _x2, float _y2)
{
  float xd2 = (_x2-_x1)*(_x2-_x1);
  float yd2 = (_y2-_y1)*(_y2-_y1);
  float d   = xd2+yd2;
  if(d<0.0) d*=-1.0;
  return(sqrt(d));
}



// Rotate point _px/_py around center _cx/_cy with angle _angle
//
void  
mtRotatePoint(float _cx, float _cy, float* _px, float* _py, float _angle)
{
  float dist,      // temporary distance
        ang;     // temporary angle

  dist = mtGetDistance(_cx, _cy, *_px, *_py);
  ang  = mtCorrAngle(mtGetAngle(_cx, _cy, *_px, *_py)+_angle);
  *_px = _cx+cos(ang/ARAD)*dist;
  *_py = _cy+sin(ang/ARAD)*dist;
}



// Mirror point _px/_py on line (_x1,_y1 / _x2,_y2):
//
void  
mtMirrorPoint(float _x1, float _y1, 
              float _x2, float _y2, 
              float* _px, float* _py)
{
  float tmpDis,          // temporary distance
        tmpX, tmpY;      // temporary coordinate
  RElement tmpEl;        // temporary element
  float mirAngle;        // mirroring angle (angle of axe +90.0)
  
  tmpEl.createLine(_x1, _y1, _x2, _y2);
  
  mirAngle = mtCorrAngle(tmpEl.getDirection1()+90.0);

  tmpDis = tmpEl.getDistanceToPoint(*_px, *_py, true);
  tmpX = *_px + cos(mirAngle/ARAD)*tmpDis*2.0;
  tmpY = *_py + sin(mirAngle/ARAD)*tmpDis*2.0;
  
  // Mirrored to wrong side:
  //
  if(tmpEl.getDistanceToPoint(tmpX, tmpY, true) >= 1.9*tmpDis) {
    tmpX = *_px - cos(mirAngle/ARAD)*tmpDis*2.0;
    tmpY = *_py - sin(mirAngle/ARAD)*tmpDis*2.0;
  }
  *_px = tmpX;
  *_py = tmpY;
}



// Square:
//
float 
mtSqr(float _v)
{
  return _v*_v;
}


// EOF

