/***************************************************************************
                          rmath.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rmath.h 1998/08/27 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RMATH_H
#define RMATH_H

#include <math.h>

#include "rmathdef.h"
#include "rgraphdef.h"
#include "rprgdef.h"


bool  mtCompFloat(float _v1, float _v2, float _tol=DEF_MMTOL);
float mtCorrAngle(float _ang);
void  mtCorrAngle(float* _ang);
float mtGetAngle(float _x1, float _y1, float _x2, float _y2);
float mtGetAngleDiff(float _a1, float _a2);
bool  mtAngleIsBetween(float _ang, float _startAngle, float _endAngle);
float mtGetDistance(float _x1, float _y1, float _x2, float _y2);
void  mtRotatePoint(float _cx, float _cy, float* _px, float* _py, float _angle);
void  mtMirrorPoint(float _x1, float _y1, float _x2, float _y2, float* _px, float* _py);
float mtSqr(float _v);

#endif


// EOF

