/***************************************************************************
                          rsimulationpanel.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rsimulationpanel.cpp 1998/09/20 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rsimulationpanel.h"

#include <qslider.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qwindowdefs.h>

#include "rappwin.h"
#include "rcadwidget.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rlayoutdef.h"
#include "rlog.h"
#include "rxpmsim.h"

// Constructor:
//
RSimulationPanel::RSimulationPanel(QWidget* _parent, 
               const char* _name,
               WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;

  //setFrameStyle(WinPanel|Raised);
  setFrameStyle(Panel|Raised);
  setLineWidth(1);

  // Create Buttons / Checkboxes / Slider:
  //
  bStart = new QToolButton(this, "start");
  bStart->setPixmap(QPixmap(simstart_xpm));
  QToolTip::add(bStart, RMES(205));
  connect(bStart, SIGNAL(clicked()), this, SLOT(start()));
    
  bSmooth = new QToolButton(this, "smooth");
  bSmooth->setPixmap(QPixmap(simsmooth_xpm));
  QToolTip::add(bSmooth, RMES(206));
  connect(bSmooth, SIGNAL(clicked()), this, SLOT(smooth()));

  bPointing=0;
  /*
  bPointing = new QToolButton(this, "pointing");
  bPointing->setPixmap(QPixmap(simpointing_xpm));
  QToolTip::add(bPointing, RMES(207));
  connect(bPointing, SIGNAL(clicked()), this, SLOT(pointing()));
  */

  fSep1 = new QFrame(this, "sep1");
  fSep1->setFrameStyle(VLine|Sunken);

  bRapid = new QToolButton(this, "rapidmove");
  //bRapid->setStyle(MotifStyle);
  bRapid->setPixmap(QPixmap(simrapidmove_xpm));
  bRapid->setToggleButton(true);
  bRapid->setOn(false);
  QToolTip::add(bRapid, RMES(208));
  connect(bRapid, SIGNAL(toggled(bool)), this, SLOT(rapid(bool)));
  
  bDetails = new QToolButton(this, "details");
  //bDetails->setStyle(MotifStyle);
  bDetails->setPixmap(QPixmap(simdetails_xpm));
  bDetails->setToggleButton(true);
  bDetails->setOn(false);
  QToolTip::add(bDetails, RMES(209));
  connect(bDetails, SIGNAL(toggled(bool)), this, SLOT(details(bool)));

  bBroken = new QToolButton(this, "broken");
  //bBroken->setStyle(MotifStyle);
  bBroken->setPixmap(QPixmap(simbroken_xpm));
  bBroken->setToggleButton(true);
  bBroken->setOn(false);
  QToolTip::add(bBroken, RMES(210));
  connect(bBroken, SIGNAL(toggled(bool)), this, SLOT(broken(bool)));

  bGrid = new QToolButton(this, "grid");
  //bGrid->setStyle(MotifStyle);
  bGrid->setPixmap(QPixmap(simgrid_xpm));
  bGrid->setToggleButton(true);
  bGrid->setOn(false);
  QToolTip::add(bGrid, RMES(419));
  connect(bGrid, SIGNAL(toggled(bool)), this, SLOT(grid(bool)));

  fSep2 = new QFrame(this, "sep2");
  fSep2->setFrameStyle(VLine|Sunken);

  bInfo = new QToolButton(this, "info");
  //bInfo->setStyle(MotifStyle);
  bInfo->setPixmap(QPixmap(info_xpm));
  bInfo->setToggleButton(true);
  bInfo->setOn(false);
  QToolTip::add(bInfo, RMES(211));
  connect(bInfo, SIGNAL(toggled(bool)), this, SLOT(info(bool)));

  bEdit=0;
  /*
  bEdit = new QToolButton(this, "edit");
  bEdit->setStyle(MotifStyle);
  bEdit->setPixmap(QPixmap(edit_xpm));
  bEdit->setToggleButton(true);
  bEdit->setOn(false);
  QToolTip::add(bEdit, RMES(212));
  connect(bEdit, SIGNAL(toggled(bool)), this, SLOT(edit(bool)));
  */

  bLayerList = new QToolButton(this, "layer");
  //bLayerList->setStyle(MotifStyle);
  bLayerList->setPixmap(QPixmap(layerlist_xpm));
  bLayerList->setToggleButton(true);
  bLayerList->setOn(false);
  QToolTip::add(bLayerList, RMES(213));
  connect(bLayerList, SIGNAL(toggled(bool)), this, SLOT(layerList(bool)));

  fSep3 = new QFrame(this, "sep3");
  fSep3->setFrameStyle(VLine|Sunken);

  sSpeed = new QSlider(0, DEF_SPEEDRES, DEF_SPEEDRES/10, DEF_SPEEDRES, 
                       QSlider::Horizontal, 
                       this, "sspeed");
  sSpeed->setTickmarks(QSlider::Below);
  sSpeed->setTickInterval(DEF_SPEEDRES/10);
  //sSpeed->setStyle(MotifStyle);
  QToolTip::add(sSpeed, RMES(214));
}



// Destructor:
//
RSimulationPanel::~RSimulationPanel()
{

}



// Resize event:
//
void 
RSimulationPanel::resizeEvent(QResizeEvent* _ev)
{
  RWidget::resizeEvent(_ev);
  resizeChildren();
}



// Resize the children:
//
void
RSimulationPanel::resizeChildren()
{
  int x=2;

  if(bStart) {
    bStart->setGeometry(x, 2,
                        DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bSmooth) {
    bSmooth->setGeometry(x, 2,
                         DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bPointing) {
    bPointing->setGeometry(x, 2,
                           DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(fSep1) {
    fSep1->setGeometry(x, 2,
                       6, DEF_BSIZE0);
    x+=6;
  }

  if(bRapid) {
    bRapid->setGeometry(x, 2,
                        DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bDetails) {
    bDetails->setGeometry(x, 2,
                          DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bBroken) {
    bBroken->setGeometry(x, 2,
                         DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bGrid) {
    bGrid->setGeometry(x, 2,
                       DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(fSep2) {
    fSep2->setGeometry(x, 2,
                       6, DEF_BSIZE0);
    x+=6;
  }
  
  if(bInfo) {
    bInfo->setGeometry(x, 2,
                       DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bEdit) {
    bEdit->setGeometry(x, 2,
                       DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(bLayerList) {
    bLayerList->setGeometry(x, 2,
                            DEF_BSIZE0, DEF_BSIZE0);
    x+=DEF_BSIZE0;
  }

  if(fSep3) {
    fSep3->setGeometry(x, 2,
                       6, DEF_BSIZE0);
    x+=6;
  }

  if(sSpeed) {
    sSpeed->setGeometry(x+4, 3,
                        width()-x-10, DEF_BSIZE0-3);
  }
  
}



// Set the pointer to a graphic and update the layers:
//
void 
RSimulationPanel::setGraphic(RGraphic* _graphic) 
{
  // Disconnect old connections:
  //
  if(graphic) {
    if(sSpeed)    disconnect(sSpeed,0, graphic,0);
  }
  
  graphic=_graphic; 

  // New connections / set states from graphic:
  //
  if(graphic) {
    graphic->setAutoUpdateGraphic(false);
    
    if(sSpeed) {
      connect(sSpeed, SIGNAL(valueChanged(int)), 
              graphic, SLOT(setDelay(int)));
      sSpeed->setValue(graphic->getDelayPosition());
    }

    if(bRapid) {
      bRapid->setOn(graphic->getFlag(G_RAPID));
    }

    if(bDetails) {
      bDetails->setOn(graphic->getFlag(G_DETAILS));
    }

    if(bBroken) {
      bBroken->setOn(graphic->getFlag(G_BROKEN));
    }

    if(bGrid) {
      bGrid->setOn(graphic->getFlag(G_GRID));
    }

    graphic->setAutoUpdateGraphic(true);
  }
}



// Start Simulation:
//
void
RSimulationPanel::start()
{
  if(graphic) graphic->simulate();
}



// Smooth Simulation:
//
void
RSimulationPanel::smooth()
{
  if(graphic) graphic->simulateSmooth();
}



// Pointing Simulation:
//
void
RSimulationPanel::pointing()
{
  if(graphic) graphic->repaint();
}



// Show Rapid Move:
//
void
RSimulationPanel::rapid(bool _on)
{
  if(graphic) graphic->setRapid(_on);
}



// Show Details:
//
void
RSimulationPanel::details(bool _on)
{
  if(graphic) graphic->setDetails(_on);
}



// Highlight broken contours:
//
void
RSimulationPanel::broken(bool _on)
{
  if(graphic) graphic->setBroken(_on);
}



// Show/hide Grid:
//
void
RSimulationPanel::grid(bool _on)
{
  if(graphic) graphic->setGrid(_on);
}



// Info:
//
void
RSimulationPanel::info(bool _on)
{
  RAppWin* appWin=RAppWin::getRAppWin();
  appWin->getCadWidget1()->showInfoWidget(_on);
  appWin->getCadWidget2()->showInfoWidget(_on);
  appWin->getCadWidget1()->resizeChildren();
  appWin->getCadWidget2()->resizeChildren();
}



// Edit:
//
void
RSimulationPanel::edit(bool /*_on*/)
{
}



// Layer list:
//
void
RSimulationPanel::layerList(bool _on)
{
  RAppWin* appWin=RAppWin::getRAppWin();
  appWin->getCadWidget1()->showLayerWidget(_on);
  appWin->getCadWidget2()->showLayerWidget(_on);
  appWin->getCadWidget1()->resizeChildren();
  appWin->getCadWidget2()->resizeChildren();
}


// EOF





