/***************************************************************************
                          rsimulationpanel.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rsimulationpanel.h 1998/09/20 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RSIMULATIONPANEL_H
#define RSIMULATIONPANEL_H

#include "rwidget.h"

class QSlider;
class QToolButton;
class RGraphic;

class RSimulationPanel : public RWidget
{
  Q_OBJECT
public:
  RSimulationPanel(QWidget* _parent=0, 
         const char* _name=0,
         WFlags _f=0);
  ~RSimulationPanel();

  void resizeChildren();

  void      setGraphic(RGraphic* _graphic);
  RGraphic* getGraphic() { return graphic; }

protected:
  virtual void resizeEvent(QResizeEvent* _ev);
    
private slots:
  void start();
  void smooth();
  void pointing();
  void rapid(bool);
  void details(bool);
  void broken(bool);
  void grid(bool);
  void info(bool);
  void edit(bool);
  void layerList(bool);

private:
  RGraphic* graphic;              // Pointer to graphic
  
  QToolButton*  bStart;           // tool button start simulation
  QToolButton*  bSmooth;          //             smooth simulation
  QToolButton*  bPointing;        //             pointing simulation
  QFrame*       fSep1;            // Seperator
  QToolButton*  bRapid;           // tool button for Rapidmove
  QToolButton*  bDetails;         //             for Details
  QToolButton*  bBroken;          //             for Broken Contours
  QToolButton*  bGrid;            //             for Grid
  QFrame*       fSep2;            // Seperator
  QToolButton*  bInfo;            //             show info
  QToolButton*  bEdit;            //             edit file
  QToolButton*  bLayerList;       //             show / hide layer list
  QFrame*       fSep3;            // Seperator

  QSlider*      sSpeed;           // Slider for speed
  
};


#endif

// EOF



