/***************************************************************************
                          ryesnodialog.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** ryesnodialog.h 1998/09/03 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RYESNODIALOG_H
#define RYESNODIALOG_H

#include <qdialog.h>

class RLabel;

/*! Dialog for messages with OK/Cancel Button
*/
class RYesNoDialog : public QDialog
{
  Q_OBJECT
public:
  /*! Constructor:
      \param _label Label (Message)
      \param _but1  Button text for button 1
      \param _but2  Button text for button 2
      \param _parent The parent widget
      \param _name  Name
  */
  RYesNoDialog(const char* _label,
               const char* _but1,
               const char* _but2,
               QWidget* _parent=0, 
               const char* _name=0);
  /*! Destructor
  */
  ~RYesNoDialog();

private:
  /*! The button 1
  */
  QPushButton* bBut1;
  /*! The button 2
  */
  QPushButton* bBut2;

  /*! The label
  */
  RLabel*      lText;
  
};


#endif

// EOF

