/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_WINDOW_MAIN_H
#define _TF_WINDOW_MAIN_H 1


#include <gtk--.h>
#include <gtk/gtk.h>
#include "GuiDialogOAC.h"
#include "GuiDialogYN.h"
#include "GuiDialogAbout.h"
#include "TFCListMainWin.h"
#include "TFWindowBase.h"


/*
 *  TFWindowMain: the main (drawing) window for terraformer. Extends
 * 	TFWindowBase to inherit the shared dialogs.
 */
class TFWindowMain : public TFWindowBase
	{
	public: 
				TFWindowMain (FlexArray *wList); 
		virtual		~TFWindowMain (); 
		virtual void 	quit ();
		void		checkMenus ();
		Gtk_CList	*getCList () 	{ return p_cList; }

	protected: 
		virtual void	fileMenuCallback (string m);
		void            fileSelectionOK ();
                void            fileSelectionCancel ();
                void            fileSelection ();
		void		buildWindow ();

		Gtk_AccelGroup		d_accelGroup,
					d_accelGroupCList;
		Gtk_VBox		d_vBoxList,
					d_vBoxMenu,
					d_vBoxMain;
		Gtk_Window		d_win;
		Gtk_ObjectHandle<Gtk_MenuBar>	d_menuBarHandle;
		Gtk_ObjectHandle<Gtk_Menu>	d_menuCListHandle;
		TFCListMainWin		*p_cList;
		Gtk_FileSelection	*p_fileSelection;
		Gtk_ItemFactory		*p_itemFactory;
		Gtk_ItemFactory		*p_itemFactoryCList;
		Gtk_ScrolledWindow	*p_scrolledWin;
		GuiDialogOAC		*p_genSSynthDialog,
					*p_genSubdivDialog;
	};


#endif // _TF_WINDOW_MAIN_H

