#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "agename.h"

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif




/* 
 * agename: parse a filename and attempt to either update an existing 
 * 	versioning scheme or insert a new one into the string. All memory is 
 * 	allocated using malloc and the returned pointer should be disposed of 
 * 	using free(), not the C++ delete.
 * 
 * The Naming convention used is as follows: 
 * 	name-version.extension
 * where something like "filename-01.tga" becomes "filename-02.tga" and 
 * something like "filename.tga" becomes "filename-01.tga" 
 *
 * This is actually plain C code (regardless of the *.cc file it's in)
 */ 
char *agename (char *name)
{
	char 	*lMinus,				/* location of Minus sign */
		*lDot,					/* location of Dot */
		*dst,					/* destination string */
		*s; 
	char	version[80];				/* actual version part of string */
	int	val;
	int	insert=FALSE;

	if (!name) 
		return NULL;

	lMinus = strchr (name, '-');
	lDot = strchr (name, '.');

	if (!lDot) 					/* should at least be able to find the dot */
		return NULL;

	if (!lMinus) 					/* no minus -> insert a new one */
		insert = TRUE;

	dst = (char *)malloc(strlen(name)+16);
	if (!dst)
		return NULL;

	if (insert)					/* insert a new version */
		{
		strncpy (dst, name, lDot-name);
		dst[lDot-name] = '\0';
		strcat (dst, "-01");
		strcat (dst, lDot);
		}
	else						/* update existing version */
		{
		s = lMinus+1;
		while (s < lDot)
			{
			if (!isdigit(*s))
				break;
			s++;
			}

		if (s != lDot)				/* break, it's not all numbers */
			return NULL;

		strncpy (version, lMinus+1, lDot-lMinus);
		version[lDot-lMinus] = '\0';
		val = atoi (version);
		if (val < 99)
			sprintf (version, "-%02d", val+1);
		else
			sprintf (version, "-%d", val+1);
		strncpy (dst, name, lMinus-name);
		dst[lMinus-name] = '\0';
		strcat (dst, version);
		strcat (dst, lDot);
		}

	/* printf ("%s ---> %s\n", name, dst); */
	return (dst);
}


/*
int main (int argc, char **argv)
{
	char 	*t1= "test.tga",
		*t2= "test-28.tga",
		*t3= "Untitled.tga",
		*t4= "Untitled-01.tga";

	printf ("[%s]\n", agename(t1));
	printf ("[%s]\n", agename(t2));
	printf ("[%s]\n", agename(t3));
	printf ("[%s]\n", agename(t4));
}
*/
