/******************************************************************************
    Xplanet 0.43 - render an image of the earth into an X window
    Copyright (C) 1999 Hari Nair <hari@alumni.caltech.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

******************************************************************************/

struct coordinates
{
  double lon;
  double lat;
  double dist;
  double alpha;
  double delta;
};

class planet
{
 public:
  planet (double T, int ibody);
  void calc_helio ();
  void calc_geo ();
  coordinates calc_coordinates (coordinates body, double eps);
  coordinates helio, geo;

 private:
  double mlong,       // mean longitude
    manom,            // mean anomaly
    axis,             // semimajor axis
    ecc,              // eccentricity
    incl,             // inclination
    perih,            // argument of perihelion
    ascnode,          // longitude of ascending node

    alpha0,           // right ascension of the north pole
    delta0,           // declination of the north pole

    null_meridian,    // orientation of zero longitude
    wdot,             // rotation rate

    axis_position;    // position angle of the axis, from north
  
  char name[8];
};

extern char *current_body;
extern int flipped;
