// ctyfile.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "ctyfile.h"

#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define BUFFER_SIZE    1024
#define FIELD_SIZE     100

RCtyFile::RCtyFile(char *name)
{
    callList = NULL;
    ctyCount = 0;
    if (!name)
        name = "cqww.cty";
    RCtyFile::open(name);
        
}

RCtyFile::~RCtyFile()
{
    int tempCount;
    
    // Deallocate the memory used to store country information.
    if (ctyCount > 0)
        for (tempCount = 0; tempCount < ctyCount; tempCount++)
        {
            delete ctyList[tempCount].countryName;
            delete ctyList[tempCount].countryPrefix;
        }

    // Deallocate all callsigns in the prefix/callsign list.
    while (callList != NULL)
    {
        callInfo *nextCall = callList->next;
        delete callList;
        callList = nextCall;
    }
}        

boolean RCtyFile::open(char *name, int mode)
{
#ifdef LINUX
    if (!RFile::open(name, mode))
        return FALSE;
#else
    // State ios::binary again just in case user does not.
    if (!RFile::open(name, mode | ios::binary))
        return FALSE;
#endif

    if (!RCtyFile::ProcessCtyFile())
    {
        RFile::close();
        return FALSE;
    }
    return TRUE;
}

boolean RCtyFile::ProcessCtyFile()
{
    char buffer[BUFFER_SIZE];
    char countryName[FIELD_SIZE];
    char countryPrefix[FIELD_SIZE];
    int  zone;
    int  countryNumber;
    
    char callsign[BUFFER_SIZE];
    char *tempPtr;
    char *semicolonPtr;
    
    RFile::getString(buffer, BUFFER_SIZE);
    while (!RFile::eof())
    {
        if ((tempPtr = strstr(buffer, "\r")) != (char *)NULL)
            *tempPtr = (char)NULL;
        semicolonPtr = strstr(buffer, ";");
            
        if (isupper(buffer[0]))
        {
            strcpy(countryName, strtok(buffer, ":"));
            zone = atoi(strtok(NULL, ":"));
            strcpy(countryPrefix, strtok(NULL, " :"));
            RCtyFile::AddCtyToList(&countryNumber, countryName, countryPrefix, zone);
        }
        else
            strtok(buffer, " ");

        while ((tempPtr = strtok(NULL, " ,;")) != (char *)NULL)
            if ((semicolonPtr == (char *)NULL ) || (tempPtr < semicolonPtr))
            {
                AddCallToList(tempPtr, countryNumber);
                strcpy(callsign, tempPtr);
                // Insert new call/prefix into list with cty number.
            }
            
        RFile::getString(buffer, BUFFER_SIZE);
    }

    return TRUE;
}

boolean RCtyFile::AddCtyToList(int *countryNumber, char *countryName, char *countryPrefix, int zone)
{
    ctyList[ctyCount].countryName = new char[strlen(countryName) + 1];
    strcpy(ctyList[ctyCount].countryName, countryName);
    
    ctyList[ctyCount].countryPrefix = new char[strlen(countryPrefix) + 1];
    strcpy(ctyList[ctyCount].countryPrefix, countryPrefix);

    ctyList[ctyCount].zone = zone;

    *countryNumber = ctyCount;
    ctyCount++;
    return TRUE;
}

boolean RCtyFile::AddCallToList(char *callsign, int countryNumber)
{
    callInfo *listPtr = callList;
    
    if (callList == NULL)
    {
        callList = new callInfo;
        callList->callsign = new char[strlen(callsign) + 1];
        strcpy(callList->callsign, callsign);
        callList->countryNumber = countryNumber;
        callList->next = NULL;
    }
    else
    {
        callInfo *newPtr;
        
        while (listPtr->next != NULL)
            listPtr = listPtr->next;

        newPtr = new callInfo;
        newPtr->callsign = new char[strlen(callsign) + 1];
        strcpy(newPtr->callsign, callsign);
        newPtr->countryNumber = countryNumber;
        newPtr->next = NULL;

        listPtr->next = newPtr;
    }
            
    return TRUE;
}

boolean RCtyFile::GetInfo(const char *callsign, char *countryName, char *prefix, int *zone)
{
    char tempCall[FIELD_SIZE];
    callInfo *callListPtr;
    ctyinfo *tempCty;
    boolean Found = FALSE;

    strcpy(tempCall, callsign);
    while (!Found && (strlen(tempCall) != 0))
    {
        callListPtr = callList;
        while ((callListPtr != NULL) && (strcmp(tempCall, callListPtr->callsign) != 0))
            callListPtr = callListPtr->next;
        if (callListPtr == NULL)
        {
            if (strlen(tempCall) > 1)
            {
                char *tempChar = &tempCall[strlen(tempCall) - 1];
                *tempChar = (char)NULL;
            }
            else
                return FALSE;
        }
        else
            Found = TRUE;
    }

    tempCty = &ctyList[callListPtr->countryNumber];
    strcpy(countryName, tempCty->countryName);
    strcpy(prefix, tempCty->countryPrefix);
    *zone = tempCty->zone;

    return TRUE;

}
    
