// ---------------------------------------------------------------------------
// - Input.hpp                                                               -
// - standard object library - input stream base class definition            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_INPUT_HPP
#define  ALEPH_INPUT_HPP

#ifndef  ALEPH_BUFFER_HPP
#include "Buffer.hpp"
#endif

namespace aleph {

  /// The input stream class is a base class which provides a read method for
  /// character in a generic way. Various classes are derived from it, like 
  /// the InputTerm or InputFile. The class implements a buffer which provides
  /// a generic pushback method. When the read method is invoked, the character
  /// is placed in the buffer.
  /// @author amaury darsch

  class Input : public virtual Object {
  protected:
    /// the local buffer
    Buffer d_buffer;

  public:
    /// @return the next available character
    virtual char read (void) =0;

    /// @return the next available line
    String readln (void);

    /// @return true if we are at the eof
    virtual bool iseof (void) const =0;

    /// push back a character in the input stream.
    /// @param value the character to push back
    void pushback (const char value);

    /// pushback a string on this input stream
    void pushback (const String& value);

    /// apply this input with a set of arguments and a method name
    /// @param interp interp the current interpreter
    /// @param nset   the current nameset    
    /// @param name   the name to apply this arguments
    /// @param argv   the argument vector to apply
    Object* apply (Interp* interp, Nameset* nset, const String& name,
		   Vector* argv);
  };
}

#endif
