// ---------------------------------------------------------------------------
// - cdl.hxx                                                                 -
// - standard system library - c dynamic library definitions                 -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

/// This package contains c dynamic library procedures. A dynamic library is
/// is used to to retreive symbol. The library can be opened, queried and
/// closed. This package is for unix only.
/// @author amaury darsch

#ifndef ALEPH_CDL_HXX
#define ALEPH_CDL_HXX

namespace aleph {

  /// Open a dynamic library by name.
  /// @param  the library name.
  /// @return a library descriptor suitable for query.
  void* c_dlopen (const char* name);
  
  /// Query a symbol by name, using a library descriptor.
  /// @param name the symbol name
  /// @param lptr the library descriptor
  /// @return a symbol descriptor
  void* c_dlsym (const char* name, void* lptr);
  
  /// Close the dynamic library.
  /// @param lptr the library descriptor  
  void c_dlclose (void* lptr);
}

#endif
