// ---------------------------------------------------------------------------
// - t_localset.cpp                                                          -
// - aleph engine - local set class tester module                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Localset.hpp"

int main (int, char**) {
  using namespace aleph;

  // create a local set
  Localset lset;
  Object::iref (&lset);
  if (lset.repr () != "Localset") return 1;
  if (lset.getparent () != nilp)   return 1;

  // add some objects
  lset.bind ("hello", (Object*) nilp);
  if (lset.exists ("hello") == false) return 1;
  if (lset.find ("hello") != nilp)    return 1;

  // remove and check again
  lset.remove ("hello");
  if (lset.exists ("hello") == true) return 1;

  // success
  return 0;
}
