/********************************************************************************
*                                                                               *
*          M u l t i p l e   D o c u m e n t   C h i l d   W i n d o w          *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMDIChild.h,v 1.5 1999/11/09 23:58:37 jeroen Exp $                      *
********************************************************************************/
#ifndef FXMDICHILD_H
#define FXMDICHILD_H

class FXMDIClient;


// MDI Child Window styles
enum FXMDIChildStyle {
  MDI_NORMAL    = 0,
  MDI_MAXIMIZED = 0x00001000,
  MDI_MINIMIZED = 0x00002000 
  };



// Base composite
class FXAPI FXMDIChild : public FXComposite {
  FXDECLARE(FXMDIChild)
protected:
  FXString      title;
  FXMenuButton *windowbtn;
  FXButton     *minimizebtn;
  FXButton     *restorebtn;
  FXButton     *maximizebtn;
  FXButton     *deletebtn;
  FXFont       *font;
  FXTimer      *timer;
  FXColor       baseColor;
  FXColor       hiliteColor;
  FXColor       shadowColor;
  FXColor       borderColor;
  FXColor       titleColor;
  FXColor       titleBackColor;
  FXint         iconPosX;
  FXint         iconPosY;
  FXint         normalPosX;
  FXint         normalPosY;
  FXint         normalWidth;
  FXint         normalHeight;
  FXint         xoff;
  FXint         yoff;
  FXint         oldx;
  FXint         oldy;
  FXint         oldw;
  FXint         oldh;
  FXint         tween;
  FXuchar       action;
  FXuchar       anim;
private:
  FXMDIChild   *mdinext;
  FXMDIChild   *mdiprev;
protected:
  FXMDIChild();
  void drawRubberBox(FXint x,FXint y,FXint w,FXint h);
  void drawTweenBox(FXint t);
  FXuchar where(FXint x,FXint y);
  void changeCursor(FXint x,FXint y);
  void revertCursor();
  virtual void layout();
private:
  FXMDIChild(const FXMDIChild&);
  FXMDIChild &operator=(const FXMDIChild&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onAnimTimer(FXObject*,FXSelector,void*);
  long onFocusSelf(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onDelete(FXObject*,FXSelector,void*);
  long onClose(FXObject*,FXSelector,void*);
  long onSelected(FXObject*,FXSelector,void*);
  long onDeselected(FXObject*,FXSelector,void*);
  long onMinimize(FXObject*,FXSelector,void*);
  long onRestore(FXObject*,FXSelector,void*);
  long onMaximize(FXObject*,FXSelector,void*);
  long onCmdRestore(FXObject*,FXSelector,void*);
  long onCmdMaximize(FXObject*,FXSelector,void*);
  long onCmdMinimize(FXObject*,FXSelector,void*);
  long onCmdClose(FXObject*,FXSelector,void*);
  long onCmdDelete(FXObject*,FXSelector,void*);
  long onUpdRestore(FXObject*,FXSelector,void*);
  long onUpdMaximize(FXObject*,FXSelector,void*);
  long onUpdMinimize(FXObject*,FXSelector,void*);
  long onUpdWindow(FXObject*,FXSelector,void*);
  long onUpdMenuRestore(FXObject*,FXSelector,void*);
  long onUpdMenuMinimize(FXObject*,FXSelector,void*);
  long onUpdMenuClose(FXObject*,FXSelector,void*);
  long onUpdMenuWindow(FXObject*,FXSelector,void*);
  long onUpdClose(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
public:
  enum{
    ID_TIMER_ANIM=FXComposite::ID_LAST,
    ID_LAST
    };
public:
  
  /// Construct MDI Child window with given name and icon
  FXMDIChild(FXMDIClient* p,const FXString& name,FXIcon* ic=NULL,FXMenuPane* mn=NULL,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// Create window
  virtual void create();
  
  /// Detach window
  virtual void detach();
  
  /// Get next MDI Child
  FXMDIChild* getMDINext() const { return mdinext; }

  /// Get previous MDI Child
  FXMDIChild* getMDIPrev() const { return mdiprev; }

  /// Compute default size
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  
  /// MDI Child can receive focus
  virtual FXbool canFocus() const;

  /// For message forwarding
  virtual long handle(FXObject* sender,FXSelector key,void* data);
  
  /// Return content window
  FXWindow *contentWindow() const;
  
  /// Change MDI Child's title
  void setTitle(const FXString& name);
  
  /// Get current title
  FXString getTitle() const { return title; }

  /// Get colors
  FXColor getHiliteColor() const { return hiliteColor; }
  FXColor getShadowColor() const { return shadowColor; }
  FXColor getBaseColor() const { return baseColor; }
  FXColor getBorderColor() const { return borderColor; }

  /// Change colors
  void setHiliteColor(FXColor clr);
  void setShadowColor(FXColor clr);
  void setBaseColor(FXColor clr);
  void setBorderColor(FXColor clr);
  
  /// Return TRUE if maximized
  FXbool isMaximized() const;
  
  /// Return TRUE if minimized
  FXbool isMinimized() const;
  
  /// Maximize MDI Child
  void maximize();
  
  /// Minimize/iconify MDI Child
  void minimize();
  
  /// Restore MDI Child to normal
  void restore();
  
  /// Get window icon
  FXIcon *getWindowIcon() const;
  
  /// Set window icon
  void setWindowIcon(FXIcon* icon);
  
  /// Get window menu
  FXPopup* getWindowMenu() const;
  
  /// Set window menu
  void setWindowMenu(FXPopup* menu);
  
  /// Set title font
  void setFont(FXFont *fnt);
  
  /// Get title font
  FXFont* getFont() const { return font; }

  /// Serialization
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  
  virtual ~FXMDIChild();
  };

  
#endif
