/********************************************************************************
*                                                                               *
*              T h e   P a t h F i n d e r   F i l e   B r o w s e r            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: PathFinder.cpp,v 1.5 1999/11/16 19:36:52 jeroen Exp $                    *
********************************************************************************/
#include "xincs.h"
#include "fx.h"
#include "PathFinder.h"
#include "icons.h"
#include <stdio.h>
#include <stdlib.h>


  
/*******************************************************************************/

// Map
FXDEFMAP(PathFinderMain) PathFinderMainMap[]={
  FXMAPFUNC(SEL_CLOSE,0,PathFinderMain::onQuit),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_QUIT,PathFinderMain::onQuit),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_DIRECTORYLIST,PathFinderMain::onCmdDirectory),
  FXMAPFUNC(SEL_CLICKED,PathFinderMain::ID_FILELIST,PathFinderMain::onCmdFileClicked),
  FXMAPFUNC(SEL_DOUBLECLICKED,PathFinderMain::ID_FILELIST,PathFinderMain::onCmdFileDblClicked),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_ABOUT,PathFinderMain::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_DIRBOX,PathFinderMain::onCmdDirTree),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_SEARCHPATH,PathFinderMain::onCmdSetSearchPath),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_UPDIRECTORY,PathFinderMain::onCmdUpDirectory),
  };


// Object implementation
FXIMPLEMENT(PathFinderMain,FXMainWindow,PathFinderMainMap,ARRAYNUMBER(PathFinderMainMap))


/*******************************************************************************/
  
// Make some windows
PathFinderMain::PathFinderMain(FXApp* a):FXMainWindow(a,"PathFinder",NULL,NULL,DECOR_ALL,0,0,800,600){
  
  // Menu bar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // File menu pane
  FXMenuPane* filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"&New Folder",NULL,NULL,0);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q\tQuit PathFinder",NULL,this,ID_QUIT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
    
  // Separator
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  
  // Toolbar
  toolbar=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 4,4,0,0, 0,0);

  
  // Status bar
  FXStatusbar *status=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  
  // Subtle plug for LINUX
  new FXButton(status,"\tHello, I'm Tux...\nThe symbol for the Linux Operating System.\nAnd all it stands for.\tLinux:- the alternative operating system.",new FXBMPIcon(getApp(),minipenguin,0,IMAGE_ALPHAGUESS),this,ID_ABOUT,LAYOUT_TOP|LAYOUT_RIGHT);
  
  
  // Main window interior
  splitter=new FXSplitter(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);
  group1=new FXVerticalFrame(splitter,LAYOUT_FILL_Y|LAYOUT_FILL_Y, 0,0,180,0, 0,0,0,0);
  group2=new FXVerticalFrame(splitter,LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);


  // Directories
  new FXLabel(group1,"Directories",NULL,JUSTIFY_LEFT|LAYOUT_TOP|LAYOUT_FILL_X|FRAME_SUNKEN);
  subgroup1=new FXVerticalFrame(group1,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  
  // Files
  new FXLabel(group2,"Files",NULL,JUSTIFY_LEFT|LAYOUT_TOP|LAYOUT_FILL_X|FRAME_SUNKEN);
  subgroup2=new FXVerticalFrame(group2,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);

  // Directory List on the left
  dirlist=new FXDirList(subgroup1,0,this,ID_DIRECTORYLIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_RIGHT|TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES);
    
  // Icon list on the right
  filelist=new FXFileList(subgroup2,this,ID_FILELIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|ICONLIST_BIG_ICONS);

  // Edit Menu Pane
  FXMenuPane* editmenu=new FXMenuPane(this);
  new FXMenuCommand(editmenu,"&Select All\t\tSelect all icons",NULL,filelist,FXFileList::ID_SELECT_ALL);
  new FXMenuCommand(editmenu,"&Deselect All\t\tDeselect all icons",NULL,filelist,FXFileList::ID_DESELECT_ALL);
  new FXMenuCommand(editmenu,"&Invert Selection\t\tInvert selection",NULL,filelist,FXFileList::ID_SELECT_INVERSE);
  new FXMenuTitle(menubar,"&Edit",NULL,editmenu);
  
  // View Menu Pane
  FXMenuPane *viewmenu=new FXMenuPane(this);
  new FXMenuCommand(viewmenu,"&Toolbar\t\tShow or hide tool bar",NULL,toolbar,FXWindow::ID_TOGGLESHOWN);
  new FXMenuCommand(viewmenu,"&Statusbar\t\tShow or hide status bar",NULL,status,FXWindow::ID_TOGGLESHOWN);
  new FXMenuTitle(menubar,"&View",NULL,viewmenu);
  
  // Pattern
  pattern=new FXTextField(status,10,filelist,FXFileList::ID_SET_PATTERN,FRAME_SUNKEN|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0, 0,0,1,1);

  // Caption before pattern  
  new FXLabel(status,"Pattern:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y);
  
  // Directory box
  dirbox=new FXDirBox(toolbar,5,this,ID_DIRBOX,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FIX_WIDTH|LAYOUT_CENTER_Y,0,0,180,0, 0,0, 1,1);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);

  // Add some toolbar buttons
  new FXButton(toolbar,"\tUp\tChange up one level.",new FXBMPIcon(getApp(),dirup,0,IMAGE_ALPHAGUESS),this,ID_UPDIRECTORY,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  new FXButton(toolbar,"\tMount\tMount device.",new FXBMPIcon(getApp(),maphost,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tUnmount\tUnmount device.",new FXBMPIcon(getApp(),unmaphost,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  new FXButton(toolbar,"\tCut\tCut to clipboard.",new FXBMPIcon(getApp(),cut,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tCopy\tCopy to clipboard.",new FXBMPIcon(getApp(),copy,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tPaste\tPaste from clipboard.",new FXBMPIcon(getApp(),paste,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  new FXButton(toolbar,"\tProperties\tDisplay file properties.",new FXBMPIcon(getApp(),properties,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  // Switch display modes
  new FXButton(toolbar,"\tBig Icons\tShow big icons.",new FXBMPIcon(getApp(),bigicons,0,IMAGE_ALPHAGUESS),filelist,FXFileList::ID_SHOW_BIG_ICONS,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tSmall Icons\tShow small icons.",new FXBMPIcon(getApp(),smallicons,0,IMAGE_ALPHAGUESS),filelist,FXFileList::ID_SHOW_MINI_ICONS,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tDetails\tShow detail view.",new FXBMPIcon(getApp(),details,0,IMAGE_ALPHAGUESS),filelist,FXFileList::ID_SHOW_DETAILS,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,16,0);
  
  // Delete button far away
  new FXButton(toolbar,"\tDelete\tDelete file.",new FXBMPIcon(getApp(),deleteit,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Arrange menu
  FXMenuPane* arrangemenu=new FXMenuPane(this);
  new FXMenuCommand(arrangemenu,"&Details\t\tShow detail view.",NULL,filelist,FXFileList::ID_SHOW_DETAILS);
  new FXMenuCommand(arrangemenu,"&Small Icons\t\tShow small icons.",NULL,filelist,FXFileList::ID_SHOW_MINI_ICONS);
  new FXMenuCommand(arrangemenu,"&Big Icons\t\tShow big icons.",NULL,filelist,FXFileList::ID_SHOW_BIG_ICONS);
  new FXMenuCommand(arrangemenu,"&Rows\t\tView row-wise.",NULL,filelist,FXFileList::ID_ARRANGE_BY_ROWS);
  new FXMenuCommand(arrangemenu,"&Columns\t\tView column-wise.",NULL,filelist,FXFileList::ID_ARRANGE_BY_COLUMNS);
  new FXMenuTitle(menubar,"&Arrange",NULL,arrangemenu);
  
  // Sort menu
  FXMenuPane* sortmenu=new FXMenuPane(this);
  new FXMenuCommand(sortmenu,"&Name\t\tSort by file name.",NULL,filelist,FXFileList::ID_SORT_BY_NAME);
  new FXMenuCommand(sortmenu,"&Type\t\tSort by file type.",NULL,filelist,FXFileList::ID_SORT_BY_TYPE);
  new FXMenuCommand(sortmenu,"&Size\t\tSort by file size.",NULL,filelist,FXFileList::ID_SORT_BY_SIZE);
  new FXMenuCommand(sortmenu,"T&ime\t\tSort by modification time.",NULL,filelist,FXFileList::ID_SORT_BY_TIME);
  new FXMenuCommand(sortmenu,"&User\t\tSort by user name.",NULL,filelist,FXFileList::ID_SORT_BY_USER);
  new FXMenuCommand(sortmenu,"&Group\t\tSort by group name.",NULL,filelist,FXFileList::ID_SORT_BY_GROUP);
  new FXMenuCommand(sortmenu,"&Reverse\t\tReverse sort direction.",NULL,filelist,FXFileList::ID_SORT_REVERSE);
  new FXMenuTitle(menubar,"&Sort",NULL,sortmenu);
  
  // Options menu
  FXMenuPane* optionsmenu=new FXMenuPane(this);
  new FXMenuCommand(optionsmenu,"&Hidden Directories\t\tShow hidden directories.",NULL,dirlist,FXDirList::ID_TOGGLE_HIDDEN);
  new FXMenuCommand(optionsmenu,"&Hidden Files\t\tShow hidden files and directories.",NULL,filelist,FXFileList::ID_TOGGLE_HIDDEN);
  new FXMenuTitle(menubar,"&Options",NULL,optionsmenu);
  
  // Preferences menu
  FXMenuPane* prefmenu=new FXMenuPane(this);
  new FXMenuCommand(prefmenu,"&Icon path...\t\tIcon search path.",NULL,this,ID_SEARCHPATH);
  new FXMenuTitle(menubar,"&Preferences",NULL,prefmenu);
  
  // Help menu
  FXMenuPane* helpmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);
  new FXMenuCommand(helpmenu,"&About PathFinder...\t\tDisplay PathFinder About Panel.",NULL,this,ID_ABOUT,0);
  
  // Make a tool tip
  new FXTooltip(getApp(),0);
  }
  

// Handle quitting
long PathFinderMain::onQuit(FXObject*,FXSelector,void*){
  if(MBOX_CLICKED_YES==FXMessageBox::question(this,MBOX_YES_NO,"Quiting PathFinder","Do you really want to quit PathFinder?")){
    getApp()->exit(0);
    }
  return 1;
  }


// Change the directory
long PathFinderMain::onCmdDirectory(FXObject*,FXSelector,void* ptr){
  FXTreeItem *item=(FXTreeItem*)ptr;
  if(item){
    directory=dirlist->getItemPathname(item);
    filelist->setDirectory(directory);
    dirbox->setDirectory(directory);
    }
  return 1;
  }


// Command from directory combo 
long PathFinderMain::onCmdDirTree(FXObject*,FXSelector,void* ptr){
  directory=dirbox->getDirectory();
  dirlist->setDirectory(directory);
  filelist->setDirectory(directory);
  return 1;
  }


// File Item was double-clicked
long PathFinderMain::onCmdFileDblClicked(FXObject*,FXSelector,void* ptr){
  FXint index=(FXint)(long)ptr;
  if(0<=index){
    
    // If directory, open the directory
    if(filelist->isItemDirectory(index)){
      directory=filelist->getItemPathname(index);
      filelist->setDirectory(directory);
      dirlist->setDirectory(directory);
      dirbox->setDirectory(directory);
      }
    
    // If executable, execute it!
    else if(filelist->isItemExecutable(index)){
      FXString executable=filelist->getItemPathname(index) + " &";
      system(executable.text());
      }

    // If regular file return as the selected file
    else if(filelist->isItemFile(index)){
      FXFileAssoc *association=filelist->getItemAssoc(index);
      if(association){
        if(association->command.text()){
          FXString command=FXStringFormat(association->command.text(),filelist->getItemPathname(index).text());
          system(command.text());
          }
        else{
          FXMessageBox::information(this,MBOX_OK,"Unknown Command","No command defined for file: %s",filelist->getItemFilename(index).text());
          }
        }
      else{
        FXMessageBox::information(this,MBOX_OK,"Unknown File Type","No association has been set for file: %s",filelist->getItemFilename(index).text());
        }
      }
    }
  return 1;
  }


// File Item was clicked
long PathFinderMain::onCmdFileClicked(FXObject*,FXSelector,void* ptr){
//   FXchar path[MAXPATHLEN+1],name[MAXPATHLEN+1],dir[MAXPATHLEN+1],*p;
//   FXOldIconItem *item=(FXOldIconItem*)ptr;
//   name[0]=0;
//   strcpy(path,filelist->getDirectory());
//   if(item){
//     strcpy(name,filelist->getItemText(item));
//     if((p=strchr(name,'\t'))) *p=0;
//     }
//   fxpathname(dir,path,name);
//   filename->setText(dir);
  return 1;
  }



// About
long PathFinderMain::onCmdAbout(FXObject*,FXSelector,void*){
  FXBMPIcon icon(getApp(),bigpenguin,0,IMAGE_ALPHAGUESS);
  FXMessageBox about(this,"About PathFinder","PathFinder File Browser V0.1 (beta)\n\nUsing the FOX C++ GUI Library (http://cyberia.cfdrc.com/FOX/fox.html)\n\nCopyright (C) 1998 Jeroen van der Zijp (jvz@cfdrc.com)",&icon,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
  about.execute();  
  return 1;
  }


// Set search path
long PathFinderMain::onCmdSetSearchPath(FXObject*,FXSelector,void*){
  FXDialogBox dialog(getApp(),"Change icon search path",DECOR_TITLE|DECOR_BORDER);
  const FXchar *path;
  FXVerticalFrame* content=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,10,10,10,10,10,10);
  new FXLabel(content,"&Specify a `" PATHLISTSEPSTRING "' separated list of directories where icons are to be found:",NULL,LAYOUT_FILL_X);
  FXTextField *text=new FXTextField(content,30,NULL,0,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X);
  new FXHorizontalSeparator(content,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  FXHorizontalFrame* buttons=new FXHorizontalFrame(content,LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);
  new FXButton(buttons,"&OK",NULL,&dialog,FXDialogBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT);
  new FXButton(buttons,"&Cancel",NULL,&dialog,FXDialogBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT,0,0,0,0,20,20);
  path=getApp()->reg().readStringEntry("SETTINGS","iconpath","~/.foxicons");
  text->setText(path);
  if(dialog.execute()){
    getApp()->reg().writeStringEntry("SETTINGS","iconpath",text->getText().text());
    }
  return 1;
  }


// Move up one directory
long PathFinderMain::onCmdUpDirectory(FXObject*,FXSelector,void*){
  FXchar path[MAXPATHLEN];
  fxupdir(path,filelist->getDirectory().text());
  filelist->setDirectory(path);
  dirbox->setDirectory(path);
  dirlist->setDirectory(path);
  return 1;
  }


// Switch to given directory
void PathFinderMain::setDirectory(const FXString& dir){
  filelist->setDirectory(dir);
  dirbox->setDirectory(dir);
  dirlist->setDirectory(dir);
  }


// Make application
void PathFinderMain::create(){
  FXMainWindow::create();
  show();
  }



/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){
  FXApp* application=new FXApp("Desktop",NULL);
  application->init(argc,argv);
  new PathFinderMain(application);
  application->create();
  application->run();
  }


