/********************************************************************************
*                                                                               *
*                     A p p l i c a t i o n   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* Major Contributions for Windows NT by Lyle Johnson                            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXApp.cpp,v 1.53 1999/11/10 21:28:32 jeroen Exp $                        *
********************************************************************************/
#ifdef FX_NATIVE_WIN32
#if _WIN32_WINNT < 0x0400
#define _WIN32_WINNT 0x0400
#endif
#endif
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXVisual.h"
#include "FXCursor.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXBitmap.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXString.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXComposite.h"
#include "FXRootWindow.h"
#include "FXShell.h"
#include "FXTopWindow.h"
#include "FXDialogBox.h"
#include "FXMessageBox.h"
#include "FXProfiler.h"

/*
  Notes:
  
  - Need some sort of journal facility.
  - Should not be able to DND drop into some windows while modal window is up
  - Perhaps combine delayed paint, scroll, and layout into one mechanism...
  - refresh() now forces total GUI updating; flush() updates display only.
  - Sender is the FXApp, but in case of DND ops, we might have a special stand-in object
    as the sender (e.g. so we can send it messages).
  - Need two constructors for FXApp: one for deserialize, one normal...
  - Application should have a target to be notified of certain app-wide events,
    such as activation of [a window of] the application etc.
  - Need way to specify visual on command line (X11).
  - Need to be able to run event loop w/o display connection (just I/O, and timers).
  - Need to be able to ``detach'' from GUI more cleanly.
*/

// Just in case
#define bzero(ptr,size) memset(ptr,0,size)


// Regular define
#define SELECT(n,r,w,e,t)  select(n,r,w,e,t)


// FIX for HPUX
#ifdef _HPUX_SOURCE
#ifndef _XPG4_EXTENDED    // HPUX 9.07
#undef SELECT
#define SELECT(n,r,w,e,t)  select(n,(int*)(r),(int*)(w),(int*)(e),t)
#endif
#endif


// FIX for AIX 3.x
#ifndef _XOPEN_SOURCE_EXTENDED
#if defined(_POWER) || defined(_IBMR2)
#undef SELECT
#define SELECT(n,r,w,e,t)  select(n,(void*)(r),(void*)(w),(void*)(e),t)
extern "C" int gettimeofday(struct timeval *tv, struct timezone *tz);
#endif
#endif


// Default maximum number of colors to allocate
#define MAXCOLORS 125

// Determine largest number of signals on this system
#define MAXSIGNALS 64               // Nobody seems to have more than this...


/*******************************************************************************/

// Horizontal splitter cursor
#include "hsplit.xbm"
#include "hsplit_mask.xbm"

// Vertical splitter cursor
#include "vsplit.xbm"
#include "vsplit_mask.xbm"
   
// Cross splitter cursor
#include "xsplit.xbm"
#include "xsplit_mask.xbm"

// Corner resize handle cursor
#include "resize.xbm"
#include "resize_mask.xbm"

// Color swatch drag-and-drop cursor
#include "swatch.xbm"
#include "swatch_mask.xbm"

// NO DROP drag-and-drop cursor
#include "dontdrop.xbm"
#include "dontdrop_mask.xbm"

// Upper or lower side MDI resize cursor
#include "resizetop.xbm"
#include "resizetop_mask.xbm"
   
// Right MDI resize cursor
#include "resizetopright.xbm"
#include "resizetopright_mask.xbm"

// Left MDI resize cursor
#include "resizetopleft.xbm"
#include "resizetopleft_mask.xbm"

// Left or right side MDI resize cursor
#include "resizeleft.xbm"
#include "resizeleft_mask.xbm"

// Move cursor
#include "move.xbm"
#include "move_mask.xbm"

// Drag and drop COPY
#include "dndcopy.xbm"
#include "dndcopy_mask.xbm"
   
// Drag and drop LINK
#include "dndlink.xbm"
#include "dndlink_mask.xbm"
   
// Drag and drop MOVE
#include "dndmove.xbm"
#include "dndmove_mask.xbm"


/*******************************************************************************/

// Callback Record
struct FXCBSpec {
  FXObject      *target;            // Receiver object
  FXSelector     message;           // Message sent to receiver
  };

  
// Timer record
struct FXTimer {
  FXTimer       *next;              // Next timeout in list
  FXObject      *target;            // Receiver object
  FXSelector     message;           // Message sent to receiver
#ifndef FX_NATIVE_WIN32
  struct timeval due;               // When time is due
#else
  UINT           id;                // Timer id
#endif
  };

  
// Signal record
struct FXSignal {
  FXObject      *target;            // Receiver object
  FXSelector     message;           // Message sent to receiver
  FXbool         handlerset;        // Handler was already set
  FXbool         notified;          // Signal has fired
  };


// Idle record
struct FXChore {
  FXChore       *next;              // Next chore in list
  FXObject      *target;            // Receiver object
  FXSelector     message;           // Message sent to receiver
  };

  
// Input record
struct FXInput {
  FXCBSpec       read;              // Callback spec for read
  FXCBSpec       write;             // Callback spec for write
  FXCBSpec       excpt;             // Callback spec for except
  };


// A repaint event record
struct FXRepaint {
  FXRepaint     *next;              // Next repaint in list
  FXID           window;            // Window ID of the dirty window
  FXRectangle    rect;              // Dirty rectangle
  FXint          hint;              // Hint for compositing
  FXbool         synth;             // Synthetic expose event or real one?
  };
  
  
/*******************************************************************************/

   
// Application object
FXApp* FXApp::app=NULL;


// Version number that the library has been compiled with
const FXuchar FXApp::version[3]={FOX_MAJOR,FOX_MINOR,FOX_LEVEL};


// Windows application instance handle
#ifdef FX_NATIVE_WIN32
HINSTANCE FXApp::hInstance=0;
#endif


#ifndef FX_NATIVE_WIN32

// 17 stipple patterns which match up exactly with the 4x4 dither kernel
static const unsigned char stipple_patterns[17][8]={
  {0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00},   // 0 (white)
  {0x00,0x00,0x00,0x88, 0x00,0x00,0x00,0x88},
  {0x00,0x22,0x00,0x88, 0x00,0x22,0x00,0x88},
  {0x00,0x22,0x00,0xaa, 0x00,0x22,0x00,0xaa},
  {0x00,0xaa,0x00,0xaa, 0x00,0xaa,0x00,0xaa},
  {0x00,0xaa,0x44,0xaa, 0x00,0xaa,0x44,0xaa},
  {0x11,0xaa,0x44,0xaa, 0x11,0xaa,0x44,0xaa},
  {0x11,0xaa,0x55,0xaa, 0x11,0xaa,0x55,0xaa},
  {0x55,0xaa,0x55,0xaa, 0x55,0xaa,0x55,0xaa},   // 8 (50% grey)
  {0x55,0xaa,0x55,0xee, 0x55,0xaa,0x55,0xee},
  {0x55,0xbb,0x55,0xee, 0x55,0xbb,0x55,0xee},
  {0x55,0xbb,0x55,0xff, 0x55,0xbb,0x55,0xff},
  {0x55,0xff,0x55,0xff, 0x55,0xff,0x55,0xff},
  {0x55,0xff,0xdd,0xff, 0x55,0xff,0xdd,0xff},
  {0x77,0xff,0xdd,0xff, 0x77,0xff,0xdd,0xff},
  {0x77,0xff,0xff,0xff, 0x77,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff}    // 16 (black)
  };


// Standard-issue cross hatch pattern
static const unsigned char cross_bits[] = {
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0xff, 0xff, 0xff,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0xff, 0xff, 0xff, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0xff, 0xff, 0xff,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0xff, 0xff, 0xff, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20
  };
   
// Standard-issue diagonal cross hatch pattern
static const unsigned char crossdiag_bits[] = {
  0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x41, 0x41,
  0x80, 0x80, 0x41, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x14, 0x14,
  0x22, 0x22, 0x41, 0x41, 0x80, 0x80, 0x41, 0x41
  };
   
// Standard-issue diagonal hatch pattern
static const unsigned char diag_bits[] = {
  0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01,
  0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04,
  0x02, 0x02, 0x01, 0x01, 0x80, 0x80, 0x40, 0x40
  };
   
// Standard-issue horizontal hatch pattern
static const unsigned char hor_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };
   
// Standard-issue reverse diagonal hatch pattern
static const unsigned char revdiag_bits[] = {
  0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40,
  0x80, 0x80, 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10,
  0x20, 0x20, 0x40, 0x40, 0x80, 0x80, 0x01, 0x01
  };
   
// Standard-issue vertical hatch pattern
static const unsigned char ver_bits[] = {
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20,
  0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20
  };

#else
  
// 17 stipple patterns which match up exactly with the 4x4 dither kernel
// Note that each scan line must be word-aligned so we pad to the right
// with zeroes.
static const BYTE stipple_patterns[17][16]={
  {0xff,0x00,0xff,0x00,0xff,0x00,0xff,0x00, 0xff,0x00,0xff,0x00,0xff,0x00,0xff,0x00},   // 0 (white)
  {0xff,0x00,0xff,0x00,0xff,0x00,0x77,0x00, 0xff,0x00,0xff,0x00,0xff,0x00,0x77,0x00},
  {0xff,0x00,0xdd,0x00,0xff,0x00,0x77,0x00, 0xff,0x00,0xdd,0x00,0xff,0x00,0x77,0x00},
  {0xff,0x00,0xdd,0x00,0xff,0x00,0x55,0x00, 0xff,0x00,0xdd,0x00,0xff,0x00,0x55,0x00},
  {0xff,0x00,0x55,0x00,0xff,0x00,0x55,0x00, 0xff,0x00,0x55,0x00,0xff,0x00,0x55,0x00},
  {0xff,0x00,0x55,0x00,0xbb,0x00,0x55,0x00, 0xff,0x00,0x55,0x00,0xbb,0x00,0x55,0x00},
  {0xee,0x00,0x55,0x00,0xbb,0x00,0x55,0x00, 0xee,0x00,0x55,0x00,0xbb,0x00,0x55,0x00},
  {0xee,0x00,0x55,0x00,0xaa,0x00,0x55,0x00, 0xee,0x00,0x55,0x00,0xaa,0x00,0x55,0x00},
  {0xaa,0x00,0x55,0x00,0xaa,0x00,0x55,0x00, 0xaa,0x00,0x55,0x00,0xaa,0x00,0x55,0x00},   // 8 (50% grey)
  {0xaa,0x00,0x55,0x00,0xaa,0x00,0x11,0x00, 0xaa,0x00,0x55,0x00,0xaa,0x00,0x11,0x00},
  {0xaa,0x00,0x44,0x00,0xaa,0x00,0x11,0x00, 0xaa,0x00,0x44,0x00,0xaa,0x00,0x11,0x00},
  {0xaa,0x00,0x44,0x00,0xaa,0x00,0x00,0x00, 0xaa,0x00,0x44,0x00,0xaa,0x00,0x00,0x00},
  {0xaa,0x00,0x00,0x00,0xaa,0x00,0x00,0x00, 0xaa,0x00,0x00,0x00,0xaa,0x00,0x00,0x00},
  {0xaa,0x00,0x00,0x00,0x22,0x00,0x00,0x00, 0xaa,0x00,0x00,0x00,0x22,0x00,0x00,0x00},
  {0x88,0x00,0x00,0x00,0x22,0x00,0x00,0x00, 0x88,0x00,0x00,0x00,0x22,0x00,0x00,0x00},
  {0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}    // 16 (black)
  };

#endif

/*******************************************************************************/


// Map
FXDEFMAP(FXApp) FXAppMap[]={
  FXMAPFUNC(SEL_COMMAND,FXApp::ID_QUIT,FXApp::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,FXApp::ID_DUMP,FXApp::onCmdDump),
  };


// Implementation
FXIMPLEMENT(FXApp,FXObject,FXAppMap,ARRAYNUMBER(FXAppMap))

  
/*******************************************************************************/

  
// Initialize application object
FXApp::FXApp(const FXchar *name,const FXchar *vendor) : appname(name),registry(name,vendor){
  
  // Test if application object already exists
  if(app){ fxwarning("Warning: Trying to construct multiple application objects.\n"); }
  
  // Initialize private platform independent data
#ifdef FX_NATIVE_WIN32
  hInstance=GetModuleHandle(NULL);        // Application instance handle
#endif
  mainWindow=NULL;                        // Main window, or window group leader
  focusWindow=NULL;                       // Window which has focus
  cursorWindow=NULL;                      // Window under the cursor
  grabWindow=NULL;                        // Window that is grabbed
  keyWindow=NULL;                         // Window in which key was pressed
  dragWindow=NULL;                        // Window which has the drag source
  selectionWindow=NULL;                   // Window which has the selection
  clipboardWindow=NULL;                   // Window which has the clipboard
  refresher=NULL;                         // Window being refreshed
  timers=NULL;
  chores=NULL;
  repaints=NULL;
  timerrecs=NULL;
  chorerecs=NULL;
  repaintrecs=NULL;
  invocation=NULL;                        // Modal loop invocation
#ifndef FX_NATIVE_WIN32
  FXCALLOC(&inputs,FXInput,8);            // Input file descriptors
  ninputs=8;                              // Number of these
  maxinput=0;                             // Maximum input number
  FXCALLOC(&r_fds,fd_set,1);              // Read File Descriptor set
  FXCALLOC(&w_fds,fd_set,1);              // Write File Descriptor set
  FXCALLOC(&e_fds,fd_set,1);              // Except File Descriptor set
#endif
  signals=NULL;                           // Signals array
  nsignals=0;                             // Number of signal handlers set
  done=FALSE;                             // True if application is done
  maxcolors=MAXCOLORS;                    // Maximum number of colors to allocate
  exitcode=0;
  
  // Clear event structure
  event.type=0;
  event.window=0;
  event.time=0;
  event.win_x=0;
  event.win_y=0;
  event.root_x=0;
  event.root_y=0;
  event.state=0;
  event.code=0;
  event.last_x=0;
  event.last_y=0;
  event.click_x=0;
  event.click_y=0;
  event.click_time=0;
  event.click_window=0;
  event.click_button=0;
  event.click_count=0;
  event.moved=0;
  event.rect.x=0;
  event.rect.y=0;
  event.rect.w=0;
  event.rect.h=0;
  event.synthetic=0;
  event.requestor=0;
  event.property=0;
  event.target=0;
  event.origin=FROM_UNKNOWN;

  // Monochrome visual
  monoVisual=new FXVisual(this,VISUAL_MONOCHROME);

  // Default visual
  defaultVisual=new FXVisual(this,VISUAL_DEFAULT);

  // Make some cursors
  arrowCursor=new FXCursor(this,CURSOR_ARROW);
  rarrowCursor=new FXCursor(this,CURSOR_RARROW);
  textCursor=new FXCursor(this,CURSOR_IBEAM);

  // Cursors for splitter
  hsplitCursor=new FXCursor(this,hsplit_bits,hsplit_mask_bits,hsplit_width,hsplit_height,hsplit_x_hot,hsplit_y_hot);
  vsplitCursor=new FXCursor(this,vsplit_bits,vsplit_mask_bits,vsplit_width,vsplit_height,vsplit_x_hot,vsplit_y_hot);
  xsplitCursor=new FXCursor(this,xsplit_bits,xsplit_mask_bits,xsplit_width,xsplit_height,xsplit_x_hot,xsplit_y_hot);
  
  // Resize corner
  resizeCursor=new FXCursor(this,resize_bits,resize_mask_bits,resize_width,resize_height,resize_x_hot,resize_y_hot);
  
  // Color swatch
  swatchCursor=new FXCursor(this,swatch_bits,swatch_mask_bits,swatch_width,swatch_height,swatch_x_hot,swatch_y_hot);
  
  // DND no drop
  dontdropCursor=new FXCursor(this,dontdrop_bits,dontdrop_mask_bits,dontdrop_width,dontdrop_height,dontdrop_x_hot,dontdrop_y_hot);

  // Move  
  moveCursor=new FXCursor(this,move_bits,move_mask_bits,move_width,move_height,move_x_hot,move_y_hot);

  // Dragging edges/corners  
  dragHCursor=new FXCursor(this,resizetop_bits,resizetop_mask_bits,resizetop_width,resizetop_height,resizetop_x_hot,resizetop_y_hot);
  dragVCursor=new FXCursor(this,resizeleft_bits,resizeleft_mask_bits,resizeleft_width,resizeleft_height,resizeleft_x_hot,resizeleft_y_hot);
  dragTRCursor=new FXCursor(this,resizetopright_bits,resizetopright_mask_bits,resizetopright_width,resizetopright_height,resizetopright_x_hot,resizetopright_y_hot);
  dragTLCursor=new FXCursor(this,resizetopleft_bits,resizetopleft_mask_bits,resizetopleft_width,resizetopleft_height,resizetopleft_x_hot,resizetopleft_y_hot);

  // DND actions  
  dndCopyCursor=new FXCursor(this,dndcopy_bits,dndcopy_mask_bits,dndcopy_width,dndcopy_height,dndcopy_x_hot,dndcopy_y_hot);
  dndMoveCursor=new FXCursor(this,dndmove_bits,dndmove_mask_bits,dndmove_width,dndmove_height,dndmove_x_hot,dndmove_y_hot);
  dndLinkCursor=new FXCursor(this,dndlink_bits,dndlink_mask_bits,dndlink_width,dndlink_height,dndlink_x_hot,dndlink_y_hot);
  
  // Root window
  root=new FXRootWindow(this,defaultVisual);

  // X Window specific inits
#ifndef FX_NATIVE_WIN32
  display=NULL;
  wcontext=0;
  wmDeleteWindow=0;
  wmQuitApp=0;
  wmProtocols=0;
  wmMotifHints=0;
  wmTakeFocus=0;
  
  // TARGETS
  reqTargets=0;                       // Atom used in XConvertSelection to get list of types
  
  // CLIPBOARD
  xcbSelection=0;                     // Clipboard selection atom
  xcbTypeList=NULL;                   // List of clipboard types
  xcbNumTypes=0;                      // How many types clipped
  
  // SELECTION
  xselTypeList=NULL;                  // List of primary selection types
  xselNumTypes=0;                     // How many types in list
  
  // Miscellaneous stuff
  shmi=TRUE;
  shmp=TRUE;
  synchronize=FALSE;

#endif

  // XDND
  xdndTypeList=NULL;                  // List of XDND types 
  xdndNumTypes=0;                     // How many types in list
  xdndAware=0;                        // XDND awareness atom    
  xdndEnter=0;                        // XDND Message types
  xdndLeave=0;       
  xdndPosition=0;    
  xdndStatus=0;      
  xdndDrop=0;   
  xdndFinished=0;     
  xdndSelection=0;
  xdndActionMove=0;                   // XDND Copy action
  xdndActionCopy=0;                   // XDND Move action
  xdndActionLink=0;                   // XDND Link action
  xdndTypes=0;
  xdndSource=0;                       // XDND drag source window
  xdndTarget=0;                       // XDND drop target window
  xdndAction=0;                       // XDND action being performed
  xdndAccepts=FALSE;                  // XDND true if target accepts
  xdndSendPosition=FALSE;             // XDND send position update when status comes in
  xdndStatusPending=FALSE;            // XDND waiting for status feedback
  xdndFinishPending=FALSE;            // XDND waiting for drop-confirmation
  xdndStatusReceived=FALSE;           // XDND received at least one status
  xdndWantUpdates=TRUE;               // XDND target always wants new positions
#ifndef FX_NATIVE_WIN32
  xdndVersion=XDND_PROTOCOL_VERSION;  // Version for this transaction
#endif
  xdndRect.x=0;                       // XDND motion rectangle
  xdndRect.y=0;
  xdndRect.w=0;
  xdndRect.h=0;

  // DDE
  ddeAtom=0;                          // Data exchange atom
  ddeDelete=0;                        // Data exchange delete request
  ddeData=NULL;                       // Data exchange array
  ddeSize=0;                          // Data exchange array size
  
  // Make font
#ifndef FX_NATIVE_WIN32
  normalFont=new FXFont(this,"helvetica",9,FONTWEIGHT_BOLD);
#else
  HDC hdc=CreateCompatibleDC(NULL);
  SelectObject(hdc,GetStockObject(DEFAULT_GUI_FONT));
  int count=GetTextFace(hdc,0,NULL);
  FXchar *textfacename;
  FXMALLOC(&textfacename,FXchar,count);
  GetTextFace(hdc,count,textfacename);
  TEXTMETRIC tm;
  GetTextMetrics(hdc,&tm);
  normalFont=new FXFont(this,textfacename,fxheight_to_pointsize(hdc,tm.tmHeight)/10);
  FXFREE(&textfacename);
  DeleteDC(hdc);
#endif
  
  // Other settings
  clickSpeed=400;
  scrollSpeed=100;
  blinkSpeed=500;
  animSpeed=10;
  menuPause=400;
  tooltipPause=800;
  tooltipTime=3000;
  scrollbarWidth=15;
  dragDelta=6;
  
  // Init colors
  borderColor=FXRGB(0,0,0);
  baseColor=FXRGB(192,192,192);   
  hiliteColor=makeHiliteColor(baseColor); 
  shadowColor=makeShadowColor(baseColor); 
  backColor=FXRGB(255,255,255);   
  foreColor=FXRGB(0,0,0);   
  selforeColor=FXRGB(255,255,255);
  selbackColor=FXRGB(0,0,128);
  
  // Pointer to FXApp
  app=this;
  }


/*******************************************************************************/

// Perhaps should do something else...
#ifndef FX_NATIVE_WIN32
static int xerrorhandler(Display* dpy,XErrorEvent* eev){
  char buf[1000];
  XGetErrorText(dpy,eev->error_code,buf,sizeof(buf));
  fxwarning("X Error: code %d major %d minor %d: %s.\n",eev->error_code,eev->request_code,eev->minor_code,buf);
  return 1;
  }
#endif


// Fatal error (e.g. lost connection)
#ifndef FX_NATIVE_WIN32
static int xfatalerrorhandler(Display*){
  fxerror("X Fatal error.\n");
  return 1;
  }
#endif

/*******************************************************************************/


// Open the display
int FXApp::openDisplay(const FXchar* dpyname){
#ifndef FX_NATIVE_WIN32
  const FXchar* dpy;
 
  // Set error handler
  XSetErrorHandler(xerrorhandler);
  
  // Set fatal handler; it should save the app data & exit the program
  XSetIOErrorHandler(xfatalerrorhandler);
  
  // Try locate display
  dpy=dpyname;
  if(!dpy){
    dpy=getenv("DISPLAY");
    if(!dpy) dpy=":0.0";
    }

  // What's going on
  FXTRACE((100,"%s::openDisplay: opening display: %s.\n",getClassName(),dpy));
  
  // Open display
  display=XOpenDisplay(dpy);
  if(!display){ fxerror("%s::openDisplay: unable to open display %s\n",getClassName(),dpy); }

  // For debugging
  if(synchronize) XSynchronize(display,TRUE);

  // Make hash context for window mapping
  wcontext=XUniqueContext();
  
  // See if we wanted/have XSHM
#ifdef HAVE_XSHM
  FXTRACE((100,"Checking for shared memory.\n"));
  if(!(dpy[0]==':' && isdigit(dpy[1]))){
    shmi=0;
    shmp=0;
    }
  if(shmi || shmp){
    int maj,min,dum; Bool pm;
    shmi=FALSE;
    shmp=FALSE;
    if(XQueryExtension(display,"MIT-SHM",&dum,&dum,&dum)){
      if(XShmQueryVersion(display,&maj,&min,&pm)){
        shmp=pm && (XShmPixmapFormat(display)==ZPixmap);
        shmi=TRUE;
        }
      }
    }
  FXTRACE((100,"Shared Images  = %d\n",shmi));
  FXTRACE((100,"Shared Pixmaps = %d\n",shmp));
   
  // Don't have it!
#else
  FXTRACE((100,"Shared memory not available.\n"));
  shmi=FALSE;
  shmp=FALSE;
#endif

  // Window manager communication
  wmDeleteWindow=XInternAtom(display,"WM_DELETE_WINDOW",0);
  wmQuitApp=XInternAtom(display,"_WM_QUIT_APP",0);
  wmProtocols=XInternAtom(display,"WM_PROTOCOLS",0);
  wmMotifHints=XInternAtom(display,"_MOTIF_WM_HINTS",0);
  wmTakeFocus=XInternAtom(display,"WM_TAKE_FOCUS",0);
  
  // TARGETS
  reqTargets=XInternAtom(display,"TARGETS",0);
  
  // Clipboard
  xcbSelection=XInternAtom(display,"CLIPBOARD",0);

  // XDND protocol awareness
  xdndAware=XInternAtom(display,"XdndAware",0);
  
  // XDND Messages
  xdndEnter=XInternAtom(display,"XdndEnter",0);
  xdndLeave=XInternAtom(display,"XdndLeave",0);
  xdndPosition=XInternAtom(display,"XdndPosition",0);
  xdndStatus=XInternAtom(display,"XdndStatus",0);
  xdndDrop=XInternAtom(display,"XdndDrop",0);
  xdndFinished=XInternAtom(display,"XdndFinished",0);
  
  // XDND Selection atom
  xdndSelection=XInternAtom(display,"XdndSelection",0);

  // XDND Actions
  xdndActionCopy=XInternAtom(display,"XdndActionCopy",0);
  xdndActionMove=XInternAtom(display,"XdndActionMove",0);
  xdndActionLink=XInternAtom(display,"XdndActionLink",0);
  
  // XDND Types list
  xdndTypes=XInternAtom(display,"XdndTypeList",0);
  
  // DDE property
  ddeAtom=XInternAtom(display,"_FOX_DDE",0);
  ddeDelete=XInternAtom(display,"DELETE",0);
  
  // Init DDE stuff
  ddeData=NULL;
  ddeSize=0;
  
  // Standard stipples
  stipples[STIPPLE_0]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_0],8,8);
  stipples[STIPPLE_1]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_1],8,8);
  stipples[STIPPLE_2]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_2],8,8);
  stipples[STIPPLE_3]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_3],8,8);
  stipples[STIPPLE_4]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_4],8,8);
  stipples[STIPPLE_5]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_5],8,8);
  stipples[STIPPLE_6]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_6],8,8);
  stipples[STIPPLE_7]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_7],8,8);
  stipples[STIPPLE_8]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_8],8,8);
  stipples[STIPPLE_9]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_9],8,8);
  stipples[STIPPLE_10]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_10],8,8);
  stipples[STIPPLE_11]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_11],8,8);
  stipples[STIPPLE_12]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_12],8,8);
  stipples[STIPPLE_13]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_13],8,8);
  stipples[STIPPLE_14]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_14],8,8);
  stipples[STIPPLE_15]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_15],8,8);
  stipples[STIPPLE_16]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)stipple_patterns[STIPPLE_16],8,8);
  
  // Hatch patterns
  stipples[STIPPLE_HORZ]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)hor_bits,24,24);
  stipples[STIPPLE_VERT]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)ver_bits,24,24);
  stipples[STIPPLE_CROSS]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)cross_bits,24,24);
  stipples[STIPPLE_DIAG]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)diag_bits,16,16);
  stipples[STIPPLE_REVDIAG]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)revdiag_bits,16,16);
  stipples[STIPPLE_CROSSDIAG]=XCreateBitmapFromData(display,XDefaultRootWindow(display),(char*)crossdiag_bits,16,16);

#else

  // What's going on
  FXTRACE((100,"%s::openDisplay: opening display.\n",getClassName()));

  // TARGETS
  reqTargets=GlobalAddAtom("TARGETS");

  // XDND protocol awareness
  xdndAware=GlobalAddAtom("XdndAware");

  // XDND messages
  xdndRequest=RegisterWindowMessage("XdndRequest");
  xdndEnter=RegisterWindowMessage("XdndEnter");
  xdndLeave=RegisterWindowMessage("XdndLeave");
  xdndPosition=RegisterWindowMessage("XdndPosition");
  xdndStatus=RegisterWindowMessage("XdndStatus");
  xdndDrop=RegisterWindowMessage("XdndDrop");
  xdndFinished=RegisterWindowMessage("XdndFinished");

  // XDND Actions
  xdndActionCopy=GlobalAddAtom("XdndActionCopy");
  xdndActionMove=GlobalAddAtom("XdndActionMove");
  xdndActionLink=GlobalAddAtom("XdndActionLink");

  // DDE property
  ddeDelete=RegisterClipboardFormat("DELETE");

  // Standard stipples
  stipples[STIPPLE_0]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_0]);
  stipples[STIPPLE_1]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_1]);
  stipples[STIPPLE_2]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_2]);
  stipples[STIPPLE_3]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_3]);
  stipples[STIPPLE_4]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_4]);
  stipples[STIPPLE_5]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_5]);
  stipples[STIPPLE_6]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_6]);
  stipples[STIPPLE_7]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_7]);
  stipples[STIPPLE_8]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_8]);
  stipples[STIPPLE_9]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_9]);
  stipples[STIPPLE_10]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_10]);
  stipples[STIPPLE_11]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_11]);
  stipples[STIPPLE_12]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_12]);
  stipples[STIPPLE_13]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_13]);
  stipples[STIPPLE_14]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_14]);
  stipples[STIPPLE_15]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_15]);
  stipples[STIPPLE_16]=CreateBitmap(8,8,1,1,stipple_patterns[STIPPLE_16]);

  // Register our sole window class
  WNDCLASSEX wndclass;
  wndclass.cbSize=sizeof(WNDCLASSEX);
  wndclass.style=CS_HREDRAW|CS_VREDRAW;
  wndclass.lpfnWndProc=FXApp::wndproc;
  wndclass.cbClsExtra=0;
  wndclass.cbWndExtra=sizeof(FXWindow*);
  wndclass.hInstance=FXApp::hInstance;
  
  // Try load application icon
  wndclass.hIcon=LoadIcon(FXApp::hInstance,IDI_APPLICATION);
  
  // Failed, try again w/o instance
  if(wndclass.hIcon==NULL) wndclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
  
  // Try load small application icon
  wndclass.hIconSm=(HICON)LoadImage(FXApp::hInstance,IDI_APPLICATION,IMAGE_ICON,16,16,LR_DEFAULTCOLOR);
  
  // Failed, substitute the big icon instead
  if(wndclass.hIconSm==NULL) wndclass.hIconSm=wndclass.hIcon;
  
  // Load the stock cursor
  wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
  wndclass.hbrBackground=(HBRUSH) GetStockObject(NULL_BRUSH);
  wndclass.lpszMenuName=NULL;
  wndclass.lpszClassName="FXWindow";
  RegisterClassEx(&wndclass);

  // Drag context info is shared by all apps
  HANDLE hMap=CreateFileMapping((HANDLE)0xFFFFFFFF,NULL,PAGE_READWRITE,0,sizeof(FXDragContext),"FXDragContext");
  FXASSERT(hMap!=0);
  if(hMap){
    dragContext=(FXDragContext*)MapViewOfFile(hMap,FILE_MAP_READ|FILE_MAP_WRITE,0,0,0);
    FXASSERT(dragContext!=0);
    }

#endif
  return 1;
  }

  
// Close display
void FXApp::closeDisplay(){
#ifndef FX_NATIVE_WIN32
  if(!display) return;
  
  // Free standard stipples
  XFreePixmap(display,stipples[STIPPLE_0]);
  XFreePixmap(display,stipples[STIPPLE_1]);
  XFreePixmap(display,stipples[STIPPLE_2]);
  XFreePixmap(display,stipples[STIPPLE_3]);
  XFreePixmap(display,stipples[STIPPLE_4]);
  XFreePixmap(display,stipples[STIPPLE_5]);
  XFreePixmap(display,stipples[STIPPLE_6]);
  XFreePixmap(display,stipples[STIPPLE_7]);
  XFreePixmap(display,stipples[STIPPLE_8]);
  XFreePixmap(display,stipples[STIPPLE_9]);
  XFreePixmap(display,stipples[STIPPLE_10]);
  XFreePixmap(display,stipples[STIPPLE_11]);
  XFreePixmap(display,stipples[STIPPLE_12]);
  XFreePixmap(display,stipples[STIPPLE_13]);
  XFreePixmap(display,stipples[STIPPLE_14]);
  XFreePixmap(display,stipples[STIPPLE_15]);
  XFreePixmap(display,stipples[STIPPLE_16]);
  
  // Free hatch patterns
  XFreePixmap(display,stipples[STIPPLE_HORZ]);
  XFreePixmap(display,stipples[STIPPLE_VERT]);
  XFreePixmap(display,stipples[STIPPLE_CROSS]);
  XFreePixmap(display,stipples[STIPPLE_DIAG]);
  XFreePixmap(display,stipples[STIPPLE_REVDIAG]);
  XFreePixmap(display,stipples[STIPPLE_CROSSDIAG]);
  
  // Close display
  XCloseDisplay(display);

#else

  // Free standard stipples
  DeleteObject(stipples[STIPPLE_0]);
  DeleteObject(stipples[STIPPLE_1]);
  DeleteObject(stipples[STIPPLE_2]);
  DeleteObject(stipples[STIPPLE_3]);
  DeleteObject(stipples[STIPPLE_4]);
  DeleteObject(stipples[STIPPLE_5]);
  DeleteObject(stipples[STIPPLE_6]);
  DeleteObject(stipples[STIPPLE_7]);
  DeleteObject(stipples[STIPPLE_8]);
  DeleteObject(stipples[STIPPLE_9]);
  DeleteObject(stipples[STIPPLE_10]);
  DeleteObject(stipples[STIPPLE_11]);
  DeleteObject(stipples[STIPPLE_12]);
  DeleteObject(stipples[STIPPLE_13]);
  DeleteObject(stipples[STIPPLE_14]);
  DeleteObject(stipples[STIPPLE_15]);
  DeleteObject(stipples[STIPPLE_16]);

#endif
  }


/*******************************************************************************/

#ifndef FX_NATIVE_WIN32

// Compare times
static inline int operator<(const struct timeval& a,const struct timeval& b){
  return (a.tv_sec<b.tv_sec) || (a.tv_sec==b.tv_sec && a.tv_usec<b.tv_usec);
  }

#endif

// Add timeout, sorted by time
FXTimer* FXApp::addTimeout(FXint ms,FXObject* tgt,FXSelector sel){
  if(ms<1){ fxerror("%s::addTimeout: wait time should be greater than 0\n",getClassName()); }
  FXTimer *t;
  if(timerrecs){
    t=timerrecs;
    timerrecs=t->next;
    }
  else{
    t=new FXTimer;
    }
  t->target=tgt;
  t->message=sel;
#ifndef FX_NATIVE_WIN32
  gettimeofday(&t->due,NULL);
  t->due.tv_sec+=ms/1000;
  t->due.tv_usec+=(ms%1000)*1000;
  if(t->due.tv_usec>=1000000){
    t->due.tv_usec-=1000000;
    t->due.tv_sec+=1;
    }
  FXTimer **hh=&timers;
  FXTimer *h=*hh;
  while(h && (h->due < t->due)){
    hh=&h->next;
    h=*hh;
    }
  t->next=h;
  *hh=t;
#else
  t->id=SetTimer(NULL,0,ms,NULL);
  t->next=timers;
  timers=t;
#endif
  return t;
  }


// Remove timeout from the list
FXTimer* FXApp::removeTimeout(FXTimer *t){
  if(t){
    FXTimer *h,**hh;
    for(h=timers,hh=&timers; h!=t; hh=&h->next,h=h->next){
      if(h==NULL) return NULL;
      }
    FXASSERT(h==t);
    *hh=t->next;
    t->next=timerrecs;
    timerrecs=t;
#ifdef FX_NATIVE_WIN32
    KillTimer(NULL,t->id);
#endif
    }
  return NULL;
  }


/*******************************************************************************/


// Signal handler; note this is a single write operation 
// which can not be interrupted by another handler!
void FXApp::signalhandler(int sig){
  app->signals[sig].notified=TRUE;
  }


// This signal handler is potentially dangerous as it dispatches
// the message to the target right here in the handler; you probably
// want to use this one only in ``desparate'' situations. 
void FXApp::immediatesignalhandler(int sig){
  if(app->signals[sig].target) app->signals[sig].target->handle(app,MKUINT(app->signals[sig].message,SEL_SIGNAL),(void*)sig);
  }


// Add a signal message
void FXApp::addSignal(FXint sig,FXObject* tgt,FXSelector sel,FXbool immediate,FXuint flags){
  void (*handler)(int);
  if(sig<0 || MAXSIGNALS<sig){ fxerror("%s::addSignal: bad signal number\n",getClassName()); }

  // First signal added allocates the array
  if(nsignals==0){FXCALLOC(&signals,FXSignal,MAXSIGNALS);}

  // May have just changed the message and/or target
  signals[sig].target=tgt;
  signals[sig].message=sel;
  
  // Has handler been set?
  if(!signals[sig].handlerset){
    if(immediate) 
      handler=immediatesignalhandler; 
    else 
      handler=signalhandler;
#ifdef WIN32
    if(signal(sig,handler)==SIG_ERR){ fxwarning("%s::addSignal: error setting signal handler\n",getClassName()); }
#else
#if defined(_POSIX_SOURCE) || defined(_INCLUDE_POSIX_SOURCE)
    struct sigaction sigact;
    sigact.sa_handler=handler;
    sigemptyset(&sigact.sa_mask);
    sigact.sa_flags=flags;
    if(sigaction(sig,&sigact,NULL)!=0){ fxwarning("%s::addSignal: error setting signal handler\n",getClassName()); }
#else
    signal(sig,handler);        //////// NON-POSIX SYSTEMS NOT TESTED YET
#endif
#endif
    signals[sig].notified=FALSE;
    signals[sig].handlerset=TRUE;
    nsignals++;
    }
  }


// Remove all signal messages for signal sig
void FXApp::removeSignal(FXint sig){
  if(sig<0 || MAXSIGNALS<sig){ fxerror("%s::removeSignal: bad signal number\n",getClassName()); }

  // Has a handler been set?
  if(signals[sig].handlerset){
#ifdef WIN32
    if(signal(sig,SIG_DFL)==SIG_ERR){ fxwarning("%s::removeSignal: error removing signal handler\n",getClassName()); }
#else
#if defined(_POSIX_SOURCE) || defined(_INCLUDE_POSIX_SOURCE)
    struct sigaction sigact;
    sigact.sa_handler=SIG_DFL;
    sigemptyset(&sigact.sa_mask);
    sigact.sa_flags=0;
    if(sigaction(sig,&sigact,NULL)!=0){ fxwarning("%s::removeSignal: error removing signal handler\n",getClassName()); }
#else
    signal(sig,SIG_DFL);      //////// NON-POSIX SYSTEMS NOT TESTED YET
#endif
#endif
    signals[sig].target=NULL;
    signals[sig].message=0;
    signals[sig].handlerset=FALSE;
    signals[sig].notified=FALSE;
    nsignals--;
    
    // Last signal removed deletes the array
    if(nsignals==0){FXFREE(&signals);}
    }
  }


/*******************************************************************************/


// Add chore to the END of the list
FXChore* FXApp::addChore(FXObject* tgt,FXSelector sel){
  register FXChore *c,**cc;
  if(chorerecs){
    c=chorerecs;
    chorerecs=c->next;
    }
  else{
    c=new FXChore;
    }
  for(cc=&chores; *cc; cc=&(*cc)->next);
  c->target=tgt;
  c->message=sel;
  c->next=NULL;
  *cc=c;
  return c;
  }


// Remove chore from the list
FXChore* FXApp::removeChore(FXChore *c){
  register FXChore *h,**hh;
  if(c){
    for(h=chores,hh=&chores; h!=c; hh=&h->next,h=h->next){
      if(h==NULL) return NULL;
      }
    FXASSERT(h==c);
    *hh=c->next;
    c->next=chorerecs;
    chorerecs=c;
    }
  return NULL;
  }


/*******************************************************************************/

#ifndef FX_NATIVE_WIN32

// Add input
void FXApp::addInput(FXint fd,FXuint mode,FXObject *tgt,FXSelector sel){
  if(fd<0 || mode==INPUT_NONE) return;
  if(fd>=FD_SETSIZE){ fxerror("%s::addInput: illegal file descriptor.\n",getClassName()); }
  if(fd>=ninputs){
    FXRESIZE(&inputs,FXInput,fd+1);
    memset(&inputs[ninputs],0,sizeof(FXInput)*(fd+1-ninputs));
    ninputs=fd+1;
    }
  FXASSERT(inputs);
  FXASSERT(fd<ninputs);
  if(mode&INPUT_READ){
    inputs[fd].read.target=tgt;
    inputs[fd].read.message=sel;
    FD_SET(fd,(fd_set*)r_fds);
    }
  if(mode&INPUT_WRITE){
    inputs[fd].write.target=tgt;
    inputs[fd].write.message=sel;
    FD_SET(fd,(fd_set*)w_fds);
    }
  if(mode&INPUT_EXCEPT){
    inputs[fd].excpt.target=tgt;
    inputs[fd].excpt.message=sel;
    FD_SET(fd,(fd_set*)e_fds);
    }
  if(fd>maxinput) maxinput=fd;
  }


// Remove input
void FXApp::removeInput(FXint fd,FXuint mode){
  if(fd<0 || mode==INPUT_NONE) return;
  if(fd>maxinput){ fxerror("%s::removeInput: illegal file descriptor.\n",getClassName()); }
  if(mode&INPUT_READ){
    inputs[fd].read.target=NULL;
    inputs[fd].read.message=0;
    FD_CLR(fd,(fd_set*)r_fds);
    }
  if(mode&INPUT_WRITE){
    inputs[fd].write.target=NULL;
    inputs[fd].write.message=0;
    FD_CLR(fd,(fd_set*)w_fds);
    }
  if(mode&INPUT_EXCEPT){
    inputs[fd].excpt.target=NULL;
    inputs[fd].excpt.message=0;
    FD_CLR(fd,(fd_set*)e_fds);
    }
  while(0<=maxinput){
    if(inputs[maxinput].read.target || inputs[maxinput].write.target || inputs[maxinput].excpt.target) break;
    maxinput--;
    }
  }

#endif

/*******************************************************************************/


// Add a repaint rectangle
#ifndef FX_NATIVE_WIN32


// Smart rectangle compositing algorithm
void FXApp::addRepaint(FXID win,FXint x,FXint y,FXint w,FXint h,FXbool synth){
  register FXint px,py,pw,ph,hint,area;
  register FXRepaint *r,**pr;
  hint=w*h;
  w+=x;
  h+=y;
  do{
    
    // Find overlap with outstanding rectangles
    for(r=repaints,pr=&repaints; r; pr=&r->next,r=r->next){
      if(r->window==win){

        // Tentatively conglomerate rectangles
        px=FXMIN(x,r->rect.x);
        py=FXMIN(y,r->rect.y);
        pw=FXMAX(w,r->rect.w);
        ph=FXMAX(h,r->rect.h);
        area=(pw-px)*(ph-py);

        // New area MUCH bigger than sum; forget about it
        if(area > (hint+r->hint)*2) continue;

        // Take old paintrect out of the list
        *pr=r->next; 
        r->next=repaintrecs; 
        repaintrecs=r;
        
        // New rectangle
        synth|=r->synth;        // Synthethic is preserved!
        hint=area;
        x=px; 
        y=py; 
        w=pw; 
        h=ph; 
        break;
        }
      }
    }
  while(r);
  
  // Get rectangle, recycled if possible
  if(repaintrecs){
    r=repaintrecs;
    repaintrecs=r->next;
    }
  else{
    r=new FXRepaint;
    }
  
  // Fill it
  r->window=win;
  r->rect.x=x;
  r->rect.y=y;
  r->rect.w=w;
  r->rect.h=h;
  r->hint=hint;
  r->synth=synth;
  r->next=NULL;
  *pr=r;
  }


#endif


/*******************************************************************************/


#ifndef FX_NATIVE_WIN32

// Get an event
FXbool FXApp::getNextEvent(FXRawEvent& ev,FXbool blocking){
  struct timeval now,delta;
  fd_set readfds;
  fd_set writefds;
  fd_set exceptfds;
  int maxfds;
  int nfds;
  int fff;
  int sig;
  
  while(1){
    while(1){

      // Handle all currently outstanding timers.
      // This can NOT loop forever, as newly scheduled timers
      // will be scheduled LATER than the current time!
      gettimeofday(&now,NULL);
      while(timers){
        FXTimer* t=timers;
        if(now < t->due) break;
        timers=t->next;
        
        // Call the timeout handler
        if(t->target && t->target->handle(this,MKUINT(t->message,SEL_TIMEOUT),&event)) refresh();
        
        // Add record to list of recycled timer records
        t->next=timerrecs;
      
        timerrecs=t;
        }

      // Check for pending signals and call corresponding handlers
      if(nsignals){
        for(sig=0; sig<MAXSIGNALS; sig++){
          if(signals[sig].notified){
            signals[sig].notified=FALSE;
            if(signals[sig].target && signals[sig].target->handle(this,MKUINT(signals[sig].message,SEL_SIGNAL),(void*)sig)) refresh();
            }
          }
        }

      // Any events already received? 
      if(XEventsQueued(display,QueuedAfterFlush)) break;

      // Prepare fd's to watch
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(ConnectionNumber(display),&readfds);

      // Add other inputs...
      maxfds=ConnectionNumber(display);

      delta.tv_usec=0;
      delta.tv_sec=0;

      // Do a quick poll for any ready events (and ONLY event!)
      nfds=SELECT(maxfds+1,&readfds,&writefds,&exceptfds,&delta);

      // No events, do idle processing
      if(nfds==0){

        // Release the expose events...
        if(repaints){
          register FXRepaint *r=repaints;
          ev.xany.type=Expose;
          ev.xexpose.window=r->window;
          ev.xexpose.send_event=r->synth;
          ev.xexpose.x=r->rect.x;
          ev.xexpose.y=r->rect.y;
          ev.xexpose.width=r->rect.w-r->rect.x;
          ev.xexpose.height=r->rect.h-r->rect.y;
          repaints=r->next;
          r->next=repaintrecs;
          repaintrecs=r;
          return TRUE;
          }

        // GUI updating:- walk the whole widget tree.
        if(refresher){

          // Call the refresher handler
          refresher->handle(this,MKUINT(0,SEL_UPDATE),NULL);

          // Next widget to refresh
          if(refresher->getFirst()){
            refresher=refresher->getFirst();
            continue;
            }
          while(!refresher->getNext() && refresher->getParent()!=root){
            refresher=refresher->getParent();
            }
          refresher=refresher->getNext();
          continue;
          }
                  
        // Do our chores :-)
        if(chores){
          register FXChore* c=chores;
          chores=c->next;
          
          // Call the chore handler
          if(c->target && c->target->handle(this,MKUINT(c->message,SEL_CHORE),&event)) refresh();
          
          // Add record to list of recycled chore records
          c->next=chorerecs;
          chorerecs=c;
          continue;
          }

        // We're not blocking
        if(!blocking) return FALSE;

        // Now, block till timeout, i/o, or event
        readfds=*((fd_set*)r_fds);
        writefds=*((fd_set*)w_fds);
        exceptfds=*((fd_set*)e_fds);
        FD_SET(ConnectionNumber(display),&readfds);

        // Add other inputs...
        maxfds=FXMAX(maxinput,ConnectionNumber(display));

        // If there are timers, we block only for a little while.
        if(timers){

          // All that testing above may have taken some time...
          gettimeofday(&now,NULL);

          // Compute how long to wait
          delta.tv_usec=timers->due.tv_usec-now.tv_usec;
          delta.tv_sec=timers->due.tv_sec-now.tv_sec;
          while(delta.tv_usec<0){
            delta.tv_usec+=1000000;
            delta.tv_sec-=1;
            }
          FXASSERT(0<=delta.tv_usec && delta.tv_usec<1000000);

          // Some timers are already due; do them right away!
          if(delta.tv_sec<0 || (delta.tv_sec==0 && delta.tv_usec==0)) continue;

          // Block till timer or event or interrupt
          nfds=SELECT(maxfds+1,&readfds,&writefds,&exceptfds,&delta);

          // Timed out, so handle those timeouts
          if(nfds==0) continue;
          }

        // If no timers, we block till event or interrupt
        else{
          nfds=SELECT(maxfds+1,&readfds,&writefds,&exceptfds,NULL);
          }
        }

      // Interrupt
      if(nfds<0 && errno!=EAGAIN && errno!=EINTR){
        fxerror("Application terminated: interrupt or lost connection errno=%d\n",errno);
        }
      
      // Check for pending signals and call corresponding handlers
      if(nsignals){
        for(sig=0; sig<MAXSIGNALS; sig++){
          if(signals[sig].notified){
            signals[sig].notified=FALSE;
            if(signals[sig].target && signals[sig].target->handle(this,MKUINT(signals[sig].message,SEL_SIGNAL),(void*)sig)) refresh();
            }
          }
        }

      // Try I/O channels 
      if(nfds>1 || !FD_ISSET(ConnectionNumber(display),&readfds)){
        FXTRACE((100,"Other active FDs: "));
        for(fff=0; fff<=maxinput; fff++){
          if(fff==ConnectionNumber(display)) continue;
          if(FD_ISSET(fff,&readfds)){
            FXTRACE((100,"R%d ",fff));
            if(inputs[fff].read.target && inputs[fff].read.target->handle(this,MKUINT(inputs[fff].read.message,SEL_IO_READ),(void*)fff)){
              refresh();
              }
            }
          if(FD_ISSET(fff,&writefds)){
            FXTRACE((100,"W%d ",fff));
            if(inputs[fff].write.target && inputs[fff].write.target->handle(this,MKUINT(inputs[fff].write.message,SEL_IO_WRITE),(void*)fff)){
              refresh();
              }
            }
          if(FD_ISSET(fff,&exceptfds)){
            FXTRACE((100,"E%d ",fff));
            if(inputs[fff].excpt.target && inputs[fff].excpt.target->handle(this,MKUINT(inputs[fff].read.message,SEL_IO_EXCEPT),(void*)fff)){
              refresh();
              }
            }
          }
        FXTRACE((100,"\n"));
        }

      // Got event
      if(nfds>1 && FD_ISSET(ConnectionNumber(display),&readfds)){
        if(XEventsQueued(display,QueuedAfterReading)) break;
        }
      }
    
    // Get an event
    XNextEvent(display,&ev);

    // Save expose events for later...
    if(ev.xany.type==Expose || ev.xany.type==GraphicsExpose){
      addRepaint(ev.xexpose.window,ev.xexpose.x,ev.xexpose.y,ev.xexpose.width,ev.xexpose.height,0);
      continue;
      }

    // Compress motion events
    if(ev.xany.type==MotionNotify){
      while(XPending(display)){
        XEvent e;
        XPeekEvent(display,&e);
        if((e.xany.type!=MotionNotify) || (ev.xmotion.window!=e.xmotion.window) || (ev.xmotion.subwindow!=e.xmotion.subwindow)) break;
        XNextEvent(display,&ev);
        }
      }

    // Regular event
    return TRUE;
    }

  return FALSE;
  }


/*******************************************************************************/


// Peek for event
FXbool FXApp::peekEvent(){
  struct timeval delta;
  fd_set readfds;
  fd_set writefds;
  fd_set exceptfds;
  int maxfds;
  int nfds;
  
  // Events queued up in client already (Shouldn't this not be QueuedAlready?)
  if(XEventsQueued(display,QueuedAfterFlush)) return TRUE;

  // Prepare fd's to watch
  FD_ZERO(&readfds);
  FD_ZERO(&writefds);
  FD_ZERO(&exceptfds);
  FD_SET(ConnectionNumber(display),&readfds);

  // Add other inputs...
  maxfds=ConnectionNumber(display);

  delta.tv_usec=0;
  delta.tv_sec=0;

  // Do a quick poll for any ready events
  nfds=SELECT(maxfds+1,&readfds,&writefds,&exceptfds,&delta);

  // Interrupt
  if(nfds<0 && errno!=EAGAIN && errno!=EINTR){
    fxerror("Application terminated: interrupt or lost connection errno=%d\n",errno);
    }

  // I/O activity
  if((nfds>0) && FD_ISSET(ConnectionNumber(display),&readfds)){
    if(XEventsQueued(display,QueuedAfterReading)) return TRUE;
    }
  
  // No events
  return FALSE;
  }


/*******************************************************************************/

// Dispatch event to widget
void FXApp::dispatchEvent(FXRawEvent& ev){
  FXWindow *window;
  FXuint    ks1,ks2;
  Window    tmp;
  XEvent    se;
  if(XFindContext(display,ev.xany.window,wcontext,(XPointer*)&window)==0){
    FXASSERT(window);
    
    // Translate it
    switch(ev.xany.type){

      // Composite expose events into rectangle
      case GraphicsExpose:
      case Expose:
        event.type=SEL_PAINT;
        event.window=ev.xexpose.window;
        event.rect.x=ev.xexpose.x;
        event.rect.y=ev.xexpose.y;
        event.rect.w=ev.xexpose.width;
        event.rect.h=ev.xexpose.height;
        event.synthetic=ev.xexpose.send_event;
        window->handle(this,MKUINT(0,SEL_PAINT),&event);

      // Not interested in this event
      case NoExpose:
        break;

      // Keyboard
      case KeyPress:
      case KeyRelease:
        event.type=SEL_KEYPRESS+ev.xkey.type-KeyPress;
        event.window=ev.xkey.window;
        event.time=ev.xkey.time;
        event.win_x=ev.xkey.x;
        event.win_y=ev.xkey.y;
        event.root_x=ev.xkey.x_root;
        event.root_y=ev.xkey.y_root;
        event.state=ev.xkey.state;
        ks1=XLookupKeysym(&ev.xkey,0);
        ks2=XLookupKeysym(&ev.xkey,1);
        if((event.state&NUMLOCKMASK) && (KEY_KP_Space<=ks2) && (ks2<=KEY_KP_Equal)){
          if(event.state&SHIFTMASK) event.code=ks1; else event.code=ks2;
          }
        else if((KEY_a<=ks1) && (ks1<=KEY_z)){            // Alpha shifted and/or caplocked
          if(((event.state&CAPSLOCKMASK)!=0) ^ ((event.state&SHIFTMASK)!=0)) event.code=ks2; else event.code=ks1;
          }
        else if((event.state&SHIFTMASK) && (ks2!=0)){     // Simple shifted
          event.code=ks2;
          }
        else{                                             // Unshifted
          event.code=ks1;
          }
// {char buf[20]; KeySym sym; static XComposeStatus cs;
// XLookupString(&ev.xkey,buf,20,&sym,&cs);
// FXTRACE((10,"KEY: keysym=0x%04x state=%04x ks1=%x ks2=%x sym=%x\n",event.code,event.state,ks1,ks2,sym));
// }
        if(ev.xkey.type==KeyPress){
          keyWindow=focusWindow;
          if(!event.moved && (event.time-event.click_time<clickSpeed) && (event.window==event.click_window) && (event.code==event.click_button)){
            event.click_count++;
            event.click_time=event.time;
            }
          else{
            event.click_count=1;
            event.click_x=event.win_x;
            event.click_y=event.win_y;
            event.click_window=event.window;
            event.click_button=event.code;
            event.click_time=event.time;
            }
          if(!(event.state&(LEFTBUTTONMASK|MIDDLEBUTTONMASK|RIGHTBUTTONMASK))) event.moved=0;
          }
        if(keyWindow){
          if(keyWindow->passModalEvents()){
            keyWindow->handle(this,MKUINT(0,event.type),&event); 
            refresh();
            }
          else if(ev.xany.type==KeyPress){
            beep();
            }
          }
        event.last_x=event.win_x;
        event.last_y=event.win_y;
        break;
        
      // Motion
      case MotionNotify:
        event.type=SEL_MOTION;
        event.window=ev.xmotion.window;
        event.time=ev.xmotion.time;
        event.win_x=ev.xmotion.x;
        event.win_y=ev.xmotion.y;
        event.root_x=ev.xmotion.x_root;
        event.root_y=ev.xmotion.y_root;
        event.code=0;
        event.state=ev.xmotion.state;
        if(!event.moved && (FXABS(ev.xmotion.x-event.click_x)>=dragDelta || FXABS(ev.xmotion.y-event.click_y)>=dragDelta)){
          event.moved=1;
          }
        if(grabWindow){
          if(grabWindow->handle(this,MKUINT(0,event.type),&event)) refresh();
          }
        else if(window->passModalEvents()){
          if(window->handle(this,MKUINT(0,SEL_MOTION),&event)) refresh();
          }
        event.last_x=event.win_x;
        event.last_y=event.win_y;
        break;
        
      // Button
      case ButtonPress:
      case ButtonRelease:
        event.window=ev.xbutton.window;
        event.time=ev.xbutton.time;
        event.win_x=ev.xbutton.x;
        event.win_y=ev.xbutton.y;
        event.root_x=ev.xbutton.x_root;
        event.root_y=ev.xbutton.y_root;
        event.code=ev.xbutton.button;
        event.state=ev.xbutton.state;
        if(ev.xbutton.type==ButtonPress){
          event.type=SEL_LEFTBUTTONPRESS+((ev.xbutton.button-1)<<1);
          if(!event.moved && (event.time-event.click_time<clickSpeed) && (event.window==event.click_window) && (event.code==event.click_button)){
            event.click_count++;
            event.click_time=event.time;
            }
          else{
            event.click_count=1;
            event.click_x=event.win_x;
            event.click_y=event.win_y;
            event.click_window=event.window;
            event.click_button=event.code;
            event.click_time=event.time;
            }
          if(!(event.state&(LEFTBUTTONMASK|MIDDLEBUTTONMASK|RIGHTBUTTONMASK))) event.moved=0;
          }
        else if(ev.xbutton.type==ButtonRelease){
          event.type=SEL_LEFTBUTTONRELEASE+((ev.xbutton.button-1)<<1);
          }
        if(grabWindow){
          if(grabWindow->handle(this,MKUINT(0,event.type),&event)) refresh();
          }
        else if(window->passModalEvents()){
          if(window->handle(this,MKUINT(0,event.type),&event)) refresh();
          }
        else if(ev.xany.type==ButtonPress){
          beep();
          }
        event.last_x=event.win_x;
        event.last_y=event.win_y;
        break;

      // Crossing
      case EnterNotify:
      case LeaveNotify:
        if(ev.xcrossing.mode==NotifyGrab || ev.xcrossing.mode==NotifyUngrab || (ev.xcrossing.mode==NotifyNormal && ev.xcrossing.detail!=NotifyInferior)){
          event.type=SEL_ENTER+ev.xany.type-EnterNotify;
          event.time=ev.xcrossing.time;
          event.win_x=ev.xcrossing.x;
          event.win_y=ev.xcrossing.y;
          event.root_x=ev.xcrossing.x_root;
          event.root_y=ev.xcrossing.y_root;
          event.window=ev.xcrossing.window;
          event.code=ev.xcrossing.mode;
          if(window->handle(this,MKUINT(0,event.type),&event)) refresh();
          event.last_x=event.win_x;
          event.last_y=event.win_y;
          }
        break;

      // Focus change on shell window
      case FocusIn:
      case FocusOut:
        window=window->getShell();
        if(ev.xfocus.type==FocusIn){
          if(focusWindow!=window){
            event.type=SEL_FOCUSIN;
            event.window=ev.xfocus.window;
            if(window->handle(this,MKUINT(0,SEL_FOCUSIN),&event)) refresh();
            focusWindow=window;
            }
          }
        else{
          if(focusWindow){
            event.type=SEL_FOCUSOUT;
            event.window=ev.xfocus.window;
            if(focusWindow->handle(this,MKUINT(0,SEL_FOCUSOUT),&event)) refresh();
            focusWindow=NULL;
            }
          }
        break;

      // Map
      case MapNotify:
        event.type=SEL_MAP;
        event.window=ev.xmap.window;
        if(window->handle(this,MKUINT(0,SEL_MAP),&event)) refresh();
        break;

      // Unmap
      case UnmapNotify:
        event.type=SEL_UNMAP;
        event.window=ev.xunmap.window;
        if(window->handle(this,MKUINT(0,SEL_UNMAP),&event)) refresh();
        break;

      // Create
      case CreateNotify:
        event.type=SEL_CREATE;
        event.window=ev.xcreatewindow.window;
        event.rect.x=ev.xcreatewindow.x;
        event.rect.y=ev.xcreatewindow.y;
        event.rect.w=ev.xcreatewindow.width;
        event.rect.h=ev.xcreatewindow.height;
        if(window->handle(this,MKUINT(0,SEL_CREATE),&event)) refresh();
        break;

      // Destroy
      case DestroyNotify:
        event.type=SEL_DESTROY;
        event.window=ev.xdestroywindow.window;
        if(window->handle(this,MKUINT(0,SEL_DESTROY),&event)) refresh();
        break;

      // Configure
      case ConfigureNotify:
        event.type=SEL_CONFIGURE;
        event.window=ev.xconfigure.window;

        // The x,y in the original event record are not always root-relative
        //XTranslateCoordinates(display,ev.xconfigure.window,XDefaultRootWindow(display),0,0,&ev.xconfigure.x,&ev.xconfigure.y,&tmp); 

        // According to the ICCCM, if its synthetic, the coordinates are relative
        // to root window; otherwise, they're relative to the parent; so we use
        // the old coordinates if its not a synthetic configure notify
        if(!ev.xconfigure.send_event){
          ev.xconfigure.x=window->getX();
          ev.xconfigure.y=window->getY();
          }

//         FXTRACE((1,"ev.xconfigure.window=%s\n",window->getClassName()));
//         FXTRACE((1,"ev.xconfigure.send_event=%d\n",ev.xconfigure.send_event));
//         FXTRACE((1,"ev.xconfigure.x=%d\n",ev.xconfigure.x));
//         FXTRACE((1,"ev.xconfigure.y=%d\n",ev.xconfigure.y));
//         FXTRACE((1,"ev.xconfigure.width=%d\n",ev.xconfigure.width));
//         FXTRACE((1,"ev.xconfigure.height=%d\n\n",ev.xconfigure.height));

        event.rect.x=ev.xconfigure.x;
        event.rect.y=ev.xconfigure.y;
        event.rect.w=ev.xconfigure.width;
        event.rect.h=ev.xconfigure.height;
        event.synthetic=ev.xconfigure.send_event;
        if(window->handle(this,MKUINT(0,SEL_CONFIGURE),&event)) refresh();
        break;

      // Circulate 
      case CirculateNotify:
        event.type=SEL_RAISED+(ev.xcirculate.place&1);
        event.window=ev.xcirculate.window;
        if(window->handle(this,MKUINT(0,event.type),&event)) refresh();
        break;

      // Selection Clear
      case SelectionClear:
        event.window=ev.xselectionclear.window;
        event.time=ev.xselectionclear.time;
        if(ev.xselectionclear.selection==XA_PRIMARY){
          if(selectionWindow){
            event.type=SEL_SELECTION_LOST;
            if(selectionWindow->handle(this,MKUINT(0,SEL_SELECTION_LOST),&event)) refresh();
            FXFREE(&xselTypeList);
            xselNumTypes=0;
            selectionWindow=NULL;
            }
          }
        else if(ev.xselectionclear.selection==xcbSelection){
          if(clipboardWindow){
            event.type=SEL_CLIPBOARD_LOST;
            if(clipboardWindow->handle(this,MKUINT(0,SEL_CLIPBOARD_LOST),&event)) refresh();
            FXFREE(&xcbTypeList);
            xcbNumTypes=0;
            clipboardWindow=NULL;
            }
          }
        break;

      // Selection Request
      case SelectionRequest:
        event.window=ev.xselectionrequest.owner;
        event.time=ev.xselectionrequest.time;
        event.requestor=ev.xselectionrequest.requestor;
        event.property=ev.xselectionrequest.property;
        event.target=ev.xselectionrequest.target;
        if(ev.xselectionrequest.target==reqTargets){            // Request for TYPES
          event.property=None;
          if(ev.xselectionrequest.selection==XA_PRIMARY){
            FXTRACE((100,"Window %d being requested by window %d for SELECTION TYPES\n",ev.xselectionrequest.owner,ev.xselectionrequest.requestor));
            if(xselTypeList && xselNumTypes>0){   
              XChangeProperty(display,ev.xselectionrequest.requestor,ev.xselectionrequest.property,XA_ATOM,32,PropModeReplace,(unsigned char*)xselTypeList,xselNumTypes);
              event.property=ev.xselectionrequest.property;
              }
            }
          else if(ev.xselectionrequest.selection==xcbSelection){
            FXTRACE((100,"Window %d being requested by window %d for CLIPBOARD TYPES\n",ev.xselectionrequest.owner,ev.xselectionrequest.requestor));
            if(xcbTypeList && xcbNumTypes>0){   
              XChangeProperty(display,ev.xselectionrequest.requestor,ev.xselectionrequest.property,XA_ATOM,32,PropModeReplace,(unsigned char*)xcbTypeList,xcbNumTypes);
              event.property=ev.xselectionrequest.property;
              }
            }
          else if(ev.xselectionrequest.selection==xdndSelection){
            FXTRACE((100,"Window %d being requested by window %d for XDND TYPES\n",ev.xselectionrequest.owner,ev.xselectionrequest.requestor));
            if(xdndTypeList && xdndNumTypes>0){   
              XChangeProperty(display,ev.xselectionrequest.requestor,ev.xselectionrequest.property,XA_ATOM,32,PropModeReplace,(unsigned char*)xdndTypeList,xdndNumTypes);
              event.property=ev.xselectionrequest.property;
              }
            }
          }
        else{                                                   // Request for DATA
          if(ev.xselectionrequest.selection==XA_PRIMARY){
            FXTRACE((100,"Window %d being requested by window %d for SELECTION DATA of type %d\n",ev.xselectionrequest.owner,ev.xselectionrequest.requestor,ev.xselectionrequest.target));
            event.type=SEL_SELECTION_REQUEST;
            event.origin=FROM_SELECTION;
            if(window->handle(this,MKUINT(0,SEL_SELECTION_REQUEST),&event)) refresh();
            // Perhaps we should put the tail-end of setDNDData here...
            }
          else if(ev.xselectionrequest.selection==xcbSelection){
            FXTRACE((100,"Window %d being requested by window %d for CLIPBOARD DATA of type %d\n",ev.xselectionrequest.owner,ev.xselectionrequest.requestor,ev.xselectionrequest.target));
            event.type=SEL_CLIPBOARD_REQUEST;
            event.origin=FROM_CLIPBOARD;
            if(window->handle(this,MKUINT(0,SEL_CLIPBOARD_REQUEST),&event)) refresh();
            }
          else if(ev.xselectionrequest.selection==xdndSelection){
            FXTRACE((100,"Window %d being requested by window %d for XDND DATA of type %d\n",ev.xselectionrequest.owner,ev.xselectionrequest.requestor,ev.xselectionrequest.target));
            event.type=SEL_DND_REQUEST;
            event.origin=FROM_DRAGNDROP;
            if(window->handle(this,MKUINT(0,SEL_DND_REQUEST),&event)) refresh();
            }
          }
        se.xselection.type=SelectionNotify;
        se.xselection.property=event.property;                  // May be None
        se.xselection.send_event=TRUE;
        se.xselection.display=display;
        se.xselection.requestor=ev.xselectionrequest.requestor;
        se.xselection.selection=ev.xselectionrequest.selection;
        se.xselection.target=ev.xselectionrequest.target;
        se.xselection.time=event.time;
        XSendEvent(display,ev.xselectionrequest.requestor,True,NoEventMask,&se);
        break;

      // Keyboard mapping
      case MappingNotify:
        if(ev.xmapping.request!=MappingPointer) XRefreshKeyboardMapping(&ev.xmapping);
        break;

      // Client message
      case ClientMessage:
        if(ev.xclient.format==32){
        
          // WM_PROTOCOLS
          if(ev.xclient.message_type==wmProtocols){
            if((FXID)ev.xclient.data.l[0]==wmDeleteWindow){
              event.type=SEL_CLOSE;
              event.window=ev.xclient.window;
              window->handle(this,MKUINT(0,SEL_CLOSE),&event);
              }
            else if((FXID)ev.xclient.data.l[0]==wmQuitApp){
              event.type=SEL_CLOSE;
              event.window=ev.xclient.window;
              window->handle(this,MKUINT(0,SEL_CLOSE),&event);
              }
            }
          
          // XDND Enter from source
          else if(ev.xclient.message_type==xdndEnter){
            FXTRACE((100,"DNDEnter from remote\n"));
            event.type=SEL_DND_ENTER;
            event.window=ev.xclient.window;
            xdndTarget=ev.xclient.window;                             // Target of the message
            xdndSource=ev.xclient.data.l[0];                          // Source window
            xdndVersion=((FXuint)ev.xclient.data.l[1])>>24;           // Protocol version
            if(ev.xclient.data.l[1]&1){                               // More than 3 types
              unsigned long ni,b; int fmt; Atom typ;
              unsigned char* data=NULL;
              if(XGetWindowProperty(display,xdndSource,xdndTypes,0,1024,False,XA_ATOM,&typ,&fmt,&ni,&b,&data)!=Success) return;
              if(!data) return;
              if(typ!=XA_ATOM || fmt!=32 || ni==0){ XFree(data); return; }
              xdndTypeList=(FXID*)data;
              xdndNumTypes=ni;
              }
            else{                                                     // If types if less than 3
              xdndTypeList=(FXID*)malloc(3*sizeof(FXID));
              xdndNumTypes=0;
              if(ev.xclient.data.l[2]){xdndTypeList[0]=ev.xclient.data.l[2];xdndNumTypes++;}
              if(ev.xclient.data.l[3]){xdndTypeList[1]=ev.xclient.data.l[3];xdndNumTypes++;}
              if(ev.xclient.data.l[4]){xdndTypeList[2]=ev.xclient.data.l[4];xdndNumTypes++;}
              }
            if(window->handle(this,MKUINT(0,SEL_DND_ENTER),&event)) refresh();
            }
          
          // XDND Leave from source
          else if(ev.xclient.message_type==xdndLeave){
            FXTRACE((100,"DNDLeave from remote\n"));
            event.type=SEL_DND_LEAVE;
            event.window=ev.xclient.window;
            xdndTarget=ev.xclient.window;
            xdndSource=ev.xclient.data.l[0];                          // Source window
            if(window->handle(this,MKUINT(0,SEL_DND_LEAVE),&event)) refresh();
            if(xdndTypeList) XFree(xdndTypeList);
            xdndTypeList=NULL;
            xdndNumTypes=0;
            xdndVersion=XDND_PROTOCOL_VERSION;                        // Done, restore stuff
            xdndTarget=0;
            xdndSource=0;
            }
          
          // XDND Drop from source
          else if(ev.xclient.message_type==xdndDrop){
            FXTRACE((100,"DNDDrop from remote\n"));
            event.type=SEL_DND_DROP;
            event.window=ev.xclient.window;
            xdndTarget=ev.xclient.window;
            xdndSource=ev.xclient.data.l[0];                          // Source window
            event.time=ev.xclient.data.l[2];
            if(window->handle(this,MKUINT(0,SEL_DND_DROP),&event)) refresh();
            se.xclient.type=ClientMessage;                            // Drop window has finished processing of the drop
            se.xclient.display=display;
            se.xclient.message_type=xdndFinished;
            se.xclient.format=32;
            se.xclient.window=xdndSource;
            se.xclient.data.l[0]=xdndTarget;                          // Target window, i.e. me!
            se.xclient.data.l[1]=0;
            se.xclient.data.l[2]=0;
            se.xclient.data.l[3]=0;
            se.xclient.data.l[4]=0;
            XSendEvent(display,xdndSource,True,NoEventMask,&se);
            if(xdndTypeList) XFree(xdndTypeList);
            xdndTypeList=NULL;
            xdndNumTypes=0;
            xdndVersion=XDND_PROTOCOL_VERSION;
            xdndTarget=0;
            xdndSource=0;
            }
          
          // XDND Position from source
          else if(ev.xclient.message_type==xdndPosition){
            FXTRACE((100,"DNDPosition from remote\n"));
            event.type=SEL_DND_MOTION;
            event.window=ev.xclient.window;
            xdndTarget=ev.xclient.window;
            xdndSource=ev.xclient.data.l[0];                          // Source window
            event.root_x=((FXuint)ev.xclient.data.l[2])>>16;
            event.root_y=((FXuint)ev.xclient.data.l[2])&0xffff;
            event.time=ev.xclient.data.l[3];
            xdndAction=ev.xclient.data.l[4];                          // Drag and Drop Action
            xdndAccepts=FALSE;                                        // If message is not handled, we assume no drop!
            XTranslateCoordinates(display,XDefaultRootWindow(display),event.window,event.root_x,event.root_y,&event.win_x,&event.win_y,&tmp);
            if(window->handle(this,MKUINT(0,SEL_DND_MOTION),&event)) refresh();
            event.last_x=event.win_x;
            event.last_y=event.win_y;
            se.xclient.type=ClientMessage;
            se.xclient.display=display;
            se.xclient.message_type=xdndStatus;
            se.xclient.format=32;
            se.xclient.window=xdndSource;
            se.xclient.data.l[0]=xdndTarget;                          // Target window, i.e. me!
            se.xclient.data.l[1]=0;
            if(xdndAccepts) se.xclient.data.l[1]|=1;                  // Target accepted
            if(xdndWantUpdates) se.xclient.data.l[1]|=2;              // Target wants continuous position updates
            se.xclient.data.l[2]=MKUINT(xdndRect.y,xdndRect.x);
            se.xclient.data.l[3]=MKUINT(xdndRect.h,xdndRect.w);
            se.xclient.data.l[4]=xdndAction;                          // Type of Drag and Drop Action accepted
            XSendEvent(display,xdndSource,True,NoEventMask,&se);
            }
          
          // XDND Status from target
          else if(ev.xclient.message_type==xdndStatus){
            FXTRACE((100,"DNDStatus from %s remote\n",xdndTarget==ev.xclient.data.l[0] ? "active" : "old"));

            // Ignore status messages which are (no longer) applicable
            if(xdndTarget==(FXID)ev.xclient.data.l[0]){
              xdndAccepts=ev.xclient.data.l[1]&1;
              xdndAction=ev.xclient.data.l[4];                        // Drag and Drop Action
              xdndWantUpdates=(ev.xclient.data.l[1]&2)!=0;
              xdndRect.x=((FXuint)ev.xclient.data.l[2])>>16;
              xdndRect.y=((FXuint)ev.xclient.data.l[2])&0xffff;
              xdndRect.w=((FXuint)ev.xclient.data.l[3])>>16;
              xdndRect.h=((FXuint)ev.xclient.data.l[3])&0xffff;
              xdndStatusReceived=TRUE;
              xdndStatusPending=FALSE;
              if(xdndSendPosition){                                   // Long overdue position update must now be sent
                se.xclient.type=ClientMessage;
                se.xclient.display=display;
                se.xclient.message_type=xdndPosition;
                se.xclient.format=32;
                se.xclient.window=xdndTarget;
                se.xclient.data.l[0]=xdndSource;                      // Source window
                se.xclient.data.l[1]=0;
                se.xclient.data.l[2]=MKUINT(xdndYPos,xdndXPos);       // Coordinates
                se.xclient.data.l[3]=event.time;                      // Time stamp
                se.xclient.data.l[4]=xdndAction;                      // Drag and Drop action
                XSendEvent(display,xdndTarget,True,NoEventMask,&se);
                xdndSendPosition=FALSE;
                xdndStatusPending=TRUE;                               // We're now waiting for the next status message!
                }
              }
            }
          }
        break;

      // Others
      default:
        break;
      }
    }
  }


#else


// Get an event
FXbool FXApp::getNextEvent(FXRawEvent& msg,FXbool blocking){
  while(TRUE){

    // Calls to PeekMessage() will mark the message queue "clean",
    // even if you pass in the PM_NOREMOVE flag. This can in turn
    // cause the call to MsgWaitForMultipleObjects() to fail, even if
    // there are still some messages stacked up. The solution for now
    // (as suggested by Dustin Graves) is to call both MsgWaitForMultipleObjects()
    // and PeekMessage() before doing GUI update or chores.
    while(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)==0 &&
      MsgWaitForMultipleObjects(0,NULL,FALSE,0,QS_ALLEVENTS)==WAIT_TIMEOUT){
    
      // GUI updating
      if(refresher){
      
        // Call the refresher handler
        refresher->handle(this,MKUINT(0,SEL_UPDATE),&event);
      
        // Next widget to refresh
        if(refresher->getFirst()){
          refresher=refresher->getFirst();
          continue;
          }
        while(!refresher->getNext() && refresher->getParent()!=root){
          refresher=refresher->getParent();
          }
        refresher=refresher->getNext();
        continue;
        }
    
      // Chores
      if(chores){
        FXChore* c=chores;
        chores=c->next;
      
        // Call the chore handler
        if(c->target && c->target->handle(this,MKUINT(c->message,SEL_CHORE),&event)) refresh();
      
        // Add record to list of recycled chore records
        c->next=chorerecs;
        chorerecs=c;
        continue;
        }

      // No updates or chores pending, so return at this point if not blocking
      if(!blocking) return FALSE;
      break;
      }

    // Get an event
    GetMessage(&msg,NULL,0,0);

    // Maybe it's a timer?
    if(msg.message==WM_TIMER){
      // Fired timer, unlink from list
      // Note the callback may do anything, including setting another timer;
      // So best is to unlink before calling it, and add it to the free list
      // after calling it.
      KillTimer(NULL,msg.wParam);
      FXTimer *h,**hh;
      for(h=timers,hh=&timers; h && h->id!=msg.wParam; hh=&h->next,h=h->next);
      if(h!=NULL){
	FXASSERT(h->id==msg.wParam);
	*hh=h->next;
	if(h->target && h->target->handle(this,MKUINT(h->message,SEL_TIMEOUT),&event)) refresh();
	h->next=timerrecs;
	timerrecs=h;
	}
      continue;
      }

    // Compress motion events
    if(msg.message==WM_MOUSEMOVE){
      MSG m;
      while(PeekMessage(&m,NULL,0,0,PM_NOREMOVE)){
        if(m.message!=WM_MOUSEMOVE || m.hwnd!=msg.hwnd) break;
        GetMessage(&msg,NULL,0,0);
        }
      }
    else if(msg.message==WM_NCMOUSEMOVE){
      MSG m;
      while(PeekMessage(&m,NULL,0,0,PM_NOREMOVE)){
        if(m.message!=WM_NCMOUSEMOVE || m.hwnd!=msg.hwnd) break;
        GetMessage(&msg,NULL,0,0);
        }
      }

    // Regular event
    return TRUE;
    }
  return FALSE;
  }


// Peek for event
FXbool FXApp::peekEvent(){
  MSG msg;
  return PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)!=0;
  }


// Dispatch event to widget
void FXApp::dispatchEvent(FXRawEvent& msg){
  TranslateMessage(&msg);
  DispatchMessage(&msg);
  }


#endif

/*******************************************************************************/



// Flush pending repaints
void FXApp::flush(){
#ifndef FX_NATIVE_WIN32
  FXRepaint *r;
  XEvent ev;
  struct timeval delta;
  fd_set readfds;
  fd_set writefds;
  fd_set exceptfds;
  int maxfds;
  int nfds;
  if(display){

    // Flush buffer first; then we wait for the server to process the  
    // events because some of the commands may lead to expose events...
    XSync(display,FALSE);

    // Prepare fd's to watch
    FD_ZERO(&readfds);
    FD_ZERO(&writefds);
    FD_ZERO(&exceptfds);
    FD_SET(ConnectionNumber(display),&readfds);

    // Add other inputs...
    maxfds=ConnectionNumber(display);

    delta.tv_usec=0;
    delta.tv_sec=0;

    // Do a quick poll for any ready events in the server; we don't
    // want to block if there are no events in the server's queue...
    nfds=SELECT(maxfds+1,&readfds,&writefds,&exceptfds,&delta);

    // Interrupt
    if(nfds<0 && errno!=EAGAIN && errno!=EINTR){
      fxerror("Application terminated: interrupt or lost connection errno=%d\n",errno);
      }

    // Pull events from server now we know that there are some...
    if((nfds>0) && FD_ISSET(ConnectionNumber(display),&readfds)){
      XEventsQueued(display,QueuedAfterReading);
      }

    // First compound extant expose events
    while(XCheckMaskEvent(display,ExposureMask,&ev)){
      if(ev.xany.type==NoExpose) continue;
      addRepaint(ev.xexpose.window,ev.xexpose.x,ev.xexpose.y,ev.xexpose.width,ev.xexpose.height,0);
      }

    // Then process them
    while(repaints){
      r=repaints;
      ev.xany.type=Expose;
      ev.xexpose.window=r->window;
      ev.xexpose.x=r->rect.x;
      ev.xexpose.y=r->rect.y;
      ev.xexpose.width=r->rect.w-r->rect.x;
      ev.xexpose.height=r->rect.h-r->rect.y;
      repaints=r->next;
      r->next=repaintrecs;
      repaintrecs=r;
      dispatchEvent(ev);
      }

    // Flush the buffer again, this time its just drawing commands;
    // We don't hang around for the server to process them this time...
    XFlush(display);
    }
#else
  FXWindow *top;

  // Force all windows marked as dirty to be repainted
  for(top=root->getFirst(); top; top=top->getNext()){
    RedrawWindow((HWND)top->id(),NULL,NULL,RDW_ERASENOW|RDW_UPDATENOW|RDW_ALLCHILDREN);
    }
#endif
  }


// Force GUI refresh of every widget in this application
void FXApp::forceRefresh(){
  getRoot()->forceRefresh();
  }


// Perform refresh some time
void FXApp::refresh(){
  refresher=root;
  }


// Run application
FXint FXApp::run(){
  done=FALSE;
  runUntil(done);
  return exitcode;
  }


// Break out of topmost event loop
void FXApp::stop(FXint code){
  exitcode=code;
  done=TRUE;
  }
  

// Run till some flag becomes non-zero
void FXApp::runUntil(FXuint& condition){
  while(condition==0){
    runOneEvent();
    }
  }


// Perform one event dispatch
void FXApp::runOneEvent(){
  FXRawEvent ev;
  getNextEvent(ev);
  dispatchEvent(ev);
  }


// Run modal for window
FXint FXApp::runModalFor(FXWindow* window){
  FXInvocation inv;
  if(window==NULL || window->id()==0){ fxerror("%s::runModalFor: illegal window specified.\n",getClassName()); }
  inv.upper=invocation;
  inv.window=window->id();
  inv.done=FALSE;
  inv.code=0;
  invocation=&inv;
  while(!inv.done){
    runOneEvent();
    }
  invocation=inv.upper;
  return inv.code;
  }


// Break out of current modal loop
void FXApp::stopModal(FXWindow* window,FXint value){
  FXInvocation* inv;
  if(window==NULL || window->id()==0){ fxerror("%s::stopModal: illegal window specified.\n",getClassName()); }
  for(inv=invocation; inv; inv=inv->upper){
    if(inv->window==window->id()){
      inv->done=TRUE;
      inv->code=value;
      break;
      }
    }
  }


// Run modal while window is shown, or until stopModal is called
FXint FXApp::runModalWhileShown(FXWindow* window){
  FXInvocation inv;
  if(window==NULL || window->id()==0){ fxerror("%s::runModalWhileShown: illegal window specified.\n",getClassName()); }
  inv.upper=invocation;
  inv.window=window->id();
  inv.done=FALSE;
  inv.code=0;
  invocation=&inv;
  while(!inv.done && window->shown()){
    runOneEvent();
    }
  invocation=inv.upper;
  return inv.code;
  }


// Test if the window is involved in the innermost modal invocation
FXbool FXApp::isModal(FXWindow *window) const {
  FXInvocation* inv;
  if(window==NULL || window->id()==0){ fxerror("%s::isModal: illegal window specified.\n",getClassName()); }
  for(inv=invocation; inv; inv=inv->upper){
    if(inv->window==window->id()) return TRUE;
    }
  return FALSE;
  }

  
// Initialize application
void FXApp::init(int& argc,char** argv){
  char *dpy=NULL;
  FXint i,j;
  FXuint maxcols=0;

  // Verify implementation invariants
  FXASSERT(sizeof(FXuchar)==1);
  FXASSERT(sizeof(FXbool)==1);
  FXASSERT(sizeof(FXchar)==1);
  FXASSERT(sizeof(FXushort)==2);
  FXASSERT(sizeof(FXshort)==2);
  FXASSERT(sizeof(FXuint)==4);
  FXASSERT(sizeof(FXint)==4);
  FXASSERT(sizeof(FXfloat)==4);
  FXASSERT(sizeof(FXdouble)==8);
  
  FXASSERT(sizeof(FXString)==sizeof(FXchar*));
  
  // Long is not always available on all implementations
#ifdef FX_LONG
  FXASSERT(sizeof(FXulong)==8);
  FXASSERT(sizeof(FXlong)==8);
#endif

  // No shared memory with Windoze
#ifndef FX_NATIVE_WIN32
#ifdef WIN32
  shmi=FALSE;
  shmp=FALSE;
#endif
#endif
  
  // Parse out FOX args
  i=j=1;
  while(j<argc){
    
#ifndef FX_NATIVE_WIN32
    
    // Start synchronized mode
    if(strcmp(argv[j],"-sync")==0){
      synchronize=TRUE;
      j++;
      continue;
      }
    
    // Start synchronized mode
    if(strcmp(argv[j],"-noshm")==0){
      shmi=FALSE;
      shmp=FALSE;
      j++;
      continue;
      }
    
    // Alternative display
    if(strcmp(argv[j],"-display")==0){
      j++;
      if(j>=argc){ fxerror("%s:init: missing argument for -display.\n",getClassName()); }
      dpy=argv[j];
      j++;
      continue;
      }
    
#endif
    
    // Set trace level
    if(strcmp(argv[j],"-tracelevel")==0){
      j++;
      if(j>=argc){ fxerror("%s:init: missing argument for -tracelevel.\n",getClassName()); }
      if(sscanf(argv[j],"%d",&fxTraceLevel)!=1){ fxerror("%s::init: expected trace level number.\n",getClassName()); }
      j++;
      continue;
      }

    // Set maximum number of colors
    if(strcmp(argv[j],"-maxcolors")==0){
      j++;
      if(j>=argc){ fxerror("%s:init: missing argument for -maxcolors.\n",getClassName()); }
      if(sscanf(argv[j],"%u",&maxcols)!=1 || maxcols<2){ fxerror("%s::init: expected number of colors > 2.\n",getClassName()); }
      j++;
      continue;
      }
    
    // Copy program arguments
    argv[i++]=argv[j++];
    }
  
  // Adjust argment count
  argv[i]=NULL;
  argc=i;
  
  // Open display
  openDisplay(dpy);
  
  // Read the registry
  registry.read();

  // Change some settings
  clickSpeed=registry.readUnsignedEntry("SETTINGS","clickspeed",400);
  animSpeed=registry.readUnsignedEntry("SETTINGS","animspeed",10);
  scrollSpeed=registry.readUnsignedEntry("SETTINGS","scrollspeed",200);
  blinkSpeed=registry.readUnsignedEntry("SETTINGS","blinkspeed",500);
  menuPause=registry.readUnsignedEntry("SETTINGS","menupause",400);
  tooltipPause=registry.readUnsignedEntry("SETTINGS","tippause",800);
  tooltipTime=registry.readUnsignedEntry("SETTINGS","tiptime",3000);
  scrollbarWidth=registry.readIntEntry("SETTINGS","scrollbarwidth",15);
  dragDelta=registry.readIntEntry("SETTINGS","dragdelta",6);

  // Colors
  borderColor=reg().readColorEntry("SETTINGS","bordercolor",FXRGB(0,0,0));
  baseColor=reg().readColorEntry("SETTINGS","basecolor",FXRGB(192,192,192));
  hiliteColor=reg().readColorEntry("SETTINGS","hilitecolor",makeHiliteColor(baseColor));
  shadowColor=reg().readColorEntry("SETTINGS","shadowcolor",makeShadowColor(baseColor));
  backColor=reg().readColorEntry("SETTINGS","backcolor",FXRGB(255,255,255));
  foreColor=reg().readColorEntry("SETTINGS","forecolor",FXRGB(0,0,0));   
  selforeColor=reg().readColorEntry("SETTINGS","selforecolor",FXRGB(255,255,255));
  selbackColor=reg().readColorEntry("SETTINGS","selbackcolor",FXRGB(0,0,128));

  // Maximum number of colors to allocate
  maxcolors=reg().readUnsignedEntry("SETTINGS","maxcolors",MAXCOLORS);

  // Command line takes precedence
  if(maxcols) maxcolors=maxcols;

  // Set maximum number of colors in default visual to be nice to legacy
  // Motif applications which don't handle color allocation gracefully.
  getRoot()->getVisual()->setMaxColors(maxcolors);
  }


// Exit application
void FXApp::exit(FXint code){

  // Free display resources
  closeDisplay();

  // Write the registry
  registry.write();
  
  // Dump profile data
#ifdef FX_ENABLE_PROFILING
  FXProfiler::speak();
#endif

  // Exit the program
  ::exit(code);
  }
  

// Create application's windows
void FXApp::create(){ 
#ifndef FX_NATIVE_WIN32
  if(display==NULL){ fxerror("%s::create(): Should open display first\n",getClassName()); }
#endif

  // Create default font
  normalFont->create();

  // Create cursors
  arrowCursor->create();
  rarrowCursor->create();
  textCursor->create();
  hsplitCursor->create();
  vsplitCursor->create();
  xsplitCursor->create();
  resizeCursor->create();
  swatchCursor->create();
  dontdropCursor->create();
  moveCursor->create();
  dragHCursor->create();
  dragVCursor->create();
  dragTLCursor->create();
  dragTRCursor->create();
  dndCopyCursor->create();
  dndMoveCursor->create();
  dndLinkCursor->create();

  // Create all windows
  root->create();
  }



// Detach application's windows
void FXApp::detach(){
  root->detach();

  // Detach default font
  normalFont->detach();

  // Detach cursors
  arrowCursor->detach();
  rarrowCursor->detach();
  textCursor->detach();
  hsplitCursor->detach();
  vsplitCursor->detach();
  xsplitCursor->detach();
  resizeCursor->detach();
  swatchCursor->detach();
  dontdropCursor->detach();
  moveCursor->detach();
  dragHCursor->detach();
  dragVCursor->detach();
  dragTLCursor->detach();
  dragTRCursor->detach();
  dndCopyCursor->detach();
  dndMoveCursor->detach();
  dndLinkCursor->detach();

#ifndef WIN32
  close(ConnectionNumber(display));
  display=NULL;
#endif
  }


// Destroy application's windows
void FXApp::destroy(){
  root->destroy();
  }

  
#ifdef FX_NATIVE_WIN32

// Convert Win32 virtual key codes (and modifiers) to FOX keycaps
static FXuint winkey2foxkey(FXuint state,WPARAM wParam){
  FXuint i;
  
  // Patch from Alexander V. Voinov <avv@quasar.ipa.nw.ru>
  if(wParam >= 48 && wParam <= 255){ 
    HKL kl=GetKeyboardLayout(0);
    BYTE kstate[256];
    GetKeyboardState(kstate);
    unsigned short winchar=0;
    int ret=ToAsciiEx(wParam,0,kstate,&winchar,0,kl);
    if(ret>0){
      if((state&(CONTROLMASK|ALTMASK))==0){
        return winchar;
        }
      else{
        
        // Numbers
        static FXuint numbersmap[]={
          KEY_parenright,KEY_exclam,KEY_at,KEY_numbersign,KEY_dollar,KEY_percent,
          KEY_asciicircum,KEY_ampersand,KEY_asterisk,KEY_parenleft
          };

        // Letters
        if(wParam>=48&&wParam<=57){
          if(state&SHIFTMASK)
            return numbersmap[wParam-48];
          else
            return KEY_0+(wParam-48);
          }

        if(((state&CAPSLOCKMASK)!=0)^((state&SHIFTMASK)!=0))
          return wParam+(KEY_A-65);
        else
          return wParam+(KEY_a-KEY_A);
        }
      }
    }

//   // Letters
//   if(wParam>=65&&wParam<=90){
//     if(((state&CAPSLOCKMASK)!=0) ^ ((state&SHIFTMASK)!=0))
//       return wParam+(KEY_A-65);
//     else
//       return wParam+(KEY_a-KEY_A);
//     }
// 
//   // Numbers
//   FXuint numbersmap[]={
//     KEY_parenright,KEY_exclam,KEY_at,KEY_numbersign,KEY_dollar,KEY_percent,
//     KEY_asciicircum,KEY_ampersand,KEY_asterisk,KEY_parenleft
//     };
// 
//   if(wParam>=48&&wParam<=57){
//     if(state&SHIFTMASK)
//       return numbersmap[wParam-48];
//     else
//       return KEY_0+(wParam-48);
//     }

  // Keypad numbers
  if(wParam>=VK_NUMPAD0&&wParam<=VK_NUMPAD9){
    return KEY_KP_0+(wParam-VK_NUMPAD0);
    }

  // Undocumented keycodes; how portable???
  if(state&SHIFTMASK){
    FXuint codesmap1[]={
      0xC0, KEY_asciitilde, 0xBD, KEY_underscore, 0xBB, KEY_plus, 0xDB, KEY_braceleft,
      0xDD, KEY_braceright, 0xDC, KEY_bar, 0xBA, KEY_colon, 0xDE, KEY_quotedbl,
      0xBC, KEY_less, 0xBE, KEY_greater, 0xBF, KEY_question
      };
    for(i=0; i<ARRAYNUMBER(codesmap1)/2; i++){
      if(codesmap1[2*i]==wParam) return codesmap1[2*i+1];
      }
    }
  else{
    FXuint codesmap2[]={
      0xC0, KEY_grave, 0xBD, KEY_minus, 0xBB, KEY_equal, 0xDB, KEY_bracketleft,
      0xDD, KEY_bracketright, 0xDC, KEY_backslash, 0xBA, KEY_semicolon, 0xDE, KEY_apostrophe,
      0xBC, KEY_comma, 0xBE, KEY_period, 0xBF, KEY_slash
      };
    for(i=0; i<ARRAYNUMBER(codesmap2)/2; i++){
      if(codesmap2[2*i]==wParam) return codesmap2[2*i+1];
      }
    }

  // Function keys
  if(wParam>=VK_F1&&wParam<=VK_F16){
    return KEY_F1+(wParam-VK_F1);
    }

  // Left or Right Shift Key
  if(wParam==VK_SHIFT){
    return (GetKeyState(VK_LSHIFT)<0) ? KEY_Shift_L : KEY_Shift_R;
    }

  // Left or Right Alt key
  if(wParam==VK_MENU){
    return (GetKeyState(VK_RMENU)<0) ? KEY_Alt_L : KEY_Alt_R;
    }

  // Left or Right Ctrl key
  if(wParam==VK_CONTROL){
    return (GetKeyState(VK_LCONTROL)<0) ? KEY_Control_L : KEY_Control_R;
    }

  // Pause/Break key
  if(wParam==VK_PAUSE){
    return (GetKeyState(VK_SHIFT)<0) ? KEY_Pause : KEY_Break;
    }

  // Miscellaneous
  FXuint miscmap[]={
    VK_SPACE,     KEY_space,
    VK_BACK,      KEY_BackSpace,
    VK_TAB,       KEY_Tab,
    VK_RETURN,    KEY_Return,
    VK_SCROLL,    KEY_Scroll_Lock,
    VK_ESCAPE,    KEY_Escape,
    VK_INSERT,    KEY_Insert,
    VK_DELETE,    KEY_Delete,
    VK_HOME,      KEY_Home,
    VK_LEFT,      KEY_Left,
    VK_UP,        KEY_Up,
    VK_RIGHT,     KEY_Right,
    VK_DOWN,      KEY_Down,
    VK_PRIOR,     KEY_Prior,
    VK_NEXT,      KEY_Next,
    VK_END,       KEY_End,
    VK_CAPITAL,   KEY_Caps_Lock,
    VK_NUMLOCK,   KEY_Num_Lock,
    VK_MULTIPLY,  KEY_KP_Multiply,
    VK_ADD,       KEY_KP_Add,
    VK_SEPARATOR, KEY_KP_Separator,
    VK_SUBTRACT,  KEY_KP_Subtract,
    VK_DECIMAL,   KEY_KP_Decimal,
    VK_DIVIDE,    KEY_KP_Divide,
    VK_SNAPSHOT,  KEY_Print,
    };

  for(i=0;i<ARRAYNUMBER(miscmap)/2;i++){
    if(miscmap[2*i]==wParam) return miscmap[2*i+1];
    }

  fxwarning("Caught unrecognized key code [%4x]\n",wParam);

  return KEY_VoidSymbol;
  }


// This window procedure is a static member function of class FXApp.
// Its sole purpose is to forward the message info on to FXApp::dispatchEvent().
LRESULT CALLBACK FXApp::wndproc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam){
  return app->dispatchEvent(hwnd,iMsg,wParam,lParam);
  }

#ifndef WM_SYNCPAINT
#define WM_SYNCPAINT 0x0088
#endif

// Message dispatching
LRESULT FXApp::dispatchEvent(HWND hwnd,UINT iMsg,WPARAM wParam,LPARAM lParam){
  LPCREATESTRUCT pCS;
  FXWindow *window;
  POINT pt;
  BOOL fShow;
  UINT iFormat;
  PAINTSTRUCT ps;
  
  if(!IsWindow(hwnd))
    return DefWindowProc(hwnd,iMsg,wParam,lParam);

  window=(FXWindow*)GetWindowLong(hwnd,0);
  if(window==0 && iMsg!=WM_CREATE)
    return DefWindowProc(hwnd,iMsg,wParam,lParam);

  // Translate Win32 message to FOX message type
  switch(iMsg){

    // Composite expose events into rectangle
    case WM_PAINT:
      event.type=SEL_PAINT;
      event.window=hwnd;
      event.synthetic=1;
      BeginPaint(hwnd,&ps);
      event.rect.x=(FXshort)ps.rcPaint.left;
      event.rect.y=(FXshort)ps.rcPaint.top;
      event.rect.w=(FXshort)(ps.rcPaint.right-ps.rcPaint.left+1);
      event.rect.h=(FXshort)(ps.rcPaint.bottom-ps.rcPaint.top+1);
      window->handle(this,MKUINT(0,SEL_PAINT),&event);
      EndPaint(hwnd,&ps);
      return 0;

    // Keyboard
    case WM_KEYDOWN:
    case WM_SYSKEYDOWN:
    case WM_KEYUP:
    case WM_SYSKEYUP:
      // Ignore auto-repeat for Shift, Ctrl & Alt keys
      if((iMsg==WM_SYSKEYDOWN || iMsg==WM_KEYDOWN) && (HIWORD(lParam)&KF_REPEAT)){
        if(wParam==VK_SHIFT||wParam==VK_CONTROL||wParam==VK_MENU)
          return 0;
        }

      // Normal processing
      event.type=((iMsg==WM_KEYDOWN)||(iMsg==WM_SYSKEYDOWN))?SEL_KEYPRESS:SEL_KEYRELEASE;
      event.window=hwnd;
      event.time=GetMessageTime();
      GetCursorPos(&pt);
      event.root_x=pt.x;
      event.root_y=pt.y;
      ScreenToClient(hwnd,&pt);
      event.win_x=pt.x;
      event.win_y=pt.y;
      event.state=fxmodifierkeys();

      // Translate virtual key code
      event.code=winkey2foxkey(event.state,wParam);

      if(event.type==SEL_KEYPRESS){
        keyWindow=focusWindow;
        if(!event.moved && (event.time-event.click_time<clickSpeed) && (event.window==event.click_window) && (event.code==event.click_button)){
          if(!(HIWORD(lParam)&KF_REPEAT)) event.click_count++; // Account for auto-repeat
          event.click_time=event.time;
          }
        else{
          event.click_count=1;
          event.click_x=event.win_x;
          event.click_y=event.win_y;
          event.click_window=event.window;
          event.click_button=event.code;
          event.click_time=event.time;
          }
        if(!(event.state&(LEFTBUTTONMASK|MIDDLEBUTTONMASK|RIGHTBUTTONMASK))) event.moved=0;
        }
      if(keyWindow){
        if(keyWindow->passModalEvents()){
          keyWindow->handle(this,MKUINT(0,event.type),&event);
          refresh();
          }
        else if(iMsg==WM_KEYDOWN || iMsg==WM_SYSKEYDOWN){
          beep();
          }
        }
      event.last_x=event.win_x;
      event.last_y=event.win_y;
      return 0;

    // Motion
    case WM_MOUSEMOVE:

      // Synthesize enter and leave events first
      if(window!=cursorWindow){
        event.type=SEL_ENTER;
        event.time=GetMessageTime();
        event.win_x=pt.x=LOWORD(lParam);
        event.win_y=pt.y=HIWORD(lParam);
        ClientToScreen(hwnd,&pt);
        event.root_x=pt.x;
        event.root_y=pt.y;
        event.window=hwnd;
        event.code=CROSSINGNORMAL;
        if(window->handle(this,MKUINT(0,SEL_ENTER),&event)) refresh();
        event.last_x=event.win_x;
        event.last_y=event.win_y;

        // Set up a mouse tracker to catch the leave
        TRACKMOUSEEVENT tme;
        tme.cbSize=sizeof(TRACKMOUSEEVENT);
        tme.dwFlags=TME_LEAVE;
        tme.hwndTrack=hwnd;
        tme.dwHoverTime=HOVER_DEFAULT;  // Unused in this case
#if defined(__CYGWIN__) || defined(__MINGW32__)
        TrackMouseEvent(&tme);          // Renamed from TrackMouseEvent
#else
        _TrackMouseEvent(&tme);         // Renamed from TrackMouseEvent
#endif
        }

      // Normal motion event
      event.type=SEL_MOTION;
      event.window=hwnd;
      event.time=GetMessageTime();
      event.win_x=pt.x=(int)((short)LOWORD(lParam)); // Position in client coordinates
      event.win_y=pt.y=(int)((short)HIWORD(lParam));
      ClientToScreen(hwnd,&pt);
      event.root_x=pt.x;
      event.root_y=pt.y;
      event.code=0;
      event.state=fxmodifierkeys();

      //if(!event.moved && && (FXABS(event.win_x-event.click_x)>=dragDelta || FXABS(event.win_y-event.click_y)>=dragDelta)){
      if(!event.moved && event.window==event.click_window && (FXABS(event.win_x-event.click_x)>=dragDelta || FXABS(event.win_y-event.click_y)>=dragDelta)){
        event.moved=1;
        }
      if(grabWindow){
        if(grabWindow->handle(this,MKUINT(0,SEL_MOTION),&event)) refresh();
        }
      else if(window->passModalEvents()){
        if(window->handle(this,MKUINT(0,SEL_MOTION),&event)) refresh();
        }
      event.last_x=event.win_x;
      event.last_y=event.win_y;
      return 0;

    // Button
    case WM_LBUTTONDOWN:
    case WM_MBUTTONDOWN:
    case WM_RBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_MBUTTONUP:
    case WM_RBUTTONUP:
      event.window=hwnd;
      event.time=GetMessageTime();
      event.win_x=pt.x=(int)((short)LOWORD(lParam));;
      event.win_y=pt.y=(int)((short)HIWORD(lParam));;
      ClientToScreen(hwnd, &pt);
      event.root_x=pt.x;
      event.root_y=pt.y;
      event.state=fxmodifierkeys();   
      switch(iMsg){
        case WM_LBUTTONDOWN:
          event.type=SEL_LEFTBUTTONPRESS;
          event.state&=~LEFTBUTTONMASK;         // Was not down till now
          event.code=LEFTBUTTON;
          break;
        case WM_MBUTTONDOWN:
          event.type=SEL_MIDDLEBUTTONPRESS;
          event.state&=~MIDDLEBUTTONMASK;       // Was not down till now
          event.code=MIDDLEBUTTON;
          break;
        case WM_RBUTTONDOWN:
          event.type=SEL_RIGHTBUTTONPRESS;
          event.state&=~RIGHTBUTTONMASK;        // Was not down till now
          event.code=RIGHTBUTTON;
          break;
        case WM_LBUTTONUP:
          event.type=SEL_LEFTBUTTONRELEASE;
          event.code=LEFTBUTTON;
          break;
        case WM_MBUTTONUP:
          event.type=SEL_MIDDLEBUTTONRELEASE;
          event.code=MIDDLEBUTTON;
          break;
        case WM_RBUTTONUP:
          event.type=SEL_RIGHTBUTTONRELEASE;
          event.code=RIGHTBUTTON;
          break;
        }
      if(iMsg==WM_LBUTTONDOWN || iMsg==WM_MBUTTONDOWN || iMsg==WM_RBUTTONDOWN){
        if(!event.moved && (event.time-event.click_time<clickSpeed) && (event.window==event.click_window) && (event.code==event.click_button)){
          event.click_count++;
          event.click_time=event.time;
          }
        else{
          event.click_count=1;
          event.click_x=event.win_x;
          event.click_y=event.win_y;
          event.click_window=event.window;
          event.click_button=event.code;
          event.click_time=event.time;
          }
        if(!(event.state&(LEFTBUTTONMASK|MIDDLEBUTTONMASK|RIGHTBUTTONMASK))) event.moved=0;
        }
      else if(iMsg==WM_LBUTTONUP || iMsg==WM_MBUTTONUP || iMsg==WM_RBUTTONUP){
        }
      if(grabWindow){
        if(grabWindow->handle(this,MKUINT(0,event.type),&event)) refresh();
        }
      else if(window->passModalEvents()){
        if(window->handle(this,MKUINT(0,event.type),&event)) refresh();
        }
      else if(iMsg==WM_LBUTTONDOWN || iMsg==WM_MBUTTONDOWN || iMsg==WM_RBUTTONDOWN){
        beep();
        }
      event.last_x=event.win_x;
      event.last_y=event.win_y;
      return 0;

    // Crossing
    case WM_MOUSELEAVE:
      if(cursorWindow && !cursorWindow->isChildOf(window)){

        // Send SEL_LEAVE to all ancestor windows up to, but not including, our common ancestor
        FXWindow *ancestor=cursorWindow->commonAncestor(window);
        while(window!=ancestor){
          event.type=SEL_LEAVE;
          event.time=GetMessageTime();
          GetCursorPos(&pt);
          event.root_x=pt.x;
          event.root_y=pt.y;
          FXASSERT(event.window);
          ScreenToClient((HWND)event.window,&pt);
          event.win_x=pt.x;
          event.win_y=pt.y;
          event.code=CROSSINGNORMAL;
          if(window->handle(this,MKUINT(0,SEL_LEAVE),&event)) refresh();
          event.last_x=event.win_x;
          event.last_y=event.win_y;
          window=window->getParent();
          } 
        }
      return 0;
      
    // Focus
    case WM_SETFOCUS:
    case WM_KILLFOCUS:
      window=window->getShell();
      if(iMsg==WM_SETFOCUS){
        if(focusWindow!=window){
          event.type=SEL_FOCUSIN;
          event.window=hwnd;
          if(window->handle(this,MKUINT(0,SEL_FOCUSIN),&event)) refresh();
          focusWindow=window;
          }
        }
      else{
        if(focusWindow){
          event.type=SEL_FOCUSOUT;
          event.window=hwnd;
          if(focusWindow->handle(this,MKUINT(0,SEL_FOCUSOUT),&event)) refresh();
          focusWindow=NULL;
          }
        }
      return 0;

    // Map or Unmap
    case WM_SHOWWINDOW:
      fShow=(BOOL)wParam;
      event.type=fShow ? SEL_MAP : SEL_UNMAP;
      event.window=hwnd;
      window->handle(this,MKUINT(0,event.type),&event);
      return 0;

    // Create
    case WM_CREATE:
      pCS=(LPCREATESTRUCT)lParam;
      window=static_cast<FXWindow*>(pCS->lpCreateParams);
      event.type=SEL_CREATE;
      event.window=hwnd;
      event.rect.x=pCS->x;
      event.rect.y=pCS->y;
      event.rect.w=pCS->cx;
      event.rect.h=pCS->cy;
      SetWindowLong(hwnd,0,reinterpret_cast<LONG>(pCS->lpCreateParams));
      if(window->handle(this,MKUINT(0,SEL_CREATE),&event)) refresh();
      return 0;

    // Close
    case WM_CLOSE:

      ////// Semantics: SEL_CLOSE is a suggestion that the window be closed;
      ////// SEL_DESTROY is a notify that destruction has already taken place.
      ////// Thus, a toplevel window gets a close, and MAY decide not to be closed;
      ////// If it thinks its OK to close, it gets a SEL_DESTROY also.
      event.type=SEL_CLOSE;
      event.window=hwnd;
      if(window->handle(this,MKUINT(0,SEL_CLOSE),&event)) refresh();
      return 0;
      
    // Destroy
    case WM_DESTROY:
      event.type=SEL_DESTROY;
      event.window=hwnd;
      if(window->handle(this,MKUINT(0,SEL_DESTROY),&event)) refresh();
      return 0;

    case WM_SIZING:
    case WM_MOVING:
    case WM_ERASEBKGND:     // Do nothing, erasing background causes flashing
      return 0;

    // Configure (size)
    case WM_SIZE:
      event.window=hwnd;
      event.type=SEL_CONFIGURE;
      event.rect.x=window->getX();
      event.rect.y=window->getY();
      event.rect.w=LOWORD(lParam);
      event.rect.h=HIWORD(lParam);
      window->handle(this,MKUINT(0,SEL_CONFIGURE),&event);
      return 0;

    // Configure (move)
    case WM_MOVE:
      event.window=hwnd;
      event.type=SEL_CONFIGURE;
      event.rect.x=(short)LOWORD(lParam);
      event.rect.y=(short)HIWORD(lParam);
      event.rect.w=window->getWidth();
      event.rect.h=window->getHeight();
      window->handle(this,MKUINT(0,SEL_CONFIGURE),&event);
      return 0;

    case WM_STYLECHANGING:
    case WM_STYLECHANGED:
    case WM_WINDOWPOSCHANGED:
      return DefWindowProc(hwnd,iMsg,wParam,lParam);

    // Notify the grab window, then break the capture
    case WM_CANCELMODE:
      event.type=SEL_UNGRABBED;
      event.window=hwnd;
      // Synthesize SEL_LEAVE/CROSSINGUNGRAB on grab owner
      if(grabWindow){
        if(grabWindow->handle(this,MKUINT(0,SEL_UNGRABBED),&event)) refresh();
        }
      // Synthesize SEL_ENTER/CROSSINGUNGRAB on new window under cursor [if ours]
      return DefWindowProc(hwnd,iMsg,wParam,lParam);

    // Lost clipboard ownership
    case WM_DESTROYCLIPBOARD:
      event.type=SEL_CLIPBOARD_LOST;
      event.window=hwnd;
      event.time=GetMessageTime();
      event.requestor=NULL; // No requestor; system sends this message when window loses clipboard ownership
      event.property=NULL;
      event.target=ddeDelete;                   // Target is DELETE
      event.origin=FROM_CLIPBOARD;
      if(window->handle(this,MKUINT(0,SEL_CLIPBOARD_LOST),&event)) refresh();
      return 0;

    // Safeguard it in the clipboard
    case WM_RENDERALLFORMATS:
      OpenClipboard(hwnd);
      EmptyClipboard();
      iFormat=0;
      while((iFormat=EnumClipboardFormats(iFormat))!=0){
        event.type=SEL_CLIPBOARD_REQUEST;
        event.window=hwnd;
        event.time=GetMessageTime();
        event.requestor=NULL; // No requestor; system sends this message when window is destroyed
        event.property=NULL;
        event.target=iFormat;
        event.origin=FROM_CLIPBOARD;
        if(window->handle(this,MKUINT(0,SEL_CLIPBOARD_REQUEST),&event)) refresh();
        }
      event.origin=FROM_UNKNOWN;
      CloseClipboard();
      return 0;

    // We're asked to provide certain format to the clipboard
    case WM_RENDERFORMAT:
      event.window=hwnd;
      event.type=SEL_CLIPBOARD_REQUEST;
      event.time=GetMessageTime();
      event.requestor=NULL;
      event.property=NULL;
      event.target=wParam; // Desired format
      event.origin=FROM_CLIPBOARD;
      if(window->handle(this,MKUINT(0,SEL_CLIPBOARD_REQUEST),&event)) refresh();
      event.origin=FROM_UNKNOWN;
      return 0;

    case WM_SETCURSOR:    // Change cursor; will get this only when not captured!
      if(window->getDefaultCursor()&&LOWORD(lParam)==HTCLIENT){
        SetCursor((HCURSOR)window->getDefaultCursor()->id());
        return 0;
        }
      return DefWindowProc(hwnd,iMsg,wParam,lParam);

    case WM_QUERYNEWPALETTE:
      if(window->getVisual()->hPalette){
        HDC hdc=GetDC(hwnd);
        SelectPalette(hdc,window->getVisual()->hPalette,FALSE);
        RealizePalette(hdc);
        InvalidateRect(hwnd,NULL,TRUE);
        ReleaseDC(hwnd,hdc);
        return TRUE;
        }
      return DefWindowProc(hwnd,iMsg,wParam,lParam);

    case WM_PALETTECHANGED:
      if(window->getVisual()->hPalette){
        HDC hdc=GetDC(hwnd);
        SelectPalette(hdc,window->getVisual()->hPalette,FALSE);
        RealizePalette(hdc);
        UpdateColors(hdc);
        ReleaseDC(hwnd,hdc);
        }
      return DefWindowProc(hwnd,iMsg,wParam,lParam);

    case WM_SYSCHAR:
      return 0;

    case WM_INITMENU:
    case WM_ENTERMENULOOP:
    case WM_MENUCHAR:
    case WM_MENUSELECT:
    case WM_EXITMENULOOP:
      return DefWindowProc(hwnd,iMsg,wParam,lParam);

    // Non-client area messages
    case WM_NCMOUSEMOVE:
    case WM_NCCREATE:
    case WM_NCHITTEST:
    case WM_NCCALCSIZE:
    case WM_NCPAINT:
    case WM_NCLBUTTONDOWN:
    case WM_NCLBUTTONUP:
    case WM_NCACTIVATE:
    case WM_NCDESTROY:
      return DefWindowProc(hwnd,iMsg,wParam,lParam);
    case WM_ENTERSIZEMOVE:
    case WM_EXITSIZEMOVE:
      return DefWindowProc(hwnd,iMsg,wParam,lParam);
    case WM_CHAR:
    case WM_PARENTNOTIFY:
    case WM_GETMINMAXINFO:
    case WM_SETTEXT:
    case WM_GETTEXT:
    case WM_SYSCOMMAND:
    case WM_QUERYOPEN:
    case WM_ENABLE:
    case WM_CAPTURECHANGED:
    case WM_WINDOWPOSCHANGING:
    case WM_ACTIVATE:
    case WM_MOUSEACTIVATE:
    case WM_CHILDACTIVATE:
    case WM_ACTIVATEAPP:
    case WM_SYNCPAINT:
      return DefWindowProc(hwnd,iMsg,wParam,lParam);
    default:
      // XDND message types are not constants, so we can't put them in a switch() block
      if(iMsg==xdndEnter){
        FXTRACE((100,"%s::dispatchEvent(): got xdndEnter message.\n",getClassName()));
        event.type=SEL_DND_ENTER;
        event.window=hwnd;
        xdndTarget=hwnd;
        xdndSource=(HWND)lParam;
        xdndNumTypes=wParam;
        FXASSERT(xdndTypeList==0);
        if(xdndNumTypes>0){
          HANDLE hMap=OpenFileMapping(FILE_MAP_READ,FALSE,"XdndTypeList");
          if(hMap){
            LPVOID lpView=MapViewOfFile(hMap,FILE_MAP_READ,0,0,0);
            if(lpView){
              if(FXMALLOC(&xdndTypeList,FXDragType,xdndNumTypes))
                memcpy(xdndTypeList,lpView,xdndNumTypes*sizeof(FXDragType));
              UnmapViewOfFile(lpView);
              }
            }
          CloseHandle(hMap);
          }
        if(window->handle(this,MKUINT(0,SEL_DND_ENTER),&event)) refresh();
        return 0;
        }

      // XDND Leave from source
      else if(iMsg==xdndLeave){
        FXTRACE((100,"%s::dispatchEvent(): got xdndLeave message.\n",getClassName()));
        event.type=SEL_DND_LEAVE;
        event.window=hwnd;
        xdndTarget=hwnd;
        xdndSource=(HWND)lParam;
        if(window->handle(this,MKUINT(0,SEL_DND_LEAVE),&event)) refresh();

        // Reset these
        if(xdndTypeList){
          FXFREE(&xdndTypeList);
          xdndTypeList=NULL;
          }
        xdndNumTypes=0;
        xdndTarget=0;
        xdndSource=0;
        return 0;
        }

      // XDND Drop from source
      else if(iMsg==xdndDrop){
        FXTRACE((100,"%s::dispatchEvent(): got xdndDrop message.\n",getClassName()));
        event.type=SEL_DND_DROP;
        event.window=hwnd;
        xdndTarget=hwnd;
        xdndSource=(HWND)lParam;
        event.time=dragContext->time;
        if(window->handle(this,MKUINT(0,SEL_DND_DROP),&event)) refresh();

        // Confirm drop with source
        SendMessage(xdndSource,xdndFinished,0,(LPARAM)hwnd);

        // Reset these
        if(xdndTypeList){
          FXFREE(&xdndTypeList);
          xdndTypeList=NULL;
          }
        xdndNumTypes=0;
        xdndTarget=0;
        xdndSource=0;
        return 0;
        }

      // XDND Position from source
      else if(iMsg==xdndPosition){
        event.type=SEL_DND_MOTION;
        event.window=hwnd;
        xdndTarget=hwnd;
        xdndSource=(HWND)lParam;
        event.root_x=(int)((short)LOWORD(wParam));
        event.root_y=(int)((short)HIWORD(wParam));
        FXTRACE((100,"%s::dispatchEvent(): got xdndPosition (%d,%d) from source.\n",getClassName(),event.root_x,event.root_y));
        event.time=dragContext->time;
        xdndAction=dragContext->action;
        xdndAccepts=FALSE;
        POINT pt;
        pt.x=event.root_x;
        pt.y=event.root_y;
        ScreenToClient(hwnd,&pt);
        event.win_x=pt.x;
        event.win_y=pt.y;
        if(window->handle(this,MKUINT(0,SEL_DND_MOTION),&event)) refresh();
        event.last_x=event.win_x;
        event.last_y=event.win_y;

        // Now confirm latest status with source
        dragContext->target=xdndTarget;
        dragContext->accepts=xdndAccepts;
        dragContext->wantUpdates=xdndWantUpdates;
        dragContext->rect.x=xdndRect.x;
        dragContext->rect.y=xdndRect.y;
        dragContext->rect.w=xdndRect.w;
        dragContext->rect.h=xdndRect.h;
        dragContext->action=xdndAction;
        PostMessage(xdndSource,xdndStatus,0,(LPARAM)hwnd);
        return 0;
        }

      // SEL_DND_REQUEST from target
      else if(iMsg==xdndRequest){
        FXTRACE((100,"%s::dispatchEvent(): got dndRequest message.\n",getClassName()));
        event.window=hwnd;
        event.time=GetMessageTime();
        event.requestor=(HWND)lParam;
        event.property=0;
        event.target=(FXDragType)wParam;
        if(event.target==reqTargets){            // Request for TYPES
          FXASSERT(FALSE);
          }
        else{
          event.type=SEL_DND_REQUEST;            // Request for DATA
          event.origin=FROM_DRAGNDROP;
          if(window->handle(this,MKUINT(0,SEL_DND_REQUEST),&event)) refresh();
          }
        // Now send SelectionNotify back to the requestor?
        return 0;
        }

      // XDND Status from target
      else if(iMsg==xdndStatus){
        FXTRACE((100,"DNDStatus from %s remote\n",xdndTarget==(HWND)lParam ? "active" : "old"));

        // Ignore status messages which are no longer applicable
        if(xdndTarget==(HWND)lParam){
          xdndAccepts=dragContext->accepts;
          xdndAction=dragContext->action;
          xdndWantUpdates=dragContext->wantUpdates;
          xdndRect.x=dragContext->rect.x;
          xdndRect.y=dragContext->rect.y;
          xdndRect.w=dragContext->rect.w;
          xdndRect.h=dragContext->rect.h;
          xdndStatusReceived=TRUE;
          xdndStatusPending=FALSE;
          if(xdndSendPosition){
            dragContext->time=event.time;
            dragContext->action=xdndAction;
            PostMessage(xdndTarget,xdndPosition,MAKELONG(xdndXPos,xdndYPos),(LPARAM)hwnd);
            xdndSendPosition=FALSE;
            xdndStatusPending=TRUE;
            }
          }
        return 0;
        }

      // XDND Finished from target
      else if(iMsg==xdndFinished){
        FXTRACE((100,"%s::dispatchEvent(): got xdndFinished message.\n",getClassName()));
        }
      return DefWindowProc(hwnd,iMsg,wParam,lParam);
    }
  }

#endif


// Handle quit
long FXApp::onCmdQuit(FXObject*,FXSelector,void*){
  exit(0); 
  return 1;
  }


// Register DND type
FXDragType FXApp::registerDragType(const FXString& name) const {
#ifndef FX_NATIVE_WIN32
  if(display==NULL){ fxerror("%s::registerDragType: Should open display first.\n",getClassName()); }
  if(!name.text()){ fxerror("%s::registerDragType: NULL name argument.\n",getClassName()); }
  return (FXDragType)XInternAtom(display,name.text(),0);
#else
  return RegisterClipboardFormat(name.text());
#endif
  }


// Get name of registered drag type
FXString FXApp::getDragTypeName(FXDragType type) const {
#ifndef FX_NATIVE_WIN32
  if(display==NULL){ fxerror("%s::getDragTypeName: Should open display first.\n",getClassName()); }
  FXchar *name=XGetAtomName(display,type);
  FXString dragtypename(name);
  XFree(name);
  return dragtypename;
#else
  char pBuffer[256];
  GetClipboardFormatName(type,pBuffer,sizeof(pBuffer));
  return FXString(pBuffer);
#endif
  }


/*******************************************************************************/


// Beep
void FXApp::beep(){
#ifndef FX_NATIVE_WIN32
  XBell(display,0);
#else
  MessageBeep(0);
#endif
  }
  
  
// Dump widgets
long FXApp::onCmdDump(FXObject*,FXSelector,void*){
  dumpWidgets(); 
  return 1;
  }


// Dump widget information
void FXApp::dumpWidgets() const {
  const FXWindow *w=root;
  const FXObject *t;
  FXchar s;
  FXint lev=0;
  while(w){
    t=w->getTarget();
    s=w->shown()?'+':'-';
    if(t){
      fxmessage("%*c%s (0x%08x): id=%d target=%s (0x%08x) sel=%d x=%d y=%d w=%d h=%d\n",lev*2,s,w->getClassName(),w,w->id(),t->getClassName(),t,w->getSelector(),w->getX(),w->getY(),w->getWidth(),w->getHeight());
      }
    else{
      fxmessage("%*c%s (0x%08x): id=%d x=%d y=%d w=%d h=%d\n",lev*2,s,w->getClassName(),w,w->id(),w->getX(),w->getY(),w->getWidth(),w->getHeight());
      }
    if(w->getFirst()){
      w=w->getFirst();
      lev++;
      continue;
      }
    while(!w->getNext() && w->getParent()!=root){
      w=w->getParent();
      lev--;
      if(lev==1) fxmessage("\n");
      }
    w=w->getNext();
    }
  }


// Change default visual
void FXApp::setDefaultVisual(FXVisual* vis){
  if(!vis){ fxerror("%s::setDefaultVisual: NULL visual\n",getClassName()); }
  defaultVisual=vis;
  }


// Save to stream
void FXApp::save(FXStream& store) const {
  FXObject::save(store);
  store << clickSpeed;
  store << animSpeed;
  store << scrollSpeed;
  store << blinkSpeed;
  store << menuPause;
  store << tooltipPause;
  store << tooltipTime;
  store << scrollbarWidth;
  store << dragDelta;
  store << borderColor;
  store << baseColor;
  store << hiliteColor;
  store << shadowColor;
  store << backColor;
  store << foreColor;
  store << selforeColor;
  store << selbackColor;
  }


// Load from stream
void FXApp::load(FXStream& store){ 
  FXObject::load(store);
  store >> clickSpeed;
  store >> animSpeed;
  store >> scrollSpeed;
  store >> blinkSpeed;
  store >> menuPause;
  store >> tooltipPause;
  store >> tooltipTime;
  store >> scrollbarWidth;
  store >> dragDelta;
  store >> borderColor;
  store >> baseColor;
  store >> hiliteColor;
  store >> shadowColor;
  store >> backColor;
  store >> foreColor;
  store >> selforeColor;
  store >> selbackColor;
  }


// Virtual destructor
FXApp::~FXApp(){
  app=NULL;
  
  // Delete root window & its children
  delete root;
  
  // Delete visuals
  delete defaultVisual;
  delete monoVisual;
  
  // Delete font
  delete normalFont;
  
  // Delete cursors
  delete arrowCursor;
  delete rarrowCursor;
  delete textCursor;

  delete hsplitCursor;
  delete vsplitCursor;
  delete xsplitCursor;

  // Resize corner
  delete resizeCursor;

  // Color swatch
  delete swatchCursor;

  // DND no drop
  delete dontdropCursor;

  // Move  
  delete moveCursor;

  // Dragging edges/corners  
  delete dragHCursor;
  delete dragVCursor;
  delete dragTRCursor;
  delete dragTLCursor;

  // DND actions  
  delete dndCopyCursor;
  delete dndMoveCursor;
  delete dndLinkCursor;

#ifndef FX_NATIVE_WIN32
  FXFREE(&inputs);
  FXFREE(&r_fds);
  FXFREE(&w_fds);
  FXFREE(&e_fds);
#endif
  
  // Free signals list
  FXFREE(&signals);

  // Thrash dangling pointers
  root=(FXRootWindow*)-1;
  defaultVisual=(FXVisual*)-1;
  monoVisual=(FXVisual*)-1;
  normalFont=(FXFont*)-1;
  arrowCursor=(FXCursor*)-1;
  rarrowCursor=(FXCursor*)-1;
  textCursor=(FXCursor*)-1;
  hsplitCursor=(FXCursor*)-1;
  vsplitCursor=(FXCursor*)-1;
  xsplitCursor=(FXCursor*)-1;
  resizeCursor=(FXCursor*)-1;
  swatchCursor=(FXCursor*)-1;
  dontdropCursor=(FXCursor*)-1;
  moveCursor=(FXCursor*)-1;
  dragHCursor=(FXCursor*)-1;
  dragVCursor=(FXCursor*)-1;
  dragTLCursor=(FXCursor*)-1;
  dragTRCursor=(FXCursor*)-1;
  dndCopyCursor=(FXCursor*)-1;
  dndMoveCursor=(FXCursor*)-1;
  dndLinkCursor=(FXCursor*)-1;
  }
