/********************************************************************************
*                                                                               *
*                             Periodic Table of Widgets                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: window.cpp,v 1.1 1999/09/14 13:42:43 jeroen Exp $                       *
********************************************************************************/
#include "fx.h"
#include <stdio.h>
#include <stdlib.h>


/* Generated by reswrap from file minidoc1.gif */
const unsigned char minidoc1[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xbf,0xbf,0xbf,
  0x00,0x00,0x00,0xff,0xff,0xff,0x7f,0x7f,0x7f,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x39,0x84,0x8f,0x89,0xc1,0x1d,0x7a,0x82,0x98,0x93,0x41,0x20,
  0x87,0x16,0xf2,0x29,0x49,0x71,0xcd,0x27,0x68,0x9b,0x16,0x0c,0x09,0x18,0x56,0xea,
  0x52,0x9a,0x5b,0xba,0xb6,0x14,0x0d,0xcb,0xf3,0x1b,0xd9,0x6e,0xad,0x1b,0x70,0x78,
  0x06,0x56,0x0b,0x17,0x71,0x28,0x89,0x86,0xa0,0xec,0x02,0x05,0x14,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderopen.gif */
const unsigned char minifolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xff,0xff,0xff,0xd9,0xd9,0xd9,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0x2c,0x10,0xba,0x37,0x6a,0x15,0x13,0x88,0x41,0x4a,0x27,0x43,
  0x14,0x29,0x9b,0x67,0x82,0x56,0x18,0x68,0xdc,0xe9,0x12,0x42,0x20,0xce,0x62,0x11,
  0x6f,0x69,0x1e,0xc3,0x72,0xfb,0xb9,0xb2,0x18,0xeb,0x47,0xbc,0xad,0x4a,0xc4,0x93,
  0x6c,0xc5,0x7a,0x99,0x62,0x4c,0x1a,0x2d,0xc0,0x04,0x50,0xaf,0x58,0x6c,0x66,0xcb,
  0x6d,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderclosed.gif */
const unsigned char minifolderclosed[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file bigfolder.gif */
const unsigned char bigfolder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xff,0xff,0xff,0xff,0xff,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x80,
  0x80,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x83,0x08,0xba,0xdc,0xfe,0x30,0xca,0x49,0x6b,0x0c,0x38,0x67,0x0b,0x83,0xf8,0x20,
  0x18,0x70,0x8d,0x37,0x10,0x67,0x8a,0x12,0x23,0x09,0x98,0xab,0xaa,0xb6,0x56,0x40,
  0xdc,0x78,0xae,0x6b,0x3c,0x5f,0xbc,0xa1,0xa0,0x70,0x38,0x2c,0x14,0x60,0xb2,0x98,
  0x32,0x99,0x34,0x1c,0x05,0xcb,0x28,0x53,0xea,0x44,0x4a,0xaf,0xd3,0x2a,0x74,0xca,
  0xc5,0x6a,0xbb,0xe0,0xa8,0x16,0x4b,0x66,0x7e,0xcb,0xe8,0xd3,0x38,0xcc,0x46,0x9d,
  0xdb,0xe1,0x75,0xba,0xfc,0x9e,0x77,0xe5,0x70,0xef,0x33,0x1f,0x7f,0xda,0xe9,0x7b,
  0x7f,0x77,0x7e,0x7c,0x7a,0x56,0x85,0x4d,0x84,0x82,0x54,0x81,0x88,0x62,0x47,0x06,
  0x91,0x92,0x93,0x94,0x95,0x96,0x91,0x3f,0x46,0x9a,0x9b,0x9c,0x9d,0x9e,0x9a,0x2e,
  0xa1,0xa2,0x13,0x09,0x00,0x3b
  };

const unsigned char tbuplevel[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x32,0x84,0x8f,0x79,0xc1,0xac,0x18,0xc4,0x90,0x22,0x3c,0xd0,
  0xb2,0x76,0x78,0x7a,0xfa,0x0d,0x56,0xe4,0x05,0x21,0x35,0x96,0xcc,0x29,0x62,0x92,
  0x76,0xa6,0x28,0x08,0x8e,0x35,0x5b,0x75,0x28,0xfc,0xba,0xf8,0x27,0xfb,0xf5,0x36,
  0x44,0xce,0xe5,0x88,0x44,0x14,0x00,0x00,0x3b
  };





int main(int argc,char *argv[]){
  int i;
  
  // Make application
  FXApp* application=new FXApp("Window","Test");
  
  // Open display
  application->init(argc,argv);

  // Make a few icons
  FXGIFIcon *labelicon=new FXGIFIcon(application,bigfolder);

  FXIcon *buttonicon=new FXGIFIcon(application,tbuplevel);

  // Folder icons
  FXIcon *folder_open=new FXGIFIcon(application,minifolderopen);
  FXIcon *folder_closed=new FXGIFIcon(application,minifolderclosed);

  // Document icon
  FXIcon *doc=new FXGIFIcon(application,minidoc1);

  // Make my own main window
  FXMainWindow* main=new FXMainWindow(application,"Periodic Table",NULL,NULL,DECOR_ALL,0,0,800,600);

  // Make menubar
  FXMenuBar* menubar=new FXMenuBar(main,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

  // Make status bar
  new FXStatusbar(main,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // Make file popup menu
  FXMenuPane *filemenu=new FXMenuPane(main);
  new FXMenuCommand(filemenu,"&Open",NULL,NULL,0,MENU_DEFAULT);
  new FXMenuCommand(filemenu,"&Close");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"aaaaa");
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,application,0,0);

  // Hang it under menubar
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
    
  // Make edit popup menu
  FXMenuPane *editmenu=new FXMenuPane(main);
  new FXMenuCommand(editmenu,"Undo");
  new FXMenuCommand(editmenu,"Cut");
  new FXMenuCommand(editmenu,"aaaaa");
  new FXMenuCommand(editmenu,"bbbbb");
  new FXMenuCommand(editmenu,"ccccc");
  new FXMenuCommand(editmenu,"dddddd");
  new FXMenuSeparator(editmenu);
  new FXMenuCommand(editmenu,"Copy");

    FXMenuPane *submenu1=new FXMenuPane(main);
    new FXMenuCommand(submenu1,"One");
    new FXMenuCommand(submenu1,"Two");
    new FXMenuCommand(submenu1,"Three");
    new FXMenuCommand(submenu1,"Four");
    new FXMenuCommand(submenu1,"Three");
    new FXMenuCommand(submenu1,"Three");
    new FXMenuCommand(submenu1,"Three");
    new FXMenuCommand(submenu1,"Four");
    new FXMenuCommand(submenu1,"Four");
    new FXMenuCommand(submenu1,"Four");

  new FXMenuCascade(editmenu,"Submenu1",NULL,submenu1);

    FXMenuPane *submenu2=new FXMenuPane(main);
    new FXMenuCommand(submenu2,"Aaaa");
    new FXMenuCommand(submenu2,"Bbbb");
    new FXMenuCommand(submenu2,"Cccc");
  new FXMenuCascade(editmenu,"Submenu2",NULL,submenu2);

    FXMenuPane *submenu3=new FXMenuPane(main);
    new FXMenuCommand(submenu3,"11111");
    new FXMenuCommand(submenu3,"22222");
    
      FXMenuPane *submenu4=new FXMenuPane(main);
      new FXMenuCommand(submenu4,"QQQQQQ");
      new FXMenuCommand(submenu4,"RRRRRR");
      new FXMenuCommand(submenu4,"SSSSSS");
      new FXMenuCommand(submenu4,"TTTTTT");
      new FXMenuCommand(submenu4,"UUUUUU");
      new FXMenuCommand(submenu4,"VVVVVV");

    new FXMenuCascade(submenu3,"subsub",NULL,submenu4);
    new FXMenuCommand(submenu3,"33333");
  new FXMenuCascade(editmenu,"Submenu3",NULL,submenu3);


  // Hang it under menubar
  new FXMenuTitle(menubar,"Edit",NULL,editmenu);

  // Make help menu
  FXMenuPane *helpmenu=new FXMenuPane(main);
  new FXMenuCommand(helpmenu,"About");

  new FXMenuTitle(menubar,"Help",NULL,helpmenu,LAYOUT_RIGHT);

  // Make Periodic Table
  FXHorizontalFrame *periodictable=new FXHorizontalFrame(main,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);


    // Labels
    FXGroupBox *labels=new FXGroupBox(periodictable,"Labels",FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,5,5,5,5);
    new FXLabel(labels,"Label Types",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(labels,SEPARATOR_LINE|LAYOUT_FILL_X);
    new FXHorizontalSeparator(labels,SEPARATOR_GROOVE|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT,0,0,0,10);
    new FXHorizontalSeparator(labels,SEPARATOR_RIDGE|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT,0,0,0,10);
    new FXHorizontalSeparator(labels,SEPARATOR_LINE|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT,0,0,0,10);
    new FXLabel(labels,"Text Label",NULL);
    new FXLabel(labels,"Label met een icoontje",labelicon,TEXT_OVER_ICON|FRAME_RAISED);
    new FXLabel(labels,"TEXT and ICON",buttonicon);
 
      
    new FXButton(labels,"Popup",NULL,NULL,0,FRAME_RAISED|FRAME_THICK);


    FXTextField* text=new FXTextField(labels,10,NULL,0,FRAME_SUNKEN|FRAME_THICK);

    text=new FXTextField(labels,10,NULL,0,FRAME_SUNKEN|FRAME_THICK);

    FXList *simplelist=new FXList(labels,10,NULL,0,LIST_EXTENDEDSELECT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_RIGHT);
    simplelist->appendItem("One very long list entry");
    simplelist->appendItem("Disabled entry");
    simplelist->disableItem(1);
    for(i=0; i<30; i++){
      simplelist->appendItem(FXStringVal(i),folder_open);
      }

    // Buttons
    FXVerticalFrame* buttons=new FXVerticalFrame(periodictable,FRAME_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);
    new FXLabel(buttons,"Button Types",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(buttons,SEPARATOR_LINE|LAYOUT_FILL_X);
    new FXButton(buttons,"Click Me",NULL,NULL,0,FRAME_RAISED|FRAME_THICK);
    new FXCheckButton(buttons,"Check Button");
    new FXRadioButton(buttons,"Radio Button");
    new FXButton(buttons,NULL,buttonicon,NULL,0,FRAME_RAISED|FRAME_THICK);
    new FXArrowButton(buttons,NULL,0,FRAME_RAISED|FRAME_THICK|ARROW_UP|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,10,10,0,0,0,0);
    new FXArrowButton(buttons,NULL,0,FRAME_RAISED|FRAME_THICK|ARROW_DOWN);
    new FXArrowButton(buttons,NULL,0,FRAME_RAISED|FRAME_THICK|ARROW_LEFT);
    new FXArrowButton(buttons,NULL,0,FRAME_RAISED|FRAME_THICK|ARROW_RIGHT);


    FXTreeList *tree=new FXTreeList(buttons,0,NULL,0,TREELIST_ROOT_BOXES|TREELIST_SHOWS_BOXES|TREELIST_SHOWS_LINES|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_RIGHT);
    FXTreeItem *branch,*twig,*leaf,*topmost,*topmost2;

    topmost=tree->addItemLast(0,"Top",folder_open,folder_closed);
    topmost2=tree->addItemLast(0,"Top2",folder_open,folder_closed);
             tree->addItemLast(topmost2,"First",doc,doc);

    tree->addItemLast(topmost,"First",doc,doc);
    tree->addItemLast(topmost,"Second",doc,doc);
    tree->addItemLast(topmost,"Third",doc,doc);
    branch=tree->addItemLast(topmost,"Fourth",folder_open,folder_closed);
      tree->addItemLast(branch,"Fourth-First",doc,doc);
      tree->addItemLast(branch,"Fourth-Second",doc,doc);
      twig=tree->addItemLast(branch,"Fourth-Third",folder_open,folder_closed);
        tree->addItemLast(twig,"Fourth-Third-First",doc,doc);
        tree->addItemLast(twig,"Fourth-Third-Second",doc,doc);
        tree->addItemLast(twig,"Fourth-Third-Third",doc,doc);
        leaf=tree->addItemLast(twig,"Fourth-Third-Fourth",folder_open,folder_closed);
          tree->addItemLast(leaf,"Fourth-Third-Fourth-First",doc,doc);
          tree->addItemLast(leaf,"Fourth-Third-Fourth-Second",doc,doc);
          tree->addItemLast(leaf,"Fourth-Third-Fourth-Third",doc,doc);
      twig=tree->addItemLast(branch,"Fourth-Fourth",folder_open,folder_closed);
        tree->addItemLast(twig,"Fourth-Fourth-First",doc,doc);
        tree->addItemLast(twig,"Fourth-Fourth-Second",doc,doc);
        tree->addItemLast(twig,"Fourth-Fourth-Third",doc,doc);
        for(i=0; i<10; i++){
          char name[50];
          sprintf(name,"%09d",i);
          tree->addItemLast(twig,name,doc,doc);
          }
      twig=tree->addItemLast(branch,"Fourth-Fifth",folder_open,folder_closed);
        tree->addItemLast(twig,"Fourth-Fifth-First",doc,doc);
        tree->addItemLast(twig,"Fourth-Fifth-Second",doc,doc);
        tree->addItemLast(twig,"Fourth-Fifth-Third",doc,doc);
        for(i=0; i<10; i++){
          char name[50];
          sprintf(name,"%09d",i);
          tree->addItemLast(twig,name,doc,doc);
          }
    tree->addItemLast(topmost,"Fifth",doc,doc);
    tree->addItemLast(topmost,"Sixth",doc,doc);
    branch=tree->addItemLast(topmost,"Seventh",folder_open,folder_closed);
      tree->addItemLast(branch,"Seventh-First",doc,doc);
      tree->addItemLast(branch,"Seventh-Second",doc,doc);
      tree->addItemLast(branch,"Seventh-Third",doc,doc);
    tree->addItemLast(topmost,"Eighth",doc,doc);


    // Switcher windows
    FXVerticalFrame* switchers=new FXVerticalFrame(periodictable,FRAME_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);
    new FXLabel(switchers,"Switcher Windows",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(switchers,SEPARATOR_LINE|LAYOUT_FILL_X);

    FXTabBook* tabbook=new FXTabBook(switchers,NULL,0,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    new FXTabItem(tabbook,"One");
    new FXLabel(tabbook,"Tab Book Page 1",NULL,FRAME_THICK|FRAME_RAISED);
    
    new FXTabItem(tabbook,"Two");
    new FXLabel(tabbook,"Tab Book Page 2",NULL,FRAME_THICK|FRAME_RAISED);
    
    new FXTabItem(tabbook,"Three",buttonicon);
    new FXLabel(tabbook,"Tabs can be on all sides",NULL,FRAME_THICK|FRAME_RAISED);

    new FXTabItem(tabbook,NULL,buttonicon);
    FXVerticalFrame* page=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);
    new FXLabel(page,"Switch Page",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXButton(page,"Text Button",NULL,NULL,0,LAYOUT_TOP);
    new FXCheckButton(page,"Check Button",NULL,0,LAYOUT_TOP|ICON_BEFORE_TEXT);
    new FXRadioButton(page,"Radio Button",NULL,0,LAYOUT_TOP|ICON_BEFORE_TEXT);
    new FXButton(page,NULL,buttonicon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|ICON_BEFORE_TEXT);

    // Scroll windows
    FXVerticalFrame* scrollwin=new FXVerticalFrame(periodictable,FRAME_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);
    new FXLabel(scrollwin,"Scrolled Window",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(scrollwin,SEPARATOR_LINE|LAYOUT_FILL_X);
 
    FXScrollWindow *scrolledwindow=new FXScrollWindow(scrollwin,LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(scrolledwindow,"TEXT and ICON",buttonicon,ICON_ABOVE_TEXT|FRAME_RAISED);

    
  // Resize and display main window
  application->create();
  main->show();

  // Run
  application->run();
  }


