/*
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998,99 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <string.h>
#include "libch.h"

/* cgi tests */
void test_cgi() {
	string 	s;
	char query_string[] = "a=1&b=&c&d=--+--%4D--";

	ch_cgi_set_string(query_string);

	/* ch_cgi_value() */
	printf("\ntesting ch_cgi_value() ...\n");
	strncpy(s, ch_cgi_value("a"), sizeof(s)-1);
	if (strcmp(s,"1")) exit(1);
	printf("value of a is |%10s| (1)\n",s);

	strncpy(s, ch_cgi_value("b"), sizeof(s)-1);
	if (strcmp(s,"")) exit(1);
	printf("value of b is |%10s| ()\n",s);
	
	strncpy(s, ch_cgi_value("c"), sizeof(s)-1);
	if (strcmp(s,"")) exit(1);
	printf("value of c is |%10s| ()\n",s);

	strncpy(s, ch_cgi_value("d"), sizeof(s)-1);
	if (strcmp(s,"-- --M--")) exit(1);
	printf("value of d is |%10s| (-- --M--)\n",s);

	/* ch_cgi_get_value() */	
	printf("\ntesting ch_cgi_get_value() ...\n");
	ch_cgi_get_value("a",s,sizeof(s)-1); 
	if (strcmp(s,"1")) exit(1);
	printf("value of a is |%10s| (1)\n",s);

	ch_cgi_get_value("b",s,sizeof(s)-1); 
	if (strcmp(s,"")) exit(1);
	printf("value of b is |%10s| ()\n",s);

	ch_cgi_get_value("c",s,sizeof(s)-1); 
	if (strcmp(s,"")) exit(1);
	printf("value of d is |%10s| ()\n",s);

	ch_cgi_get_value("d",s,sizeof(s)-1); 
	if (strcmp(s,"-- --M--")) exit(1);
	printf("value of d is |%10s| (-- --M--)\n",s);

	/* ch_cgi_dump() */
	printf("\ntesting ch_cgi_dump() ...\n");
	strncpy(s, ch_cgi_get_string(), sizeof(s)-1);
	if (strcmp(s,query_string)) exit(1);
	printf("value of ch_cgi_s is |%s| (%s)\n",s,query_string);
	
}
	
int main() {

	test_cgi();

	return 0;
}
