/* $Id: dl.c,v 1.4 1999/05/11 19:39:40 marcus Exp $
******************************************************************************

   Input library for GGI. Library extensions dynamic loading.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define GII_DLINIT_SYM         "GIIdlinit"

#include <ggi/internal/gii.h>

/* Open the dynamic libary requested
 */
gii_dlhandle *_giiLoadDL(const char *name, const char *version)
{
	gii_dlhandle hand,*hp;

	GIIDPRINT_LIBS("_giiLoadDL(\"%s\",\"%s\") called \n", name,
		       version ? version : "(NULL)");

	hand.handle=ggMLoadModule(_giiconfhandle, name, version, 0);

	GIIDPRINT_LIBS("hand.handle=%p\n",hand.handle);
	if (hand.handle==NULL) 
		return NULL;

	hand.init = ggGetSymbolAddress(hand.handle, GII_DLINIT_SYM);

	GIIDPRINT_LIBS("hand.init=%p\n",hand.init);
	if (hand.init == NULL ||
	    (hp = (gii_dlhandle *) malloc(sizeof(gii_dlhandle))) == NULL) {
		ggFreeModule(hand.handle);
		return NULL;
	}
	memcpy(hp, &hand, sizeof(gii_dlhandle));

	return hp;
}

int _giiCloseDL(gii_dlhandle *hand) {
	ggFreeModule(hand->handle);
	return 0;
}
