/*								-*- C++ -*-
 * $Id: WIN_frame.cpp,v 1.4 1999/08/20 12:16:44 wg Exp $
 *
 * Purpose: base class for all frames
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_frame.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxApp
#define  Uses_wxButton
#define  Uses_wxFrame
#define  Uses_wxGDI
#define  Uses_wxList
#define  Uses_wxMenuBar
#define  Uses_wxMessage
#define  Uses_wxToolBar
#include "wx.h"
#define  Uses_ShellWidget
#define  Uses_BoardWidget
#include <widgets.h>

// simplify setting of args
#define SET_ARG(n, v) {				\
   args[num_args].name = n;			\
   args[num_args].value = (long int)v;		\
   ++num_args;					\
}

//-----------------------------------------------------------------------------
// create and destroy frame
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxFrame, wxPanel)

wxFrame::wxFrame(void) : wxPanel()
{
    __type = wxTYPE_FRAME;

    menubar         = NULL;
    toolbar         = NULL;
    toolbar_pos     = wxALIGN_TOP;
    status          = NULL;
    num_status      = 0;
    is_shown        = FALSE;
    being_destroyed = FALSE;

    // adjust panel placement variables
    h_margin = 0;
    v_margin = 0;
    fit_one_child = TRUE;

    // modality
    modal = modal_showing = FALSE;
}

wxFrame::wxFrame(wxFrame *parent, Const char *title,
		 int x, int y, int width, int height, int style, Constdata char *name)
    : wxPanel()
{
    __type = wxTYPE_FRAME;

    menubar         = NULL;
    toolbar         = NULL;
    toolbar_pos     = wxALIGN_TOP;
    status          = NULL;
    num_status      = 0;
    is_shown        = FALSE;
    being_destroyed = FALSE;

    // adjust panel placement variables
    h_margin = 0;
    v_margin = 0;
    fit_one_child = TRUE;

    // modality
    modal = modal_showing = FALSE;

    Create(parent, title, x, y, width, height, style, name);
}

wxFrame::~wxFrame(void)
{
    being_destroyed = TRUE;
    // hide frame
    Show(FALSE);
    // destroy private children (menubar, toolbar, statusline)
    if (menubar)
	delete menubar;
    if (num_status && status) {
	for (int i=0; i<num_status; ++i)
	    delete status[i];
	delete[] status;
    }
#if USE_TOOLBAR
    if (toolbar)
	delete toolbar;
#endif
    // reset variables
    toolbar = NULL; menubar = NULL; status = NULL; num_status = 0;
    // destroy children first to popdown child frames
    DestroyChildren();

    // should the deletion of the frame exit the application?
#if !WXGARBAGE_COLLECTION_ON
    wxTopLevelFrames.DeleteObject(this); // remove this for list
#endif
    if (wxTheApp->GetExitOnFrameDelete() && wxTheApp->GetInitFrame() == this)
	wxTheApp->ExitMainLoop();
#if !WXGARBAGE_COLLECTION_ON
    if (!wxTheApp->GetExitOnFrameDelete() && wxTopLevelFrames.Number() == 0)
	wxTheApp->ExitMainLoop();
#endif

    // destroy widget and discard all events on the queue
    if (FWidget()) {
	RemoveEventHandlers();
	XtDestroyWidget(FWidget());
    }
    FWidget() = HWidget() = PWidget() = NULL;
    // XSync(wxAPP_DISPLAY, FALSE);
}

Bool wxFrame::Create(wxFrame *frame_parent, Const char *title,
		     int x, int y, int width, int height,
		     int _style, Constdata char *name)
{
    Widget parent_widget;

    Arg args[10]; int num_args = 0;

    // chain child <-> parent
    if ((parent = frame_parent)) {
 	parent_widget = frame_parent->FWidget();
	parent->AddChild(this);
    } else {
	parent_widget = wxAPP_TOPLEVEL;
	// transfer startup options
	if (wxTopLevelFrames.Number() == 0) {
	    SET_ARG(XtNgeometry, wxAPP_GEOMETRY);
	    SET_ARG(XtNiconic,   wxAPP_ICONIC);
	}
#if !WXGARBAGE_COLLECTION_ON
	wxTopLevelFrames.Append(this);
#endif
    }

    if (x      > -1) SET_ARG(XtNx, x);
    if (y      > -1) SET_ARG(XtNy, y);
    SET_ARG(XtNwidth,  (width  > 0 ? width  : 1000));
    SET_ARG(XtNheight, (height > 0 ? height : 1000));
    SET_ARG(XtNinput,  TRUE);

    // create top level or transient shell
    if ( (style = _style) & wxTRANSIENT ) {
	// create transient shell with WM_TRANSIENT_FOR property
	wxWindow *p;
	for (p = wxFindFrame(parent); p; p = wxFindFrame(p->GetParent()))
	    if ( !(p->GetWindowStyleFlag() & wxTRANSIENT) )
		break;
	SET_ARG(XtNsaveUnder, FALSE);
	SET_ARG(XtNtransientFor, (p ? p->FWidget() : wxAPP_TOPLEVEL));

	FWidget() = XtCreatePopupShell
	    (name, transientShellWidgetClass, parent_widget,
	     args, num_args);
    } else {
	// create top level shell
	FWidget() = XtCreatePopupShell
	    (name, topLevelShellWidgetClass, parent_widget,
	     args, num_args);
    }
    // set common data
    SetTitle((char*)title);
    // create private frame widget (container for menubar, toolbar, statusline)
    PWidget() = XtVaCreateManagedWidget(
	name, xfwfBoardWidgetClass, FWidget(),
	XtNhighlightThickness, 0,
	XtNbackground, bg.GetPixel(&cmap),
	NULL);
    // create board widget
    HWidget() = XtVaCreateManagedWidget(
	name, xfwfBoardWidgetClass, PWidget(),
	XtNhighlightThickness, 0,
	XtNbackground, bg.GetPixel(&cmap),
	NULL);
    AddEventHandlers();
    return TRUE;
}

//-----------------------------------------------------------------------------
// leave place for menubar, toolbar and statusline
//-----------------------------------------------------------------------------

void wxFrame::Centre(int direction)
{
    int x=-1,       y=-1,       width=0,      height=0,
	parent_x=0, parent_y=0, parent_width, parent_height;

    // get position and width of parent
    if (parent) {
	parent->GetPosition(&parent_x, &parent_y);
	parent->GetSize(&parent_width, &parent_height);
    } else {
	wxDisplaySize(&parent_width, &parent_height);
    }
    // get position and size of THIS window
    if (direction & wxCENTRE_TOPLEFT) {
	x = parent_x + parent_width / 2;
	y = parent_y + parent_height / 2;
    } else {
	GetPosition(&x, &y); GetSize(&width, &height);
	// compute centered position
	if (direction & wxHORIZONTAL)
	    x = parent_x + (parent_width - width) / 2;
	if (direction & wxVERTICAL)
	    y = parent_y + (parent_height - height) / 2;
    }
    // move window
    Move(x, y);
}

void wxFrame::GetPosition(int *x, int *y)
{
    if (!FWidget()) { // forbid, if no widget associated
	*x = *y = 0;
	return;
    }

    // use parent method, if a frame has a parent or if not realized yet
    if (/*GetParent() ||*/ !XtWindow(FWidget())) {
	wxPanel::GetPosition(x, y);
	return;
    }

    // search for the parent that is child of ROOT, because the WM may
    // reparent twice and notify only the next parent (like FVWM)
    Window parent_window = XtWindow(FWidget());
    Window next_parent   = XtWindow(FWidget());
    Window root          = RootWindowOfScreen(XtScreen(FWidget()));
    while (next_parent != root) {
	Window *children; unsigned int n;
	parent_window = next_parent;
	XQueryTree(XtDisplay(FWidget()), parent_window, &root, &next_parent, &children, &n);
	XFree(children); // not needed
    }
    int xx, yy; unsigned int dummy;
    XGetGeometry(XtDisplay(FWidget()), parent_window, &root,
		 &xx, &yy, &dummy, &dummy, &dummy, &dummy);
    if (x) *x = xx;
    if (y) *y = yy;
}

void wxFrame::GetToolSizes(int *mheight, int *sheight, int *twidth, int *theight)
{
    *mheight = *sheight = *theight = *twidth = 0;

    if (menubar)
	menubar->GetSize(NULL, mheight);
    if (status && status[0])
	status[0]->GetSize(NULL, sheight);
#if USE_TOOLBAR
    if (toolbar)
	if (toolbar_pos == wxALIGN_LEFT || toolbar_pos == wxALIGN_RIGHT)
	    toolbar->GetSize(twidth, NULL);
	else
	    toolbar->GetSize(NULL, theight);
#endif
}

void wxFrame::SetClientSize(int WXUNUSED(x), int WXUNUSED(y), int width, int height)
{
    // !!! x and y are ignored since wxFrame has it's own policy !!!
    int mheight, sheight, twidth, theight;
    GetToolSizes(&mheight, &sheight, &twidth, &theight);
    // set frame size with additional needs
    SetSize(width + twidth + 2*h_margin,
	    height + mheight + theight + sheight + 2*v_margin);
}

void wxFrame::SetSize(int x, int y, int width, int height, int flags)
{
    // there is a problem to position the frame to (0, 0)
    // if the frame is invisible (is_shown == FALSE) I position the frame to
    // (1, 1) and afterwards to (x, y).
    if (!is_shown && x == 0 || y == 0)
	wxWindow::Move(1, 1);
    wxWindow::SetSize(x, y, width, height, flags);
}

//-----------------------------------------------------------------------------
// iconize, maximize
//-----------------------------------------------------------------------------

void wxFrame::Iconize(Bool iconize)
{
    XtVaSetValues(FWidget(), XtNiconic, iconize, NULL);
}

Bool wxFrame::Iconized(void) const
{
    return !IsMapped();
}

Bool wxFrame::IsMapped(void) const
{
    return mapped;
}

void wxFrame::Maximize(Bool WXUNUSED(maximize))
{
}

//-----------------------------------------------------------------------------
// status line
//-----------------------------------------------------------------------------

void wxFrame::CreateStatusLine(int number)
{
    if (StatusLineExists())
	return;

    // create statusline from messages
    status = wxNEW wxMessage* [num_status = wxMin(number, wxMAX_STATUS)];
    int i;
    for (i = 0; i < num_status; ++i) status[i] = NULL;
    for (i = 0; i < num_status; ++i) {
	char statusname[80]; sprintf(statusname, "status%d", i);
	status[i] = wxNEW wxMessage(this, "", 0, 0,
				    wxBORDER | wxPRIVATE_CHILD | wxUSE_BUTTON_FONT,
				    statusname);
	status[i]->AllowResize(FALSE);
    }
    // reposition status line
    PreResize();
}

void wxFrame::SetStatusText(Const char *text, int number)
{
    if (number>=0 && number<num_status)
	status[number]->SetLabel(text ? text : "");
}

Bool wxFrame::StatusLineExists(void) const
{
    return (num_status != 0);
}

//-----------------------------------------------------------------------------
// associated items
//-----------------------------------------------------------------------------

wxMenuBar *wxFrame::GetMenuBar(void)
{
    return menubar;
}

wxToolBar *wxFrame::GetToolBar(void)
{
    return toolbar;
}

void wxFrame::SetIcon(wxIcon *new_icon)
{
    if (new_icon && new_icon->Ok()) {
	icon = new_icon;
	XtVaSetValues(FWidget(), XtNiconPixmap, icon.GetPixmap(), NULL);
	XtVaSetValues(FWidget(), XtNiconMask, icon.GetMask(), NULL);
    }
}

void wxFrame::SetMenuBar(wxMenuBar *new_menubar)
{
    // destroy old menubar and create new menubar
    if (menubar)		  menubar->Destroy();
    if ((menubar = new_menubar))  menubar->Create(this, wxPRIVATE_CHILD);
    // reposition everything
    PreResize();
}

void wxFrame::SetToolBar(wxToolBar *new_toolbar, int alignment)
{
#if USE_TOOLBAR
    // assign new toolbar and toolbar position
    toolbar_pos = alignment;
    toolbar     = new_toolbar;
    if (toolbar) {
	// recompute orientation of toolbar
	if (toolbar_pos == wxALIGN_TOP || toolbar_pos == wxALIGN_BOTTOM)
	    toolbar->SetOrientation(wxHORIZONTAL);
	else
	    toolbar->SetOrientation(wxVERTICAL);
	// Fit toolbar
	float ww, hh;
	toolbar->GetMaxSize(&ww, &hh);
	toolbar->SetSize(int(ww), int(hh));
    }
    // reposition everything
    PreResize();
#else
    toolbar_pos = alignment;
    toolbar     = NULL;
    wxError("no wxToolBar option compiled in", "wxFrame");
#endif
}

//-----------------------------------------------------------------------------
// miscellaneous
//-----------------------------------------------------------------------------

void wxFrame::ChangeColours(void)
{
    wxPanel::ChangeColours();
    if (PWidget())
	XtVaSetValues(PWidget(),
		      XtNbackground,  bg.GetPixel(&cmap),
		      XtNforeground,  fg.GetPixel(&cmap),
		      XtNborderColor, bg.GetPixel(&cmap),
		      NULL);
}

void wxFrame::Command(int id)
{
    GetEventHandler()->OnMenuCommand(id);
}

void wxFrame::LoadAccelerators(char *WXUNUSED(resource))
{
}

void wxFrame::MakeModal(Bool mod)
{
    if (!modal_showing && !is_shown)
	modal = mod;
}

Bool wxFrame::Show(Bool show)
{
    if (show == is_shown) // do nothing if state doesn't change
	return TRUE;

#if WXGARBAGE_COLLECTION_ON
    // adjust list of top level frames
    if (show)
	wxTopLevelFrames.Append(this);
    else
	wxTopLevelFrames.DeleteObject(this);
#endif

    if ((is_shown = show)) {
	if (!XtIsRealized(FWidget())) {
	    XtRealizeWidget(FWidget());
	    // make a WM_PROTOCOLS atom if necessary
	    XInternAtom(XtDisplay(FWidget()), "WM_PROTOCOLS", False);
	    Atom WM_atom[1];
	    WM_atom[0] = XInternAtom(XtDisplay(FWidget()), "WM_DELETE_WINDOW", False);
	    XSetWMProtocols(XtDisplay(FWidget()), XtWindow(FWidget()), WM_atom, 1);
	}
	XtPopup(FWidget(), XtGrabNone);
    } else {
	XtPopdown(FWidget());
    }

    // handle modality
    if (show) {
	if (modal) {
	    if (modal_showing)
		return TRUE;
	    wxModalShowingStack.Insert((wxObject*)TRUE);
	    wxModalFrames.Insert(this);
	    modal_showing = TRUE;
	    XtAddGrab(FWidget(), TRUE, FALSE);
#if WXDEBUG_EVENTS
	    if (wxAPP_DEBUGEVENTS)
		printf("----- modal dialog -----\n");
#endif
	    while ((wxModalShowingStack.Number() > 0)
	    && (Bool)wxModalShowingStack.First()->Data()) {
		XEvent event;
#if 0
		// we can't allow thread exits because of the grab
		wxThreadYield(FALSE);
#endif
		XtAppNextEvent(wxAPP_CONTEXT, &event);
#if WXDEBUG_EVENTS
		if (wxAPP_DEBUGEVENTS) {
		    // print widgetname and event number
		    Widget w; int type = event.xany.type;
		    static const char* const event_name[] = {
			"", "unknown(-)",                                         // 0-1
			"KeyPress", "KeyRelease", "ButtonPress", "ButtonRelease", // 2-5
			"MotionNotify", "EnterNotify", "LeaveNotify", "FocusIn",  // 6-9
			"FocusOut", "KeymapNotify", "Expose", "GraphicsExpose",   // 10-13
			"NoExpose", "VisibilityNotify", "CreateNotify",           // 14-16
			"DestroyNotify", "UnmapNotify", "MapNotify", "MapRequest",// 17-20
			"ReparentNotify", "ConfigureNotify", "ConfigureRequest",  // 21-23
			"GravityNotify", "ResizeRequest", "CirculateNotify",      // 24-26
			"CirculateRequest", "PropertyNotify", "SelectionClear",   // 27-29
			"SelectionRequest", "SelectionNotify", "ColormapNotify",  // 30-32
			"ClientMessage", "MappingNotify",                         // 33-34
			"unknown(+)"};                                            // 35
		    type = wxMin(35, type); type = wxMax(1, type);
		    w = XtWindowToWidget(event.xany.display, event.xany.window);
		    printf("%-17s: %s(%p)\n", event_name[type], (w ? XtName(w) : "unknown"), w);
		    fflush(stdout);
		}
#endif
		XtDispatchEvent(&event);
	    }
#if WXDEBUG_EVENTS
	    if (wxAPP_DEBUGEVENTS) {
		printf("--------- done ---------\n");
		fflush(stdout);
	    }
#endif
	    // Remove modal dialog flag from stack
	    wxNode *node = wxModalShowingStack.First();
	    if (node) {
		delete node;
		delete wxModalFrames.First();
	    }
	} else
	    modal_showing = FALSE;
    } else {
	if (modal_showing) {
	    XtRemoveGrab(FWidget());
	    modal_showing = FALSE;
	    wxNode *node = wxModalShowingStack.First();
	    if (node)
		node->SetData((wxObject *)FALSE);
	}
	XFlush(XtDisplay(wxAPP_TOPLEVEL));
	XSync(XtDisplay(wxAPP_TOPLEVEL), FALSE);
    }

    // Now process all events, to ensure focus out before anything else
//     if (!being_destroyed)
// 	wxFlushEvents();

    return TRUE;
}

//-----------------------------------------------------------------------------
// special hints for the window manager
//-----------------------------------------------------------------------------

void wxFrame::GetBaseSize(int *base_width, int *base_height)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaGetValues(FWidget(), XtNbaseWidth,  base_width,
		            XtNbaseHeight, base_height, NULL);
}

void wxFrame::SetBaseSize(int base_width, int base_height)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaSetValues(FWidget(), XtNbaseWidth,  base_width,
		            XtNbaseHeight, base_height, NULL);
}

void wxFrame::GetIncrement(int *x_inc, int *y_inc)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaGetValues(FWidget(), XtNwidthInc,  x_inc,
		            XtNheightInc, y_inc, NULL);
}

void wxFrame::SetIncrement(int x_inc, int  y_inc)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaSetValues(FWidget(), XtNwidthInc,  x_inc,
		            XtNheightInc, y_inc, NULL);
}

void wxFrame::GetMaxSize(int *max_width, int *max_height)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaGetValues(FWidget(), XtNmaxWidth,  max_width,
		            XtNmaxHeight, max_height, NULL);
}

void wxFrame::SetMaxSize(int max_width, int  max_height)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaSetValues(FWidget(), XtNmaxWidth,  max_width,
		            XtNmaxHeight, max_height, NULL);
}

void wxFrame::GetMinSize(int *min_width, int *min_height)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaGetValues(FWidget(), XtNminWidth,  min_width,
		            XtNminHeight, min_height, NULL);
}

void wxFrame::SetMinSize(int min_width, int  min_height)
{
    if (!FWidget()) return; // forbid, if no widget associated
    XtVaSetValues(FWidget(), XtNminWidth,  min_width,
		            XtNminHeight, min_height, NULL);
}

//-----------------------------------------------------------------------------
// virtual event functions
//-----------------------------------------------------------------------------

Bool wxFrame::OnCharHook(wxKeyEvent& event)
{
    // route to wxApp:OnCharHook()
    if (wxTheApp)
	return wxTheApp->OnCharHook(event);
    return FALSE;
}

void wxFrame::OnCommand(wxWindow& WXUNUSED(win), wxCommandEvent& WXUNUSED(event))
{
    // routing stops here
}

void wxFrame::OnDefaultAction(wxItem *item)
{
    // if a default item is associated with this panel, execute it
    if (default_item) {
	wxCommandEvent event(wxEVENT_TYPE_BUTTON_COMMAND);
	// make item available for callback or OnCommand
	event.clientData = (char*)item;
	default_item->Command(event);
	return;
    }
    // routing stops here
}

Bool wxFrame::OnHotKey(wxKeyEvent& event)
{
    // first try hotkey handling of menubar
    Bool handled = (menubar && menubar->OnHotKey(event));

    return (handled ? TRUE : wxPanel::OnHotKey(event));
}

void wxFrame::OnMenuSelect(int id)
{
    SetStatusText(menubar->GetHelpString(id));
}

void wxFrame::PreResize(int x, int y, int width, int height)
{
    // get sizes
    int fwidth, fheight, twidth, theight, mheight, sheight;
    GetSize(&fwidth, &fheight);
    GetToolSizes(&mheight, &sheight, &twidth, &theight);
    // client size: cwidth and cheight are set immediately
    //              cx and cy depend on toolbar position
    int cx      = h_margin,
	cy      = v_margin + mheight,
	cwidth  = fwidth - twidth - 2*h_margin,
	cheight = fheight - mheight - sheight - theight - 2*v_margin;
    // position menubar
    if (menubar)
	menubar->SetSize(0, 0, fwidth, mheight);
    // position status line fields
    if (status && status[0]) {
	// all status fields (but the last) should habe equal sizes
	int i = 0, part = (fwidth-4) / num_status;
	for (/**/; i < num_status - 1; ++i)
	    status[i]->SetSize(i*part + 2, fheight - sheight, part, -1);
	status[i]->SetSize(i*part + 2, fheight - sheight, part + (fwidth-4) % num_status, -1);
    }
#if USE_TOOLBAR
    // position toolbar
    if (toolbar)
	switch (toolbar_pos) {
	default: case wxALIGN_TOP:
	    toolbar->SetSize(0, mheight, fwidth, -1);
	    cy += theight;
	    break;
	case wxALIGN_LEFT:
	    toolbar->SetSize(0, mheight, -1, fheight-mheight-sheight);
	    cx += twidth;
	    break;
	case wxALIGN_BOTTOM:
	    toolbar->SetSize(0, fheight-theight-sheight, fwidth, -1);
	    break;
	case wxALIGN_RIGHT:
	    toolbar->SetSize(fwidth-twidth, mheight, -1, fheight-mheight-sheight);
	    break;
	}
#endif

//     // for debugging purposes
//     printf("Frame(%s, %d x %d): "
// 	   "MenuBar(%d x %d) "
// 	   "ToolBar(%d x %d, %d) "
// 	   "Status(%d x %d, %d)\n"
// 	   "-->Client area at %d %d size %d %d\n",
// 	   GetName(), width,  height,
// 	   fwidth, mheight,
// 	   twidth, theight, toolbar_pos,
// 	   fwidth, sheight, num_status,
// 	   cx, cy, cwidth, cheight);

    // set client size (don't use specialized wxFrame or wxPanel methods)
    wxWindow::SetClientSize(cx, cy, cwidth, cheight);
    // chain to wxPanel method
    GetPosition(&x, &y); // when a frame is only resized, (x,y) is (0,0)
    wxPanel::PreResize(x, y, width, height);
}
