;;;
;;;  cmail-search.el - utility functions for searching
;;; 
;;;  $Author: iwa $
;;;  created at: Fri Jun  8 13:22:49 JST 1994
;;;
;;;  Copyright (C) 1992-1996 Yukihiro Matsumoto.

(provide 'cmail-search)

(defvar *cmail-last-search-regexp nil)
(defconst *cmail-search-buf " *cmail-search")

(defun cmail-search-mail-forward (page regxp)
  (save-excursion
    (cmail-get-folder)
    (cmail-n-page page)
    (let ((buf (get-buffer-create *cmail-search-buf)))
      (save-excursion
	(set-buffer buf)
	(erase-buffer))
      (copy-to-buffer buf (point) (cmail-page-max))
      (set-buffer buf)
      (let ((code (detect-coding-region (point-min) (point-max))))
	(if (listp code) (setq code (car code)))
	(decode-coding-region (point-min) (point-max) code))
      (re-search-forward regxp nil t))))

(defun cmail-search-mail-backward (page regxp)
  (save-excursion
    (cmail-get-folder)
    (cmail-n-page page)
    (let ((buf (get-buffer-create *cmail-search-buf)))
      (save-excursion
	(set-buffer buf)
	(erase-buffer))
      (copy-to-buffer buf (point) (cmail-page-max))
      (set-buffer buf)
      (let ((code (detect-coding-region (point-min) (point-max))))
	(if (listp code) (setq code (car code)))
	(decode-coding-region (point-min) (point-max) code))
      (goto-char (point-max))
      (re-search-backward regxp nil t))))

(defun cmail-summary-search-article-forward (regexp)
  "Search for an article containing REGEXP forward."
  (interactive
   (list (read-string
	  (concat (cmail-get-resource 'summary-search-article-forward-1)
		  (if *cmail-last-search-regexp
		      (cmail-format-resource1 'summary-search-article-forward-2
					      *cmail-last-search-regexp))))))
  (if (string-equal regexp "")
      (setq regexp (or *cmail-last-search-regexp ""))
    (setq *cmail-last-search-regexp regexp))
  (let ((found nil) page)
    (forward-line 1)
    (while (and (null found) (not (eobp)))
      (cmail-fixcp)
      (setq page (cmail-get-page-number-from-summary))
      (if (cmail-search-mail-forward page regexp)
	  (save-excursion
	    (setq found t)
	    (cmail-show-contents page)
	    (let ((oldwin (selected-window)))
	      (unwind-protect
		  (progn
		    (pop-to-buffer *cmail-mail-buffer)
		    (widen)
		    (re-search-forward regexp nil t)
		    (cmail-narrow-to-page)
		    (recenter (/ (window-height) 2)))
		(select-window oldwin))))
	(forward-line 1)))
    (and (get-buffer *cmail-search-buf) (kill-buffer *cmail-search-buf))
    (cmail-fixcp)
    (if (not found) (cmail-error-resource1 'summary-search-article-forward-3
					   regexp))))

(defun cmail-summary-search-article-backward (regexp)
  "Search for an article containing REGEXP backward."
  (interactive
   (list (read-string
	  (concat (cmail-get-resource 'summary-search-article-backward-1)
		  (if *cmail-last-search-regexp
		      (cmail-format-resource1 'summary-search-article-forward-2
					      *cmail-last-search-regexp))))))
  (if (string-equal regexp "")
      (setq regexp (or *cmail-last-search-regexp ""))
    (setq *cmail-last-search-regexp regexp))
  (let ((found nil) page)
    (forward-line -1)
    (while (and (null found) (not (bobp)))
      (cmail-fixcp)
      (setq page (cmail-get-page-number-from-summary))
      (if (cmail-search-mail-backward page regexp)
	  (save-excursion
	    (setq found t)
	    (cmail-show-contents page)
	    (let ((oldwin (selected-window)))
	      (unwind-protect
		  (progn
		    (pop-to-buffer *cmail-mail-buffer)
		    (widen)
		    (re-search-forward regexp nil t)
		    (cmail-narrow-to-page)
		    (recenter (/ (window-height) 2)))
		(select-window oldwin))))
	(forward-line -1)))
    (and (get-buffer *cmail-search-buf) (kill-buffer *cmail-search-buf))
    (cmail-fixcp)
    (if (not found) (cmail-error-resource1 'summary-search-article-forward-3
					   regexp))))

(defun cmail-summary-isearch-article ()
  "Do incremental search forward on current article."
  (interactive)
  (let ((page (cmail-get-page-number-from-summary)))
    (or (get-buffer-window *cmail-mail-buffer)
	(string= cmail-current-folder *cmail-current-folder)
	(= page *cmail-current-page)
	(cmail-show-contents page)))
  (let ((w (selected-window)))
    (unwind-protect
	(progn
	  (pop-to-buffer *cmail-mail-buffer)
	  (widen)
	  (isearch-forward))
      (select-window w))))

;;; cmail-search.el ends here
