/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"rfc1035.h"
#include	"rfc1035mxlist.h"
#include	"rfc1035_res.h"

static const char rcsid[]="$Id: rfc1035mxlist.c,v 1.3 1999/12/06 13:24:23 mrsam Exp $";

void rfc1035_mxlist_free(struct rfc1035_mxlist *p)
{
struct rfc1035_mxlist *q;

	while (p)
	{
		q=p->next;
		if (p->hostname)	free(p->hostname);
		free(p);
		p=q;
	}
}

static int addrecord(struct rfc1035_mxlist **list, const char *mxname,
	int mxpreference, struct in_addr *in)
{
struct sockaddr_in sin;
struct rfc1035_mxlist *p;

	if ((p=(struct rfc1035_mxlist *)malloc(sizeof(struct rfc1035_mxlist)))
		== 0 || (p->hostname=malloc(strlen(mxname)+1)) == 0)
	{
		if (p)	free ( (char *)p);
		return (-1);
	}

	sin.sin_family=AF_INET;
	sin.sin_addr= *in;
	sin.sin_port=0;

	while ( *list && (*list)->priority < mxpreference )
		list= &(*list)->next;

	p->next=*list;
	*list=p;
	p->priority=mxpreference;
	strcpy(p->hostname, mxname);
	memcpy(&p->address, &sin, sizeof(sin));
	return (0);
}

static int add_arecords(struct rfc1035_res *res, struct rfc1035_mxlist **list,
	struct rfc1035_reply *mxreply,
	int mxpreference,
	char *mxname)
{
RFC1035_UINT32 n=rfc1035_aton(mxname);
struct in_addr in;
struct rfc1035_reply *areply=0;
int	index;
int	found=0;

	if (n != (RFC1035_UINT32)-1)
	{	/* Broken MX record */

		in.s_addr=n;
		if (addrecord(list, inet_ntoa(in), mxpreference, &in))
			return (RFC1035_MX_INTERNAL);
		return (RFC1035_MX_OK);
	}

	if (!mxreply || (index=rfc1035_replysearch_all( mxreply, mxname,
					RFC1035_TYPE_A,
					RFC1035_CLASS_IN,
					0)) < 0)
	{
		index=rfc1035_resolve_cname(res,
			RFC1035_RESOLVE_RECURSIVE, mxname,
			RFC1035_TYPE_A,
			RFC1035_CLASS_IN, &areply);
		if (index < 0)
		{
			if (!areply)
			{
				if (index == RFC1035_ERR_CNAME_RECURSIVE)
					return (RFC1035_MX_BADDNS);
				return (RFC1035_MX_INTERNAL);
			}

			if (areply->rcode == RFC1035_RCODE_NXDOMAIN ||
				areply->rcode == RFC1035_RCODE_NOERROR)
			{
				rfc1035_replyfree(areply);
				return (RFC1035_MX_HARDERR);
			}
			rfc1035_replyfree(areply);
			return (RFC1035_MX_SOFTERR);
		}
		mxreply=areply;
	}

	for ( ; index >= 0 ;
			index=rfc1035_replysearch_all( mxreply, mxname,
					RFC1035_TYPE_A,
					RFC1035_CLASS_IN,
					index+1))
	{
		if (mxreply->allrrs[index]->rrtype != RFC1035_TYPE_A)
			continue;
		found=1;
		in.s_addr=mxreply->allrrs[index]->rr.inaddr.s_addr;
		if (addrecord(list, mxname, mxpreference, &in))
		{
			if (areply)
				rfc1035_replyfree(areply);
			return (RFC1035_MX_INTERNAL);
		}
	}
	if (areply)
		rfc1035_replyfree(areply);
	if (!found)	return (RFC1035_MX_HARDERR);
	return (RFC1035_MX_OK);
}

static int domxlistcreate(struct rfc1035_res *res,
	const char *q_name, struct rfc1035_mxlist **list)
{
char	namebuf[RFC1035_MAXNAMESIZE+1];
struct	rfc1035_reply *replyp;
int	index;

	*list=0;

	if (rfc1035_aton(q_name) != (RFC1035_UINT32)-1)
		return (RFC1035_MX_HARDERR);	/* Don't gimme an IP address */

	strcpy(namebuf, q_name);
	if (namebuf[0] == '[')
	{
	char	*q=strchr(namebuf, ']');
	RFC1035_UINT32 n;
	struct in_addr in;

		if (!q || q[1])	return (RFC1035_MX_HARDERR);	/* Bad addr */
		*q=0;
		n=rfc1035_aton(namebuf+1);
		if (n == (RFC1035_UINT32)-1)	return (RFC1035_MX_HARDERR);

		in.s_addr=n;
		if (addrecord(list, q_name, -1, &in))
			return (RFC1035_MX_INTERNAL);
		return (RFC1035_MX_OK);
	}

	index=rfc1035_resolve_cname(res,
		RFC1035_RESOLVE_RECURSIVE, namebuf,
		RFC1035_TYPE_MX,
		RFC1035_CLASS_IN, &replyp);

	if (index < 0)
	{
		if (!replyp)
		{
			if (index == RFC1035_ERR_CNAME_RECURSIVE)
				return (RFC1035_MX_BADDNS);
			return (RFC1035_MX_INTERNAL);
		}

		if (replyp->rcode == RFC1035_RCODE_NXDOMAIN ||
			replyp->rcode == RFC1035_RCODE_NOERROR)
		{
			rfc1035_replyfree(replyp);
			strcpy(namebuf, q_name);
			return (add_arecords(res, list, 0, -1, namebuf));
		}

		rfc1035_replyfree(replyp);
		return (RFC1035_MX_SOFTERR);
	}

	for ( ; index >= 0;
			index=rfc1035_replysearch_all( replyp, namebuf,
					RFC1035_TYPE_MX,
					RFC1035_CLASS_IN,
					index+1))
	{
	char	mxname[RFC1035_MAXNAMESIZE+1];

		if (replyp->allrrs[index]->rrtype != RFC1035_TYPE_MX)
			continue;

		if (rfc1035_replyhostname(replyp,
			replyp->allrrs[index]->rr.mx.mx_label, mxname) == 0)
			continue;

		switch (add_arecords(res, list, replyp,
			replyp->allrrs[index]->rr.mx.preference, mxname)) {
		case	RFC1035_MX_SOFTERR:
			rfc1035_replyfree(replyp);
			return (RFC1035_MX_SOFTERR);
		case	RFC1035_MX_INTERNAL:
			rfc1035_replyfree(replyp);
			return (RFC1035_MX_INTERNAL);
		case	RFC1035_MX_BADDNS:
			rfc1035_replyfree(replyp);
			return (RFC1035_MX_BADDNS);
		}
	}

	rfc1035_replyfree(replyp);
	if (*list)	return (RFC1035_MX_OK);
	return (RFC1035_MX_HARDERR);
}

static int domxlistcreate2(struct rfc1035_res *res,
	const char *q_name, struct rfc1035_mxlist **list)
{
char	*buf;
int	rc;

	if (strchr(q_name, '.') || !res->rfc1035_defaultdomain)
		return (domxlistcreate(res, q_name, list));

	if ((buf=malloc(strlen(q_name)+
		strlen(res->rfc1035_defaultdomain)+2)) == 0)
		return (-1);

	strcat(strcat(strcpy(buf, q_name), "."), res->rfc1035_defaultdomain);

	rc=domxlistcreate(res, buf, list);

	free(buf);
	return (rc);
}

int rfc1035_mxlist_create(struct rfc1035_res *res,
	const char *q_name, struct rfc1035_mxlist **list)
{
int	rc=domxlistcreate2(res, q_name, list);

	if (rc != RFC1035_MX_OK)
	{
		rfc1035_mxlist_free(*list);
		*list=0;
	}
	return (rc);
}
