/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * cont_install.c
 */
#include <stdio.h>
#include <constants.h>
#include <defaults.h>
#include <pm.h>
#include "cont_defaults.h"
#include <continue.h>
#include <utilities.h>

static char *CONT_OBJ_NAME = "Cont";


static char *CONT[] = {	
"Cont.Stpsize" ,"Cont.Mode" , "Cont.M_Names" ,"Cont.Iters" ,"Cont.Direction" ,
"Cont.Param" ,"Cont.Vary_Switch" ,"Cont.Jac_Update" ,"Cont.Abserr" ,
"Cont.Relerr" ,"Cont.Maxstp" ,"Cont.Minstp" ,"Cont.Target" ,
"Cont.Param_Fc" ,"Cont.Varb_Fc" ,"Cont.Funct_Fc", "Cont.Ews", 
"Cont.Search" , "Cont.Plot_0" , "Cont.Plot_1", 
"Cont.Plot_2", "Cont.Active_Params" , "Cont.Check_Switch" , "Cont.Forwards" ,
"Cont.Backwards" , "Cont.Continue" , "Cont.Debug_Level" , "Cont.Reset", 
"Cont.Set_Code", "Cont.GetState", "Cont.CopyState", "Cont.Compute_Functions",
"Cont.Get_Ews", "Cont.Num_Req_Param"
};

typedef enum {
STPSIZE=0, MODE, M_NAMES, ITERS, DIRECTION, PARAM, VARY_SWITCH,
JAC_UPDATE, ABSERR, RELERR, MAXSTEP, MINSTEP, TARGET, PARAM_FC,
VARB_FC, FUNCT_FC, EWS, SEARCH, PLOT_0, PLOT_1, PLOT_2, 
ACTIVE_PARAMS, CHECK_SWITCH, GO_FORWARDS, GO_BACKWARDS, GO_CONTINUE, 
DEBUG_LEVEL, RESET, SETCODE, GETSTATE, COPYSTATE, GETFUNCS, GET_EWS, 
NUM_REQ_PARAM 
} CONT_t;


void 
cont_install()
{
    int i;

pm(CREATE_OBJ, CONT_OBJ_NAME,
     CREATE_ELEM, CONT[STPSIZE], DBL,
     CREATE_ELEM, CONT[MODE], INT,
     CREATE_ELEM, CONT[M_NAMES], STRNG_LIST,
     CREATE_ELEM, CONT[ITERS], INT,
     CREATE_ELEM, CONT[DIRECTION], INT,
     CREATE_ELEM, CONT[PARAM], INT,
     CREATE_ELEM, CONT[VARY_SWITCH], INT ,
     CREATE_ELEM, CONT[JAC_UPDATE], INT,
     CREATE_ELEM, CONT[ABSERR], DBL,
     CREATE_ELEM, CONT[RELERR], DBL,
     CREATE_ELEM, CONT[MAXSTEP], DBL,
     CREATE_ELEM, CONT[MINSTEP], DBL,
     CREATE_ELEM, CONT[TARGET], DBL,
     CREATE_ELEM, CONT[PARAM_FC], DBL_LIST,
     CREATE_ELEM, CONT[VARB_FC], DBL_LIST,
     CREATE_ELEM, CONT[FUNCT_FC], DBL_LIST,
     CREATE_ELEM, CONT[EWS], STRNG_LIST,
     CREATE_ELEM, CONT[SEARCH], INT,
     CREATE_ELEM, CONT[PLOT_0], INT,
     CREATE_ELEM, CONT[PLOT_1], INT, 
     CREATE_ELEM, CONT[PLOT_2], INT,
     CREATE_ELEM, CONT[ACTIVE_PARAMS], INT_LIST,
     CREATE_ELEM, CONT[CHECK_SWITCH], INT,
     CREATE_ELEM, CONT[GO_FORWARDS], FNCT,
     CREATE_ELEM, CONT[GO_BACKWARDS], FNCT, 
     CREATE_ELEM, CONT[GO_CONTINUE], FNCT,
     CREATE_ELEM, CONT[DEBUG_LEVEL], INT,
     CREATE_ELEM, CONT[RESET], FNCT,
     CREATE_ELEM, CONT[SETCODE], INT,
     CREATE_ELEM, CONT[GETSTATE], FNCT,
     CREATE_ELEM, CONT[COPYSTATE], FNCT,
     CREATE_ELEM, CONT[GETFUNCS], FNCT,
     CREATE_ELEM, CONT[GET_EWS], FNCT,
     CREATE_ELEM, CONT[NUM_REQ_PARAM], INT_LIST,
     NULL);

	pm(CREATE_ELEM, "Memory.Continuation", MEMRY, NULL);  

        pm(INIT, CONT[M_NAMES], N_Cont, MAX_LONG_STR, 
           INIT, CONT[NUM_REQ_PARAM], N_Cont, 
           NULL);
        for (i=0; i<N_Cont ; i++ )
            pm(PUT, CONT[M_NAMES], i, Cont_Sel[i].Cont_Name, 
               PUT, CONT[NUM_REQ_PARAM], i, Cont_Sel[i].Num_Req_Param, 
               NULL);
     
        pm(INIT, CONT[RESET], 
           PUT, CONT[RESET], cont_reset, 
           INIT, CONT[GO_FORWARDS],
	   PUT, CONT[GO_FORWARDS], cont_forwards,
           INIT, CONT[GO_BACKWARDS], 
           PUT, CONT[GO_BACKWARDS], cont_backwards,
           INIT, CONT[GO_CONTINUE], 
           PUT, CONT[GO_CONTINUE], cont_continue,
           INIT, CONT[GETSTATE], 
           PUT, CONT[GETSTATE], cont_get_state,
           INIT, CONT[COPYSTATE], 
           PUT, CONT[COPYSTATE], cont_copy_state,
           INIT, CONT[GETFUNCS], 
           PUT, CONT[GETFUNCS], cont_compute_functions,
           INIT, CONT[GET_EWS], 
           PUT, CONT[GET_EWS], cont_get_ews,
           NULL);
}

void cont_reset()
{
  int v,p,f,i;

  get_n_all_types(&v, &p, &f);
  pm(INIT, CONT[VARB_FC], v,
     INIT, CONT[EWS], v, MAX_LONG_STR,
     INIT, CONT[PARAM_FC], p,
     INIT, CONT[FUNCT_FC], f,
     INIT, CONT[ACTIVE_PARAMS], p,
     NULL);
  pm(INIT, "Memory.Continuation", CONT_MEMORY,  
     NULL);
 
  pm(PUT, CONT[STPSIZE], CONT_STPSIZE,
     PUT, CONT[MODE], CONT_MODE,
     PUT, CONT[ITERS], CONT_ITERS,
     PUT, CONT[DIRECTION], CONT_DIRECTION,
     PUT, CONT[PARAM], CONT_PARAM,
     PUT, CONT[VARY_SWITCH], CONT_VARY_SWITCH ,
     PUT, CONT[JAC_UPDATE], CONT_JAC_UPDATE,
     PUT, CONT[ABSERR], CONT_ABSERR,
     PUT, CONT[RELERR], CONT_RELERR,
     PUT, CONT[MAXSTEP], CONT_MAXSTEP,
     PUT, CONT[MINSTEP], CONT_MINSTEP,
     PUT, CONT[TARGET], CONT_TARGET,
/*     PUT, CONT[PARAM_FC], CONT_PARAM_FC,
     PUT, CONT[FC], CONT_FC,			*/
     PUT, CONT[SEARCH], CONT_SEARCH,
     PUT, CONT[PLOT_0], CONT_PLOT_TYPE,
     PUT, CONT[PLOT_1], CONT_PLOT_TYPE, 
     PUT, CONT[PLOT_2], CONT_PLOT_TYPE,
     PUT, CONT[CHECK_SWITCH], CONT_CHECK_SWITCH, 
     PUT, CONT[DEBUG_LEVEL], CONT_DEBUG_LEVEL,
     NULL);

     for (i=0;i<Cont_Sel[CONT_MODE].Num_Req_Param;i++)  
         pm(PUT,CONT[ACTIVE_PARAMS],i,1, NULL);
     
}

