static char rcsid[] = "$Id: randfield.c,v 1.3 1997/07/18 03:11:14 dhb Exp $";

/*
** $Log: randfield.c,v $
** Revision 1.3  1997/07/18 03:11:14  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.2  1993/02/24 23:46:34  dhb
** 1.4 to 2.0 command argument changes.
**
** Revision 1.1  1992/12/11  19:03:40  dhb
** Initial revision
**
*/

#include "per_ext.h"

/* 1/89 Matt Wilson */
void do_random_field(argc,argv)
int 	argc;
char 	**argv;
{
char 		val[80];
float 		lower;
float 		upper;
float 		mean;
float 		sd;
float 		var;
char 		*field;
char		*path;
ElementList	*list;
int		i;
int		mode;
int		status;

    mode = -1;
    initopt(argc, argv, "path field -uniform low high -gaussian mean sd -exponential low high");
    while ((status = G_getopt(argc, argv)) == 1)
      {
	/*
	** check the distribution options
	*/
	if(strcmp(G_optopt,"-uniform") == 0){
	    mode = 0;
	    lower = Atof(optargv[1]);
	    upper = Atof(optargv[2]);
	} else if(strcmp(G_optopt,"-gaussian") == 0){
	    mode = 1;
	    mean = Atof(optargv[1]);
	    sd = Atof(optargv[2]);
	    var = sd*sd;
	} else if(strcmp(G_optopt,"-exponential") == 0){
	    mode = 2;
	    lower = Atof(optargv[1]);
	    upper = Atof(optargv[2]);
	}
      }

    if(status < 0 || mode == -1){
	printoptusage(argc, argv);
	printf("\n");
	printf("One of the command options must be given.\n");
	return;
    }

    path = optargv[1];
    field = optargv[2];

    /*
    ** make the element list
    */
    if((list = WildcardGetElement(path,1)) == NULL){
	InvalidPath(optargv[0],path);
	return;
    }
    /*
    ** set the fields
    */
    switch(mode){
    case 0:			/* uniform */
	for(i=0;i<list->nelements;i++){
	    sprintf(val,"%e",frandom(lower,upper));
	    SetElement(list->element[i],field,val);
	}
	break;
    case 1:			/* gaussian */
	for(i=0;i<list->nelements;i++){
	    sprintf(val,"%e",rangauss(mean,var));
	    SetElement(list->element[i],field,val);
	}
	break;
    case 2:			/* exponential */
	for(i=0;i<list->nelements;i++){
	    sprintf(val,"%e",-log(frandom(lower,upper)));
	    SetElement(list->element[i],field,val);
	}
	break;
    }
    FreeElementList(list);
    OK();
}

