/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef LISTPDEF
#define LISTPDEF

#include "geomclass.h"
#include "list.h"

struct List {
    GEOMFIELDS
    Geom 	*car;
    Handle	*carhandle;
    struct List	*cdr;
};

extern List *ListCreate( List *exist, GeomClass *, va_list );
extern void  ListDelete( List * );
extern List *ListCopy( List * );

extern List *ListImport( Pool * );
extern int   ListExport( List *, Pool * );
extern Geom *ListPick(List *list, Pick *p, Appearance *ap, Transform T);
extern List *ListDice(List *list, int nu, int nv);

#endif /*LISTPDEF*/
