#include "mgP.h"
#include "mgriP.h"

int
mgri_mesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    ColorA	*c;
    Color   *c3;
    Point3  *n;
    void    mgri_submesh();
    int u,v;

    ap = &_mgc->astk->ap;

    if(ap->flag & APF_FACEDRAW) {
	mgri_submesh( wrap, nu, nv, P, N, C);
    }
    
    if(ap->flag & APF_EDGEDRAW) {
    	RiAttributeBegin();
	RiGeometricRepresentation("lines");
	mgri_closer();
	c3 = &ap->mat->edgecolor;
	RiColor((float *)c3);
	mgri_submesh( wrap, nu, nv, P, N, C);
	RiAttributeEnd();
    }
    
    if((ap->flag & APF_NORMALDRAW) && N!=NULL) {
	Color *color = &_mgc->astk->mat.normalcolor;
	n = N;
	RiAttributeBegin();
	RiSurface(RI_CONSTANT, RI_NULL);
	RiColor((float *)color);
	for(u=0; u<nu; u++) {
	    for(v=0; v<nv; v++) {
	        mgri_drawnormal(&P[u + v * nu], &N[u + v * nu], color);
	    }
	}
	RiAttributeEnd();
    }
    
    return 1;
}

void
mgri_submesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    char    *uwrap,*vwrap;
    int     shading;
    int     i;
    register HPoint3 *p;
    register Point3  *n;
    register ColorA	*c;
    int     nunv;
    float   alpha;
    int colorsdefined;
    int normalsdefined;

    /* Ignore colors if overridden */
    if((_mgc->astk->mat.override & MTF_DIFFUSE) && !_mgc->astk->useshader)
	C = NULL;

    nunv = nu * nv;
    p = P;
    n = N;
    c = C;
	    
    ap = &_mgc->astk->ap;
    
    if(wrap & MM_UWRAP) uwrap = RI_PERIODIC;
    else uwrap = RI_NONPERIODIC;
    
    if(wrap & MM_VWRAP) vwrap = RI_PERIODIC;
    else vwrap = RI_NONPERIODIC;
    
    RiAttributeBegin(); // IS THIS NECESSARY!?

    /* Points */
    /* NOTES: Check to see if we can use Pw here!! */
    for(i=0; i<nunv; i++, p++) {
    	mgri_normalize(p, ript[i]);
    }
    
    /* use normals if supplied */
    if(N!=NULL) {
	for(i=0; i<nunv; i++, n++) {
	    bcopy((char *)n, (char *)rinormal[i], sizeof(float)*3);
	}
	normalsdefined=1;
    } else normalsdefined=0;
    
    /* use colors if supplied */
    if(C!=NULL) {
	for(i=0; i<nunv; i++, c++) {
	    //bcopy((char *)c, (char *)ricolor[i], sizeof(float)*3);
	    *(Color *)&ricolor[i] = *(Color *)c;
	}
	colorsdefined=1;
    } else colorsdefined=0;
	
	/* No Opacity in QuickRenderman */

    /* Define mesh via the renderman interface */
    if(!colorsdefined && normalsdefined)
	RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
	    RI_N, (RtPointer)rinormal, RI_NULL);
    else if(colorsdefined && !normalsdefined)
	RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
	    RI_CS, (RtPointer)ricolor, RI_NULL);
    else if(!colorsdefined && !normalsdefined)
	RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
	    RI_NULL);
    else RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
    	    RI_CS, (RtPointer)ricolor, RI_N, (RtPointer)rinormal, RI_NULL);

    RiAttributeEnd();
}
