#include "geom.h"
#include "pointlistP.h"

static char methods[][POINTLIST_MAXNAME] =
{
  POINTLIST_METHNAMES
};

void *pointlist_default(int sel, Geom *geom, va_list args);

void pointlist_init() {
  int i;

  for (i = 0; i < POINTLIST_MAXMETH; i++) 
	    GeomNewMethod(methods[i], pointlist_default);

  /* This should be the only place where the methods are mentioned by 
   * name. */
  ptlBezier_init();
  ptlInst_init();
  ptlList_init();
  ptlMesh_init();
  ptlPolylist_init();
  ptlQuad_init();
  ptlVect_init();

}

void pointlist_initspec(SpecFunc *specfunc, int n_func, GeomClass *class) {
  int i;

  for (i = 0; i < n_func; i++) 
    GeomSpecifyMethod(GeomMethodSel(specfunc[i].name), class, 
		     specfunc[i].func);
}

void *pointlist_default(int sel, Geom *geom, va_list args) {
  return NULL;
}

HPoint3 *PointList_get(Geom *geom, Transform T, int CoordSystem)
{
  return (HPoint3 *)GeomCall(GeomMethodSel("PointList_get"), geom,
			     T, CoordSystem);
}

HPoint3 *PointList_fillin(Geom *geom, Transform T, int CoordSystem,
			  HPoint3 *plist) {
  return (HPoint3 *)GeomCall(GeomMethodSel("PointList_fillin"), geom,
			     T, CoordSystem, plist);
}

void PointList_set(Geom *geom, int CoordSystem, HPoint3 *plist)
{
  GeomCall(GeomMethodSel("PointList_set"), geom, CoordSystem, plist);
}

int PointList_length(Geom *geom) {
  return (int)GeomCall(GeomMethodSel("PointList_length"), geom);
}
 

