.TH "alistat" 1 ""Dec 1998"" "HMMER 2.1.1" "HMMER Manual"

.SH NAME
.TP 
alistat - show statistics for a multiple alignment file

.SH SYNOPSIS
.B alistat
.I [options]
.I alignfile

.SH DESCRIPTION

.B alistat
reads a multiple sequence alignment from the file
.I alignfile
in any supported format (including SELEX, GCG MSF, and
CLUSTAL), and shows a number of simple statistics about it.
These statistics include the name of the format,
the number of sequences, the total number of residues,
the average and range of the sequence lengths, the
alignment length (e.g. including gap characters).

.PP
Also shown are some percent identities. A percent
pairwise alignment identity is defined as
.I (idents / MIN(len1, len2))
where 
.I idents
is the number of exact identities
and 
.I len1, len2
are the unaligned lengths of the two
sequences. The "average percent identity",
"most related pair", and "most unrelated pair"
of the alignment are the average, maximum, and
minimum of all 
(N)(N-1)/2 pairs, respectively.
The "most distant seq" is calculated by finding
the maximum pairwise identity (best relative) for all N sequences,
then finding the minimum of these N numbers (hence, 
the most outlying sequence).

.SH OPTIONS

.TP
.B -a 
Show additional verbose information: a table with one line per
sequence showing name, length, and its highest and lowest pairwise
identity. These lines are prefixed with a * character to enable
easily 
.BR grep' ing
them out and sorting them. For example,
.I alistat -a foo.slx | grep "*" | sort -n +3 
gives a ranked list of the most distant sequences
in the alignment. 
Incompatible with the
.B -f
option.

.TP 
.B -f 
Fast; use a sampling method to estimate the average %id.
When this option is chosen, 
.B alistat 
doesn't show the other three pairwise identity numbers.
This option is useful for very large alignments, for
which the full (N)(N-1) calculation of all pairs would
be prohibitive (e.g. Pfam's GP120 alignment, with over
10,000 sequences). Incompatible with the 
.B -a 
option.

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.SH SEE ALSO

.PP
alistat getseq seqstat sreformat

.SH AUTHOR

This software and documentation is Copyright (C) 1992-1998 Washington
University School of Medicine.  It is freely distributable under terms
of the GNU General Public License. See COPYING in the source code
distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


