; Add a few things that make Scheme a little nicer
(define (caaaar l) (caar (caar l)))
(define (cdaaar l) (cdar (caar l)))
(define (cadaar l) (cadr (caar l)))
(define (cddaar l) (cddr (caar l)))
(define (caadar l) (caar (cdar l)))
(define (cdadar l) (cdar (cdar l)))
(define (caddar l) (cadr (cdar l)))
(define (cdddar l) (cddr (cdar l)))
(define (caaadr l) (caar (cadr l)))
(define (cdaadr l) (cdar (cadr l)))
(define (cadadr l) (cadr (cadr l)))
(define (cddadr l) (cddr (cadr l)))
(define (caaddr l) (caar (cddr l)))
(define (cdaddr l) (cdar (cddr l)))
(define (cadddr l) (cadr (cddr l)))
(define (cddddr l) (cddr (cddr l)))

(define (<= x y)
  (or (< x y) (= x y)))

(define (>= x y)
  (or (> x y) (= x y)))

; hard-coded defaults
(define viewer-command "gvu")
(define lpr-command "lpr")
(define editor-command "xedplus")
(define help-command siaghelp)
(define filer-command "xfiler")

(define homedir (string-append (getenv "HOME") "/.siag"))

(if (not (string? homedir)) (set! homedir "/tmp"))

(if (not (stat homedir)) (mkdir homedir (string->number "700" 8)))

(define appfile (string-append homedir "/applications.scm"))

(define (save-applications)
  (let ((fp (fopen appfile "w")))
    (writes fp
	    "; Auto generated file. Do not edit.\n"
	    "(define viewer-command \"" viewer-command "\")\n"
	    "(define lpr-command \"" lpr-command "\")\n"
	    "(define editor-command \"" editor-command "\")\n"
	    "(define help-command \"" help-command "\")\n"
	    "(define filer-command \"" filer-command "\")\n")
    (fclose fp)))

(if (stat appfile)
    (require appfile)
    (save-applications))

(define (edit-applications)
  (let ((new nil)
	(viewer viewer-command)
	(lpr lpr-command)
	(editor editor-command)
	(help help-command)
	(filer filer-command)
	(int "Custom"))
    (form-begin)
    (form-label "Integration")
    (form-properties XtNwidth 120)
    (form-menu "int")
    (form-menuentry "Defaults")
    (form-menuentry "Gnome")
    (form-menuentry "KDE")
    (form-menuentry "CDE")
    (form-menuentry "Custom")
    (form-properties XtNlabel int XtNwidth 200)
    (form-newline)
    (input-field "Previewer" 120 "viewer" 200 viewer)
    (input-field "Printer" 120 "lpr" 200 lpr)
    (input-field "Editor" 120 "editor" 200 editor)
    (input-field "Help browser" 120 "help" 200 help)
    (input-field "File manager" 120 "filer" 200 filer)
    (form-okbutton "OK")
    (form-cancelbutton "Cancel")
    (set! new (form-end))
    (set! viewer (extract-string "viewer" new))
    (set! lpr (extract-string "lpr" new))
    (set! editor (extract-string "editor" new))
    (set! help (extract-string "help" new))
    (set! filer (extract-string "filer" new))
    (set! int (extract-string "int" new))
    (cond
      ((equal? int "Defaults")
       (begin
	 (set! viewer "gvu")
	 (set! lpr "lpr")
	 (set! editor "xedplus")
	 (set! help siaghelp)
	 (set! filer "xfiler")))
      ((equal? int "Gnome")
       (begin
	 (set! viewer "ggv")
	 (set! editor "gedit")
	 (set! help "gzilla")
	 (set! filer "gmc")))
      ((equal? int "KDE")
       (begin
	 (set! viewer "kghostview")
	 (set! editor "kedit")
	 (set! help "kdehelp")
	 (set! filer "kfm")))
      ((equal? int "CDE")
       (begin
	 (set! editor "dtpad")
	 (set! filer "dtfile")))
      (t nil))				; keep all the defaults
    (if (string? viewer) (set! viewer-command viewer))
    (if (string? lpr) (set! lpr-command lpr))
    (if (string? editor) (set! editor-command editor))
    (if (string? help) (set! help-command help))
    (if (string? filer) (set! filer-command filer))))

(define (exec-siod)
  (execute-interpreter-command 'SIOD))

(define (exec-c)
  (execute-interpreter-command 'C))

(define (exec-guile)
  (execute-interpreter-command 'Guile))

(define (exec-python)
  (execute-interpreter-command 'Python))

(define (exec-tcl)
  (execute-interpreter-command 'Tcl))

(define (execute-extended-command)
  (exec-siod))

(define (llpr x)
  (puts x))

(define (do-help helpfile)
  (spawn (string-append help-command " file:" docdir "/" helpfile)))

(define (do-link url)
  (spawn (string-append help-command " " url)))

(define (help-for-help)
  (do-help "common/siaghelp.html"))

(define (help-search)
  (do-help "common/search.html"))

(define (help-copyright)
  (do-help "common/COPYING"))

(define (keyboard-quit)
  (llpr "Quit"))

(define (no-op)
  (llpr "This command does nothing"))

