/*
   Siag, Scheme In A Grid
   Copyright (C) 1996  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
   Module name:    selection.c

   This module handles selection: grabbing, releasing, cutting, pasting.

   The selection uses a custom target SIAG_BLOCK which has this format:

   <HEIGHT>\0<WIDTH>\0<TYPE><TEXT>\0<TYPE><TEXT>\0...

   HEIGHT = numbers of rows in selection
   WIDTH = number of columns in selection
   TYPE = type char where:
	'"' = label
	'#' = empty
	'=' = expression
	'$' = string
	'+' = expression with named interpreter
	'm' = image
   TEXT = verbatim text from the cell

   This is pretty similar to the file format but different enough to
   be confusing.
*/

#include <stdio.h>
#include <string.h>

#include "../siag/calc.h"
#include "tsiag.h"

#if 0 /* Doesn't seem to be used...*/
int pack_selection(buffer *b, char *data,
                 int r1, int c1, int r2, int c2)
{
	int row, col;
	char *q = data;

	sprintf(data, "%d", r2-r1+1);
	data += strlen(data)+1;
	sprintf(data, "%d", c2-c1+1);
	data += strlen(data)+1;

	for (row = r1; row <= r2; row++) {
		if (data-q > 30000) goto toolong;
		for (col = c1; col <= c2; col++) {
			switch (ret_type(b, row, col)) {
			case EMPTY:
				sprintf(data, "#");
				break;
			case LABEL:
				sprintf(data, "\"%s",
					ret_text(b, row, col));
				break;
			case EMBED:
				sprintf(data, "m%s",
					ret_text(b, row, col));
				break;
			default:	/* incl. STRING and ERROR */
				sprintf(data, "+%s,%s",
					interpreter2name(ret_interpreter(b,
								row, col)),
					ret_text(b, row, col));
			}
			data += strlen(data)+1;
		}
	}
toolong:
	*data = '\0';
	return 0;
}
#endif

void transfer_done_proc()
{
	; /* no need to do anything at all */
}

#if 0 /* Again, I don't think this is even used */
int unpack_selection(buffer *b, char *data, int row, int col)
{
	int height, width, i, j, intp;
	char *texti, *comma;
	cval value;

	value.number = 0;

	sscanf(data, "%d", &height);
	data += strlen(data)+1;
	sscanf(data, "%d", &width);
	data += strlen(data)+1;

	undo_save(b, row, col, row+height-1, col+width-1);

	for (i = 0; i < height; i++) {
		for (j = 0; j < width; j++) {
			switch (data[0]) {
			case '"':
				texti = (data+1);
				ins_data(b,
					siod_interpreter,
					texti, value,
					LABEL, row+i, col+j);
				break;
			case '=':
				texti = (data+1);
				ins_data(b,
					siod_interpreter,
					texti, value,
					EXPRESSION, row+i, col+j);
				break;
			case '$':
				texti = (data+1);
				ins_data(b,
					siod_interpreter,
					texti, value,
					STRING, row+i, col+j);
				break;
			case '+':
				comma = strchr(data, ',');
				if (comma) {
					*comma = '\0';
				}
				intp = name2interpreter(data+1);
				if (intp < 0) intp = siod_interpreter;
				data = comma+1;
				ins_data(b, intp, data, value,
					EXPRESSION, row+i, col+j);
				break;
			default:
				ins_data(b,
					siod_interpreter,
					NULL, value,
					EMPTY, row+i, col+j);
			}
			data += strlen(data)+1;
		}
	}
	pr_scr_flag = TRUE;
TRACEME((f, "unpack_selection is calling show_cur")); show_cur(w_list);
	return 0;
}
#endif
