/*
    Copyright (C) 1996-1999  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA.
*/

/*
 * tooltip.c
 */

#include <stdlib.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include "../common/common.h"
#include "xcommon.h"

#define HIGHLIGHT_WIDTH 2
#define UNHIGHLIGHT_WIDTH 1

/* ---
This function highlights by increasing the shadow width. This
doesn't work for plain Athena widgets which have no shadow at
all, so they won't be highlighted.
*/

static void highlight_action(Widget w, XEvent *event,
        String *params, Cardinal *num_params)
{
	int sw;
	Boolean set;

	if (*num_params) sw = atoi(*params);
	else sw = HIGHLIGHT_WIDTH;
	if (*num_params > 1) {
		XtVaGetValues(w,
			XtNstate, &set,
			(char *)0);
	} else {
		set = 0;
	}
	if (set) {
		sw++;
	}

        if (w) XtVaSetValues(w,
		"shadowWidth", sw,
                (char *)0);
}

/* ---
Remove the highlighting.
*/

static void unhighlight_action(Widget w, XEvent *event,
        String *params, Cardinal *num_params)
{
	int sw;
	Boolean set;

	if (*num_params) sw = atoi(*params);
        else sw = UNHIGHLIGHT_WIDTH;
	if (*num_params > 1) {
		XtVaGetValues(w,
			XtNstate, &set,
			(char *)0);
	} else {
		set = 0;
	}
	if (set) {
		sw++;
	}

        if (w) XtVaSetValues(w,
		"shadowWidth", sw,
                (char *)0);
}

static XtActionsRec actions[] =
{
        {"siag-highlight", highlight_action},
        {"siag-unhighlight", unhighlight_action},
};

/* ---
Set the highlighting and unhighlighting colours.
*/

void tooltip_init(Widget pw, unsigned long hl, unsigned long uhl)
{
	XtAppAddActions(XtWidgetToApplicationContext(pw),
		actions, XtNumber(actions));
}

