/*
    Copyright (C) 1996-1999  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/stat.h>
#include <unistd.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/xpm.h>
#include "../common/common.h"

static pid_t splashpid;

/* ---
Get the text in a label.
*/

String label_get(Widget w)
{
	String p = NULL;
	XtVaGetValues(w, XtNlabel, &p, (char *)0);
	return p;
}

/* ---
Set the text in a label.
*/

void label_set(Widget w, String p)
{
        char *q, *r;
        int must_set = 0;

        if (w == None || p == NULL) return;
        q = translate((char *)p);
        if (q == NULL) return;
        r = label_get(w);

        if (r == NULL) {
                must_set = 1;
        } else {
                must_set = (strcmp(q, r) != 0);
        }

        if (must_set) XtVaSetValues(w, XtNlabel, q, (char *)0);
}

/* ---
Get the state of a toggle widget
*/

Boolean state_get(Widget w)
{
	Boolean i = False;
	if (w != None)
		XtVaGetValues(w, XtNstate, &i, (char *)0);
	return i;
}

/* this is needed if we include vanilla Athena headers */
#ifndef XtNshadowWidth
#define XtNshadowWidth "shadowWidth"
#endif

/* ---
If no widget, do nothing.
If same state and same shadow width as before, do nothing.
If set, use shadow width ssw.
If unset, use shadow width usw.
*/

void state_set(Widget w, Boolean i, int ssw, int usw)
{
	Boolean set;
	Dimension osw, nsw;
	if (w == None) return;
	XtVaGetValues(w,
		XtNstate, &set,
		XtNshadowWidth, &osw,
		(char *)0);
	if (i) nsw = ssw;
	else nsw = usw;
	if (i == set && nsw == osw) return;
	XtVaSetValues(w,
		XtNstate, i,
		XtNshadowWidth, nsw,
		(char *)0);
}

/* ---
Get the width of a widget.
*/

Dimension width_get(Widget w)
{
	Dimension x = 80;
	if (w != None)
		XtVaGetValues(w, XtNwidth, &x, (char *)0);
	return x;
}

/* ---
Get the height of a widget.
*/

Dimension height_get(Widget w)
{
	Dimension x = 20;
	if (w != None)
		XtVaGetValues(w, XtNheight, &x, (char *)0);
	return x;
}

void start_splash(void)
{
	char *p = getenv("SIAG_SPLASH");

	if (p) {
		splashpid = fork();

		if (splashpid == 0) {
			char cmd[1024];
			char image[1024];
			sprintf(cmd, "%s/plugins/image", libexecdir);
			sprintf(image, "%s/common/bitmaps/SO3.xpm", datadir);
			execlp(cmd, "image", image, (char *)NULL);
			_exit(0);
		}
	}
}

void stop_splash(void)
{
	if (splashpid > 0) kill(splashpid, SIGINT);
}

Pixmap load_pixmap(Widget w, char *pm)
{
	XpmAttributes xa;
	Pixmap pm_return;
	int result;
	XpmColorSymbol symbol;
	Pixel color;
	char fn[1024];
	char *pixpath = getenv("PIXPATH");
	struct stat statbuf;
	int found = 0;

	if (pm[0] == '/') {
		strcpy(fn, pm);
		found = 1;
	} else if (pixpath) {
		sprintf(fn, "%s/%s", pixpath, pm);
		found = !stat(fn, &statbuf);
	}
	if (!found) sprintf(fn, "%s/common/bitmaps/%s", datadir, pm);

	if (w == None) return None;

	XtVaGetValues(w, XtNbackground, &color, (char *)0);
	xa.closeness = 40000;
	xa.exactColors = False;
	xa.valuemask = XpmCloseness | XpmExactColors;

	symbol.name = NULL;
	symbol.value = "none";
	symbol.pixel = color;
	xa.colorsymbols = &symbol;
	xa.numsymbols = 1;
	xa.valuemask |= XpmColorSymbols;
	result = XpmReadFileToPixmap(XtDisplay(w),
		XRootWindowOfScreen(XtScreen(w)),
		fn, &pm_return, NULL, &xa);

	if (result != XpmSuccess) {
		fprintf(stderr, "XpmReadFileToPixmap(%s) returns %s\n",
			fn, XpmGetErrorString(result));
		return None;
	}
	return pm_return;
}

