/*
   Pathetic Writer
   Copyright (C) 1997-1999  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/* ---
   Module name:    selection.c

   This module handles selection: grabbing, releasing, cutting, pasting.

   The selection uses a custom target PW_BLOCK, which is simple
   plaintext. No formatting is preserved.

   All in all, plenty good enough for now.
--- */

#include <stdio.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/StdSel.h>

#include "../common/common.h"
#include "../common/cmalloc.h"

#include "../pw/pw.h"
#include "xpw.h"

Atom target_atom;	/* used for selection */

/* ---
*/
Boolean convert_proc(Widget w,
	Atom *selection, Atom *target, Atom *type_return,
	XtPointer *value_return, unsigned long *length_return,
	int *format_return)
{
	window *wl = find_window_by_widget(w);
	unsigned int lr;

	XSelectionRequestEvent *req = XtGetSelectionRequest(w,
		*selection, (XtRequestId) NULL);

	/* handle all required atoms, and the one that we use */
	/* Xt already handles MULTIPLE, no branch necessary */
	if (*target == XA_TARGETS(XtDisplay(w))) {
		Atom *targetP;
		Atom *std_targets;
		unsigned long std_length;
		XmuConvertStandardSelection(w, req->time, selection,
			target, type_return,
			(XPointer *)&std_targets,
			&std_length, format_return);
		*value_return = XtMalloc(sizeof(Atom)*(std_length+1));
		targetP = *(Atom **)value_return;
		*length_return = std_length+1;
		*targetP++ = target_atom;
		memcpy(targetP, std_targets, sizeof(Atom)*std_length);
		XtFree((char *)std_targets);
		*type_return = XA_ATOM;
		*format_return = sizeof(Atom)*8;
		return True;
	} else if (*target == target_atom) {
		/* handle normal selection */
		char *data = pack_area(wl->buf, wl->bsht,
			block_upper(wl).row, block_upper(wl).col,
			block_lower(wl).row, block_lower(wl).col,
			&lr);
		*length_return = lr;
		*value_return = XtMalloc(*length_return);
		memcpy(*value_return, data, *length_return);
		cfree(data);
#if 0
		char *data;
		int s = wl->bsht;
		sheet *st = wl->buf->sht;

		/* Use a fixed size buffer for now */
		*length_return = 32000;

		data = XtMalloc(*length_return);
		pack_selection(wl->buf, data, s,
				st[s].blku.row, st[s].blku.col,
				st[s].blkl.row, st[s].blkl.col);

		*value_return = data;
#endif
		*type_return = target_atom;

		*format_return = 8;
		return True;
	} else if (*target == XA_STRING) {
		/* handle string selections (from outside PW) */
#if 0
		char *data;
		int s = wl->bsht;
		sheet *st = wl->buf->sht;
		*length_return = 32000;
		data = XtMalloc(*length_return);
		pack_string_selection(wl->buf, data, s,
			st[s].blku.row, st[s].blku.col,
			st[s].blkl.row, st[s].blkl.col);
		*value_return = data;
#endif
		char *data = pack_area(wl->buf, wl->bsht,
			block_upper(wl).row, block_upper(wl).col,
			block_lower(wl).row, block_lower(wl).col,
			&lr);
		*length_return = strlen(data)+1;
/*		*length_return = lr;
*/
		*value_return = XtMalloc(*length_return);
		memcpy(*value_return, data, *length_return);
		cfree(data);

		*type_return = XA_STRING;
		*format_return = 8;
		return True;
	} else {
		if (XmuConvertStandardSelection(w, CurrentTime, selection,
				target, type_return, (XPointer *)value_return,
				length_return, format_return))
			return True;
		else {
			XtWarning("PW: unsupported selection type\n");
			return False;
		}
	}
	/*NOTREACHED*/
}

/* ---
*/
void lose_ownership_proc(Widget w, Atom *selection)
{
	window *wl = find_window_by_widget(w);
	int s = wl->bsht;
	sheet *st = wl->buf->sht;
	wl->bsht = -1;

	st[s].blku.row = st[s].blku.col = -1;
	st[s].blkl.row = st[s].blkl.col = -1;

	pr_scr_flag = TRUE;	/* Is this enough? */	
	show_cur(wl);
}

/* ---
*/
void transfer_done_proc(void)
{
	; /* no need to do anything at all */
}

/* ---
*/
void string_requestor_callback(Widget w, XtPointer client_data,
        Atom *selection, Atom *type, XtPointer value,
        unsigned long *length, int *format)
{
        if ((value == NULL) && (*length == 0)) {
                XBell(XtDisplay(w), 100);
                XtWarning("PW: no selection or selection timed out\n");
        } else {
                unpack_string_area(w_list->buf, (char *)value,
			w_list->sht,
                        get_point(w_list).row, get_point(w_list).col);
                w_list->buf->change = TRUE;
                XtFree((char *)value);
                pr_scr_flag = TRUE;
        }
	show_cur(w_list);
}

/* ---
*/
void requestor_callback(Widget w, XtPointer client_data,
	Atom *selection, Atom *type, XtPointer value,
	unsigned long *length, int *format)
{
	if ((value == NULL) && (*length == 0)) {
        /* if we asked for a PW_BLOCK and got a null response,
           we'll ask again, this time for an XA_STRING */
                XtGetSelectionValue(w, XA_PRIMARY, XA_STRING,
                        string_requestor_callback,
                        NULL, CurrentTime);     /* NULL is bogus event */
	} else {
		unpack_area(w_list->buf, (char *)value,
			w_list->sht,
			get_point(w_list).row, get_point(w_list).col);
		w_list->buf->change = TRUE;

		XtFree((char *)value);
		pr_scr_flag = TRUE;
	}
	show_cur(w_list);
}

