#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc search_file {} {

  global tnpath
  source $tnpath/gid/global.tcl

  global searchfile

  if { $tn_switch } { puts "In proc SEARCH_FILE" }

#  window
  set w_tngidmbar_search_file .w_tngidmbar_search_file
  catch {destroy $w_tngidmbar_search_file}
  toplevel $w_tngidmbar_search_file
  wm title $w_tngidmbar_search_file "Search for file in test directory containing ... "
  wm geometry $w_tngidmbar_search_file 500x500
  wm geometry $w_tngidmbar_search_file $tn_window_offset
  focus $w_tngidmbar_search_file

#    main frame
  set f $w_tngidmbar_search_file.frame
  frame $f -relief groove -borderwidth 2
  pack $f -expand 1 -fill both

#   ready
  frame $f.framespecials -relief flat
  pack $f.framespecials -side bottom -pady 2m -fill x
  button $f.framespecials.ready -text "Ready" -command { destroy $w_tngidmbar_search_file }
  button $f.framespecials.search -text "Search" -command { search_file_list }
  button $f.framespecials.help -text "Help" -command { 
    help "Enter words to search. Press search (or press return). All files containing the words will be displayed.\n\nDouble clicking on a file name will view the file."
  }
  pack $f.framespecials.ready $f.framespecials.search -side left -anchor w
  pack $f.framespecials.help -side right -anchor e

#   file entry
  frame $f.framefile -relief flat
  pack $f.framefile -side top -pady 2m -anchor w
  label $f.framefile.lab -text "Words: "
  entry $f.framefile.ent -textvariable searchfile -relief sunken -width 30
  bind $f.framefile.ent <Return> { search_file_list }
  pack $f.framefile.lab $f.framefile.ent -side left -anchor w

  if { $tn_switch } { puts "Out proc SEARCH_FILE" }

}

proc search_file_list { } {

  global tnpath
  source $tnpath/gid/global.tcl

  global searchfile

  if { $tn_switch } { 
    puts "In proc SEARCH_FILE_LIST" 
    puts "searchfile: $searchfile" 
  }

  set searchfile_list [ split $searchfile ]
  if { $tn_switch } { puts "searchfile_list: $searchfile_list" }

  set f $w_tngidmbar_search_file.frame
  catch {destroy $f.framelist}

  global $f.framelist
  frame $f.framelist -relief flat
  pack $f.framelist -fill both -side top -expand 1
  listbox $f.framelist.listbox -relief raised -yscrollcommand "$f.framelist.scroll set"
  scrollbar $f.framelist.scroll -command "$f.framelist.listbox yview"
  pack $f.framelist.scroll -side right -fill y
  pack $f.framelist.listbox -side left -fill both -expand 1

  set files_list [glob $tnpath/test/*.dat]
  if { $tn_switch } { puts "files_list: $files_list" }

  bind $f.framelist.listbox <Double-1> { viewfile [selection get] }
  foreach file $files_list {
    set fileid [open $file r]
    set all_item_in_file 1
    foreach searchitem $searchfile_list {
      seek $fileid 0
      set this_item_in_file 0
      while { [gets $fileid line]>=0 } {
        set ind [string first $searchitem $line]
        if { $ind>=0 } { set this_item_in_file 1 }
      }
      if { !$this_item_in_file } { set all_item_in_file 0 }
    }
    if { $all_item_in_file } {
      $f.framelist.listbox insert end $file
    }
    close $fileid
  }

  if { $tn_switch } { puts "Out proc SEARCH_FILE_LIST" }
}
