/*
    Copyright (C) 1998  Dennis Roddeman
    email: d.g.roddeman@wb.utwente.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h" 

double   *dbl_data[MDAT][MVERSION]; // pointer to actual double data
long int *int_data[MDAT][MVERSION]; // pointers to actual integer data
long int max_index[MDAT][MVERSION]; // maximum index allocated
long int no_index[MDAT];       // 0: index in datafile, 1: no index in data file
long int type[MDAT];           // INTEGER or DOUBLE
char     name[MDAT][MCHAR];    // "element", "node", ...
long int external[MDAT];       // 0: internal in TOCHNOG only, 1: also for datafile
long int data_length[MDAT];    // length (maximum for actual length)
long int fixed_length[MDAT];   // 0: all records same length; 1: records diff. length
long int data_class[MDAT];     // ELEMENT or NODE or so
long int print_only[MDAT];     // 0: for reading and printing; 1: for printing only
long int version_all[MDAT];    // 1: with versions, 0: without versions

void db_initialize( long int dof_type[], long int dof_label[] )

{
  long int iversion=0, idim=0, ipuknwn=0, iuknwn=0, idat=0, n=0, m=0;
  char basename[MCHAR], str[MCHAR], tmpname[MCHAR];

    // fill data base administration with defaults 
  for ( idat=0; idat<MDAT; idat++ ) {
    strcpy( name[idat], " " );
    for ( iversion=0; iversion<MVERSION; iversion++ )
      max_index[idat][iversion] = -1;
  }
  array_set( version_all, 0, MDAT );
  array_set( data_class, -1, MDAT );
  array_set( data_length, 0, MDAT );
  array_set( external, 1, MDAT );
  array_set( fixed_length, 1, MDAT );
  array_set( no_index, 0, MDAT );
  array_set( type, 0, MDAT );
  array_set( print_only, 0, MDAT );

  strcpy(name[ALL],"all" );

  strcpy(name[AREA],"area");

  strcpy(name[AREA_ELEMENT_GROUP],"area_element_group");
  type[AREA_ELEMENT_GROUP] = INTEGER;
  data_length[AREA_ELEMENT_GROUP] = 3;
  data_class[AREA_ELEMENT_GROUP] = AREA;

  strcpy(name[AREA_NODE_DATAITEM],"area_node_dataitem");
  type[AREA_NODE_DATAITEM] = INTEGER;
  data_length[AREA_NODE_DATAITEM] = 4;
  data_class[AREA_NODE_DATAITEM] = AREA;
  version_all[AREA_NODE_DATAITEM] = 1;

  strcpy(name[AVERAGE],"average");

  strcpy(name[BAR],"bar" );

  strcpy(name[BAR2],"bar2");

  strcpy(name[BAR3],"bar3");

  strcpy(name[BAR4],"bar4");

  strcpy(name[BAR5],"bar5");

  strcpy(name[BOUNDA],"bounda");

  strcpy(name[BOUNDA_FORCE],"bounda_force");
  type[BOUNDA_FORCE] = INTEGER;
  data_length[BOUNDA_FORCE] = DATA_ITEM_SIZE;
  fixed_length[BOUNDA_FORCE] = 0;
  data_class[BOUNDA_FORCE] = BOUNDA;

  strcpy(name[BOUNDA_SINE],"bounda_sine");
  type[BOUNDA_SINE] = DOUBLE;
  data_length[BOUNDA_SINE] = DATA_ITEM_SIZE;
  fixed_length[BOUNDA_SINE] = 0;
  data_class[BOUNDA_SINE] = BOUNDA;

  strcpy(name[BOUNDA_TIME],"bounda_time");
  type[BOUNDA_TIME] = DOUBLE;
  data_length[BOUNDA_TIME] = DATA_ITEM_SIZE;
  fixed_length[BOUNDA_TIME] = 0;
  data_class[BOUNDA_TIME] = BOUNDA;

  strcpy(name[BOUNDA_TIME_FILE],"bounda_time_file");
  type[BOUNDA_TIME_FILE] = INTEGER;
  data_length[BOUNDA_TIME_FILE] = 1;
  data_class[BOUNDA_TIME_FILE] = BOUNDA;

  strcpy(name[BOUNDA_UNKNOWN],"bounda_unknown");
  type[BOUNDA_UNKNOWN] = INTEGER;
  data_length[BOUNDA_UNKNOWN] = DATA_ITEM_SIZE;
  fixed_length[BOUNDA_UNKNOWN] = 0;
  data_class[BOUNDA_UNKNOWN] = BOUNDA;

  strcpy(name[BRICK],"brick" );

  strcpy(name[BUCKLING],"buckling" );

  strcpy(name[CHANGE],"change");

  strcpy(name[CHECK],"check" );

  strcpy(name[CHECK_INDEX],"check_index" );

  strcpy(name[CHECK_NUMBER],"check_number" );

  strcpy(name[CIRCLE],"circle" );

  strcpy(name[CIRCLE_HOLLOW],"circle_hollow" );

  strcpy(name[CONDIF],"condif");

  strcpy(name[CONDIF_CONVECTION],"condif_convection");
  type[CONDIF_CONVECTION] = DOUBLE;
  data_length[CONDIF_CONVECTION] = 2;
  data_class[CONDIF_CONVECTION] = CONDIF;

  strcpy(name[CONDIF_CONVECTION_GEOMETRY],"condif_convection_geometry");
  type[CONDIF_CONVECTION_GEOMETRY] = INTEGER;
  data_length[CONDIF_CONVECTION_GEOMETRY] = DATA_ITEM_SIZE;
  fixed_length[CONDIF_CONVECTION_GEOMETRY] = 0;
  data_class[CONDIF_CONVECTION_GEOMETRY] = CONDIF;

  strcpy(name[CONDIF_RADIATION],"condif_radiation");
  type[CONDIF_RADIATION] = DOUBLE;
  data_length[CONDIF_RADIATION] = 2;
  data_class[CONDIF_RADIATION] = CONDIF;

  strcpy(name[CONDIF_RADIATION_GEOMETRY],"condif_radiation_geometry");
  type[CONDIF_RADIATION_GEOMETRY] = INTEGER;
  data_length[CONDIF_RADIATION_GEOMETRY] = DATA_ITEM_SIZE;
  fixed_length[CONDIF_RADIATION_GEOMETRY] = 0;
  data_class[CONDIF_RADIATION_GEOMETRY] = CONDIF;

  strcpy(name[CONDIF_TEMPERATURE],"condif_temperature");

  strcpy(name[CONTACT],"contact");

  strcpy(name[CONTACT_FRICTION],"contact_friction");
  type[CONTACT_FRICTION] = DOUBLE;
  data_length[CONTACT_FRICTION] = 1;
  no_index[CONTACT_FRICTION] = 1;
  data_class[CONTACT_FRICTION] = CONTACT;

  strcpy(name[CONTACT_GEOMETRY],"contact_geometry");
  type[CONTACT_GEOMETRY] = INTEGER;
  data_length[CONTACT_GEOMETRY] = 2;
  data_class[CONTACT_GEOMETRY] = CONTACT;

  strcpy(name[CONTACT_GEOMETRY_SWITCH],"contact_geometry_switch");
  type[CONTACT_GEOMETRY_SWITCH] = INTEGER;
  data_length[CONTACT_GEOMETRY_SWITCH] = 1;
  data_class[CONTACT_GEOMETRY_SWITCH] = CONTACT;

  strcpy(name[CONTACT_HEAT_GENERATION],"contact_heat_generation");
  type[CONTACT_HEAT_GENERATION] = DOUBLE;
  data_length[CONTACT_HEAT_GENERATION] = 1;
  no_index[CONTACT_HEAT_GENERATION] = 1;
  data_class[CONTACT_HEAT_GENERATION] = CONTACT;

  strcpy(name[CONTACT_PENALTY_PRESSURE],"contact_penalty_pressure");
  type[CONTACT_PENALTY_PRESSURE] = DOUBLE;
  data_length[CONTACT_PENALTY_PRESSURE] = 1;
  no_index[CONTACT_PENALTY_PRESSURE] = 1;
  data_class[CONTACT_PENALTY_PRESSURE] = CONTACT;

  strcpy(name[CONTACT_PENALTY_TEMPERATURE],"contact_penalty_temperature");
  type[CONTACT_PENALTY_TEMPERATURE] = DOUBLE;
  data_length[CONTACT_PENALTY_TEMPERATURE] = 1;
  no_index[CONTACT_PENALTY_TEMPERATURE] = 1;
  data_class[CONTACT_PENALTY_TEMPERATURE] = CONTACT;

  strcpy(name[CONTACT_PENALTY_VELOCITY],"contact_penalty_velocity");
  type[CONTACT_PENALTY_VELOCITY] = DOUBLE;
  data_length[CONTACT_PENALTY_VELOCITY] = 1;
  no_index[CONTACT_PENALTY_VELOCITY] = 1;
  data_class[CONTACT_PENALTY_VELOCITY] = CONTACT;

  strcpy(name[CONTROL_DATA_DELETE],"control_data_delete");
  type[CONTROL_DATA_DELETE] = INTEGER;
  data_length[CONTROL_DATA_DELETE] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_DATA_DELETE] = 0;
  data_class[CONTROL_DATA_DELETE] = CONTROL;

  strcpy(name[CONTROL_DATA_PUT],"control_data_put");
  type[CONTROL_DATA_PUT] = INTEGER;
  data_length[CONTROL_DATA_PUT] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_DATA_PUT] = 0;
  data_class[CONTROL_DATA_PUT] = CONTROL;

  strcpy(name[CONTROL_DATA_PUT_DOUBLE],"control_data_put_double");
  type[CONTROL_DATA_PUT_DOUBLE] = DOUBLE;
  data_length[CONTROL_DATA_PUT_DOUBLE] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_DATA_PUT_DOUBLE] = 0;
  data_class[CONTROL_DATA_PUT_DOUBLE] = CONTROL;

  strcpy(name[CONTROL_DATA_PUT_INTEGER],"control_data_put_integer");
  type[CONTROL_DATA_PUT_INTEGER] = INTEGER;
  data_length[CONTROL_DATA_PUT_INTEGER] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_DATA_PUT_INTEGER] = 0;
  data_class[CONTROL_DATA_PUT_INTEGER] = CONTROL;

  strcpy(name[CONTROL_DISTRIBUTE],"control_distribute");
  type[CONTROL_DISTRIBUTE] = INTEGER;
  data_length[CONTROL_DISTRIBUTE] = DATA_ITEM_SIZE;
  data_class[CONTROL_DISTRIBUTE] = CONTROL;
  fixed_length[CONTROL_DISTRIBUTE] = 0;

  strcpy(name[CONTROL_DISTRIBUTE_VALUES],"control_distribute_values");
  type[CONTROL_DISTRIBUTE_VALUES] = DOUBLE;
  data_length[CONTROL_DISTRIBUTE_VALUES] = DATA_ITEM_SIZE;
  data_class[CONTROL_DISTRIBUTE_VALUES] = CONTROL;
  fixed_length[CONTROL_DISTRIBUTE_VALUES] = 0;

  strcpy(name[CONTROL_EIGEN],"control_eigen");
  type[CONTROL_EIGEN] = INTEGER;
  data_length[CONTROL_EIGEN] = 2;
  data_class[CONTROL_EIGEN] = CONTROL;

  strcpy(name[CONTROL_EIGEN_SCALE],"control_eigen_scale");
  type[CONTROL_EIGEN_SCALE] = DOUBLE;
  data_length[CONTROL_EIGEN_SCALE] = 1;
  data_class[CONTROL_EIGEN_SCALE] = CONTROL;

  strcpy(name[CONTROL_EIGEN_VALUES],"control_eigen_values");
  type[CONTROL_EIGEN_VALUES] = DOUBLE;
  data_length[CONTROL_EIGEN_VALUES] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_EIGEN_VALUES] = 0;
  data_class[CONTROL_EIGEN_VALUES] = CONTROL;
  no_index[CONTROL_EIGEN_VALUES] = 1;

  strcpy(name[CONTROL_MESH_ADJUST_GEOMETRY],"control_mesh_adjust_geometry");
  type[CONTROL_MESH_ADJUST_GEOMETRY] = INTEGER;
  data_length[CONTROL_MESH_ADJUST_GEOMETRY] = 2;
  data_class[CONTROL_MESH_ADJUST_GEOMETRY] = CONTROL;

  strcpy(name[CONTROL_MESH_DELETE_GEOMETRY],"control_mesh_delete_geometry");
  type[CONTROL_MESH_DELETE_GEOMETRY] = INTEGER;
  data_length[CONTROL_MESH_DELETE_GEOMETRY] = 2;
  data_class[CONTROL_MESH_DELETE_GEOMETRY] = CONTROL;

  strcpy(name[CONTROL_MESH_MACRO],"control_mesh_macro");
  type[CONTROL_MESH_MACRO] = INTEGER;
  data_length[CONTROL_MESH_MACRO] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_MESH_MACRO] = 0;
  data_class[CONTROL_MESH_MACRO] = CONTROL;

  strcpy(name[CONTROL_MESH_MACRO_PARAMETERS],"control_mesh_macro_parameters");
  type[CONTROL_MESH_MACRO_PARAMETERS] = DOUBLE;
  data_length[CONTROL_MESH_MACRO_PARAMETERS] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_MESH_MACRO_PARAMETERS] = 0;
  data_class[CONTROL_MESH_MACRO_PARAMETERS] = CONTROL;

  strcpy(name[CONTROL_MESH_MERGE],"control_mesh_merge");
  type[CONTROL_MESH_MERGE] = INTEGER;
  data_length[CONTROL_MESH_MERGE] = 1;
  data_class[CONTROL_MESH_MERGE] = CONTROL;

  strcpy(name[CONTROL_MESH_NEW_MESH],"control_mesh_new_mesh");
  type[CONTROL_MESH_NEW_MESH] = DOUBLE;
  data_length[CONTROL_MESH_NEW_MESH] = 1;
  data_class[CONTROL_MESH_NEW_MESH] = CONTROL;

  strcpy(name[CONTROL_MESH_NEW_MESH_ELEMENT],"control_mesh_new_mesh_element");
  type[CONTROL_MESH_NEW_MESH_ELEMENT] = INTEGER;
  data_length[CONTROL_MESH_NEW_MESH_ELEMENT] = 1;
  data_class[CONTROL_MESH_NEW_MESH_ELEMENT] = CONTROL;

  strcpy(name[CONTROL_MESH_NEW_MESH_REGION],"control_mesh_new_mesh_region");
  type[CONTROL_MESH_NEW_MESH_REGION] = INTEGER;
  data_length[CONTROL_MESH_NEW_MESH_REGION] = 6+nuknwn;
  fixed_length[CONTROL_MESH_NEW_MESH_REGION] = 0;
  data_class[CONTROL_MESH_NEW_MESH_REGION] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_GLOBALLY],"control_mesh_refine_globally");
  type[CONTROL_MESH_REFINE_GLOBALLY] = INTEGER;
  data_length[CONTROL_MESH_REFINE_GLOBALLY] = 4;
  fixed_length[CONTROL_MESH_REFINE_GLOBALLY] = 0;
  data_class[CONTROL_MESH_REFINE_GLOBALLY] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_GLOBALLY_GEOMETRY],"control_mesh_refine_globally_geometry");
  type[CONTROL_MESH_REFINE_GLOBALLY_GEOMETRY] = INTEGER;
  data_length[CONTROL_MESH_REFINE_GLOBALLY_GEOMETRY] = 2;
  data_class[CONTROL_MESH_REFINE_GLOBALLY_GEOMETRY] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_LOCALLY],"control_mesh_refine_locally");
  type[CONTROL_MESH_REFINE_LOCALLY] = DOUBLE;
  data_length[CONTROL_MESH_REFINE_LOCALLY] = 1;
  data_class[CONTROL_MESH_REFINE_LOCALLY] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_LOCALLY_GEOMETRY],"control_mesh_refine_locally_geometry");
  type[CONTROL_MESH_REFINE_LOCALLY_GEOMETRY] = INTEGER;
  data_length[CONTROL_MESH_REFINE_LOCALLY_GEOMETRY] = 2;
  data_class[CONTROL_MESH_REFINE_LOCALLY_GEOMETRY] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_LOCALLY_MINIMUM],"control_mesh_refine_locally_minimum");
  type[CONTROL_MESH_REFINE_LOCALLY_MINIMUM] = DOUBLE;
  data_length[CONTROL_MESH_REFINE_LOCALLY_MINIMUM] = 1;
  data_class[CONTROL_MESH_REFINE_LOCALLY_MINIMUM] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_LOCALLY_NOT],"control_mesh_refine_locally_not");
  type[CONTROL_MESH_REFINE_LOCALLY_NOT] = INTEGER;
  data_length[CONTROL_MESH_REFINE_LOCALLY_NOT] = 2;
  data_class[CONTROL_MESH_REFINE_LOCALLY_NOT] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_LOCALLY_ONLY],"control_mesh_refine_locally_only");
  type[CONTROL_MESH_REFINE_LOCALLY_ONLY] = INTEGER;
  data_length[CONTROL_MESH_REFINE_LOCALLY_ONLY] = 2;
  data_class[CONTROL_MESH_REFINE_LOCALLY_ONLY] = CONTROL;

  strcpy(name[CONTROL_MESH_REFINE_LOCALLY_UNKNOWN],"control_mesh_refine_locally_unknown");
  type[CONTROL_MESH_REFINE_LOCALLY_UNKNOWN] = INTEGER;
  data_length[CONTROL_MESH_REFINE_LOCALLY_UNKNOWN] = 1;
  data_class[CONTROL_MESH_REFINE_LOCALLY_UNKNOWN] = CONTROL;

  strcpy(name[CONTROL_MESH_REMESH],"control_mesh_remesh");
  type[CONTROL_MESH_REMESH] = INTEGER;
  data_length[CONTROL_MESH_REMESH] = 1;
  data_class[CONTROL_MESH_REMESH] = CONTROL;

  strcpy(name[CONTROL_MESH_REMESH_FACTOR],"control_mesh_remesh_factor");
  type[CONTROL_MESH_REMESH_FACTOR] = DOUBLE;
  data_length[CONTROL_MESH_REMESH_FACTOR] = 2;
  data_class[CONTROL_MESH_REMESH_FACTOR] = CONTROL;

  strcpy(name[CONTROL_MESH_RENUMBER],"control_mesh_renumber");
  type[CONTROL_MESH_RENUMBER] = INTEGER;
  data_length[CONTROL_MESH_RENUMBER] = 2;
  data_class[CONTROL_MESH_RENUMBER] = CONTROL;

  strcpy(name[CONTROL_MESH_SPLIT],"control_mesh_split");
  type[CONTROL_MESH_SPLIT] = INTEGER;
  data_length[CONTROL_MESH_SPLIT] = 1;
  data_class[CONTROL_MESH_SPLIT] = CONTROL;

  strcpy(name[CONTROL_PRINT],"control_print");
  type[CONTROL_PRINT] = INTEGER;
  data_length[CONTROL_PRINT] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_PRINT] = 0;
  data_class[CONTROL_PRINT] = CONTROL;

  strcpy(name[CONTROL_PRINT_DATABASE],"control_print_database");
  type[CONTROL_PRINT_DATABASE] = INTEGER;
  data_length[CONTROL_PRINT_DATABASE] = 1;
  data_class[CONTROL_PRINT_DATABASE] = CONTROL;

  strcpy(name[CONTROL_PRINT_DATA_VERSUS_DATA],"control_print_data_versus_data");
  type[CONTROL_PRINT_DATA_VERSUS_DATA] = INTEGER;
  data_length[CONTROL_PRINT_DATA_VERSUS_DATA] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_PRINT_DATA_VERSUS_DATA] = 0;
  data_class[CONTROL_PRINT_DATA_VERSUS_DATA] = CONTROL;

  strcpy(name[CONTROL_PRINT_GID],"control_print_gid");
  type[CONTROL_PRINT_GID] = INTEGER;
  data_length[CONTROL_PRINT_GID] = 1;
  data_class[CONTROL_PRINT_GID] = CONTROL;

  strcpy(name[CONTROL_PRINT_GMV],"control_print_gmv");
  type[CONTROL_PRINT_GMV] = INTEGER;
  data_length[CONTROL_PRINT_GMV] = 1;
  data_class[CONTROL_PRINT_GMV] = CONTROL;

  strcpy(name[CONTROL_PRINT_GMV_MESH],"control_print_gmv_mesh");
  type[CONTROL_PRINT_GMV_MESH] = INTEGER;
  data_length[CONTROL_PRINT_GMV_MESH] = 1;
  no_index[CONTROL_PRINT_GMV_MESH] = 1;
  external[CONTROL_PRINT_GMV_MESH] = 0;
  data_class[CONTROL_PRINT_GMV_MESH] = CONTROL;

  strcpy(name[CONTROL_PRINT_HISTORY],"control_print_history");
  type[CONTROL_PRINT_HISTORY] = INTEGER;
  data_length[CONTROL_PRINT_HISTORY] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_PRINT_HISTORY] = 0;
  data_class[CONTROL_PRINT_HISTORY] = CONTROL;

  strcpy(name[CONTROL_PRINT_PLOTMTV],"control_print_plotmtv");
  type[CONTROL_PRINT_PLOTMTV] = INTEGER;
  data_length[CONTROL_PRINT_PLOTMTV] = 1;
  data_class[CONTROL_PRINT_PLOTMTV] = CONTROL;

  strcpy(name[CONTROL_PRINT_PLOTMTV_MESH],"control_print_plotmtv_mesh");
  type[CONTROL_PRINT_PLOTMTV_MESH] = INTEGER;
  data_length[CONTROL_PRINT_PLOTMTV_MESH] = 1;
  no_index[CONTROL_PRINT_PLOTMTV_MESH] = 1;
  external[CONTROL_PRINT_PLOTMTV_MESH] = 0;
  data_class[CONTROL_PRINT_PLOTMTV_MESH] = CONTROL;

  strcpy(name[CONTROL_PRINT_MATLAB],"control_print_matlab");
  type[CONTROL_PRINT_MATLAB] = INTEGER;
  data_length[CONTROL_PRINT_MATLAB] = 1;
  data_class[CONTROL_PRINT_MATLAB] = CONTROL;

  strcpy(name[CONTROL_PRINT_TECPLOT],"control_print_tecplot");
  type[CONTROL_PRINT_TECPLOT] = INTEGER;
  data_length[CONTROL_PRINT_TECPLOT] = 1;
  data_class[CONTROL_PRINT_TECPLOT] = CONTROL;

  strcpy(name[CONTROL_PRINT_TECPLOT_MESH],"control_print_tecplot_mesh");
  type[CONTROL_PRINT_TECPLOT_MESH] = INTEGER;
  data_length[CONTROL_PRINT_TECPLOT_MESH] = 1;
  no_index[CONTROL_PRINT_TECPLOT_MESH] = 1;
  external[CONTROL_PRINT_TECPLOT_MESH] = 0;
  data_class[CONTROL_PRINT_TECPLOT_MESH] = CONTROL;

  strcpy(name[CONTROL_PRINT_VTK],"control_print_vtk");
  type[CONTROL_PRINT_VTK] = INTEGER;
  data_length[CONTROL_PRINT_VTK] = 1;
  data_class[CONTROL_PRINT_VTK] = CONTROL;

  strcpy(name[CONTROL_RELAXATION_CONDIF_TEMPERATURE],"control_relaxation_condif_temperature");
  type[CONTROL_RELAXATION_CONDIF_TEMPERATURE] = DOUBLE;
  data_length[CONTROL_RELAXATION_CONDIF_TEMPERATURE] = 1;
  data_class[CONTROL_RELAXATION_CONDIF_TEMPERATURE] = CONTROL;

  strcpy(name[CONTROL_RELAXATION_GROUNDFLOW_PRESSURE],"control_relaxation_groundflow_pressure");
  type[CONTROL_RELAXATION_GROUNDFLOW_PRESSURE] = DOUBLE;
  data_length[CONTROL_RELAXATION_GROUNDFLOW_PRESSURE] = 1;
  data_class[CONTROL_RELAXATION_GROUNDFLOW_PRESSURE] = CONTROL;

  strcpy(name[CONTROL_RELAXATION_MATERI_VELOCITY],"control_relaxation_materi_velocity");
  type[CONTROL_RELAXATION_MATERI_VELOCITY] = DOUBLE;
  data_length[CONTROL_RELAXATION_MATERI_VELOCITY] = 1;
  data_class[CONTROL_RELAXATION_MATERI_VELOCITY] = CONTROL;

  strcpy(name[CONTROL_RELAXATION_WAVE_FSCALAR],"control_relaxation_wave_fscalar");
  type[CONTROL_RELAXATION_WAVE_FSCALAR] = DOUBLE;
  data_length[CONTROL_RELAXATION_WAVE_FSCALAR] = 1;
  data_class[CONTROL_RELAXATION_WAVE_FSCALAR] = CONTROL;

  strcpy(name[CONTROL_REPEAT],"control_repeat");
  type[CONTROL_REPEAT] = INTEGER;
  data_length[CONTROL_REPEAT] = 2;
  data_class[CONTROL_REPEAT] = CONTROL;

  strcpy(name[CONTROL_REPEAT_UNTIL_ITEM],"control_repeat_until_item");
  type[CONTROL_REPEAT_UNTIL_ITEM] = INTEGER;
  data_length[CONTROL_REPEAT_UNTIL_ITEM] = 5;
  data_class[CONTROL_REPEAT_UNTIL_ITEM] = CONTROL;

  strcpy(name[CONTROL_REPEAT_UNTIL_TOLERANCE],"control_repeat_until_tolerance");
  type[CONTROL_REPEAT_UNTIL_TOLERANCE] = DOUBLE;
  data_length[CONTROL_REPEAT_UNTIL_TOLERANCE] = 1;
  data_class[CONTROL_REPEAT_UNTIL_TOLERANCE] = CONTROL;

  strcpy(name[CONTROL_REPEAT_UNTIL_VALUE],"control_repeat_until_value");
  type[CONTROL_REPEAT_UNTIL_VALUE] = DOUBLE;
  data_length[CONTROL_REPEAT_UNTIL_VALUE] = 1;
  external[CONTROL_REPEAT_UNTIL_VALUE] = 0;
  data_class[CONTROL_REPEAT_UNTIL_VALUE] = CONTROL;

  strcpy(name[CONTROL_RESTART],"control_restart");
  type[CONTROL_RESTART] = INTEGER;
  data_length[CONTROL_RESTART] = 1;
  data_class[CONTROL_RESTART] = CONTROL;

  strcpy(name[CONTROL_SOLVER],"control_solver");
  type[CONTROL_SOLVER] = INTEGER;
  data_length[CONTROL_SOLVER] = 1;
  data_class[CONTROL_SOLVER] = CONTROL;

  strcpy(name[CONTROL_TIMESTEP],"control_timestep");
  type[CONTROL_TIMESTEP] = DOUBLE;
  data_length[CONTROL_TIMESTEP] = DATA_ITEM_SIZE;
  fixed_length[CONTROL_TIMESTEP] = 0;
  data_class[CONTROL_TIMESTEP] = CONTROL;

  strcpy(name[CONTROL_TIMESTEP_ITERATIONS],"control_timestep_iterations");
  type[CONTROL_TIMESTEP_ITERATIONS] = INTEGER;
  data_length[CONTROL_TIMESTEP_ITERATIONS] = 1;
  data_class[CONTROL_TIMESTEP_ITERATIONS] = CONTROL;

  strcpy(name[CONTROL_TIMESTEP_ITERATIONS_AUTOMATIC],"control_timestep_iterations_automatic");
  type[CONTROL_TIMESTEP_ITERATIONS_AUTOMATIC] = DOUBLE;
  data_length[CONTROL_TIMESTEP_ITERATIONS_AUTOMATIC] = 2;
  data_class[CONTROL_TIMESTEP_ITERATIONS_AUTOMATIC] = CONTROL;

  strcpy(name[CYLINDER_HOLLOW],"cylinder_hollow" );

  strcpy(name[DATABASE],"database");

  strcpy(name[DEPENDENCY],"dependency");

  strcpy(name[DEPENDENCY_DIAGRAM],"dependency_diagram");
  type[DEPENDENCY_DIAGRAM] = DOUBLE;
  data_length[DEPENDENCY_DIAGRAM] = DATA_ITEM_SIZE;
  fixed_length[DEPENDENCY_DIAGRAM] = 0;
  data_class[DEPENDENCY_DIAGRAM] = DEPENDENCY;

  strcpy(name[DEPENDENCY_ITEM],"dependency_item");
  type[DEPENDENCY_ITEM] = INTEGER;
  data_length[DEPENDENCY_ITEM] = 4;
  data_class[DEPENDENCY_ITEM] = DEPENDENCY;

  strcpy(name[DIAGONAL],"diagonal");

  strcpy(name[EMPTY],"empty" );

  strcpy(name[MATERI_DISPLACEMENT],"materi_displacement");

  strcpy(name[DOF],"dof");

  strcpy(name[DOF_LABEL],"dof_label");
  type[DOF_LABEL] = INTEGER;
  data_length[DOF_LABEL] = nuknwn;
  no_index[DOF_LABEL] = 1;
  data_class[DOF_LABEL] = DOF;

  strcpy(name[DOF_PRINCIPAL],"dof_principal");
  type[DOF_PRINCIPAL] = INTEGER;
  data_length[DOF_PRINCIPAL] = nuknwn;
  no_index[DOF_PRINCIPAL] = 1;
  external[DOF_PRINCIPAL] = 0;
  data_class[DOF_PRINCIPAL] = DOF;

  strcpy(name[DOF_SCAL_VEC_MAT],"dof_scal_vec_mat");
  type[DOF_SCAL_VEC_MAT] = INTEGER;
  data_length[DOF_SCAL_VEC_MAT] = nuknwn;
  no_index[DOF_SCAL_VEC_MAT] = 1;
  external[DOF_SCAL_VEC_MAT] = 0;
  data_class[DOF_SCAL_VEC_MAT] = DOF;

  strcpy(name[DOF_TYINGS],"dof_tyings");
  type[DOF_TYINGS] = INTEGER;
  data_length[DOF_TYINGS] = 2+nuknwn;
  fixed_length[DOF_TYINGS] = 0;
  data_class[DOF_TYINGS] = DOF;

  strcpy(name[DOF_TYPE],"dof_type");
  type[DOF_TYPE] = INTEGER;
  data_length[DOF_TYPE] = nuknwn;
  no_index[DOF_TYPE] = 1;
  external[DOF_TYPE] = 0;
  data_class[DOF_TYPE] = DOF;

  strcpy(name[DTIME],"dtime");
  type[DTIME] = DOUBLE;
  data_length[DTIME] = 1;
  no_index[DTIME] = 1;
  version_all[DTIME] = 1;
  external[DTIME] = 0;

  strcpy(name[DYNAMIC],"dynamic" );

  strcpy(name[ELEMENT],"element");
  type[ELEMENT] = INTEGER;
  if      ( ndim==1 ) data_length[ELEMENT] = 1+5;
  else if ( ndim==2 ) data_length[ELEMENT] = 1+25;
  else if ( ndim==3 ) data_length[ELEMENT] = 1+125;
  fixed_length[ELEMENT] = 0;
  version_all[ELEMENT] = 1;
  data_class[ELEMENT] = ELEMENT;

  strcpy(name[ELEMENT_DELETE_FACTOR],"element_delete_factor");
  type[ELEMENT_DELETE_FACTOR] = DOUBLE;
  data_length[ELEMENT_DELETE_FACTOR] = 1;
  external[ELEMENT_DELETE_FACTOR] = 0;
  version_all[ELEMENT_DELETE_FACTOR] = 1;
  data_class[ELEMENT_DELETE_FACTOR] = ELEMENT;

  strcpy(name[ELEMENT_DELETE_TIMES],"element_delete_times");
  type[ELEMENT_DELETE_TIMES] = DOUBLE;
  data_length[ELEMENT_DELETE_TIMES] = 2;
  external[ELEMENT_DELETE_TIMES] = 0;
  version_all[ELEMENT_DELETE_TIMES] = 1;
  data_class[ELEMENT_DELETE_TIMES] = ELEMENT;

  strcpy(name[ELEMENT_DISTRIBUTE],"element_distribute");
  type[ELEMENT_DISTRIBUTE] = INTEGER;
  data_length[ELEMENT_DISTRIBUTE] = 2;
  external[ELEMENT_DISTRIBUTE] = 0;
  version_all[ELEMENT_DISTRIBUTE] = 1;
  data_class[ELEMENT_DISTRIBUTE] = ELEMENT;

  strcpy(name[ELEMENT_DISTRIBUTE_VALUES],"element_distribute_values");
  type[ELEMENT_DISTRIBUTE_VALUES] = DOUBLE;
  data_length[ELEMENT_DISTRIBUTE_VALUES] = 1;
  external[ELEMENT_DISTRIBUTE_VALUES] = 0;
  version_all[ELEMENT_DISTRIBUTE_VALUES] = 1;
  data_class[ELEMENT_DISTRIBUTE_VALUES] = ELEMENT;

  strcpy(name[ELEMENT_GROUP],"element_group");
  type[ELEMENT_GROUP] = INTEGER;
  data_length[ELEMENT_GROUP] = 1;
  version_all[ELEMENT_GROUP] = 1;
  data_class[ELEMENT_GROUP] = ELEMENT;

  strcpy(name[ELEMENT_MATRIX_DELETE],"element_matrix_delete");
  type[ELEMENT_MATRIX_DELETE] = DOUBLE;
  data_length[ELEMENT_MATRIX_DELETE] = MNOL*MPUKNWN;
  fixed_length[ELEMENT_MATRIX_DELETE] = 0;
  data_class[ELEMENT_MATRIX_DELETE] = ELEMENT;
  external[ELEMENT_MATRIX_DELETE] = 0;

  strcpy(name[ELEMENT_MATRIX_UNKNOWNS],"element_matrix_unknowns");
  type[ELEMENT_MATRIX_UNKNOWNS] = INTEGER;
  data_length[ELEMENT_MATRIX_UNKNOWNS] = 0; // set run-time
  fixed_length[ELEMENT_MATRIX_UNKNOWNS] = 0;
  external[ELEMENT_MATRIX_UNKNOWNS] = 0;
  data_class[ELEMENT_MATRIX_UNKNOWNS] = ELEMENT;

  strcpy(name[ELEMENT_MATRIX_VALUES],"element_matrix_values");
  type[ELEMENT_MATRIX_VALUES] = DOUBLE;
  data_length[ELEMENT_MATRIX_VALUES] = 0; // set run-time
  fixed_length[ELEMENT_MATRIX_VALUES] = 0;
  data_class[ELEMENT_MATRIX_VALUES] = ELEMENT;
  external[ELEMENT_MATRIX_VALUES] = 0;

  strcpy(name[ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES],"element_matrix_stress_stiffness_values");
  type[ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES] = DOUBLE;
  data_length[ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES] = 0; // set run-time
  fixed_length[ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES] = 0;
  data_class[ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES] = ELEMENT;
  external[ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES] = 0;

  strcpy(name[ELEMENT_RHSIDE_DELETE],"element_rhside_delete");
  type[ELEMENT_RHSIDE_DELETE] = DOUBLE;
  data_length[ELEMENT_RHSIDE_DELETE] = MNOL*MPUKNWN;
  fixed_length[ELEMENT_RHSIDE_DELETE] = 0;
  data_class[ELEMENT_RHSIDE_DELETE] = ELEMENT;
  external[ELEMENT_RHSIDE_DELETE] = 0;

  strcpy(name[ELEMENT_TENDON_DIRECTION],"element_tendon_direction");
  type[ELEMENT_TENDON_DIRECTION] = DOUBLE;
  data_length[ELEMENT_TENDON_DIRECTION] = MTENDON * MDIM;
  fixed_length[ELEMENT_TENDON_DIRECTION] = 0;
  version_all[ELEMENT_TENDON_DIRECTION] = 1;
  print_only[ELEMENT_TENDON_DIRECTION] = 1;
  data_class[ELEMENT_TENDON_DIRECTION] = ELEMENT;

  strcpy(name[ELEMENT_TENDON_NUMBER],"element_tendon_number");
  type[ELEMENT_TENDON_NUMBER] = INTEGER;
  data_length[ELEMENT_TENDON_NUMBER] = MTENDON;
  fixed_length[ELEMENT_TENDON_NUMBER] = 0;
  version_all[ELEMENT_TENDON_NUMBER] = 1;
  print_only[ELEMENT_TENDON_NUMBER] = 1;
  data_class[ELEMENT_TENDON_NUMBER] = ELEMENT;

  strcpy(name[ELEMENT_TENDON_STRESS],"element_tendon_stress");
  type[ELEMENT_TENDON_STRESS] = DOUBLE;
  data_length[ELEMENT_TENDON_STRESS] = MTENDON;
  fixed_length[ELEMENT_TENDON_STRESS] = 0;
  version_all[ELEMENT_TENDON_STRESS] = 1;
  print_only[ELEMENT_TENDON_STRESS] = 1;
  data_class[ELEMENT_TENDON_STRESS] = ELEMENT;

  strcpy(name[ELEMENT_TENDON_VOLUME],"element_tendon_volume");
  type[ELEMENT_TENDON_VOLUME] = DOUBLE;
  data_length[ELEMENT_TENDON_VOLUME] = MTENDON;
  fixed_length[ELEMENT_TENDON_VOLUME] = 0;
  version_all[ELEMENT_TENDON_VOLUME] = 1;
  print_only[ELEMENT_TENDON_VOLUME] = 1;
  data_class[ELEMENT_TENDON_VOLUME] = ELEMENT;

  strcpy(name[ELEMENT_VOLUME],"element_volume");
  type[ELEMENT_VOLUME] = DOUBLE;
  data_length[ELEMENT_VOLUME] = 1;
  external[ELEMENT_VOLUME] = 0;
  data_class[ELEMENT_VOLUME] = ELEMENT;

  strcpy(name[EVERYTHING],"everything" );

  strcpy(name[FIXED_IN_SPACE],"fixed_in_space");

  strcpy(name[FOLLOW_MATERIAL],"follow_material");

  strcpy(name[FORCE],"force");

  strcpy(name[FORCE_ELEMENT_EDGE],"force_element_edge");
  type[FORCE_ELEMENT_EDGE] = DOUBLE;
  data_length[FORCE_ELEMENT_EDGE] = npuknwn;
  data_class[FORCE_ELEMENT_EDGE] = FORCE;

  strcpy(name[FORCE_ELEMENT_EDGE_GEOMETRY],"force_element_edge_geometry");
  type[FORCE_ELEMENT_EDGE_GEOMETRY] = INTEGER;
  data_length[FORCE_ELEMENT_EDGE_GEOMETRY] = DATA_ITEM_SIZE;
  fixed_length[FORCE_ELEMENT_EDGE_GEOMETRY] = 0;
  data_class[FORCE_ELEMENT_EDGE_GEOMETRY] = FORCE;

  strcpy(name[FORCE_ELEMENT_EDGE_TIME],"force_element_edge_time");
  type[FORCE_ELEMENT_EDGE_TIME] = DOUBLE;
  data_length[FORCE_ELEMENT_EDGE_TIME] = DATA_ITEM_SIZE;
  fixed_length[FORCE_ELEMENT_EDGE_TIME] = 0;
  data_class[FORCE_ELEMENT_EDGE_TIME] = FORCE;

  strcpy(name[FORCE_ELEMENT_EDGE_NORMAL],"force_element_edge_normal");
  type[FORCE_ELEMENT_EDGE_NORMAL] = DOUBLE;
  data_length[FORCE_ELEMENT_EDGE_NORMAL] = 1;
  data_class[FORCE_ELEMENT_EDGE_NORMAL] = FORCE;

  strcpy(name[FORCE_ELEMENT_EDGE_GEOMETRY_NORMAL],"force_element_edge_geometry_normal");
  type[FORCE_ELEMENT_EDGE_GEOMETRY_NORMAL] = INTEGER;
  data_length[FORCE_ELEMENT_EDGE_GEOMETRY_NORMAL] = 2;
  fixed_length[FORCE_ELEMENT_EDGE_GEOMETRY_NORMAL] = 0;
  data_class[FORCE_ELEMENT_EDGE_GEOMETRY_NORMAL] = FORCE;

  strcpy(name[FORCE_ELEMENT_EDGE_TIME_NORMAL],"force_element_edge_time_normal");
  type[FORCE_ELEMENT_EDGE_TIME_NORMAL] = DOUBLE;
  data_length[FORCE_ELEMENT_EDGE_TIME_NORMAL] = DATA_ITEM_SIZE;
  fixed_length[FORCE_ELEMENT_EDGE_TIME_NORMAL] = 0;
  data_class[FORCE_ELEMENT_EDGE_TIME_NORMAL] = FORCE;

  strcpy(name[FORCE_ELEMENT_VOLUME],"force_element_volume");
  type[FORCE_ELEMENT_VOLUME] = DOUBLE;
  data_length[FORCE_ELEMENT_VOLUME] = npuknwn;
  data_class[FORCE_ELEMENT_VOLUME] = FORCE;
  version_all[FORCE_ELEMENT_VOLUME] = 1;

  strcpy(name[FORCE_ELEMENT_VOLUME_FACTOR],"force_element_volume_factor");
  type[FORCE_ELEMENT_VOLUME_FACTOR] = DOUBLE;
  data_length[FORCE_ELEMENT_VOLUME_FACTOR] = DATA_ITEM_SIZE;
  fixed_length[FORCE_ELEMENT_VOLUME_FACTOR] = 0;
  data_class[FORCE_ELEMENT_VOLUME_FACTOR] = FORCE;

  strcpy(name[FORCE_ELEMENT_VOLUME_GEOMETRY],"force_element_volume_geometry");
  type[FORCE_ELEMENT_VOLUME_GEOMETRY] = INTEGER;
  data_length[FORCE_ELEMENT_VOLUME_GEOMETRY] = DATA_ITEM_SIZE;
  fixed_length[FORCE_ELEMENT_VOLUME_GEOMETRY] = 0;
  data_class[FORCE_ELEMENT_VOLUME_GEOMETRY] = FORCE;

  strcpy(name[FORCE_ELEMENT_VOLUME_TIME],"force_element_volume_time");
  type[FORCE_ELEMENT_VOLUME_TIME] = DOUBLE;
  data_length[FORCE_ELEMENT_VOLUME_TIME] = DATA_ITEM_SIZE;
  fixed_length[FORCE_ELEMENT_VOLUME_TIME] = 0;
  data_class[FORCE_ELEMENT_VOLUME_TIME] = FORCE;

  strcpy(name[FORCE_GRAVITY],"force_gravity");
  type[FORCE_GRAVITY] = DOUBLE;
  data_length[FORCE_GRAVITY] = ndim;
  no_index[FORCE_GRAVITY] = 1;
  data_class[FORCE_GRAVITY] = FORCE_GRAVITY;

  strcpy(name[FORCE_GRAVITY_TIME],"force_gravity_time");
  type[FORCE_GRAVITY_TIME] = DOUBLE;
  no_index[FORCE_GRAVITY_TIME] = 1;
  data_length[FORCE_GRAVITY_TIME] = DATA_ITEM_SIZE;
  fixed_length[FORCE_GRAVITY_TIME] = 0;
  data_class[FORCE_GRAVITY_TIME] = FORCE_GRAVITY;

  strcpy(name[FROM],"from");

  strcpy(name[GEOMETRY],"geometry");

  strcpy(name[GEOMETRY_BOUNDA_FACTOR],"geometry_bounda_factor");
  type[GEOMETRY_BOUNDA_FACTOR] = DOUBLE;
  data_length[GEOMETRY_BOUNDA_FACTOR] = 3;
  fixed_length[GEOMETRY_BOUNDA_FACTOR] = 0;
  data_class[GEOMETRY_BOUNDA_FACTOR] = GEOMETRY;

  strcpy(name[GEOMETRY_CIRCLE],"geometry_circle");
  type[GEOMETRY_CIRCLE] = DOUBLE;
  data_length[GEOMETRY_CIRCLE] = ndim+2;
  data_class[GEOMETRY_CIRCLE] = GEOMETRY;

  strcpy(name[GEOMETRY_CYLINDER],"geometry_cylinder");
  type[GEOMETRY_CYLINDER] = DOUBLE;
  data_length[GEOMETRY_CYLINDER] = 8;
  data_class[GEOMETRY_CYLINDER] = GEOMETRY;

  strcpy(name[GEOMETRY_LINE],"geometry_line");
  type[GEOMETRY_LINE] = DOUBLE;
  data_length[GEOMETRY_LINE] = 2*ndim+1;
  data_class[GEOMETRY_LINE] = GEOMETRY;

  strcpy(name[GEOMETRY_NUMBER],"geometry_number");
  type[GEOMETRY_NUMBER] = INTEGER;
  data_length[GEOMETRY_NUMBER] = 1;
  data_class[GEOMETRY_NUMBER] = GEOMETRY;

  strcpy(name[GEOMETRY_POINT],"geometry_point");
  type[GEOMETRY_POINT] = DOUBLE;
  data_length[GEOMETRY_POINT] = ndim+1;
  data_class[GEOMETRY_POINT] = GEOMETRY;

  strcpy(name[GEOMETRY_POLYNOMIAL],"geometry_polynomial");
  type[GEOMETRY_POLYNOMIAL] = DOUBLE;
  data_length[GEOMETRY_POLYNOMIAL] = DATA_ITEM_SIZE;
  fixed_length[GEOMETRY_POLYNOMIAL] = 0;
  data_class[GEOMETRY_POLYNOMIAL] = GEOMETRY;

  strcpy(name[GEOMETRY_QUADRILATERAL],"geometry_quadrilateral");
  type[GEOMETRY_QUADRILATERAL] = DOUBLE;
  data_length[GEOMETRY_QUADRILATERAL] = 4*ndim+1;
  data_class[GEOMETRY_QUADRILATERAL] = GEOMETRY;

  strcpy(name[GEOMETRY_SET],"geometry_set");
  type[GEOMETRY_SET] = INTEGER;
  data_length[GEOMETRY_SET] = DATA_ITEM_SIZE;
  fixed_length[GEOMETRY_SET] = 0;
  data_class[GEOMETRY_SET] = GEOMETRY;

  strcpy(name[GEOMETRY_SPHERE],"geometry_sphere");
  type[GEOMETRY_SPHERE] = DOUBLE;
  data_length[GEOMETRY_SPHERE] = ndim+2;
  data_class[GEOMETRY_SPHERE] = GEOMETRY;

  strcpy(name[GEOMETRY_TRIANGLE],"geometry_triangle");
  type[GEOMETRY_TRIANGLE] = DOUBLE;
  data_length[GEOMETRY_TRIANGLE] = 3*ndim+1;
  data_class[GEOMETRY_TRIANGLE] = GEOMETRY;

  strcpy(name[GROUNDFLOW],"groundflow");

  strcpy(name[GROUNDFLOW_PRESSURE],"groundflow_pressure");

  strcpy(name[GROUNDFLOW_VELOCITY],"groundflow_velocity");

  strcpy(name[GROUP_CONDIF_ABSORPTION],"group_condif_absorption");
  type[GROUP_CONDIF_ABSORPTION] = DOUBLE;
  data_length[GROUP_CONDIF_ABSORPTION] = 1;
  data_class[GROUP_CONDIF_ABSORPTION] = CONDIF;

  strcpy(name[GROUP_CONDIF_DENSITY],"group_condif_density");
  type[GROUP_CONDIF_DENSITY] = DOUBLE;
  data_length[GROUP_CONDIF_DENSITY] = 1;
  data_class[GROUP_CONDIF_DENSITY] = CONDIF;

  strcpy(name[GROUP_CONDIF_CAPACITY],"group_condif_capacity");
  type[GROUP_CONDIF_CAPACITY] = DOUBLE;
  data_length[GROUP_CONDIF_CAPACITY] = 1;
  data_class[GROUP_CONDIF_CAPACITY] = CONDIF;

  strcpy(name[GROUP_CONDIF_FLOW],"group_condif_flow");
  type[GROUP_CONDIF_FLOW] = DOUBLE;
  data_length[GROUP_CONDIF_FLOW] = ndim;
  data_class[GROUP_CONDIF_FLOW] = CONDIF;

  strcpy(name[GROUP_CONDIF_CONDUCTIVITY],"group_condif_conductivity");
  type[GROUP_CONDIF_CONDUCTIVITY] = DOUBLE;
  data_length[GROUP_CONDIF_CONDUCTIVITY] = 1;
  data_class[GROUP_CONDIF_CONDUCTIVITY] = CONDIF;

  strcpy(name[GROUP_GROUNDFLOW_COMPRESSIBILITY],"group_groundflow_compressibility");
  type[GROUP_GROUNDFLOW_COMPRESSIBILITY] = DOUBLE;
  data_length[GROUP_GROUNDFLOW_COMPRESSIBILITY] = 1;
  data_class[GROUP_GROUNDFLOW_COMPRESSIBILITY] = GROUNDFLOW;

  strcpy(name[GROUP_GROUNDFLOW_DENSITY],"group_groundflow_density");
  type[GROUP_GROUNDFLOW_DENSITY] = DOUBLE;
  data_length[GROUP_GROUNDFLOW_DENSITY] = 1;
  data_class[GROUP_GROUNDFLOW_DENSITY] = GROUNDFLOW;

  strcpy(name[GROUP_GROUNDFLOW_PERMEABILITY],"group_groundflow_permeability");
  type[GROUP_GROUNDFLOW_PERMEABILITY] = DOUBLE;
  data_length[GROUP_GROUNDFLOW_PERMEABILITY] = ndim;
  data_class[GROUP_GROUNDFLOW_PERMEABILITY] = GROUNDFLOW;

  strcpy(name[GROUP_INTEGRATION_POINTS],"group_integration_points");
  type[GROUP_INTEGRATION_POINTS] = INTEGER;
  data_length[GROUP_INTEGRATION_POINTS] = 1;
  version_all[GROUP_INTEGRATION_POINTS] = 1;
  data_class[GROUP_INTEGRATION_POINTS] = GROUP_INTEGRATION_POINTS;

  strcpy(name[GROUP_MATERI_ELASTI_CAMCLAY],"group_materi_elasti_camclay");
  type[GROUP_MATERI_ELASTI_CAMCLAY] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_CAMCLAY] = 1;
  data_class[GROUP_MATERI_ELASTI_CAMCLAY] = MATERI;

  strcpy(name[GROUP_MATERI_DAMAGE_MAZARS],"group_materi_damage_mazars");
  type[GROUP_MATERI_DAMAGE_MAZARS] = DOUBLE;
  data_length[GROUP_MATERI_DAMAGE_MAZARS] = 6;

  strcpy(name[GROUP_MATERI_DAMPING],"group_materi_damping");
  type[GROUP_MATERI_DAMPING] = DOUBLE;
  data_length[GROUP_MATERI_DAMPING] = 1;

  strcpy(name[GROUP_MATERI_DENSITY],"group_materi_density");
  type[GROUP_MATERI_DENSITY] = DOUBLE;
  data_length[GROUP_MATERI_DENSITY] = 1;

  strcpy(name[GROUP_MATERI_DENSITY_MINIMUM],"group_materi_density_minimum");
  type[GROUP_MATERI_DENSITY_MINIMUM] = DOUBLE;
  data_length[GROUP_MATERI_DENSITY_MINIMUM] = 1;

  strcpy(name[GROUP_MATERI_ELASTI_COMPRESSIBILITY],"group_materi_elasti_compressibility");
  type[GROUP_MATERI_ELASTI_COMPRESSIBILITY] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_COMPRESSIBILITY] = 1;
  data_class[GROUP_MATERI_ELASTI_COMPRESSIBILITY] = MATERI;

  strcpy(name[GROUP_MATERI_ELASTI_LADE],"group_materi_elasti_lade");
  type[GROUP_MATERI_ELASTI_LADE] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_LADE] = 3;
  data_class[GROUP_MATERI_ELASTI_LADE] = MATERI;

  strcpy(name[GROUP_MATERI_ELASTI_LADE_TMP],"group_materi_elasti_lade_tmp");
  type[GROUP_MATERI_ELASTI_LADE_TMP] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_LADE_TMP] = 4;
  data_class[GROUP_MATERI_ELASTI_LADE_TMP] = MATERI;

  strcpy(name[GROUP_MATERI_ELASTI_POISSON],"group_materi_elasti_poisson");
  type[GROUP_MATERI_ELASTI_POISSON] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_POISSON] = 1;
  data_class[GROUP_MATERI_ELASTI_POISSON] = MATERI;

  strcpy(name[GROUP_MATERI_ELASTI_TRANSVERSE_ISOTROPY],"group_materi_elasti_transverse_isotropy");
  type[GROUP_MATERI_ELASTI_TRANSVERSE_ISOTROPY] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_TRANSVERSE_ISOTROPY] = 8;
  data_class[GROUP_MATERI_ELASTI_TRANSVERSE_ISOTROPY] = MATERI;

  strcpy(name[GROUP_MATERI_ELASTI_YOUNG],"group_materi_elasti_young");
  type[GROUP_MATERI_ELASTI_YOUNG] = DOUBLE;
  data_length[GROUP_MATERI_ELASTI_YOUNG] = 1;
  data_class[GROUP_MATERI_ELASTI_YOUNG] = MATERI;

  strcpy(name[GROUP_MATERI_EXPANSION_LINEAR],"group_materi_expansion_linear");
  type[GROUP_MATERI_EXPANSION_LINEAR] = DOUBLE;
  data_length[GROUP_MATERI_EXPANSION_LINEAR] = 1;
  data_class[GROUP_MATERI_EXPANSION_LINEAR] = MATERI;

  strcpy(name[GROUP_MATERI_EXPANSION_VOLUME],"group_materi_expansion_volume");
  type[GROUP_MATERI_EXPANSION_VOLUME] = DOUBLE;
  data_length[GROUP_MATERI_EXPANSION_VOLUME] = 1;
  data_class[GROUP_MATERI_EXPANSION_VOLUME] = MATERI;

  strcpy(name[GROUP_MATERI_FAILURE_DAMAGE],"group_materi_failure_damage");
  type[GROUP_MATERI_FAILURE_DAMAGE] = DOUBLE;
  data_length[GROUP_MATERI_FAILURE_DAMAGE] = 2;
  data_class[GROUP_MATERI_FAILURE_DAMAGE] = MATERI;

  strcpy(name[GROUP_MATERI_FAILURE_STRAIN_PLASTI_KAPPA],"group_materi_failure_strain_plasti_kappa");
  type[GROUP_MATERI_FAILURE_STRAIN_PLASTI_KAPPA] = DOUBLE;
  data_length[GROUP_MATERI_FAILURE_STRAIN_PLASTI_KAPPA] = 2;
  data_class[GROUP_MATERI_FAILURE_STRAIN_PLASTI_KAPPA] = MATERI;

  strcpy(name[GROUP_MATERI_FAILURE_VOIDFRACTION],"group_materi_failure_voidfraction");
  type[GROUP_MATERI_FAILURE_VOIDFRACTION] = DOUBLE;
  data_length[GROUP_MATERI_FAILURE_VOIDFRACTION] = 2;
  data_class[GROUP_MATERI_FAILURE_VOIDFRACTION] = MATERI;

  strcpy(name[GROUP_MATERI_HYPER_BESSELING],"group_materi_hyper_besseling");
  type[GROUP_MATERI_HYPER_BESSELING] = DOUBLE;
  data_length[GROUP_MATERI_HYPER_BESSELING] = 3;
  data_class[GROUP_MATERI_HYPER_BESSELING] = MATERI;

  strcpy(name[GROUP_MATERI_HYPER_MOONEY_RIVLIN],"group_materi_hyper_mooney_rivlin");
  type[GROUP_MATERI_HYPER_MOONEY_RIVLIN] = DOUBLE;
  data_length[GROUP_MATERI_HYPER_MOONEY_RIVLIN] = 2;
  data_class[GROUP_MATERI_HYPER_MOONEY_RIVLIN] = MATERI;

  strcpy(name[GROUP_MATERI_MAXWELL_CHAIN],"group_materi_maxwell_chain");
  type[GROUP_MATERI_MAXWELL_CHAIN] = DOUBLE;
  data_length[GROUP_MATERI_MAXWELL_CHAIN] = materi_maxwell_stress*2;
  data_class[GROUP_MATERI_MAXWELL_CHAIN] = MATERI;

  strcpy(name[GROUP_MATERI_MEMBRANE],"group_materi_membrane");
  type[GROUP_MATERI_MEMBRANE] = INTEGER;
  data_length[GROUP_MATERI_MEMBRANE] = 1;
  data_class[GROUP_MATERI_MEMBRANE] = MATERI;

  strcpy(name[GROUP_MATERI_MEMORY],"group_materi_memory");
  type[GROUP_MATERI_MEMORY] = INTEGER;
  data_length[GROUP_MATERI_MEMORY] = 1;
  data_class[GROUP_MATERI_MEMORY] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_CAMCLAY],"group_materi_plasti_camclay");
  type[GROUP_MATERI_PLASTI_CAMCLAY] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_CAMCLAY] = 3;
  data_class[GROUP_MATERI_PLASTI_CAMCLAY] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_CAP],"group_materi_plasti_cap");
  type[GROUP_MATERI_PLASTI_CAP] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_CAP] = DATA_ITEM_SIZE;
  data_class[GROUP_MATERI_PLASTI_CAP] = MATERI;
  fixed_length[GROUP_MATERI_PLASTI_CAP] = 0;

  strcpy(name[GROUP_MATERI_PLASTI_COMPRESSION],"group_materi_plasti_compression");
  type[GROUP_MATERI_PLASTI_COMPRESSION] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_COMPRESSION] = 1;
  data_class[GROUP_MATERI_PLASTI_COMPRESSION] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_DIPRISCO],"group_materi_plasti_diprisco");
  type[GROUP_MATERI_PLASTI_DIPRISCO] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_DIPRISCO] = 10;
  data_class[GROUP_MATERI_PLASTI_DIPRISCO] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_DRUCKPRAG],"group_materi_plasti_druckprag");
  type[GROUP_MATERI_PLASTI_DRUCKPRAG] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_DRUCKPRAG] = 3;
  data_class[GROUP_MATERI_PLASTI_DRUCKPRAG] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_GURSON],"group_materi_plasti_gurson");
  type[GROUP_MATERI_PLASTI_GURSON] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_GURSON] = 4;
  data_class[GROUP_MATERI_PLASTI_GURSON] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_HEAT_GENERATION], "group_materi_plasti_heat_generation");
  type[GROUP_MATERI_PLASTI_HEAT_GENERATION] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_HEAT_GENERATION] = 1;
  data_class[GROUP_MATERI_PLASTI_HEAT_GENERATION] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_KINEMATIC_HARDENING],"group_materi_plasti_kinematic_hardening");
  type[GROUP_MATERI_PLASTI_KINEMATIC_HARDENING] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_KINEMATIC_HARDENING] = 1;
  data_class[GROUP_MATERI_PLASTI_KINEMATIC_HARDENING] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_MOHRCOUL],"group_materi_plasti_mohrcoul");
  type[GROUP_MATERI_PLASTI_MOHRCOUL] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_MOHRCOUL] = 3;
  data_class[GROUP_MATERI_PLASTI_MOHRCOUL] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_TENSION],"group_materi_plasti_tension");
  type[GROUP_MATERI_PLASTI_TENSION] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_TENSION] = 1;
  data_class[GROUP_MATERI_PLASTI_TENSION] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_VISCO_EXPONENTIAL],"group_materi_plasti_visco_exponential");
  type[GROUP_MATERI_PLASTI_VISCO_EXPONENTIAL] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_VISCO_EXPONENTIAL] = 2;
  data_class[GROUP_MATERI_PLASTI_VISCO_EXPONENTIAL] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_VISCO_POWER],"group_materi_plasti_visco_power");
  type[GROUP_MATERI_PLASTI_VISCO_POWER] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_VISCO_POWER] = 3;
  data_class[GROUP_MATERI_PLASTI_VISCO_POWER] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_VONMISES],"group_materi_plasti_vonmises");
  type[GROUP_MATERI_PLASTI_VONMISES] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_VONMISES] = 1;
  data_class[GROUP_MATERI_PLASTI_VONMISES] = MATERI;

  strcpy(name[GROUP_MATERI_PLASTI_VONMISES_NADAI],"group_materi_plasti_vonmises_nadai");
  type[GROUP_MATERI_PLASTI_VONMISES_NADAI] = DOUBLE;
  data_length[GROUP_MATERI_PLASTI_VONMISES_NADAI] = 3;
  data_class[GROUP_MATERI_PLASTI_VONMISES_NADAI] = MATERI;

  strcpy(name[GROUP_MATERI_STOKES],"group_materi_stokes");
  type[GROUP_MATERI_STOKES] = INTEGER;
  data_length[GROUP_MATERI_STOKES] = 1;
  data_class[GROUP_MATERI_STOKES] = MATERI;

  strcpy(name[GROUP_MATERI_VISCOSITY],"group_materi_viscosity");
  type[GROUP_MATERI_VISCOSITY] = DOUBLE;
  data_length[GROUP_MATERI_VISCOSITY] = 1;
  data_class[GROUP_MATERI_VISCOSITY] = MATERI;

  strcpy(name[GROUP_TYPE],"group_type");
  type[GROUP_TYPE] = INTEGER;
  data_length[GROUP_TYPE] = MTYPE;
  fixed_length[GROUP_TYPE] = 0;
  data_class[GROUP_TYPE] = GROUP_TYPE;

  strcpy(name[GROUP_USER_DATA],"group_user_data");
  type[GROUP_USER_DATA] = DOUBLE;
  data_length[GROUP_USER_DATA] = DATA_ITEM_SIZE;
  fixed_length[GROUP_USER_DATA] = 0;

  strcpy(name[GROUP_USER_UMAT],"group_user_umat");
  type[GROUP_USER_UMAT] = INTEGER;
  data_length[GROUP_USER_UMAT] = 1;

  strcpy(name[GROUP_WAVE_SPEED_OF_SOUND],"group_wave_speed_of_sound");
  type[GROUP_WAVE_SPEED_OF_SOUND] = DOUBLE;
  data_length[GROUP_WAVE_SPEED_OF_SOUND] = 1;
  data_class[GROUP_WAVE_SPEED_OF_SOUND] = WAVE;

  strcpy(name[HEX8],"hex8");

  strcpy(name[HEX27],"hex27");

  strcpy(name[HEX64],"hex64");

  strcpy(name[HEX125],"hex125");

  strcpy(name[H_REFINEMENT],"h_refinement");

  strcpy(name[INITIALIZATION_VALUES],"initialization_values");
  type[INITIALIZATION_VALUES] = INTEGER;
  data_length[INITIALIZATION_VALUES] = DATA_ITEM_SIZE;
  no_index[INITIALIZATION_VALUES] = 1;
  external[INITIALIZATION_VALUES] = 0;
  fixed_length[INITIALIZATION_VALUES] = 0;

  strcpy(name[INVERSE],"inverse");

  strcpy(name[INVERSE_HISTORY],"inverse_history");
  type[INVERSE_HISTORY] = DOUBLE;
  data_length[INVERSE_HISTORY] = 2;
  no_index[INVERSE_HISTORY] = 1;
  external[INVERSE_HISTORY] = 0;
  data_class[INVERSE_HISTORY] = INVERSE;

  strcpy(name[INVERSE_ITERATIONS],"inverse_iterations");
  type[INVERSE_ITERATIONS] = INTEGER;
  data_length[INVERSE_ITERATIONS] = 1;
  no_index[INVERSE_ITERATIONS] = 1;
  data_class[INVERSE_ITERATIONS] = INVERSE;

  strcpy(name[INVERSE_ITERATION_NUMBER],"inverse_iteration_number");
  type[INVERSE_ITERATION_NUMBER] = INTEGER;
  data_length[INVERSE_ITERATION_NUMBER] = 1;
  no_index[INVERSE_ITERATION_NUMBER] = 1;
  data_class[INVERSE_ITERATION_NUMBER] = INVERSE;

  strcpy(name[INVERSE_PARAMETER],"inverse_parameter");
  type[INVERSE_PARAMETER] = INTEGER;
  data_length[INVERSE_PARAMETER] = 3;
  data_class[INVERSE_PARAMETER] = INVERSE;

  strcpy(name[INVERSE_PARAMETER_LIMITS],"inverse_parameter_limits");
  type[INVERSE_PARAMETER_LIMITS] = DOUBLE;
  data_length[INVERSE_PARAMETER_LIMITS] = 2;
  data_class[INVERSE_PARAMETER_LIMITS] = INVERSE;

  strcpy(name[INVERSE_PARAMETER_SENSITIVITY],"inverse_parameter_sensitivity");
  type[INVERSE_PARAMETER_SENSITIVITY] = DOUBLE;
  data_length[INVERSE_PARAMETER_SENSITIVITY] = 3;
  external[INVERSE_PARAMETER_SENSITIVITY] = 0;
  data_class[INVERSE_PARAMETER_SENSITIVITY] = INVERSE;

  strcpy(name[INVERSE_PARAMETER_STEP],"inverse_parameter_step");
  type[INVERSE_PARAMETER_STEP] = DOUBLE;
  data_length[INVERSE_PARAMETER_STEP] = 1;
  data_class[INVERSE_PARAMETER_STEP] = INVERSE;

  strcpy(name[INVERSE_PARAMETER_VARIATION],"inverse_parameter_variation");
  type[INVERSE_PARAMETER_VARIATION] = DOUBLE;
  data_length[INVERSE_PARAMETER_VARIATION] = 1;
  data_class[INVERSE_PARAMETER_VARIATION] = INVERSE;

  strcpy(name[INVERSE_TARGET],"inverse_target");
  type[INVERSE_TARGET] = INTEGER;
  data_length[INVERSE_TARGET] = 3;
  data_class[INVERSE_TARGET] = INVERSE;

  strcpy(name[INVERSE_TARGET_DATA],"inverse_target_data");
  type[INVERSE_TARGET_DATA] = DOUBLE;
  data_length[INVERSE_TARGET_DATA] = 3;
  fixed_length[INVERSE_TARGET_DATA] = 0;
  data_class[INVERSE_TARGET_DATA] = INVERSE;

  strcpy(name[INVERSE_TARGET_TIMESTEP],"inverse_target_timestep");
  type[INVERSE_TARGET_TIMESTEP] = INTEGER;
  data_length[INVERSE_TARGET_TIMESTEP] = 1;
  data_class[INVERSE_TARGET_TIMESTEP] = INVERSE;

  strcpy(name[ICONTROL],"icontrol");
  type[ICONTROL] = INTEGER;
  data_length[ICONTROL] = 1;
  no_index[ICONTROL] = 1;
  external[ICONTROL] = 0;

  strcpy(name[MATERI],"materi");

  strcpy(name[MATERI_DAMAGE],"materi_damage");

  strcpy(name[MATERI_DENSITY],"materi_density");

  strcpy(name[MATERI_DISPLACEMENT],"materi_displacement");

  strcpy(name[MATERI_HISTORY_VARIABLES],"materi_history_variables");

  strcpy(name[MATERI_MAXWELL_STRESS],"materi_maxwell_stress");

  strcpy(name[MATERI_PLASTI_F],"materi_plasti_f");

  strcpy(name[MATERI_PLASTI_KAPPA],"materi_plasti_kappa");

  strcpy(name[MATERI_PLASTI_RHO],"materi_plasti_rho");

  strcpy(name[MATERI_STRAIN_ELASTI],"materi_strain_elasti");

  strcpy(name[MATERI_STRAIN_PLASTI],"materi_strain_plasti");

  strcpy(name[MATERI_STRAIN_TOTAL],"materi_strain_total" );

  strcpy(name[MATERI_STRESS],"materi_stress");

  strcpy(name[MATERI_VELOCITY],"materi_velocity");

  strcpy(name[MATERI_VELOCITY_INTEGRATED],"materi_velocity_integrated");

  strcpy(name[MATERI_VOID_FRACTION],"materi_void_fraction");

  strcpy(name[MATERI_WORK],"materi_work");

  strcpy(name[MATRIX],"matrix");

  strcpy(name[MATRIX_DIRECT],"matrix_direct");

  strcpy(name[MATRIX_ITERATIVE],"matrix_iterative");

  strcpy(name[MAXIMAL],"maximal");

  strcpy(name[MESH],"mesh");

  strcpy(name[MINIMAL],"minimal");

  strcpy(name[NEGATIVE],"negative");

  strcpy(name[NO],"no");

  strcpy(name[NODE],"node");
  type[NODE] = DOUBLE;
  data_length[NODE] = ndim;
  version_all[NODE] = 1;
  data_class[NODE] = NODE;

  strcpy(name[NODE_BOUNDARY],"node_boundary");
  type[NODE_BOUNDARY] = INTEGER;
  data_length[NODE_BOUNDARY] = 1;
  version_all[NODE_BOUNDARY] = 1;
  data_class[NODE_BOUNDARY] = NODE;

  strcpy(name[NODE_BOUNDED],"node_bounded");
  type[NODE_BOUNDED] = INTEGER;
  data_length[NODE_BOUNDED] = npuknwn;
  external[NODE_BOUNDED] = 0;
  version_all[NODE_BOUNDED] = 1;
  data_class[NODE_BOUNDED] = NODE;

  strcpy(name[NODE_DAMPING],"node_damping");
  type[NODE_DAMPING] = DOUBLE;
  data_length[NODE_DAMPING] = ndim;
  version_all[NODE_DAMPING] = 1;
  data_class[NODE_DAMPING] = NODE;

  strcpy(name[NODE_DOF],"node_dof");
  type[NODE_DOF] = DOUBLE;
  data_length[NODE_DOF] = nuknwn;
  version_all[NODE_DOF] = 1;
  data_class[NODE_DOF] = NODE;

  strcpy(name[NODE_DOF_CALCUL],"node_dof_calcul");
  type[NODE_DOF_CALCUL] = DOUBLE;
  data_length[NODE_DOF_CALCUL] = MCALCUL;
  fixed_length[NODE_DOF_CALCUL] = 0;
  version_all[NODE_DOF_CALCUL] = 1;
  data_class[NODE_DOF_CALCUL] = NODE;

  strcpy(name[NODE_DOF_START_REFINED],"node_dof_start_refined");
  type[NODE_DOF_START_REFINED] = DOUBLE;
  data_length[NODE_DOF_START_REFINED] = nuknwn;
  external[NODE_DOF_START_REFINED] = 0;
  version_all[NODE_DOF_START_REFINED] = 1;
  data_class[NODE_DOF_START_REFINED] = NODE;

  strcpy(name[NODE_DOF_TMP],"node_dof_tmp");
  type[NODE_DOF_TMP] = DOUBLE;
  data_length[NODE_DOF_TMP] = nuknwn;
  external[NODE_DOF_TMP] = 0;
  data_class[NODE_DOF_TMP] = NODE;

  strcpy(name[NODE_EIGEN],"node_eigen");
  type[NODE_EIGEN] = DOUBLE;
  data_length[NODE_EIGEN] = DATA_ITEM_SIZE;
  fixed_length[NODE_EIGEN] = 0;
  version_all[NODE_EIGEN] = 1;
  data_class[NODE_EIGEN] = NODE;

  strcpy(name[NODE_LHSIDE],"node_lhside");
  type[NODE_LHSIDE] = DOUBLE;
  data_length[NODE_LHSIDE] = npuknwn;
  external[NODE_LHSIDE] = 0;
  data_class[NODE_LHSIDE] = NODE;

  strcpy(name[NODE_MASS],"node_mass");
  type[NODE_MASS] = DOUBLE;
  data_length[NODE_MASS] = 1;
  version_all[NODE_MASS] = 1;
  data_class[NODE_MASS] = NODE;

  strcpy(name[NODE_NEL],"node_nel");
  type[NODE_NEL] = INTEGER;
  data_length[NODE_NEL] = 1;
  external[NODE_NEL] = 0;
  version_all[NODE_NEL] = 1;
  data_class[NODE_NEL] = NODE;

  strcpy(name[NODE_NODE],"node_node");
  type[NODE_NODE] = INTEGER;
  data_length[NODE_NODE] = 0; // set run-time
  external[NODE_NODE] = 0;
  fixed_length[NODE_NODE] = 0;
  version_all[NODE_NODE] = 1;
  data_class[NODE_NODE] = NODE;

  strcpy(name[NODE_REMESH_VELOCITY],"node_remesh_velocity");
  type[NODE_REMESH_VELOCITY] = DOUBLE;
  data_length[NODE_REMESH_VELOCITY] = ndim;
  version_all[NODE_REMESH_VELOCITY] = 1;
  data_class[NODE_REMESH_VELOCITY] = NODE;
  external[NODE_REMESH_VELOCITY] = 0;

  strcpy(name[NODE_RHSIDE],"node_rhside");
  type[NODE_RHSIDE] = DOUBLE;
  data_length[NODE_RHSIDE] = npuknwn;
  data_class[NODE_RHSIDE] = NODE;

  strcpy(name[NODE_RHSIDE_INTERNAL],"node_rhside_internal");
  type[NODE_RHSIDE_INTERNAL] = DOUBLE;
  data_length[NODE_RHSIDE_INTERNAL] = npuknwn;
  data_class[NODE_RHSIDE_INTERNAL] = NODE;

  strcpy(name[NODE_RHSIDE_STATIC],"node_rhside_static");
  type[NODE_RHSIDE_STATIC] = DOUBLE;
  data_length[NODE_RHSIDE_STATIC] = npuknwn;
  data_class[NODE_RHSIDE_STATIC] = NODE;

  strcpy(name[NODE_START_REFINED],"node_start_refined");
  type[NODE_START_REFINED] = DOUBLE;
  data_length[NODE_START_REFINED] = ndim;
  external[NODE_START_REFINED] = 0;
  version_all[NODE_START_REFINED] = 1;
  data_class[NODE_START_REFINED] = NODE;

  strcpy(name[NODE_STIFFNESS],"node_stiffness");
  type[NODE_STIFFNESS] = DOUBLE;
  data_length[NODE_STIFFNESS] = ndim;
  version_all[NODE_STIFFNESS] = 1;
  data_class[NODE_STIFFNESS] = NODE;

  strcpy(name[NODE_TYINGS],"node_tyings");
  type[NODE_TYINGS] = INTEGER;
  data_length[NODE_TYINGS] = MNOL;
  fixed_length[NODE_TYINGS] = 0;
  data_class[NODE_TYINGS] = NODE;

  strcpy(name[NODE_TYINGS_FACTORS],"node_tyings_factors");
  type[NODE_TYINGS_FACTORS] = DOUBLE;
  data_length[NODE_TYINGS_FACTORS] = MNOL;
  fixed_length[NODE_TYINGS_FACTORS] = 0;
  data_class[NODE_TYINGS_FACTORS] = NODE;

  strcpy(name[NODE_TYINGS_UNKNOWNS],"node_tyings_unknowns");
  type[NODE_TYINGS_UNKNOWNS] = INTEGER;
  data_length[NODE_TYINGS_UNKNOWNS] = nuknwn;
  data_class[NODE_TYINGS_UNKNOWNS] = NODE;

  strcpy(name[NONE],"none" );

  strcpy(name[NORMAL],"normal");

  strcpy(name[NOTHING],"nothing");

  strcpy(name[NUMBER_ITERATIONS],"number_iterations");
  type[NUMBER_ITERATIONS] = INTEGER;
  data_length[NUMBER_ITERATIONS] = 1;
  no_index[NUMBER_ITERATIONS] = 1;
  external[NUMBER_ITERATIONS] = 0;
  data_class[NUMBER_ITERATIONS] = NUMBER_ITERATIONS;

  strcpy(name[OPTIONS_AXISYMMETRIC],"options_axisymmetric");
  type[OPTIONS_AXISYMMETRIC] = INTEGER;
  data_length[OPTIONS_AXISYMMETRIC] = 1;
  no_index[OPTIONS_AXISYMMETRIC] = 1;

  strcpy(name[OPTIONS_CONVECTION],"options_convection");
  type[OPTIONS_CONVECTION] = INTEGER;
  data_length[OPTIONS_CONVECTION] = 1;
  no_index[OPTIONS_CONVECTION] = 1;

  strcpy(name[OPTIONS_INERTIA],"options_inertia");
  type[OPTIONS_INERTIA] = INTEGER;
  data_length[OPTIONS_INERTIA] = 1;
  no_index[OPTIONS_INERTIA] = 1;

  strcpy(name[OPTIONS_MESH],"options_mesh");
  type[OPTIONS_MESH] = INTEGER;
  data_length[OPTIONS_MESH] = ndim;
  no_index[OPTIONS_MESH] = 1;

  strcpy(name[OPTIONS_NONLOCAL],"options_nonlocal");
  type[OPTIONS_NONLOCAL] = DOUBLE;
  data_length[OPTIONS_NONLOCAL] = 1;
  no_index[OPTIONS_NONLOCAL] = 1;

  strcpy(name[OPTIONS_PROCESSORS],"options_processors");
  type[OPTIONS_PROCESSORS] = INTEGER;
  data_length[OPTIONS_PROCESSORS] = 1;
  no_index[OPTIONS_PROCESSORS] = 1;

  strcpy(name[OPTIONS_RESIDUEFACTOR],"options_residuefactor");
  type[OPTIONS_RESIDUEFACTOR] = DOUBLE;
  data_length[OPTIONS_RESIDUEFACTOR] = npuknwn;
  no_index[OPTIONS_RESIDUEFACTOR] = 1;

  strcpy(name[OPTIONS_STABILIZATION],"options_stabilization");
  type[OPTIONS_STABILIZATION] = INTEGER;
  data_length[OPTIONS_STABILIZATION] = 1;
  no_index[OPTIONS_STABILIZATION] = 1;

  strcpy(name[PHIMOB],"phimob" );

  strcpy(name[POSITIVE],"positive");

  strcpy(name[POST],"post");

  strcpy(name[POST_CALCUL],"post_calcul");
  type[POST_CALCUL] = INTEGER;
  data_length[POST_CALCUL] = DATA_ITEM_SIZE;
  no_index[POST_CALCUL] = 1;
  fixed_length[POST_CALCUL] = 0;
  data_class[POST_CALCUL] = POST;

  strcpy(name[POST_CALCUL_SCAL_VEC_MAT],"post_calcul_scal_vec_mat");
  type[POST_CALCUL_SCAL_VEC_MAT] = INTEGER;
  data_length[POST_CALCUL_SCAL_VEC_MAT] = DATA_ITEM_SIZE;
  fixed_length[POST_CALCUL_SCAL_VEC_MAT] = 0;
  no_index[POST_CALCUL_SCAL_VEC_MAT] = 1;
  external[POST_CALCUL_SCAL_VEC_MAT] = 0;
  data_class[POST_CALCUL_SCAL_VEC_MAT] = POST;

  strcpy(name[POST_CALCUL_UNKNOWN_OPERAT],"post_calcul_unknown_operat");
  type[POST_CALCUL_UNKNOWN_OPERAT] = INTEGER;
  data_length[POST_CALCUL_UNKNOWN_OPERAT] = DATA_ITEM_SIZE;
  fixed_length[POST_CALCUL_UNKNOWN_OPERAT] = 0;
  no_index[POST_CALCUL_UNKNOWN_OPERAT] = 1;
  external[POST_CALCUL_UNKNOWN_OPERAT] = 0;
  data_class[POST_CALCUL_UNKNOWN_OPERAT] = POST;

  strcpy(name[POST_ERROR_ITEM],"post_error_item");
  type[POST_ERROR_ITEM] = INTEGER;
  data_length[POST_ERROR_ITEM] = 3;
  data_class[POST_ERROR_ITEM] = POST;

  strcpy(name[POST_ERROR_MESH1],"post_error_mesh1");
  type[POST_ERROR_MESH1] = DOUBLE;
  data_length[POST_ERROR_MESH1] = 1;
  external[POST_ERROR_MESH1] = 0;
  data_class[POST_ERROR_MESH1] = POST;

  strcpy(name[POST_ERROR_MESH2],"post_error_mesh2");
  type[POST_ERROR_MESH2] = DOUBLE;
  data_length[POST_ERROR_MESH2] = 1;
  external[POST_ERROR_MESH2] = 0;
  data_class[POST_ERROR_MESH2] = POST;

  strcpy(name[POST_ERROR_RESULT],"post_error_result");
  type[POST_ERROR_RESULT] = DOUBLE;
  data_length[POST_ERROR_RESULT] = 1;
  data_class[POST_ERROR_RESULT] = POST;

  strcpy(name[POST_LINE],"post_line");
  type[POST_LINE] = DOUBLE;
  data_length[POST_LINE] = 2*ndim;
  data_class[POST_LINE] = POST;

  strcpy(name[POST_LINE_DOF],"post_line_dof");
  type[POST_LINE_DOF] = DOUBLE;
  data_length[POST_LINE_DOF] = nuknwn;
  data_class[POST_LINE_DOF] = POST;

  strcpy(name[POST_LINE_DOF_CALCUL],"post_line_dof_calcul");
  type[POST_LINE_DOF_CALCUL] = DOUBLE;
  data_length[POST_LINE_DOF_CALCUL] = MCALCUL;
  fixed_length[POST_LINE_DOF_CALCUL] = 0;
  data_class[POST_LINE_DOF_CALCUL] = POST;

  strcpy(name[POST_LINE_MOMENT],"post_line_moment");
  type[POST_LINE_MOMENT] = INTEGER;
  data_length[POST_LINE_MOMENT] = 1;
  data_class[POST_LINE_MOMENT] = POST;

  strcpy(name[POST_LINE_N],"post_line_n");
  type[POST_LINE_N] = INTEGER;
  data_length[POST_LINE_N] = 1;
  data_class[POST_LINE_N] = POST;

  strcpy(name[POST_NODE_RHSIDE_FIXED],"post_node_rhside_fixed");
  type[POST_NODE_RHSIDE_FIXED] = DOUBLE;
  data_length[POST_NODE_RHSIDE_FIXED] = npuknwn;
  data_class[POST_NODE_RHSIDE_FIXED] = POST;
  no_index[POST_NODE_RHSIDE_FIXED] = 1;

  strcpy(name[POST_NODE_RHSIDE_FREE],"post_node_rhside_free");
  type[POST_NODE_RHSIDE_FREE] = DOUBLE;
  data_length[POST_NODE_RHSIDE_FREE] = npuknwn;
  data_class[POST_NODE_RHSIDE_FREE] = POST;
  no_index[POST_NODE_RHSIDE_FREE] = 1;

  strcpy(name[POST_NODE_RHSIDE_RATIO],"post_node_rhside_ratio");
  type[POST_NODE_RHSIDE_RATIO] = DOUBLE;
  data_length[POST_NODE_RHSIDE_RATIO] = 1;
  data_class[POST_NODE_RHSIDE_RATIO] = POST;
  no_index[POST_NODE_RHSIDE_RATIO] = 1;

  strcpy(name[POST_POINT],"post_point");
  type[POST_POINT] = DOUBLE;
  data_length[POST_POINT] = ndim;
  data_class[POST_POINT] = POST;

  strcpy(name[POST_POINT_DOF],"post_point_dof");
  type[POST_POINT_DOF] = DOUBLE;
  data_length[POST_POINT_DOF] = nuknwn;
  data_class[POST_POINT_DOF] = POST;

  strcpy(name[POST_POINT_DOF_CALCUL],"post_point_dof_calcul");
  type[POST_POINT_DOF_CALCUL] = DOUBLE;
  data_length[POST_POINT_DOF_CALCUL] = MCALCUL;
  fixed_length[POST_POINT_DOF_CALCUL] = 0;
  data_class[POST_POINT_DOF_CALCUL] = POST;

  strcpy(name[POST_QUADRILATERAL],"post_quadrilateral");
  type[POST_QUADRILATERAL] = DOUBLE;
  data_length[POST_QUADRILATERAL] = 4*ndim;
  data_class[POST_QUADRILATERAL] = POST;

  strcpy(name[POST_QUADRILATERAL_DOF],"post_quadrilateral_dof");
  type[POST_QUADRILATERAL_DOF] = DOUBLE;
  data_length[POST_QUADRILATERAL_DOF] = nuknwn;
  data_class[POST_QUADRILATERAL_DOF] = POST;

  strcpy(name[POST_QUADRILATERAL_DOF_CALCUL],"post_quadrilateral_dof_calcul");
  type[POST_QUADRILATERAL_DOF_CALCUL] = DOUBLE;
  data_length[POST_QUADRILATERAL_DOF_CALCUL] = DATA_ITEM_SIZE;
  fixed_length[POST_QUADRILATERAL_DOF_CALCUL] = 0;
  data_class[POST_QUADRILATERAL_DOF_CALCUL] = POST;

  strcpy(name[POST_QUADRILATERAL_N],"post_quadrilateral_n");
  type[POST_QUADRILATERAL_N] = INTEGER;
  data_length[POST_QUADRILATERAL_N] = 1;
  data_class[POST_QUADRILATERAL_N] = POST;

  strcpy(name[POST_NODE],"post_node");
  type[POST_NODE] = INTEGER;
  data_length[POST_NODE] = 4;
  data_class[POST_NODE] = POST;

  strcpy(name[POST_NODE_RESULT],"post_node_result");
  type[POST_NODE_RESULT] = DOUBLE;
  data_length[POST_NODE_RESULT] = DATA_ITEM_SIZE;
  fixed_length[POST_NODE_RESULT] = 0;
  data_class[POST_NODE_RESULT] = POST;

  strcpy(name[PRINT],"print");

  strcpy(name[PRINT_FILTER],"print_filter");
  type[PRINT_FILTER] = INTEGER;
  data_length[PRINT_FILTER] = DATA_ITEM_SIZE;
  fixed_length[PRINT_FILTER] = 0;
  data_class[PRINT_FILTER] = PRINT;

  strcpy(name[PRIVAL],"prival");

  strcpy(name[PRIVEC],"privec");

  strcpy(name[P_COARSEN],"p_coarsen");

  strcpy(name[P_REFINEMENT],"p_refinement");

  strcpy(name[QUAD4],"quad4");

  strcpy(name[QUAD9],"quad9");

  strcpy(name[QUAD16],"quad16");

  strcpy(name[QUAD25],"quad25");

  strcpy(name[RA],"ra");

  strcpy(name[RECTANGLE],"rectangle" );

  strcpy(name[RESIDUE],"residue");

  strcpy(name[SCALAR],"scalar");

  strcpy(name[SIZE],"size");

  strcpy(name[SIZEDEV],"sizedev");

  strcpy(name[SLIDE_GEOMETRY],"slide_geometry");
  type[SLIDE_GEOMETRY] = INTEGER;
  data_length[SLIDE_GEOMETRY] = 2;
  data_class[SLIDE_GEOMETRY] = SLIDE;

  strcpy(name[SLIDE_FRICTION],"slide_friction");
  type[SLIDE_FRICTION] = DOUBLE;
  data_length[SLIDE_FRICTION] = 1;
  data_length[SLIDE_FRICTION] = SLIDE;

  strcpy(name[SPHERE],"sphere");

  strcpy(name[STATIC],"static" );

  strcpy(name[STEP],"step");

  strcpy(name[SUM],"sum");

  strcpy(name[TARGET],"target");

  strcpy(name[TARGET_ITEM],"target_item");
  type[TARGET_ITEM] = INTEGER;
  data_length[TARGET_ITEM] = 3;
  data_class[TARGET_ITEM] = TARGET;

  strcpy(name[TARGET_VALUE],"target_value");
  type[TARGET_VALUE] = DOUBLE;
  data_length[TARGET_VALUE] = 2;
  data_class[TARGET_VALUE] = TARGET;

  strcpy(name[TENDON],"tendon");
  type[TENDON] = DOUBLE;
  data_length[TENDON] = 2*ndim + 1;
  data_class[TENDON] = TENDON;

  strcpy(name[TENDON_ELASTI],"tendon_elasti");
  type[TENDON_ELASTI] = DOUBLE;
  data_length[TENDON_ELASTI] = 1;
  data_class[TENDON_ELASTI] = TENDON;

  strcpy(name[TENDON_EXPANSION],"tendon_expansion");
  type[TENDON_EXPANSION] = DOUBLE;
  data_length[TENDON_EXPANSION] = 1;
  data_class[TENDON_EXPANSION] = TENDON;

  strcpy(name[TENDON_PLASTI],"tendon_plasti");
  type[TENDON_PLASTI] = DOUBLE;
  data_length[TENDON_PLASTI] = 1;
  data_class[TENDON_PLASTI] = TENDON;

  strcpy(name[TENDON_SPLIT],"tendon_split");
  type[TENDON_SPLIT] = DOUBLE;
  data_length[TENDON_SPLIT] = 2;
  external[TENDON_SPLIT] = 0;
  data_class[TENDON_SPLIT] = TENDON;

  strcpy(name[TENDON_SPLIT_ELEMENT],"tendon_split_element");
  type[TENDON_SPLIT_ELEMENT] = INTEGER;
  data_length[TENDON_SPLIT_ELEMENT] = MTENDON;
  fixed_length[TENDON_SPLIT_ELEMENT] = 0;
  external[TENDON_SPLIT_ELEMENT] = 0;
  data_class[TENDON_SPLIT_ELEMENT] = TENDON;

  strcpy(name[TENDON_STRESS],"tendon_stress");
  type[TENDON_STRESS] = DOUBLE;
  data_length[TENDON_STRESS] = 1;
  data_class[TENDON_STRESS] = TENDON;

  strcpy(name[TET4],"tet4");

  strcpy(name[TET10],"tet10");

  strcpy(name[TIME],"time");

  strcpy(name[TIME_AT_START],"time_at_start");
  type[TIME_AT_START] = INTEGER;
  data_length[TIME_AT_START] = 1;
  external[TIME_AT_START] = 0;
  data_class[TIME_AT_START] = TIME;

  strcpy(name[TIME_CURRENT],"time_current");
  type[TIME_CURRENT] = DOUBLE;
  data_length[TIME_CURRENT] = 1;
  no_index[TIME_CURRENT] = 1;
  version_all[TIME_CURRENT] = 1;
  data_class[TIME_CURRENT] = TIME;

  strcpy(name[TIME_CALCULATION],"time_calculation");
  type[TIME_CALCULATION] = INTEGER;
  data_length[TIME_CALCULATION] = 1;
  no_index[TIME_CALCULATION] = 1;
  data_class[TIME_CALCULATION] = TIME;

  strcpy(name[TIME_NEW],"time_new");
  type[TIME_NEW] = DOUBLE;
  external[TIME_NEW] = 0;
  data_length[TIME_NEW] = 1;
  no_index[TIME_NEW] = 1;
  version_all[TIME_NEW] = 1;
  data_class[TIME_NEW] = TIME;

  strcpy(name[TIME_OLD],"time_old");
  type[TIME_OLD] = DOUBLE;
  external[TIME_OLD] = 0;
  data_length[TIME_OLD] = 1;
  no_index[TIME_OLD] = 1;
  version_all[TIME_OLD] = 1;
  data_class[TIME_OLD] = TIME;

  strcpy(name[TO],"to");

  strcpy(name[TOTAL],"total");

  strcpy(name[TRIA3],"tria3");

  strcpy(name[TRIA6],"tria6");

  strcpy(name[TYINGS],"tyings");

  strcpy(name[UNIFORM],"uniform");

  strcpy(name[UPDATED],"updated");

  strcpy(name[UPDATED_WITHOUT_ROTATION],"updated_without_rotation");

  strcpy(name[USER],"user" );

  strcpy(name[VALUE],"value");

  strcpy(name[VECTOR],"vector");

  strcpy(name[VOLUME_ELEMENT_FACTOR],"volume_element_factor");
  type[VOLUME_ELEMENT_FACTOR] = DOUBLE;
  data_length[VOLUME_ELEMENT_FACTOR] = 1;
  version_all[VOLUME_ELEMENT_FACTOR] = 1;
  data_class[VOLUME_ELEMENT_FACTOR] = VOLUME;

  strcpy(name[VOLUME_FACTOR],"volume_factor");
  type[VOLUME_FACTOR] = DOUBLE;
  data_length[VOLUME_FACTOR] = DATA_ITEM_SIZE;
  fixed_length[VOLUME_FACTOR] = 0;
  no_index[VOLUME_FACTOR] = 1;
  data_class[VOLUME_FACTOR] = VOLUME;

  strcpy(name[WAVE],"wave");

  strcpy(name[WAVE_SCALAR],"wave_scalar");

  strcpy(name[WAVE_FSCALAR],"wave_fscalar");

  strcpy(name[YES],"yes");

  for ( idat=0; idat<MDAT; idat++ ) {
    if ( data_length[idat]<1 ) data_length[idat] = 1;
  }

  idat = YES;
  for ( ipuknwn=0; ipuknwn<npuknwn; ipuknwn++ ) {
    iuknwn = ipuknwn*nder;
    if      ( dof_type[iuknwn]==-CONDIF_TEMPERATURE ) 
      strcpy( basename, "temp"  );
    else if ( dof_type[iuknwn]==-GROUNDFLOW_PRESSURE ) 
      strcpy( basename, "pres" );
    else if ( dof_type[iuknwn]==-GROUNDFLOW_VELOCITY ) {
      if ( iuknwn==gvel_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "gvelx"  );
      else if ( n==2 ) strcpy( basename, "gvely"  );
      else if ( n==3 ) strcpy( basename, "gvelz"  );
    }
    else if ( dof_type[iuknwn]==-MATERI_DAMAGE ) 
      strcpy( basename, "dam" );
    else if ( dof_type[iuknwn]==-MATERI_DENSITY ) 
      strcpy( basename, "dens" );
    else if ( dof_type[iuknwn]==-MATERI_DISPLACEMENT ) {
      if ( iuknwn==dis_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "disx"  );
      else if ( n==2 ) strcpy( basename, "disy"  );
      else if ( n==3 ) strcpy( basename, "disz"  );
    }
    else if ( dof_type[iuknwn]==-MATERI_HISTORY_VARIABLES ) {
      if ( iuknwn==hisv_indx ) n = 0;
      strcpy( basename, "hisv" );
      long_to_a( n, str );
      strcat( basename, str );
      n++;
    }
    else if ( dof_type[iuknwn]==-MATERI_MAXWELL_STRESS ) {
      if ( iuknwn==mstres_indx ) { 
        m = 1; 
        n = 0; 
      }
      n++;
      if ( n>6 ) { 
        m++; 
        n = 1; 
      }
      if      ( n==1 ) strcpy( tmpname, "msigxx" );
      else if ( n==2 ) strcpy( tmpname, "msigxy" );
      else if ( n==3 ) strcpy( tmpname, "msigxz" );
      else if ( n==4 ) strcpy( tmpname, "msigyy" );
      else if ( n==5 ) strcpy( tmpname, "msigyz" );
      else if ( n==6 ) strcpy( tmpname, "msigzz" );
      long_to_a( m, basename );
      strcat( basename, tmpname );
    }
    else if ( dof_type[iuknwn]==-MATERI_PLASTI_F )
      strcpy( basename, "f" );
    else if ( dof_type[iuknwn]==-MATERI_PLASTI_KAPPA )
      strcpy( basename, "kap" );
    else if ( dof_type[iuknwn]==-MATERI_PLASTI_RHO ) {
      if ( iuknwn==rho_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "rhoxx" );
      else if ( n==2 ) strcpy( basename, "rhoxy" );
      else if ( n==3 ) strcpy( basename, "rhoxz" );
      else if ( n==4 ) strcpy( basename, "rhoyy" );
      else if ( n==5 ) strcpy( basename, "rhoyz" );
      else if ( n==6 ) strcpy( basename, "rhozz" );
    }
    else if ( dof_type[iuknwn]==-MATERI_STRAIN_ELASTI ) {
      if ( iuknwn==epe_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "epexx" );
      else if ( n==2 ) strcpy( basename, "epexy" );
      else if ( n==3 ) strcpy( basename, "epexz" );
      else if ( n==4 ) strcpy( basename, "epeyy" );
      else if ( n==5 ) strcpy( basename, "epeyz" );
      else if ( n==6 ) strcpy( basename, "epezz" );
    }
    else if ( dof_type[iuknwn]==-MATERI_STRAIN_PLASTI ) {
      if ( iuknwn==epp_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "eppxx" );
      else if ( n==2 ) strcpy( basename, "eppxy" );
      else if ( n==3 ) strcpy( basename, "eppxz" );
      else if ( n==4 ) strcpy( basename, "eppyy" );
      else if ( n==5 ) strcpy( basename, "eppyz" );
      else if ( n==6 ) strcpy( basename, "eppzz" );
    }
    else if ( dof_type[iuknwn]==-MATERI_STRAIN_TOTAL ) {
      if ( iuknwn==ept_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "eptxx" );
      else if ( n==2 ) strcpy( basename, "eptxy" );
      else if ( n==3 ) strcpy( basename, "eptxz" );
      else if ( n==4 ) strcpy( basename, "eptyy" );
      else if ( n==5 ) strcpy( basename, "eptyz" );
      else if ( n==6 ) strcpy( basename, "eptzz" );
    }
    else if ( dof_type[iuknwn]==-MATERI_STRESS ) {
      if ( iuknwn==stres_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "sigxx" );
      else if ( n==2 ) strcpy( basename, "sigxy" );
      else if ( n==3 ) strcpy( basename, "sigxz" );
      else if ( n==4 ) strcpy( basename, "sigyy" );
      else if ( n==5 ) strcpy( basename, "sigyz" );
      else if ( n==6 ) strcpy( basename, "sigzz" );
    }
    else if ( dof_type[iuknwn]==-MATERI_VELOCITY ) {
      if ( iuknwn==vel_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "velx"  );
      else if ( n==2 ) strcpy( basename, "vely"  );
      else if ( n==3 ) strcpy( basename, "velz"  );
    }
    else if ( dof_type[iuknwn]==-MATERI_VELOCITY_INTEGRATED ) {
      if ( iuknwn==veli_indx ) n = 0;
      n++;
      if      ( n==1 ) strcpy( basename, "velix"  );
      else if ( n==2 ) strcpy( basename, "veliy"  );
      else if ( n==3 ) strcpy( basename, "veliz"  );
    }
    else if ( dof_type[iuknwn]==-MATERI_VOID_FRACTION ) 
      strcpy( basename, "void" );
    else if ( dof_type[iuknwn]==-MATERI_WORK ) 
      strcpy( basename, "work" );
    else if ( dof_type[iuknwn]==-RESIDUE ) 
      strcpy( basename, "res" );
    else if ( dof_type[iuknwn]==-WAVE_SCALAR ) 
      strcpy( basename, "scal"  );
    else if ( dof_type[iuknwn]==-WAVE_FSCALAR ) 
      strcpy( basename, "fscal"  );

    idat++; assert( idat<MDAT );
    strcpy( name[idat], basename );
    dof_label[iuknwn] = -idat;

    if ( derivatives ) {
      for ( idim=0; idim<ndim; idim++ ) {
        iuknwn++;
        if      ( idim==0 ) strcpy( str, "x" );
        else if ( idim==1 ) strcpy( str, "y" );
        else if ( idim==2 ) strcpy( str, "z" );
        strcat( str, basename );
        idat++; strcpy( name[idat], str );
        dof_label[iuknwn] = -idat;
      }
      iuknwn++;
      strcpy( str, "t" );
      strcat( str, basename );
      idat++; strcpy( name[idat], str );
      dof_label[iuknwn] = -idat;
    }
  }

}

long int db( long int idat, long int index, long int *ival,
  double *dval, long int &length, long int version, long int task )

{
  long int i=0, l=0, data_ptr=0, data_number=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    pri( "Data item ", idat );
    db_error( idat, index );
  }

  if      ( task==GET ) {
    if ( !db_active_index(data_number,index,version) ) db_error( idat, index );
    length = db_len( data_number, index, version );
  }
  else if ( task==GET_IF_EXISTS ) {
    if ( !db_active_index(data_number,index,version) ) {
      length = 0;
      return 0;
    }
    length = db_len( data_number, index, version );
  }
  else if ( task==GET_AND_CHECK ) {
    l = db_len( data_number, index, version );
    if ( l!=length ) db_error( idat, index );
  }
  else if ( task==PUT ) {
    if ( index<0 )
      db_error( idat, index );
    if ( index>0 && db_no_index(idat) )
      db_error( idat, index );
    if ( length<1 )
      db_error( idat, index );
    if ( length>db_data_length(data_number) ) {
      if ( db_data_length(data_number)==DATA_ITEM_SIZE ) {
        pri( "DATA_ITEM_SIZE in tochnog.h is too small." );
        pri( "It should become at least", length );
        pri( "Increase it and recompile all routines." );
      }
      db_error( idat, index );
    }
    if ( db_fixed_length( idat ) && length!=db_data_length(data_number) )
      db_error( idat, index );
  }
  db_allocate( data_number, index, version, MAXIMAL );
  data_ptr = db_data_length(data_number) * index;

  if ( db_type(data_number)==INTEGER ) {
    for ( i=0; i<length; i++ ) {
      if ( task==PUT )
        int_data[data_number][version][data_ptr+i] = ival[i];
      else
        ival[i] = int_data[data_number][version][data_ptr+i];
    }
  }
  else {
    for ( i=0; i<length; i++ ) {
      if ( task==PUT )
        dbl_data[data_number][version][data_ptr+i] = dval[i];
      else
        dval[i] = dbl_data[data_number][version][data_ptr+i];
    }
  }

  if ( task==PUT ) {
    if ( length<db_data_length(data_number) ) {
      if ( db_type(data_number)==INTEGER )
        int_data[data_number][version][data_ptr+length] = LONG_MIN;
      else
        dbl_data[data_number][version][data_ptr+length] = DBL_MAX;
    }
  }

  return 1;

}


long int db_active_index( long int idat, long int index, long int version )

{
  long int result=1, max=-1, data_number=0, data_ptr=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, index );
  }

  db_max_index( data_number, max, version, GET );
  data_ptr = db_data_length(data_number) * index;

  if      ( index<0 || index>max )
    result = 0;
  else if ( db_type(data_number)==DOUBLE )
    result = (dbl_data[data_number][version][data_ptr]!=DBL_MAX);
  else {
    assert( db_type(data_number)==INTEGER );
    result = (int_data[data_number][version][data_ptr]!=LONG_MIN);
  }
  return result;

}

void db_allocate( long int idat, long int index, long int version, long int task )

{
  long int n=0, n_old=0, max_old=0, data_number=0,
    max=0, length=0, increase=0, *int_old=0;
  double *dbl_old=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, index );
  }

  db_max_index( data_number, max_old, version, GET );
  if ( index<=max_old ) return;

  assert( !parallel_active );

  max = index;
  if ( task==MAXIMAL && !db_no_index(data_number) ) {
    increase = index/10; // a bit extra for future use, heuristic
    if ( increase<1 ) increase = 1;
    max += increase; 
  }
  db_max_index( data_number, max, version, PUT );

  length = db_data_length( data_number );
  n     = (1+max    ) * length;
  n_old = (1+max_old) * length;
  if ( db_type(data_number)==INTEGER ) {
    if ( max_old>=0 ) int_old = int_data[data_number][version];
    int_data[data_number][version] = get_new_int(n);
    array_set( int_data[data_number][version], LONG_MIN, n );
    if ( max_old>=0 ) {
      array_move( int_old, int_data[data_number][version], n_old );
      delete[] int_old;
    }
  }
  else {
    assert( db_type(data_number)==DOUBLE );
    if ( max_old>=0 ) dbl_old = dbl_data[data_number][version];
    dbl_data[data_number][version] = get_new_dbl(n);
    array_set( dbl_data[data_number][version], DBL_MAX, n );
    if ( max_old>=0 ) {
      array_move( dbl_old, dbl_data[data_number][version], n_old );
      delete[] dbl_old;
    }
  }

}

void db_allocate_class( long int cl, long int index, long int version )

{
  long int idat=0, ic=0;

  ic = scalar_iabs( cl );

  for ( idat=0; idat<MDAT; idat++ ) {
    if ( db_data_class(idat)==ic && db_version( idat, version ) )
      db_allocate( idat, index, version, -MINIMAL );
  }
}

long int db_data_class( long int idat )

{
  long int data_number=0;

  data_number = scalar_iabs(idat);
  return data_class[data_number];
}

void db_close( )

{
  long int idat=0, version=0, data_number=0;

  for ( version=0; version<MVERSION; version++ ) {
    for ( idat=0; idat<MDAT; idat++ ) {
     data_number = scalar_iabs(idat);
      if ( version==0 || version_all[data_number] ) db_delete( idat, version );
    }
  }
}

void db_copy( long int idat, long int jdat, long int version )

{
  long int n=0, max=0, data_numberi=0, data_numberj=0;

  data_numberi = scalar_iabs(idat);
  data_numberj = scalar_iabs(jdat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_numberi]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, -1 );
  }
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_numberj]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( jdat, -1 );
  }

  db_max_index( data_numberi, max, version, GET );
  if ( max>=0 ) {
    if ( db_data_length(data_numberi)!=db_data_length(data_numberj) )
      db_error( data_numberj, -1 );
    db_delete( data_numberj, version );
    db_allocate( data_numberj, max, version, MINIMAL );
    n = (1+max)*db_data_length(data_numberi);
    if ( db_type(data_numberi)==INTEGER )
      array_move( int_data[data_numberi][version], int_data[data_numberj][version], n );
    else
      array_move( dbl_data[data_numberi][version], dbl_data[data_numberj][version], n );
  }

}

long int db_data_length( long int idat )

{

  long int data_number=0;

  data_number = scalar_iabs(idat);

  return data_length[data_number];

}

void db_data_length_put( long int idat, long int length )

{

  long int data_number=0, version=0;

  data_number = scalar_iabs(idat);

  for ( version=0; version<MVERSION; version++ ) {
    if ( db_version( idat, version ) ) db_delete( idat, version );
  }
  data_length[data_number] = length;

}

double *db_dbl( long int idat, long int version )

{
  long int data_number=0, ldum=0;
  double *ptr=NULL;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, -1 );
  }

  if ( db_max_index(data_number,ldum,version,GET)<0 ) db_error( idat, -1 );
  if ( db_type(data_number)!=DOUBLE ) db_error( idat, -1 );

  ptr = &dbl_data[data_number][version][0];

  return ptr;

}

double *db_dbl( long int idat, long int index, long int version )

{
  long int data_ptr=0, data_number=0;
  double *ptr=NULL;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, index );
  }

  if ( !db_active_index(data_number,index,version) ) db_error( idat, index );
  if ( db_type(data_number)!=DOUBLE ) db_error( idat, index );

  data_ptr = data_length[data_number] * index;
  ptr = &dbl_data[data_number][version][data_ptr];

  return ptr;

}

void db_delete( long int idat, long int version )

{
  long int data_number=0, max=-1, ldum=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, -1 );
  }

  if ( db_max_index(idat,ldum,version,GET)>=0 ) {
    if      ( db_type(data_number)==INTEGER )
      delete[] int_data[data_number][version];
    else
      delete[] dbl_data[data_number][version];
    db_max_index(idat,max,version,PUT);
  }

}

void db_delete_index( long int idat, long int index, long int version )

{
  long int length=0, data_number=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, index );
  }

  if ( db_active_index(idat,index,version) ) {
    length = db_data_length( idat );
    if      ( db_type(idat)==INTEGER )
      array_set( db_int(idat,index,version), LONG_MIN, length );
    else
      array_set( db_dbl(idat,index,version), DBL_MAX, length );
  }
}

void db_error( long int idat, long int index )

{
  pri( "Error." );
  cout << "\nError detected for data item " << db_name(idat) << ".";
  if ( index>=0 )
    cout << "\nError detected for record " << index << ".\n";
  if ( strcmp(last_routine,"") )
    cout << "\nError detected in or after routine " << last_routine << ".\n";
  exit(TN_EXIT_STATUS);
}


long int db_external( long int idat )

{
  long int data_number = 0;

  data_number = scalar_iabs(idat);

  return external[data_number];

}

long int db_fixed_length( long int idat )

{
  long int data_number=0;

  data_number = scalar_iabs(idat);

  return fixed_length[data_number];

}

void db_highest_index( long int idat, long int &max, long int version )

{
  long int index=0, data_number=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, -1 );
  }

  db_max_index( idat, max, version, GET );

  index = max;
  while ( index>=0 && !db_active_index(idat,index,version) ) index--;
  max = index;

}

long int *db_int( long int idat, long int version )

{
  long int data_number=0, ldum=0, *ptr=NULL;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, -1 );
  }

  if ( db_max_index(data_number,ldum,version,GET)<0 ) db_error( idat, -1 );
  if ( db_type(data_number)!=INTEGER ) db_error( idat, -1 );

  ptr = &int_data[data_number][version][0];

  return ptr;

}

long int *db_int( long int idat, long int index, long int version )

{
  long int data_ptr=0, data_number=0, *ptr=NULL;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, index );
  }

  if ( !db_active_index(data_number,index,version) ) db_error( idat, index );
  if ( db_type(data_number)!=INTEGER ) db_error( idat, index );

  data_ptr = data_length[data_number] * index;
  ptr = &int_data[data_number][version][data_ptr];

  return ptr;

}

long int db_len( long int idat, long int index, long int version )

{
  long int i=0, l=0, data_ptr=0, data_number=0, length=0;

  data_number = scalar_iabs( idat );
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, index );
  }

  l = db_data_length( data_number );
  if ( db_fixed_length( data_number ) )
    length = l;
  else if ( db_active_index( idat, index, version ) ) {
    data_ptr = l * index;
    length = -1;
    do {
      if      ( i==l )
        length = l;
      else if ( db_type(data_number)==INTEGER &&
        int_data[data_number][version][data_ptr+i]==LONG_MIN ) length = i;
      else if ( type[data_number]==DOUBLE &&
        dbl_data[data_number][version][data_ptr+i]==DBL_MAX  ) length = i;
      i++;
    }
    while ( length<0 );
  }
  else
    db_error( idat, index );

  return length;
}


long int db_max_index( long int idat, long int &max, long int version, long int task )

{
  long int data_number=0;

  data_number = scalar_iabs(idat);
  if ( version<0 || version>=MVERSION ||
       (!version_all[data_number]&&version!=VERSION_NORMAL) ) {
    pri( "Version failure for version ", version );
    db_error( idat, -1 );
  }

  assert( data_number>=0 || data_number<MDAT );

  if ( task==GET ) 
    max = max_index[data_number][version];
  else {
    assert( task==PUT );
    max_index[data_number][version] = max;
  }

  return max;
}

char *db_name( long int idat )

{
  long int data_number=0;

  data_number = scalar_iabs(idat);
  return name[data_number];
}

long int db_no_index( long int idat )
{
  long int data_number=0;

  data_number = scalar_iabs(idat);
  return no_index[data_number];
}

long int db_number( char str[] )

{
  long int data_number=0, found=-1;

  for ( data_number=0; data_number<MDAT && found<0; data_number++ ) {
    if ( !strcmp(str,db_name(data_number)) ) found = data_number;
  }

  return found;

}

long int db_print_only( long int idat )

{
  long int data_number=0, return_value=0;

  data_number = scalar_iabs(idat);

  return_value = print_only[data_number];
  return return_value;
}

void db_set_dbl( long int jdat, long int version )

{
  long int k=0, max=0, length=0, index=0, data_ptr=0, data_numberi=0, 
    data_numberj=0, idat=0, ldum=0;

  assert( db_type(jdat)==DOUBLE );

  assert( version>=0 && version<MVERSION );
  idat = db_data_class( jdat );
  if ( db_max_index(idat,ldum,version,GET)<0 ) return;

  data_numberi = scalar_iabs(idat);
  data_numberj = scalar_iabs(jdat);
  if ( !version_all[data_numberi] ) assert( version==VERSION_NORMAL );

  db_max_index( data_numberi, max, version, GET ); 
  db_delete( data_numberj, version );
  db_allocate( data_numberj, max, version, MINIMAL );

  length = db_data_length(data_numberj);
  for ( index=0; index<=max; index++ ) {
    data_ptr = length * index;
    if ( db_active_index(data_numberi,index,version) ) {
      for ( k=0; k<length; k++ )
        dbl_data[data_numberj][version][data_ptr+k] = 0.;
    }
    else {
      for ( k=0; k<length; k++ ) {
        dbl_data[data_numberj][version][data_ptr+k] = DBL_MAX;
      }
    }
  }

}

void db_set_int( long int jdat, long int version )

{
  long int k=0, max=0, length=0, index=0, data_ptr=0, data_numberi=0, 
    data_numberj=0, idat=0, ldum=0;

  assert( db_type(jdat)==INTEGER );

  assert( version>=0 && version<MVERSION );
  idat = db_data_class( jdat );
  if ( db_max_index(idat,ldum,version,GET)<0 ) return;

  data_numberi = scalar_iabs(idat);
  data_numberj = scalar_iabs(jdat);
  if ( !version_all[data_numberi] ) assert( version==VERSION_NORMAL );

  db_max_index( data_numberi, max, version, GET );
  db_delete( data_numberj, version );
  db_allocate( data_numberj, max, version, MINIMAL );

  length = db_data_length(data_numberj);
  for ( index=0; index<=max; index++ ) {
    data_ptr = length * index;
    if ( db_active_index(data_numberi,index,version) ) {
      for ( k=0; k<length; k++ )
        int_data[data_numberj][version][data_ptr+k] = 0;
    }
    else {
      for ( k=0; k<length; k++ )
        int_data[data_numberj][version][data_ptr+k] = LONG_MIN;
    }
  }

}

long int db_type( long int idat )

{
  long int data_number=0;

  data_number = scalar_iabs(idat);

  return type[data_number];

}

long int db_version( long int idat, long int version )

{
  long int data_number=0, return_value=0;

  data_number = scalar_iabs(idat);
  assert( version>=0 && version<MVERSION );

  if ( version_all[data_number] )
    return_value = 1;
  else
    return_value = (version==VERSION_NORMAL);

  return return_value;
}

void db_version_copy( long int version_from, long int version_to )

{
  long int idat=0, max=0, n=0, *int_ptr_from=NULL, *int_ptr_to=NULL;
  double *dbl_ptr_from=NULL, *dbl_ptr_to=NULL;

  assert( version_from>=0 && version_from<MVERSION );
  assert( version_to>=0 && version_to<MVERSION );
  for ( idat=0; idat<MDAT; idat++ ) {
    if ( version_all[idat] ) {
      db_max_index( idat, max, version_from, GET );
      if ( max>=0 ) {
        db_delete( idat, version_to );
        if ( db_type(idat)==INTEGER ) {
          int_ptr_from = db_int( idat, version_from );
          db_allocate( idat, max, version_to, MINIMAL );
          int_ptr_to = db_int( idat, version_to );
          n = (1+max)*db_data_length(idat);
          array_move( int_ptr_from, int_ptr_to, n );
        }
        else { 
          assert( db_type(idat)==DOUBLE );
          dbl_ptr_from = db_dbl( idat, version_from );
          db_allocate( idat, max, version_to, MINIMAL );
          dbl_ptr_to = db_dbl( idat, version_to );
          n = (1+max)*db_data_length(idat);
          array_move( dbl_ptr_from, dbl_ptr_to, n );
        }
        db_max_index( idat, max, version_to, PUT );
      }
    }
  }

}

void db_version_delete( long int version )

{
  long int idat=0;

  assert( version>=0 && version<MVERSION );
  for ( idat=0; idat<MDAT; idat++ ) {
    if ( db_version(idat,version) ) db_delete( idat, version );
  }

}

