
#ifndef __materials_h__
#define __materials_h__

template<PlatPixel color>
class CAmbient
{
public:
    CAmbient(CTriage& aTriage)
        :iTriage(aTriage) {};
    inline PlatPixel Color(CVector& aPos, CVector& aNormal) const
    {
        return color;
    };
private:
    CTriage& iTriage;
};

template<PlatPixel color>
class CDiffuse
{
public:
    CDiffuse(CTriage& aTriage)
        :iTriage(aTriage) {};
    inline PlatPixel Color(CVector& aPos, CVector& aNormal) const
    {
        CVector n;
        iTriage.Transform().TransformNormal(n,aNormal);
        if (-n.xf[2]>=0)
        {
            return Mix(Pixel(0,0,0,255),color,FixedToWeight(-n.xf[2]));
        }
        return Pixel(0,0,0,255);
    }
private:
    CTriage& iTriage;
};


template<class T,class U,class W>
class CMixColors
{
public:
    CMixColors(CTriage& aTriage)
        :iTriage(aTriage),t(aTriage),u(aTriage),w(aTriage) {};
    inline PlatPixel Color(CVector& aPos, CVector& aNormal) const
    {
        return Mix(t.Color(aPos, aNormal),u.Color(aPos, aNormal),w.Weight(aPos,aNormal));
    };
private:
    CTriage& iTriage;
    T t;
    U u;
    W w;
};


#endif

